/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import java.util.HashSet;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.dml.SelectOrderBy;
import org.h2.expression.Alias;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.message.Message;
import org.h2.result.SortOrder;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;

public abstract class Query
extends Prepared {
    protected Expression limit;
    protected Expression offset;
    protected int sampleSize;

    public Query(Parser parser) {
        super(parser);
    }

    public boolean isQuery() {
        return true;
    }

    public boolean isTransactional() {
        return true;
    }

    protected SortOrder initOrder(ObjectArray expressions, ObjectArray orderList, int visible, boolean mustBeInResult) throws SQLException {
        int[] index = new int[orderList.size()];
        int[] sortType = new int[orderList.size()];
        int originalLength = expressions.size();
        for (int i = 0; i < orderList.size(); ++i) {
            int type;
            int idx;
            SelectOrderBy o = (SelectOrderBy)orderList.get(i);
            if (o.expression != null) {
                Expression e = o.expression;
                boolean isAlias = false;
                idx = expressions.size();
                if (e instanceof ExpressionColumn) {
                    String col = ((ExpressionColumn)e).getOriginalColumnName();
                    for (int j = 0; j < visible; ++j) {
                        boolean found = false;
                        Expression ec = (Expression)expressions.get(j);
                        if (ec instanceof ExpressionColumn) {
                            ExpressionColumn c = (ExpressionColumn)ec;
                            found = col.equals(c.getColumnName());
                        } else {
                            if (!(ec instanceof Alias)) continue;
                            if (col.equals(ec.getAlias())) {
                                found = true;
                            } else {
                                Expression ec2 = ec.getNonAliasExpression();
                                if (ec2 instanceof ExpressionColumn) {
                                    ExpressionColumn c2 = (ExpressionColumn)ec2;
                                    found = col.equals(c2.getColumnName());
                                }
                            }
                        }
                        if (!found) continue;
                        idx = j;
                        isAlias = true;
                        break;
                    }
                }
                if (!isAlias) {
                    if (mustBeInResult) {
                        throw Message.getSQLException(90068, e.getSQL());
                    }
                    expressions.add(e);
                }
            } else {
                idx = o.column;
                if (idx >= originalLength) {
                    throw Message.getSQLException(90068, "index " + idx);
                }
            }
            index[i] = idx;
            int n = type = o.descending ? 1 : 0;
            if (o.nullsFirst) {
                type += 2;
            } else if (o.nullsLast) {
                type += 4;
            }
            sortType[i] = type;
        }
        return new SortOrder(this.session.getDatabase(), index, sortType);
    }

    public void setOffset(Expression offset) {
        this.offset = offset;
    }

    public void setLimit(Expression limit) {
        this.limit = limit;
    }

    public abstract void init() throws SQLException;

    public abstract ObjectArray getExpressions();

    public abstract double getCost();

    public abstract HashSet getTables();

    public abstract void setOrder(ObjectArray var1);

    public abstract void setForUpdate(boolean var1);

    public abstract int getColumnCount();

    public abstract void mapColumns(TableFilter var1, int var2) throws SQLException;

    public abstract boolean isConstant();

    public abstract boolean isEvaluatable(int var1);

    public abstract void setEvaluatable(TableFilter var1, boolean var2);

    public abstract void addGlobalCondition(Expression var1, int var2, int var3) throws SQLException;

    public abstract void setDistinct(boolean var1);

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }
}

