/*
 * Decompiled with CFR 0.152.
 */
package org.h2.compress;

import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.h2.compress.Compresser;
import org.h2.message.Message;

public class CompressDeflate
implements Compresser {
    private int level = 1;
    private int strategy = 0;

    public void setOptions(String options) throws SQLException {
        if (options == null) {
            return;
        }
        try {
            StringTokenizer tokenizer = new StringTokenizer(options);
            while (tokenizer.hasMoreElements()) {
                String option = tokenizer.nextToken();
                if (option.equals("level") || option.equals("l")) {
                    this.level = Integer.parseInt(tokenizer.nextToken());
                    continue;
                }
                if (!option.equals("strategy") && !option.equals("s")) continue;
                this.strategy = Integer.parseInt(tokenizer.nextToken());
            }
        }
        catch (Exception e) {
            throw Message.getSQLException(90102, options);
        }
    }

    public int compress(byte[] in, byte[] out, int outPos) {
        Deflater deflater = new Deflater(this.level);
        deflater.setStrategy(this.strategy);
        deflater.setInput(in, 0, in.length);
        deflater.finish();
        int compressed = deflater.deflate(out, outPos, out.length - outPos);
        return compressed;
    }

    public int getAlgorithm() {
        return 2;
    }

    public void expand(byte[] in, int inPos, byte[] out, int outLen) throws DataFormatException {
        Inflater decompresser = new Inflater();
        decompresser.setInput(in, inPos, in.length - inPos);
        decompresser.finished();
        decompresser.inflate(out);
        decompresser.end();
    }
}

