/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.engine.SessionInterface;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueArray;

public class Subquery
extends Expression {
    private Query query;

    public Subquery(Query query) {
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getValue(SessionInterface si) throws SQLException {
        Session session = (Session)si;
        this.query.setSession(session);
        LocalResult result = this.query.query(2);
        try {
            int rowcount = result.getRowCount();
            if (rowcount > 1) {
                throw Message.getSQLException(90053);
            }
            if (rowcount <= 0) {
                throw Message.getSQLException(90054);
            }
            result.next();
            Value[] values = result.currentRow();
            Value v = values.length == 1 ? values[0] : ValueArray.get(values);
            Value value = v;
            return value;
        }
        finally {
            result.close();
        }
    }

    public int getType() {
        return this.getExpression().getType();
    }

    public void mapColumns(TableFilter tableFilter, int level) throws SQLException {
        this.query.mapColumns(tableFilter, level + 1);
    }

    public Expression optimize(Session session) throws SQLException {
        if (this.query.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        this.query.prepare();
        return this;
    }

    public boolean isEvaluatable(int filterLevel) {
        return this.query.isEvaluatable(filterLevel);
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.query.setEvaluatable(tableFilter, b);
    }

    public int getScale() {
        return this.getExpression().getScale();
    }

    public long getPrecision() {
        return this.getExpression().getPrecision();
    }

    public String getSQL() {
        return "(" + this.query.getSQL() + ")";
    }

    public void updateAggregate(Session session) {
    }

    private Expression getExpression() {
        return (Expression)this.query.getExpressions().get(0);
    }
}

