/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbcx.JdbcDataSourceFactory;
import org.h2.jdbcx.JdbcXAConnection;
import org.h2.message.TraceObject;

public class JdbcDataSource
extends TraceObject
implements XADataSource,
DataSource,
ConnectionPoolDataSource,
Serializable,
Referenceable {
    private static final long serialVersionUID = 1288136338451857771L;
    private JdbcDataSourceFactory factory = new JdbcDataSourceFactory();
    private int timeout;
    private PrintWriter logWriter;
    private String user;
    private String password;
    private String url;
    static /* synthetic */ Class class$org$h2$jdbcx$JdbcDataSourceFactory;

    public JdbcDataSource() {
        int id = this.getNextId(11);
        this.setTrace(this.factory.getTrace(), 11, id);
    }

    public int getLoginTimeout() throws SQLException {
        this.infoCodeCall("getLoginTimeout");
        return this.timeout;
    }

    public void setLoginTimeout(int timeout) throws SQLException {
        this.infoCodeCall("setLoginTimeout", timeout);
        this.timeout = timeout;
    }

    public PrintWriter getLogWriter() throws SQLException {
        this.infoCodeCall("getLogWriter");
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.infoCodeCall("setLogWriter(out)");
        this.logWriter = out;
    }

    public Connection getConnection() throws SQLException {
        this.infoCodeCall("getConnection");
        return this.getJdbcConnection(this.user, this.password);
    }

    public Connection getConnection(String user, String password) throws SQLException {
        this.infoCode("getConnection(" + this.quote(user) + ", " + this.quote(password) + ");");
        return this.getJdbcConnection(user, password);
    }

    public JdbcConnection getJdbcConnection(String user, String password) throws SQLException {
        this.infoCode("getJdbcConnection(" + this.quote(user) + ", " + this.quote(password) + ");");
        Properties info = new Properties();
        info.setProperty("user", user);
        info.setProperty("password", password);
        return new JdbcConnection(this.url, info);
    }

    public String getURL() {
        this.infoCodeCall("getURL");
        return this.url;
    }

    public void setURL(String url) {
        this.infoCodeCall("setURL", url);
        this.url = url;
    }

    public String getPassword() {
        this.infoCodeCall("getPassword");
        return this.password;
    }

    public void setPassword(String password) {
        this.infoCodeCall("setPassword", password);
        this.password = password;
    }

    public String getUser() {
        this.infoCodeCall("getUser");
        return this.user;
    }

    public void setUser(String user) {
        this.infoCodeCall("setUser", user);
        this.user = user;
    }

    public Reference getReference() throws NamingException {
        this.infoCodeCall("getReference");
        String factoryClassName = (class$org$h2$jdbcx$JdbcDataSourceFactory == null ? (class$org$h2$jdbcx$JdbcDataSourceFactory = JdbcDataSource.class$("org.h2.jdbcx.JdbcDataSourceFactory")) : class$org$h2$jdbcx$JdbcDataSourceFactory).getName();
        Reference ref = new Reference(this.getClass().getName(), factoryClassName, null);
        ref.add(new StringRefAddr("url", this.getURL()));
        ref.add(new StringRefAddr("user", this.getUser()));
        ref.add(new StringRefAddr("password", this.password));
        return ref;
    }

    public XAConnection getXAConnection() throws SQLException {
        this.infoCodeCall("getXAConnection");
        int id = this.getNextId(12);
        return new JdbcXAConnection(this.factory, id, this.url, this.user, this.password);
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        this.infoCode("getXAConnection(" + this.quote(user) + ", " + this.quote(password) + ");");
        int id = this.getNextId(12);
        return new JdbcXAConnection(this.factory, id, this.url, user, password);
    }

    public PooledConnection getPooledConnection() throws SQLException {
        this.infoCodeCall("getPooledConnection");
        return this.getXAConnection();
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        this.infoCode("getPooledConnection(" + this.quote(user) + ", " + this.quote(password) + ");");
        return this.getXAConnection(user, password);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

