/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.engine.Constants;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPageBinary;
import org.h2.store.DataPageText;
import org.h2.util.MathUtils;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueLob;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public abstract class DataPage {
    static final boolean CHECKSUM = true;
    protected DataHandler handler;
    protected byte[] data;
    protected int pos;

    public static DataPage create(DataHandler handler, int capacity) {
        if (handler.getTextStorage()) {
            return new DataPageText(handler, new byte[capacity]);
        }
        return new DataPageBinary(handler, new byte[capacity]);
    }

    public static DataPage create(DataHandler handler, byte[] buff) {
        if (handler.getTextStorage()) {
            return new DataPageText(handler, buff);
        }
        return new DataPageBinary(handler, buff);
    }

    protected DataPage(DataHandler handler, int capacity) {
        this(handler, new byte[capacity]);
    }

    protected DataPage(DataHandler handler, byte[] data) {
        this.handler = handler;
        this.data = data;
    }

    public void checkCapacity(int plus) {
        if (this.pos + plus >= this.data.length) {
            byte[] d = new byte[(this.data.length + plus) * 2];
            System.arraycopy(this.data, 0, d, 0, this.data.length);
            this.data = d;
        }
    }

    public abstract void updateChecksum();

    public abstract void check(int var1) throws SQLException;

    public abstract int getFillerLength();

    public abstract void setInt(int var1, int var2);

    public int length() {
        return this.pos;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public void reset() {
        this.pos = 0;
    }

    public void writeDataPageNoSize(DataPage page) {
        this.checkCapacity(page.pos);
        int len = page.pos - this.getFillerLength();
        System.arraycopy(page.data, 0, this.data, this.pos, len);
        this.pos += len;
    }

    public DataPage readDataPageNoSize() {
        int len = this.data.length - this.pos;
        DataPage page = DataPage.create(this.handler, len);
        System.arraycopy(this.data, this.pos, page.data, 0, len);
        page.pos = len;
        return page;
    }

    public void write(byte[] buff, int off, int len) {
        this.checkCapacity(len);
        System.arraycopy(buff, 0, this.data, this.pos, len);
        this.pos += len;
    }

    public void read(byte[] buff, int off, int len) {
        System.arraycopy(this.data, this.pos, buff, off, len);
        this.pos += len;
    }

    public void writeByte(byte x) {
        this.data[this.pos++] = x;
    }

    public int readByte() {
        return this.data[this.pos++];
    }

    public abstract void writeInt(int var1);

    public abstract int readInt();

    public abstract int getIntLen();

    public abstract int getLongLen(long var1);

    public abstract int getStringLen(String var1);

    public abstract String readString();

    public abstract void writeString(String var1);

    public long readLong() {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public void writeLong(long x) {
        this.writeInt((int)(x >>> 32));
        this.writeInt((int)(x & 0xFFFFFFFFFFFFFFFFL));
    }

    public void writeValue(Value v) throws SQLException {
        if (Constants.CHECK) {
            this.checkCapacity(8);
        }
        if (v == ValueNull.INSTANCE) {
            this.data[this.pos++] = 45;
            return;
        }
        int start = this.pos;
        this.data[this.pos++] = (byte)(v.getType() + 97);
        switch (v.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.writeInt(v.getInt());
                break;
            }
            case 5: {
                this.writeLong(v.getLong());
                break;
            }
            case 6: {
                String s = v.getString();
                this.writeString(s);
                break;
            }
            case 9: {
                this.writeLong(v.getTime().getTime());
                break;
            }
            case 10: {
                this.writeLong(v.getDate().getTime());
                break;
            }
            case 11: {
                Timestamp ts = v.getTimestamp();
                this.writeLong(ts.getTime());
                this.writeInt(ts.getNanos());
                break;
            }
            case 12: {
                byte[] b = v.getBytes();
                this.writeInt(b.length);
                this.write(b, 0, b.length);
                break;
            }
            case 13: 
            case 14: {
                this.writeString(v.getString());
                break;
            }
            case 7: {
                this.writeLong(Double.doubleToLongBits(v.getDouble()));
                break;
            }
            case 8: {
                this.writeInt(Float.floatToIntBits(v.getFloat()));
                break;
            }
            case 15: 
            case 16: {
                ValueLob lob = (ValueLob)v;
                byte[] small = lob.getSmall();
                if (small == null) {
                    this.writeInt(-2);
                    this.writeInt(lob.getTableId());
                    this.writeInt(lob.getObjectId());
                    this.writeLong(lob.getPrecision());
                    this.writeByte((byte)0);
                    break;
                }
                this.writeInt(small.length);
                System.arraycopy(small, 0, this.data, this.pos, small.length);
                this.pos += small.length;
                break;
            }
            case 17: {
                Value[] list = ((ValueArray)v).getList();
                this.writeInt(list.length);
                for (int i = 0; i < list.length; ++i) {
                    this.writeValue(list[i]);
                }
                break;
            }
            default: {
                throw Message.internal("type=" + v.getType());
            }
        }
        if (Constants.CHECK && this.pos - start != this.getValueLen(v)) {
            throw Message.internal("value size error: got " + (this.pos - start) + " expected " + this.getValueLen(v));
        }
    }

    public int getValueLen(Value v) throws SQLException {
        if (v == ValueNull.INSTANCE) {
            return 1;
        }
        switch (v.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 1 + this.getIntLen();
            }
            case 5: {
                return 1 + this.getLongLen(v.getLong());
            }
            case 7: {
                return 1 + this.getLongLen(Double.doubleToLongBits(v.getDouble()));
            }
            case 8: {
                return 1 + this.getIntLen();
            }
            case 6: 
            case 13: 
            case 14: {
                return 1 + this.getStringLen(v.getString());
            }
            case 12: {
                int len = v.getBytes().length;
                return 1 + this.getIntLen() + len;
            }
            case 9: {
                return 1 + this.getLongLen(v.getTime().getTime());
            }
            case 10: {
                return 1 + this.getLongLen(v.getDate().getTime());
            }
            case 11: {
                Timestamp ts = v.getTimestamp();
                return 1 + this.getLongLen(ts.getTime()) + this.getIntLen();
            }
            case 15: 
            case 16: {
                int len = 1;
                ValueLob lob = (ValueLob)v;
                byte[] small = lob.getSmall();
                len = small != null ? (len += this.getIntLen() + small.length) : (len += this.getIntLen() + this.getIntLen() + this.getIntLen() + this.getLongLen(lob.getPrecision()) + 1);
                return len;
            }
            case 17: {
                Value[] list = ((ValueArray)v).getList();
                int len = 1 + this.getIntLen();
                for (int i = 0; i < list.length; ++i) {
                    len += this.getValueLen(list[i]);
                }
                return len;
            }
        }
        throw Message.internal("type=" + v.getType());
    }

    public Value readValue() throws SQLException {
        int type;
        if ((type = this.data[this.pos++]) == 45) {
            return ValueNull.INSTANCE;
        }
        switch (type -= 97) {
            case 1: {
                return ValueBoolean.get(this.readInt() == 1);
            }
            case 2: {
                return ValueByte.get((byte)this.readInt());
            }
            case 3: {
                return ValueShort.get((short)this.readInt());
            }
            case 4: {
                return ValueInt.get(this.readInt());
            }
            case 5: {
                return ValueLong.get(this.readLong());
            }
            case 6: {
                return ValueDecimal.get(new BigDecimal(this.readString()));
            }
            case 10: {
                return ValueDate.get(new Date(this.readLong()));
            }
            case 9: {
                return ValueTime.get(new Time(this.readLong()));
            }
            case 11: {
                Timestamp ts = new Timestamp(this.readLong());
                ts.setNanos(this.readInt());
                return ValueTimestamp.get(ts);
            }
            case 12: {
                int len = this.readInt();
                byte[] b = new byte[len];
                this.read(b, 0, len);
                return ValueBytes.get(b);
            }
            case 13: {
                return ValueString.get(this.readString());
            }
            case 14: {
                return ValueStringIgnoreCase.get(this.readString());
            }
            case 7: {
                return ValueDouble.get(Double.longBitsToDouble(this.readLong()));
            }
            case 8: {
                return ValueFloat.get(Float.intBitsToFloat(this.readInt()));
            }
            case 15: 
            case 16: {
                int smallLen = this.readInt();
                if (smallLen >= 0) {
                    byte[] small = new byte[smallLen];
                    System.arraycopy(this.data, this.pos, small, 0, smallLen);
                    this.pos += smallLen;
                    return ValueLob.createSmallLob(type, small);
                }
                int tableId = this.readInt();
                int objectId = this.readInt();
                long precision = 0L;
                if (smallLen == -2) {
                    boolean compression;
                    precision = this.readLong();
                    boolean bl = compression = this.readByte() == 1;
                    if (compression) {
                        throw Message.getUnsupportedException();
                    }
                }
                return ValueLob.open(type, this.handler, tableId, objectId, precision);
            }
            case 17: {
                int len = this.readInt();
                Value[] list = new Value[len];
                for (int i = 0; i < len; ++i) {
                    list[i] = this.readValue();
                }
                return ValueArray.get(list);
            }
        }
        throw Message.internal("type=" + type);
    }

    public abstract void fill(int var1);

    public void fillAligned() {
        this.fill(MathUtils.roundUp(this.pos + 2, 16));
    }
}

