/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test;

import java.util.Properties;
import org.h2.server.TcpServer;
import org.h2.test.TestBase;
import org.h2.test.db.TestAutoRecompile;
import org.h2.test.db.TestBatchUpdates;
import org.h2.test.db.TestBigDb;
import org.h2.test.db.TestBigResult;
import org.h2.test.db.TestCases;
import org.h2.test.db.TestCheckpoint;
import org.h2.test.db.TestCluster;
import org.h2.test.db.TestCompatibility;
import org.h2.test.db.TestCsv;
import org.h2.test.db.TestFunctions;
import org.h2.test.db.TestIndex;
import org.h2.test.db.TestLinkedTable;
import org.h2.test.db.TestListener;
import org.h2.test.db.TestLob;
import org.h2.test.db.TestLogFile;
import org.h2.test.db.TestMemoryUsage;
import org.h2.test.db.TestMultiConn;
import org.h2.test.db.TestMultiDimension;
import org.h2.test.db.TestMultiThread;
import org.h2.test.db.TestPowerOff;
import org.h2.test.db.TestReadOnly;
import org.h2.test.db.TestRights;
import org.h2.test.db.TestRunscript;
import org.h2.test.db.TestScript;
import org.h2.test.db.TestSpeed;
import org.h2.test.db.TestTempTables;
import org.h2.test.db.TestTransaction;
import org.h2.test.db.TestTrigger;
import org.h2.test.db.TestTwoPhaseCommit;
import org.h2.test.jdbc.TestCancel;
import org.h2.test.jdbc.TestDataSource;
import org.h2.test.jdbc.TestManyObjects;
import org.h2.test.jdbc.TestMetaData;
import org.h2.test.jdbc.TestNativeSQL;
import org.h2.test.jdbc.TestPreparedStatement;
import org.h2.test.jdbc.TestResultSet;
import org.h2.test.jdbc.TestStatement;
import org.h2.test.jdbc.TestUpdatableResultSet;
import org.h2.test.synth.TestCrashAPI;
import org.h2.test.synth.TestKill;
import org.h2.test.synth.TestSynth;
import org.h2.test.unit.TestBitField;
import org.h2.test.unit.TestCompress;
import org.h2.test.unit.TestDataPage;
import org.h2.test.unit.TestExit;
import org.h2.test.unit.TestFileLock;
import org.h2.test.unit.TestIntArray;
import org.h2.test.unit.TestIntIntHashMap;
import org.h2.test.unit.TestPattern;
import org.h2.test.unit.TestReader;
import org.h2.test.unit.TestSampleApps;
import org.h2.test.unit.TestSecurity;
import org.h2.test.unit.TestStringUtils;
import org.h2.test.unit.TestTools;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.h2.util.StringUtils;

public class TestAll {
    public boolean smallLog;
    public boolean big;
    public boolean networked;
    public boolean memory;
    public boolean ssl;
    public boolean textStorage;
    public boolean diskResult;
    public boolean deleteIndex;
    public boolean traceSystemOut;
    public boolean codeCoverage;
    public int logMode = 1;
    public int traceLevelFile;
    public int throttle;
    public String cipher;
    public boolean traceTest;
    public boolean stopOnError;
    public boolean jdk14 = true;
    private Server server;

    public static void main(String[] args) throws Exception {
        long time = System.currentTimeMillis();
        TestAll test = new TestAll();
        test.printSystem();
        if (args.length > 0) {
            if ("crash".equals(args[0])) {
                new TestCrashAPI().runTest(test);
            } else if ("synth".equals(args[0])) {
                new TestSynth().runTest(test);
            } else if ("kill".equals(args[0])) {
                new TestKill().runTest(test);
            } else if ("all".equals(args[0])) {
                test.testEverything();
            }
        } else {
            test.runTests();
        }
        System.out.println("done (" + (System.currentTimeMillis() - time) + " ms)");
    }

    void runTests() throws Exception {
        this.testQuick();
        this.testCombination();
    }

    void testQuick() throws Exception {
        this.traceSystemOut = false;
        this.deleteIndex = false;
        this.diskResult = false;
        this.textStorage = false;
        this.ssl = false;
        this.memory = false;
        this.networked = false;
        this.big = false;
        this.smallLog = false;
        this.throttle = 0;
        this.traceLevelFile = 0;
        this.logMode = 0;
        this.cipher = null;
        this.testAll();
    }

    void testEverything() throws Exception {
        for (int c = 0; c < 3; ++c) {
            this.cipher = c == 0 ? null : (c == 1 ? "XTEA" : "AES");
            for (int a = 0; a < 256; ++a) {
                this.smallLog = (a & 1) != 0;
                this.big = (a & 2) != 0;
                this.networked = (a & 4) != 0;
                this.memory = (a & 8) != 0;
                this.ssl = (a & 0x10) != 0;
                this.textStorage = (a & 0x20) != 0;
                this.diskResult = (a & 0x40) != 0;
                this.deleteIndex = (a & 0x80) != 0;
                this.logMode = 0;
                while (this.logMode < 3) {
                    this.traceLevelFile = this.logMode;
                    TestBase.printTime("cipher:" + this.cipher + " a:" + a + " logMode:" + this.logMode);
                    this.testAll();
                    ++this.logMode;
                }
            }
        }
    }

    void testCombination() throws Exception {
        this.traceSystemOut = false;
        this.deleteIndex = false;
        this.diskResult = false;
        this.textStorage = false;
        this.ssl = false;
        this.memory = false;
        this.networked = false;
        this.big = false;
        this.smallLog = false;
        this.throttle = 0;
        this.traceLevelFile = 0;
        this.logMode = 0;
        this.cipher = null;
        this.testAll();
        this.smallLog = false;
        this.big = false;
        this.networked = true;
        this.memory = true;
        this.ssl = false;
        this.textStorage = true;
        this.traceSystemOut = false;
        this.deleteIndex = false;
        this.diskResult = false;
        this.throttle = 0;
        this.traceLevelFile = 0;
        this.logMode = 0;
        this.cipher = null;
        this.testAll();
        this.smallLog = false;
        this.ssl = false;
        this.memory = false;
        this.networked = false;
        this.big = false;
        this.textStorage = true;
        this.diskResult = true;
        this.deleteIndex = true;
        this.traceSystemOut = false;
        this.logMode = 1;
        this.traceLevelFile = 3;
        this.throttle = 1;
        this.cipher = "XTEA";
        this.testAll();
        this.big = true;
        this.smallLog = true;
        this.networked = true;
        this.memory = false;
        this.ssl = true;
        this.textStorage = false;
        this.diskResult = false;
        this.deleteIndex = false;
        this.traceSystemOut = false;
        this.logMode = 2;
        this.traceLevelFile = 2;
        this.throttle = 0;
        this.cipher = null;
        this.testAll();
    }

    void testAll() throws Exception {
        DeleteDbFiles.execute(TestBase.BASE_DIR, null, true);
        this.testDatabase();
        this.testUnit();
        DeleteDbFiles.execute(TestBase.BASE_DIR, null, true);
    }

    void testUnit() {
        new TestBitField().runTest(this);
        new TestCompress().runTest(this);
        new TestDataPage().runTest(this);
        new TestExit().runTest(this);
        new TestFileLock().runTest(this);
        new TestIntArray().runTest(this);
        new TestIntIntHashMap().runTest(this);
        new TestPattern().runTest(this);
        new TestReader().runTest(this);
        new TestSampleApps().runTest(this);
        new TestSecurity().runTest(this);
        new TestStringUtils().runTest(this);
        new TestTools().runTest(this);
    }

    void testDatabase() throws Exception {
        System.out.println("test big=" + this.big + " net=" + this.networked + " cipher=" + this.cipher + " memory=" + this.memory);
        this.startServerIfRequired();
        new TestScript().runTest(this);
        new TestAutoRecompile().runTest(this);
        new TestBatchUpdates().runTest(this);
        new TestBigDb().runTest(this);
        new TestBigResult().runTest(this);
        new TestCases().runTest(this);
        new TestCheckpoint().runTest(this);
        new TestCluster().runTest(this);
        new TestCompatibility().runTest(this);
        new TestCsv().runTest(this);
        new TestFunctions().runTest(this);
        new TestIndex().runTest(this);
        new TestLinkedTable().runTest(this);
        new TestListener().runTest(this);
        new TestLob().runTest(this);
        new TestLogFile().runTest(this);
        new TestMemoryUsage().runTest(this);
        new TestMultiConn().runTest(this);
        new TestMultiDimension().runTest(this);
        new TestMultiThread().runTest(this);
        new TestPowerOff().runTest(this);
        new TestReadOnly().runTest(this);
        new TestRights().runTest(this);
        new TestRunscript().runTest(this);
        new TestSpeed().runTest(this);
        new TestTempTables().runTest(this);
        new TestTransaction().runTest(this);
        new TestTrigger().runTest(this);
        new TestTwoPhaseCommit().runTest(this);
        new TestCancel().runTest(this);
        new TestDataSource().runTest(this);
        new TestMetaData().runTest(this);
        new TestManyObjects().runTest(this);
        new TestNativeSQL().runTest(this);
        new TestPreparedStatement().runTest(this);
        new TestResultSet().runTest(this);
        new TestStatement().runTest(this);
        new TestUpdatableResultSet().runTest(this);
        this.stopServerIfRequired();
    }

    public void startServerIfRequired() {
        if (this.networked) {
            String[] stringArray;
            TcpServer.LOG_INTERNAL_ERRORS = true;
            if (this.ssl) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "-tcpSSL";
                stringArray = stringArray2;
                stringArray2[1] = "true";
            } else {
                stringArray = new String[]{};
            }
            String[] args = stringArray;
            this.server = Server.startTcpServer(args);
        }
    }

    public void stopServerIfRequired() {
        if (this.networked) {
            this.server.stop();
        }
    }

    private void printSystem() {
        Properties prop = System.getProperties();
        System.out.println("Java: " + prop.getProperty("java.runtime.version") + ", " + prop.getProperty("java.vm.name") + ", " + prop.getProperty("java.vendor"));
        System.out.println("Env: " + prop.getProperty("os.name") + ", " + prop.getProperty("os.arch") + ", " + prop.getProperty("os.version") + ", " + prop.getProperty("sun.os.patch.level") + ", " + prop.getProperty("file.separator") + " " + prop.getProperty("path.separator") + " " + StringUtils.javaEncode(prop.getProperty("line.separator")) + " " + prop.getProperty("user.country") + " " + prop.getProperty("user.language") + " " + prop.getProperty("user.variant") + " " + prop.getProperty("file.encoding"));
    }
}

