/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.bench;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import org.h2.test.TestBase;
import org.h2.test.bench.Bench;
import org.h2.test.bench.TestPerformance;
import org.h2.test.bnf.RuleParser;
import org.h2.tools.Server;

class Database {
    private TestPerformance test;
    private int id;
    private String name;
    private String url;
    private String user;
    private String password;
    private ArrayList replace = new ArrayList();
    private String action;
    private long startTime;
    private Connection conn;
    private Statement stat;
    private boolean trace = true;
    private long lastTrace;
    private Random random = new Random(1L);
    private ArrayList results = new ArrayList();
    private int totalTime;
    private int executedStatements;
    private Server serverH2;
    private Object serverDerby;
    private boolean serverHSQLDB;
    static /* synthetic */ Class class$java$io$PrintWriter;
    static /* synthetic */ Class array$Ljava$lang$String;

    Database() {
    }

    String getName() {
        return this.name;
    }

    int getTotalTime() {
        return this.totalTime;
    }

    ArrayList getResults() {
        return this.results;
    }

    Random getRandom() {
        return this.random;
    }

    void startServer() throws Exception {
        if (this.url.startsWith("jdbc:h2:tcp:")) {
            this.serverH2 = Server.startTcpServer(new String[0]);
            Thread.sleep(100L);
        } else if (this.url.startsWith("jdbc:derby://")) {
            this.serverDerby = Class.forName("org.apache.derby.drda.NetworkServerControl").newInstance();
            Method m = this.serverDerby.getClass().getMethod("start", class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = Database.class$("java.io.PrintWriter")) : class$java$io$PrintWriter);
            m.invoke(this.serverDerby, new Object[]{null});
            Thread.sleep(100L);
        } else if (this.url.startsWith("jdbc:hsqldb:hsql:") && !this.serverHSQLDB) {
            Class<?> c = Class.forName("org.hsqldb.Server");
            Method m = c.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Database.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            m.invoke(null, new Object[]{new String[]{"-database.0", "data/mydb;hsqldb.default_table_type=cached", "-dbname.0", "xdb"}});
            this.serverHSQLDB = true;
            Thread.sleep(100L);
        }
    }

    void stopServer() throws Exception {
        if (this.serverH2 != null) {
            this.serverH2.stop();
            this.serverH2 = null;
        }
        if (this.serverDerby != null) {
            Method m = this.serverDerby.getClass().getMethod("shutdown", new Class[0]);
            m.invoke(this.serverDerby, null);
            this.serverDerby = null;
        } else if (this.serverHSQLDB) {
            // empty if block
        }
    }

    static Database parse(TestPerformance test, int id, String dbString) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(dbString, ",");
            Database db = new Database();
            db.id = id;
            db.test = test;
            db.name = tokenizer.nextToken().trim();
            String driver = tokenizer.nextToken().trim();
            Class.forName(driver);
            db.url = tokenizer.nextToken().trim();
            db.user = tokenizer.nextToken().trim();
            db.password = "";
            if (tokenizer.hasMoreTokens()) {
                db.password = tokenizer.nextToken().trim();
            }
            System.out.println("Loaded successfully: " + db.name);
            return db;
        }
        catch (Exception e) {
            System.out.println("Cannot load database " + dbString + " :" + e.toString());
            return null;
        }
    }

    Connection getConnection() throws Exception {
        return DriverManager.getConnection(this.url, this.user, this.password);
    }

    void openConnection() throws Exception {
        this.conn = DriverManager.getConnection(this.url, this.user, this.password);
        this.stat = this.conn.createStatement();
    }

    void closeConnection() throws Exception {
        this.conn.close();
        this.stat = null;
        this.conn = null;
    }

    public void setTranslations(Properties prop) {
        String id = this.url.substring("jdbc:".length());
        id = id.substring(0, id.indexOf(58));
        Iterator<Object> it = prop.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(id + ".")) continue;
            String pattern = key.substring(id.length() + 1);
            pattern = RuleParser.replaceAll(pattern, "_", " ");
            pattern = pattern.toUpperCase();
            String replacement = prop.getProperty(key);
            this.replace.add(new String[]{pattern, replacement});
        }
    }

    PreparedStatement prepare(String sql) throws Exception {
        sql = this.getSQL(sql);
        return this.conn.prepareStatement(sql);
    }

    public String getSQL(String sql) {
        for (int i = 0; i < this.replace.size(); ++i) {
            String[] pair = (String[])this.replace.get(i);
            String pattern = pair[0];
            String replace = pair[1];
            sql = RuleParser.replaceAll(sql, pattern, replace);
        }
        return sql;
    }

    void start(Bench bench, String action) {
        this.action = bench.getName() + ": " + action;
        this.startTime = System.currentTimeMillis();
    }

    void end() {
        long time = System.currentTimeMillis() - this.startTime;
        this.log(this.action, "ms", (int)time);
        if (this.test.collect) {
            this.totalTime = (int)((long)this.totalTime + time);
        }
    }

    void dropTable(String table) {
        try {
            this.update("DROP TABLE " + table);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update(PreparedStatement prep) throws Exception {
        prep.executeUpdate();
        ++this.executedStatements;
    }

    public void update(String sql) throws Exception {
        if ((sql = this.getSQL(sql)).trim().length() > 0) {
            this.stat.execute(sql);
        } else {
            System.out.println("?");
        }
        ++this.executedStatements;
    }

    public void setAutoCommit(boolean b) throws Exception {
        this.conn.setAutoCommit(b);
    }

    public void commit() throws Exception {
        this.conn.commit();
    }

    public void rollback() throws Exception {
        this.conn.rollback();
    }

    void trace(String action, int i, int max) {
        if (this.trace) {
            long time = System.currentTimeMillis();
            if (i == 0 || this.lastTrace == 0L) {
                this.lastTrace = time;
            } else if (time > this.lastTrace + 1000L) {
                System.out.println(action + ": " + 100 * i / max + "%");
                this.lastTrace = time;
            }
        }
    }

    void logMemory(Bench bench, String action) {
        this.log(bench.getName() + ": " + action, "MB", TestBase.getMemoryUsed());
    }

    void log(String action, String scale, int value) {
        if (this.test.collect) {
            this.results.add(new Object[]{action, scale, new Integer(value)});
        }
    }

    public ResultSet query(PreparedStatement prep) throws Exception {
        ResultSet rs = prep.executeQuery();
        ++this.executedStatements;
        return rs;
    }

    public void queryReadResult(PreparedStatement prep) throws Exception {
        ResultSet rs = prep.executeQuery();
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        while (rs.next()) {
            for (int i = 0; i < columnCount; ++i) {
                rs.getString(i + 1);
            }
        }
    }

    int getExecutedStatements() {
        return this.executedStatements;
    }

    public int getId() {
        return this.id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

