/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;

public class TestAutoRecompile
extends TestBase {
    public void test() throws Exception {
        this.deleteDb("autoRecompile");
        Connection conn = this.getConnection("autoRecompile");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY)");
        PreparedStatement prep = conn.prepareStatement("SELECT * FROM TEST");
        this.check(prep.executeQuery().getMetaData().getColumnCount(), 1L);
        stat.execute("ALTER TABLE TEST ADD COLUMN NAME VARCHAR(255)");
        this.check(prep.executeQuery().getMetaData().getColumnCount(), 2L);
        stat.execute("DROP TABLE TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, X INT, Y INT)");
        this.check(prep.executeQuery().getMetaData().getColumnCount(), 3L);
        prep = conn.prepareStatement("INSERT INTO TEST VALUES(1, 2, 3)");
        stat.execute("ALTER TABLE TEST ADD COLUMN Z INT");
        try {
            prep.execute();
            this.error("must fail");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        try {
            prep.execute();
            this.error("must fail");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        conn.close();
    }
}

