/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Random;
import org.h2.test.TestBase;

public class TestCases
extends TestBase {
    public void test() throws Exception {
        this.testDisconnect();
        this.testExecuteTrace();
        if (this.config.memory) {
            return;
        }
        this.testAlterTableReconnect();
        this.testPersistentSettings();
        this.testInsertSelectUnion();
        this.testViewReconnect();
        this.testDefaultQueryReconnect();
        this.testBigString();
        this.testRenameReconnect();
        this.testAllSizes();
        this.testCreateDrop();
        this.testPolePos();
        this.testQuick();
        this.testMutableObjects();
        this.testSelectForUpdate();
        this.testDoubleRecovery();
        this.testConstraintReconnect();
    }

    private void testDisconnect() throws Exception {
        if (this.config.networked) {
            return;
        }
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        final Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID IDENTITY)");
        for (int i = 0; i < 1000; ++i) {
            stat.execute("INSERT INTO TEST() VALUES()");
        }
        final boolean[] stopped = new boolean[1];
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    ResultSet rs = stat.executeQuery("SELECT MAX(T.ID) FROM TEST T, TEST, TEST, TEST, TEST, TEST, TEST, TEST, TEST, TEST, TEST");
                    rs.next();
                    new Error("query was too quick; result: " + rs.getInt(1)).printStackTrace();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                stopped[0] = true;
            }
        });
        t.start();
        Thread.sleep(200L);
        long time = System.currentTimeMillis();
        conn.close();
        Thread.sleep(100L);
        if (!stopped[0]) {
            this.error("query still running");
        }
        if ((time = System.currentTimeMillis() - time) > 1000L) {
            this.error("closing took " + time);
        }
        this.deleteDb("cases");
    }

    private void testExecuteTrace() throws Exception {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT ? FROM DUAL {1: 'Hello'}");
        rs.next();
        this.check("Hello", rs.getString(1));
        this.checkFalse(rs.next());
        rs = stat.executeQuery("SELECT ? FROM DUAL UNION ALL SELECT ? FROM DUAL {1: 'Hello', 2:'World' }");
        rs.next();
        this.check("Hello", rs.getString(1));
        rs.next();
        this.check("World", rs.getString(1));
        this.checkFalse(rs.next());
        conn.close();
    }

    private void testAlterTableReconnect() throws Exception {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id identity);");
        stat.execute("insert into test values(1);");
        try {
            stat.execute("alter table test add column name varchar not null;");
            this.error("shouldn't work");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        conn.close();
        conn = this.getConnection("cases");
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM TEST");
        rs.next();
        this.check(rs.getString(1), "1");
        this.checkFalse(rs.next());
        stat = conn.createStatement();
        stat.execute("drop table test");
        stat.execute("create table test(id identity)");
        stat.execute("insert into test values(1)");
        stat.execute("alter table test alter column id set default 'x'");
        conn.close();
        conn = this.getConnection("cases");
        stat = conn.createStatement();
        rs = conn.createStatement().executeQuery("SELECT * FROM TEST");
        rs.next();
        this.check(rs.getString(1), "1");
        this.checkFalse(rs.next());
        stat.execute("drop table test");
        stat.execute("create table test(id identity)");
        stat.execute("insert into test values(1)");
        try {
            stat.execute("alter table test alter column id date");
            this.error("shouldn't work");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        conn.close();
        conn = this.getConnection("cases");
        rs = conn.createStatement().executeQuery("SELECT * FROM TEST");
        rs.next();
        this.check(rs.getString(1), "1");
        this.checkFalse(rs.next());
        conn.close();
    }

    private void testPersistentSettings() throws Exception {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("SET COLLATION de_DE");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        stat.execute("CREATE INDEX IDXNAME ON TEST(NAME)");
        stat.execute("INSERT INTO TEST VALUES(1, 'B\u00f6hlen'), (2, 'Bach'), (3, 'Bucher')");
        conn.close();
        conn = this.getConnection("cases");
        ResultSet rs = conn.createStatement().executeQuery("SELECT NAME FROM TEST ORDER BY NAME");
        rs.next();
        this.check(rs.getString(1), "Bach");
        rs.next();
        this.check(rs.getString(1), "B\u00f6hlen");
        rs.next();
        this.check(rs.getString(1), "Bucher");
        conn.close();
    }

    private void testInsertSelectUnion() throws Exception {
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ORDER_ID INT PRIMARY KEY, ORDER_DATE DATETIME, USER_ID INT ,DESCRIPTION VARCHAR, STATE VARCHAR, TRACKING_ID VARCHAR)");
        Timestamp orderDate = Timestamp.valueOf("2005-05-21 17:46:00");
        String sql = "insert into TEST (ORDER_ID,ORDER_DATE,USER_ID,DESCRIPTION,STATE,TRACKING_ID) select ?,?,?,?,?,? union all select ?,?,?,?,?,?";
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setInt(1, 5555);
        ps.setTimestamp(2, orderDate);
        ps.setInt(3, 2222);
        ps.setString(4, "test desc");
        ps.setString(5, "teststate");
        ps.setString(6, "testid");
        ps.setInt(7, 5556);
        ps.setTimestamp(8, orderDate);
        ps.setInt(9, 2222);
        ps.setString(10, "test desc");
        ps.setString(11, "teststate");
        ps.setString(12, "testid");
        this.check(ps.executeUpdate(), 2L);
        ps.close();
        conn.close();
    }

    private void testViewReconnect() throws Exception {
        this.trace("testViewReconnect");
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int)");
        stat.execute("create view abc as select * from test");
        stat.execute("drop table test");
        conn.close();
        conn = this.getConnection("cases");
        stat = conn.createStatement();
        try {
            stat.execute("select * from abc");
            this.error("abc should be deleted");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        conn.close();
    }

    private void testDefaultQueryReconnect() throws Exception {
        this.trace("testDefaultQueryReconnect");
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table parent(id int)");
        stat.execute("insert into parent values(1)");
        stat.execute("create table test(id int default (select max(id) from parent), name varchar)");
        conn.close();
        conn = this.getConnection("cases");
        stat = conn.createStatement();
        conn.setAutoCommit(false);
        stat.execute("insert into parent values(2)");
        stat.execute("insert into test(name) values('test')");
        ResultSet rs = stat.executeQuery("select * from test");
        rs.next();
        this.check(rs.getInt(1), 2L);
        this.checkFalse(rs.next());
        conn.close();
    }

    private void testBigString() throws Exception {
        this.trace("testBigString");
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT, TEXT VARCHAR, TEXT_C CLOB)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?, ?)");
        int len = this.getSize(1000, 66000);
        char[] buff = new char[len];
        Random random = new Random();
        random.setSeed(1L);
        for (int i = 0; i < len; ++i) {
            char c;
            while ((c = (char)random.nextInt()) >= '\ud800' && c <= '\udfff') {
            }
            buff[i] = c;
        }
        String big = new String(buff);
        prep.setInt(1, 1);
        prep.setString(2, big);
        prep.setString(3, big);
        prep.execute();
        prep.setInt(1, 2);
        prep.setCharacterStream(2, (Reader)new StringReader(big), 0);
        prep.setCharacterStream(3, (Reader)new StringReader(big), 0);
        prep.execute();
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        rs.next();
        this.check(rs.getInt(1), 1L);
        this.check(rs.getString(2), big);
        this.check(this.readString(rs.getCharacterStream(2)), big);
        this.check(rs.getString(3), big);
        this.check(this.readString(rs.getCharacterStream(3)), big);
        rs.next();
        this.check(rs.getInt(1), 2L);
        this.check(rs.getString(2), big);
        this.check(this.readString(rs.getCharacterStream(2)), big);
        this.check(rs.getString(3), big);
        this.check(this.readString(rs.getCharacterStream(3)), big);
        rs.next();
        this.checkFalse(rs.next());
        conn.close();
    }

    private void testConstraintReconnect() throws Exception {
        this.trace("testConstraintReconnect");
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("drop table if exists parent");
        stat.execute("drop table if exists child");
        stat.execute("create table parent(id int)");
        stat.execute("create table child(c_id int, p_id int, foreign key(p_id) references parent(id))");
        stat.execute("insert into parent values(1), (2)");
        stat.execute("insert into child values(1, 1)");
        stat.execute("insert into child values(2, 2)");
        stat.execute("insert into child values(3, 2)");
        stat.execute("delete from child");
        conn.close();
        conn = this.getConnection("cases");
        conn.close();
    }

    private void testDoubleRecovery() throws Exception {
        if (this.config.networked) {
            return;
        }
        this.trace("testDoubleRecovery");
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        this.deleteDb("twoPhaseCommit");
        Statement stat = conn.createStatement();
        stat.execute("SET WRITE_DELAY 0");
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        conn.setAutoCommit(false);
        stat.execute("INSERT INTO TEST VALUES(2, 'World')");
        this.crash(conn);
        conn = this.getConnection("cases");
        stat = conn.createStatement();
        stat.execute("SET WRITE_DELAY 0");
        stat.execute("INSERT INTO TEST VALUES(3, 'Break')");
        this.crash(conn);
        conn = this.getConnection("cases");
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        rs.next();
        this.check(rs.getInt(1), 1L);
        this.check(rs.getString(2), "Hello");
        rs.next();
        this.check(rs.getInt(1), 3L);
        this.check(rs.getString(2), "Break");
        conn.close();
    }

    private void testRenameReconnect() throws Exception {
        this.trace("testRenameReconnect");
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        conn.createStatement().execute("CREATE TABLE TEST_SEQ(ID INT IDENTITY, NAME VARCHAR(255))");
        conn.createStatement().execute("CREATE TABLE TEST(ID INT PRIMARY KEY)");
        conn.createStatement().execute("ALTER TABLE TEST RENAME TO TEST2");
        conn.createStatement().execute("CREATE TABLE TEST_B(ID INT PRIMARY KEY, NAME VARCHAR, UNIQUE(NAME));");
        conn.close();
        conn = this.getConnection("cases");
        conn.createStatement().execute("INSERT INTO TEST_SEQ(NAME) VALUES('Hi')");
        ResultSet rs = conn.createStatement().executeQuery("CALL IDENTITY()");
        rs.next();
        this.check(rs.getInt(1), 1L);
        conn.createStatement().execute("SELECT * FROM TEST2");
        conn.createStatement().execute("SELECT * FROM TEST_B");
        conn.createStatement().execute("ALTER TABLE TEST_B RENAME TO TEST_B2");
        conn.close();
        conn = this.getConnection("cases");
        conn.createStatement().execute("SELECT * FROM TEST_B2");
        conn.createStatement().execute("INSERT INTO TEST_SEQ(NAME) VALUES('World')");
        rs = conn.createStatement().executeQuery("CALL IDENTITY()");
        rs.next();
        this.check(rs.getInt(1), 2L);
        conn.close();
    }

    private void testAllSizes() throws Exception {
        this.trace("testAllSizes");
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(A INT, B INT, C INT, DATA VARCHAR)");
        int increment = this.getSize(100, 1);
        for (int i = 1; i < 500; i += increment) {
            StringBuffer buff = new StringBuffer();
            buff.append("CREATE TABLE TEST");
            for (int j = 0; j < i; ++j) {
                buff.append('a');
            }
            buff.append("(ID INT)");
            String sql = buff.toString();
            stat.execute(sql);
            stat.execute("INSERT INTO TEST VALUES(" + i + ", 0, 0, '" + sql + "')");
        }
        conn.close();
        conn = this.getConnection("cases");
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST");
        while (rs.next()) {
            int id = rs.getInt(1);
            String s = rs.getString("DATA");
            if (s.endsWith(")")) continue;
            this.error("id=" + id);
        }
        conn.close();
    }

    private void testSelectForUpdate() throws Exception {
        this.trace("testSelectForUpdate");
        this.deleteDb("cases");
        Connection conn1 = this.getConnection("cases");
        Statement stat1 = conn1.createStatement();
        stat1.execute("CREATE TABLE TEST(ID INT)");
        stat1.execute("INSERT INTO TEST VALUES(1)");
        conn1.setAutoCommit(false);
        stat1.execute("SELECT * FROM TEST FOR UPDATE");
        Connection conn2 = this.getConnection("cases");
        Statement stat2 = conn2.createStatement();
        try {
            stat2.execute("UPDATE TEST SET ID=2");
            this.error("must fail");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        conn1.commit();
        stat2.execute("UPDATE TEST SET ID=2");
        conn1.close();
        conn2.close();
    }

    private void testMutableObjects() throws Exception {
        this.trace("testMutableObjects");
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT, D DATE, T TIME, TS TIMESTAMP)");
        stat.execute("INSERT INTO TEST VALUES(1, '2001-01-01', '20:00:00', '2002-02-02 22:22:22.2')");
        stat.execute("INSERT INTO TEST VALUES(1, '2001-01-01', '20:00:00', '2002-02-02 22:22:22.2')");
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST");
        rs.next();
        Date d1 = rs.getDate("D");
        Time t1 = rs.getTime("T");
        Timestamp ts1 = rs.getTimestamp("TS");
        rs.next();
        Date d2 = rs.getDate("D");
        Time t2 = rs.getTime("T");
        Timestamp ts2 = rs.getTimestamp("TS");
        this.check(ts1 != ts2);
        this.check(d1 != d2);
        this.check(t1 != t2);
        this.check(t2 != rs.getObject("T"));
        this.check(d2 != rs.getObject("D"));
        this.check(ts2 != rs.getObject("TS"));
        this.checkFalse(rs.next());
        conn.close();
    }

    private void testCreateDrop() throws Exception {
        this.trace("testCreateDrop");
        this.deleteDb("cases");
        Connection conn = this.getConnection("cases");
        Statement stat = conn.createStatement();
        stat.execute("create table employee(id int, firstname VARCHAR(50), salary decimal(10, 2), superior_id int, CONSTRAINT PK_employee PRIMARY KEY (id), CONSTRAINT FK_superior FOREIGN KEY (superior_id) REFERENCES employee(ID))");
        stat.execute("DROP TABLE employee");
        conn.close();
        conn = this.getConnection("cases");
        conn.close();
    }

    private void testPolePos() throws Exception {
        this.trace("testPolePos");
        Connection c0 = this.getConnection("cases");
        c0.createStatement().executeUpdate("SET AUTOCOMMIT FALSE");
        c0.createStatement().executeUpdate("create table australia (ID  INTEGER NOT NULL, Name VARCHAR(100), FirstName VARCHAR(100), Points INTEGER, LicenseID INTEGER, PRIMARY KEY(ID))");
        c0.createStatement().executeUpdate("COMMIT");
        c0.close();
        c0 = this.getConnection("cases");
        c0.createStatement().executeUpdate("SET AUTOCOMMIT FALSE");
        PreparedStatement p15 = c0.prepareStatement("insert into australia (id,Name,FirstName,Points,LicenseID) values (?,?,?,?,?)");
        for (int i = 0; i < this.getSize(1, 3000); ++i) {
            p15.setInt(1, i);
            p15.setString(2, "Pilot_" + i);
            p15.setString(3, "Herkules");
            p15.setInt(4, i);
            p15.setInt(5, i);
            p15.executeUpdate();
        }
        c0.createStatement().executeUpdate("COMMIT");
        c0.close();
        c0 = this.getConnection("cases");
        c0.createStatement().executeUpdate("SET AUTOCOMMIT FALSE");
        c0.createStatement().executeUpdate("drop table australia");
        c0.createStatement().executeUpdate("create table australia (ID  INTEGER NOT NULL, Name VARCHAR(100), FirstName VARCHAR(100), Points INTEGER, LicenseID INTEGER, PRIMARY KEY(ID))");
        c0.createStatement().executeUpdate("COMMIT");
        c0.close();
        c0 = this.getConnection("cases");
        c0.createStatement().executeUpdate("SET AUTOCOMMIT FALSE");
        PreparedStatement p65 = c0.prepareStatement("insert into australia (id,Name,FirstName,Points,LicenseID) values (?,?,?,?,?)");
        for (int i = 0; i < this.getSize(1, 10000); ++i) {
            p65.setInt(1, i);
            p65.setString(2, "Pilot_" + i);
            p65.setString(3, "Herkules");
            p65.setInt(4, i);
            p65.setInt(5, i);
            p65.executeUpdate();
        }
        c0.createStatement().executeUpdate("COMMIT");
        c0.createStatement().executeUpdate("COMMIT");
        c0.createStatement().executeUpdate("COMMIT");
        c0.close();
        c0 = this.getConnection("cases");
        c0.close();
    }

    private void testQuick() throws Exception {
        this.trace("testQuick");
        this.deleteDb("cases");
        Connection c0 = this.getConnection("cases");
        c0.createStatement().executeUpdate("create table test (ID  int PRIMARY KEY)");
        c0.createStatement().executeUpdate("insert into test values(1)");
        c0.createStatement().executeUpdate("drop table test");
        c0.createStatement().executeUpdate("create table test (ID  int PRIMARY KEY)");
        c0.close();
        c0 = this.getConnection("cases");
        c0.createStatement().executeUpdate("insert into test values(1)");
        c0.close();
        c0 = this.getConnection("cases");
        c0.close();
    }
}

