/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Random;
import org.h2.test.TestAll;
import org.h2.test.TestBase;

public class TestMultiThread
extends TestBase
implements Runnable {
    private boolean stop;
    private TestMultiThread parent;
    private Random random;
    private Connection conn;
    private Statement stat;

    public TestMultiThread() {
    }

    private TestMultiThread(TestAll config, TestMultiThread parent) throws Exception {
        this.config = config;
        this.parent = parent;
        this.random = new Random();
        this.conn = this.getConnection();
        this.stat = this.conn.createStatement();
    }

    public void test() throws Exception {
        int i;
        Connection conn = this.getConnection();
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID IDENTITY, NAME VARCHAR)");
        int len = this.getSize(10, 200);
        Thread[] threads = new Thread[len];
        for (i = 0; i < len; ++i) {
            threads[i] = new Thread(new TestMultiThread(this.config, this));
        }
        for (i = 0; i < len; ++i) {
            threads[i].start();
        }
        int sleep = this.getSize(400, 10000);
        Thread.sleep(sleep);
        this.stop = true;
        for (int i2 = 0; i2 < len; ++i2) {
            threads[i2].join();
        }
        ResultSet rs = stat.executeQuery("SELECT COUNT(*) FROM TEST");
        rs.next();
        this.trace("max id=" + rs.getInt(1));
        conn.close();
    }

    Connection getConnection() throws Exception {
        return this.getConnection("jdbc:h2:mem:multiThread");
    }

    public void run() {
        try {
            while (!this.parent.stop) {
                this.stat.execute("SELECT COUNT(*) FROM TEST");
                this.stat.execute("INSERT INTO TEST VALUES(NULL, 'Hi')");
                PreparedStatement prep = this.conn.prepareStatement("UPDATE TEST SET NAME='Hello' WHERE ID=?");
                prep.setInt(1, this.random.nextInt(10000));
                prep.execute();
                prep = this.conn.prepareStatement("SELECT * FROM TEST WHERE ID=?");
                prep.setInt(1, this.random.nextInt(10000));
                ResultSet rs = prep.executeQuery();
                while (rs.next()) {
                    rs.getString("NAME");
                }
            }
            this.conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }
}

