/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import org.h2.test.TestBase;

public class TestResultSet
extends TestBase {
    Connection conn;
    Statement stat;

    public void test() throws Exception {
        this.deleteDb("resultset");
        this.conn = this.getConnection("resultset");
        this.stat = this.conn.createStatement();
        this.testLimitMaxRows();
        this.trace("max rows=" + this.stat.getMaxRows());
        this.stat.setMaxRows(6);
        this.trace("max rows after set to 6=" + this.stat.getMaxRows());
        this.check(this.stat.getMaxRows() == 6);
        this.testInt();
        this.testVarchar();
        this.testDecimal();
        this.testDoubleFloat();
        this.testDatetime();
        this.testDatetimeWithCalendar();
        this.testBlob();
        this.testClob();
        this.testAutoIncrement();
        this.conn.close();
    }

    private void testLimitMaxRows() throws Exception {
        this.trace("Test LimitMaxRows");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY)");
        this.stat.execute("INSERT INTO TEST VALUES(1), (2), (3), (4)");
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST");
        this.checkResultRowCount(rs, 4);
        rs = this.stat.executeQuery("SELECT * FROM TEST LIMIT 2");
        this.checkResultRowCount(rs, 2);
        this.stat.setMaxRows(2);
        rs = this.stat.executeQuery("SELECT * FROM TEST");
        this.checkResultRowCount(rs, 2);
        rs = this.stat.executeQuery("SELECT * FROM TEST LIMIT 1");
        this.checkResultRowCount(rs, 1);
        rs = this.stat.executeQuery("SELECT * FROM TEST LIMIT 3");
        this.checkResultRowCount(rs, 2);
        this.stat.setMaxRows(0);
        this.stat.execute("DROP TABLE TEST");
    }

    void testAutoIncrement() throws Exception {
        this.trace("Test AutoIncrement");
        this.stat.execute("DROP TABLE IF EXISTS TEST");
        this.stat.execute("CREATE TABLE TEST(ID IDENTITY, NAME VARCHAR)");
        this.stat.execute("INSERT INTO TEST(NAME) VALUES('Hello')");
        ResultSet rs = this.stat.getGeneratedKeys();
        this.check(rs.next());
        this.check(rs.getInt(1), 1L);
        this.stat.execute("INSERT INTO TEST(NAME) VALUES('World')");
        rs = this.stat.getGeneratedKeys();
        this.check(rs.next());
        this.check(rs.getInt(1), 2L);
        rs = this.stat.executeQuery("SELECT ID AS I, NAME AS N FROM TEST");
        ResultSetMetaData meta = rs.getMetaData();
        this.check(meta.isAutoIncrement(1));
        this.checkFalse(meta.isAutoIncrement(2));
        this.check(rs.next());
        this.check(rs.next());
        this.checkFalse(rs.next());
    }

    void testInt() throws Exception {
        this.trace("Test INT");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,VALUE INT)");
        this.stat.execute("INSERT INTO TEST VALUES(1,-1)");
        this.stat.execute("INSERT INTO TEST VALUES(2,0)");
        this.stat.execute("INSERT INTO TEST VALUES(3,1)");
        this.stat.execute("INSERT INTO TEST VALUES(4,2147483647)");
        this.stat.execute("INSERT INTO TEST VALUES(5,-2147483648)");
        this.stat.execute("INSERT INTO TEST VALUES(6,NULL)");
        this.stat.execute("INSERT INTO TEST VALUES(7,NULL)");
        ResultSet rs = this.stat.executeQuery("SELECT *, NULL AS N FROM TEST ORDER BY ID");
        ResultSetMetaData meta = rs.getMetaData();
        this.check(meta.getColumnCount(), 3L);
        this.check(meta.getCatalogName(1), "RESULTSET");
        this.check("PUBLIC".equals(meta.getSchemaName(2)));
        this.check("TEST".equals(meta.getTableName(1)));
        this.check("ID".equals(meta.getColumnName(1)));
        this.check("VALUE".equals(meta.getColumnName(2)));
        this.check(!meta.isAutoIncrement(1));
        this.check(meta.isCaseSensitive(1));
        this.check(meta.isSearchable(1));
        this.checkFalse(meta.isCurrency(1));
        this.check(meta.getColumnDisplaySize(1) > 0);
        this.check(meta.isSigned(1));
        this.check(meta.isSearchable(2));
        this.check(meta.isNullable(1), 2L);
        this.checkFalse(meta.isReadOnly(1));
        this.check(meta.isWritable(1));
        this.checkFalse(meta.isDefinitelyWritable(1));
        this.check(meta.getColumnDisplaySize(1) > 0);
        this.check(meta.getColumnDisplaySize(2) > 0);
        this.check(meta.getColumnClassName(3), null);
        this.check(rs.getRow() == 0);
        this.testResultSetMeta(rs, 3, new String[]{"ID", "VALUE", "N"}, new int[]{4, 4, 0}, new int[]{10, 10, 1}, new int[]{0, 0, 0});
        rs.next();
        this.check(rs.getConcurrency(), 1007L);
        this.check(rs.getFetchDirection(), 1000L);
        this.trace("default fetch size=" + rs.getFetchSize());
        rs.setFetchSize(0);
        this.trace("after set to 0, fetch size=" + rs.getFetchSize());
        try {
            rs.setFetchSize(-1);
            this.error("fetch size -1 is not allowed");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
            this.trace(e.toString());
        }
        this.trace("after try to set to -1, fetch size=" + rs.getFetchSize());
        try {
            rs.setFetchSize(100);
            this.error("fetch size 100 is bigger than maxrows - not allowed");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
            this.trace(e.toString());
        }
        this.trace("after try set to 100, fetch size=" + rs.getFetchSize());
        rs.setFetchSize(6);
        this.check(rs.getRow() == 1);
        this.check(rs.findColumn("VALUE"), 2L);
        this.check(rs.findColumn("value"), 2L);
        this.check(rs.findColumn("Value"), 2L);
        this.check(rs.findColumn("Value"), 2L);
        this.check(rs.findColumn("ID"), 1L);
        this.check(rs.findColumn("id"), 1L);
        this.check(rs.findColumn("Id"), 1L);
        this.check(rs.findColumn("iD"), 1L);
        this.check(rs.getInt(2) == -1 && !rs.wasNull());
        this.check(rs.getInt("VALUE") == -1 && !rs.wasNull());
        this.check(rs.getInt("value") == -1 && !rs.wasNull());
        this.check(rs.getInt("Value") == -1 && !rs.wasNull());
        this.check(rs.getString("Value").equals("-1") && !rs.wasNull());
        Object o = rs.getObject("value");
        this.trace(o.getClass().getName());
        this.check(o instanceof Integer);
        this.check((Integer)o == -1);
        o = rs.getObject(2);
        this.trace(o.getClass().getName());
        this.check(o instanceof Integer);
        this.check((Integer)o == -1);
        this.check(rs.getBoolean("Value"));
        this.check(rs.getByte("Value") == -1);
        this.check(rs.getShort("Value") == -1);
        this.check(rs.getLong("Value") == -1L);
        this.check((double)rs.getFloat("Value") == -1.0);
        this.check(rs.getDouble("Value") == -1.0);
        this.check(rs.getString("Value").equals("-1") && !rs.wasNull());
        this.check(rs.getInt("ID") == 1 && !rs.wasNull());
        this.check(rs.getInt("id") == 1 && !rs.wasNull());
        this.check(rs.getInt("Id") == 1 && !rs.wasNull());
        this.check(rs.getInt(1) == 1 && !rs.wasNull());
        rs.next();
        this.check(rs.getRow() == 2);
        this.check(rs.getInt(2) == 0 && !rs.wasNull());
        this.check(!rs.getBoolean(2));
        this.check(rs.getByte(2) == 0);
        this.check(rs.getShort(2) == 0);
        this.check(rs.getLong(2) == 0L);
        this.check((double)rs.getFloat(2) == 0.0);
        this.check(rs.getDouble(2) == 0.0);
        this.check(rs.getString(2).equals("0") && !rs.wasNull());
        this.check(rs.getInt(1) == 2 && !rs.wasNull());
        rs.next();
        this.check(rs.getRow() == 3);
        this.check(rs.getInt("ID") == 3 && !rs.wasNull());
        this.check(rs.getInt("VALUE") == 1 && !rs.wasNull());
        rs.next();
        this.check(rs.getRow() == 4);
        this.check(rs.getInt("ID") == 4 && !rs.wasNull());
        this.check(rs.getInt("VALUE") == Integer.MAX_VALUE && !rs.wasNull());
        rs.next();
        this.check(rs.getRow() == 5);
        this.check(rs.getInt("id") == 5 && !rs.wasNull());
        this.check(rs.getInt("value") == Integer.MIN_VALUE && !rs.wasNull());
        this.check(rs.getString(1).equals("5") && !rs.wasNull());
        rs.next();
        this.check(rs.getRow() == 6);
        this.check(rs.getInt("id") == 6 && !rs.wasNull());
        this.check(rs.getInt("value") == 0 && rs.wasNull());
        this.check(rs.getInt(2) == 0 && rs.wasNull());
        this.check(rs.getInt(1) == 6 && !rs.wasNull());
        this.check(rs.getString(1).equals("6") && !rs.wasNull());
        this.check(rs.getString(2) == null && rs.wasNull());
        o = rs.getObject(2);
        this.check(o == null);
        this.check(rs.wasNull());
        this.checkFalse(rs.next());
        this.check(rs.getRow(), 0L);
        this.stat.execute("DROP TABLE TEST");
        this.stat.setMaxRows(0);
    }

    void testVarchar() throws Exception {
        this.trace("Test VARCHAR");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,VALUE VARCHAR(255))");
        this.stat.execute("INSERT INTO TEST VALUES(1,'')");
        this.stat.execute("INSERT INTO TEST VALUES(2,' ')");
        this.stat.execute("INSERT INTO TEST VALUES(3,'  ')");
        this.stat.execute("INSERT INTO TEST VALUES(4,NULL)");
        this.stat.execute("INSERT INTO TEST VALUES(5,'Hi')");
        this.stat.execute("INSERT INTO TEST VALUES(6,' Hi ')");
        this.stat.execute("INSERT INTO TEST VALUES(7,'Joe''s')");
        this.stat.execute("INSERT INTO TEST VALUES(8,'{escape}')");
        this.stat.execute("INSERT INTO TEST VALUES(9,'\\n')");
        this.stat.execute("INSERT INTO TEST VALUES(10,'\\''')");
        this.stat.execute("INSERT INTO TEST VALUES(11,'\\%')");
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        this.testResultSetMeta(rs, 2, new String[]{"ID", "VALUE"}, new int[]{4, 12}, new int[]{10, 255}, new int[]{0, 0});
        rs.next();
        String value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: <>)");
        this.check(value != null && value.equals("") && !rs.wasNull());
        this.check(rs.getInt(1) == 1 && !rs.wasNull());
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: < >)");
        this.check(rs.getString(2).equals(" ") && !rs.wasNull());
        this.check(rs.getInt(1) == 2 && !rs.wasNull());
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: <  >)");
        this.check(rs.getString(2).equals("  ") && !rs.wasNull());
        this.check(rs.getInt(1) == 3 && !rs.wasNull());
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: <null>)");
        this.check(rs.getString(2) == null && rs.wasNull());
        this.check(rs.getInt(1) == 4 && !rs.wasNull());
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: <Hi>)");
        this.check(rs.getInt(1) == 5 && !rs.wasNull());
        this.check(rs.getString(2).equals("Hi") && !rs.wasNull());
        Object o = rs.getObject("value");
        this.trace(o.getClass().getName());
        this.check(o instanceof String);
        this.check(o.toString().equals("Hi"));
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: < Hi >)");
        this.check(rs.getInt(1) == 6 && !rs.wasNull());
        this.check(rs.getString(2).equals(" Hi ") && !rs.wasNull());
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: <Joe's>)");
        this.check(rs.getInt(1) == 7 && !rs.wasNull());
        this.check(rs.getString(2).equals("Joe's") && !rs.wasNull());
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: <{escape}>)");
        this.check(rs.getInt(1) == 8 && !rs.wasNull());
        this.check(rs.getString(2).equals("{escape}") && !rs.wasNull());
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: <\\n>)");
        this.check(rs.getInt(1) == 9 && !rs.wasNull());
        this.check(rs.getString(2).equals("\\n") && !rs.wasNull());
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: <\\'>)");
        this.check(rs.getInt(1) == 10 && !rs.wasNull());
        this.check(rs.getString(2).equals("\\'") && !rs.wasNull());
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: <\\%>)");
        this.check(rs.getInt(1) == 11 && !rs.wasNull());
        this.check(rs.getString(2).equals("\\%") && !rs.wasNull());
        this.check(!rs.next());
        this.stat.execute("DROP TABLE TEST");
    }

    void testDecimal() throws Exception {
        this.trace("Test DECIMAL");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,VALUE DECIMAL(10,2))");
        this.stat.execute("INSERT INTO TEST VALUES(1,-1)");
        this.stat.execute("INSERT INTO TEST VALUES(2,.0)");
        this.stat.execute("INSERT INTO TEST VALUES(3,1.)");
        this.stat.execute("INSERT INTO TEST VALUES(4,12345678.89)");
        this.stat.execute("INSERT INTO TEST VALUES(6,99999999.99)");
        this.stat.execute("INSERT INTO TEST VALUES(7,-99999999.99)");
        this.stat.execute("INSERT INTO TEST VALUES(8,NULL)");
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        this.testResultSetMeta(rs, 2, new String[]{"ID", "VALUE"}, new int[]{4, 3}, new int[]{10, 10}, new int[]{0, 2});
        rs.next();
        this.check(rs.getInt(1) == 1);
        this.check(!rs.wasNull());
        this.check(rs.getInt(2) == -1);
        this.check(!rs.wasNull());
        BigDecimal bd = rs.getBigDecimal(2);
        this.check(bd.compareTo(new BigDecimal("-1.00")) == 0);
        this.check(!rs.wasNull());
        Object o = rs.getObject(2);
        this.trace(o.getClass().getName());
        this.check(o instanceof BigDecimal);
        this.check(((BigDecimal)o).compareTo(new BigDecimal("-1.00")) == 0);
        rs.next();
        this.check(rs.getInt(1) == 2);
        this.check(!rs.wasNull());
        this.check(rs.getInt(2) == 0);
        this.check(!rs.wasNull());
        bd = rs.getBigDecimal(2);
        this.check(bd.compareTo(new BigDecimal("0.00")) == 0);
        this.check(!rs.wasNull());
        rs.next();
        this.checkColumnBigDecimal(rs, 2, 1, "1.00");
        rs.next();
        this.checkColumnBigDecimal(rs, 2, 12345678, "12345678.89");
        rs.next();
        this.checkColumnBigDecimal(rs, 2, 99999999, "99999999.99");
        rs.next();
        this.checkColumnBigDecimal(rs, 2, -99999999, "-99999999.99");
        rs.next();
        this.checkColumnBigDecimal(rs, 2, 0, null);
        this.check(!rs.next());
        this.stat.execute("DROP TABLE TEST");
    }

    void testDoubleFloat() throws Exception {
        this.trace("Test DOUBLE - FLOAT");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, D DOUBLE, R REAL)");
        this.stat.execute("INSERT INTO TEST VALUES(1, -1, -1)");
        this.stat.execute("INSERT INTO TEST VALUES(2,.0, .0)");
        this.stat.execute("INSERT INTO TEST VALUES(3, 1., 1.)");
        this.stat.execute("INSERT INTO TEST VALUES(4, 12345678.89, 12345678.89)");
        this.stat.execute("INSERT INTO TEST VALUES(6, 99999999.99, 99999999.99)");
        this.stat.execute("INSERT INTO TEST VALUES(7, -99999999.99, -99999999.99)");
        this.stat.execute("INSERT INTO TEST VALUES(8, NULL, NULL)");
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        this.testResultSetMeta(rs, 3, new String[]{"ID", "D", "R"}, new int[]{4, 8, 7}, new int[]{10, 17, 7}, new int[]{0, 0, 0});
        rs.next();
        this.check(rs.getInt(1) == 1);
        this.check(!rs.wasNull());
        this.check(rs.getInt(2) == -1);
        this.check(rs.getInt(3) == -1);
        this.check(!rs.wasNull());
        BigDecimal bd = rs.getBigDecimal(2);
        this.check(bd.compareTo(new BigDecimal("-1.00")) == 0);
        this.check(!rs.wasNull());
        Object o = rs.getObject(2);
        this.trace(o.getClass().getName());
        this.check(o instanceof Double);
        this.check(((Double)o).compareTo(new Double("-1.00")) == 0);
        o = rs.getObject(3);
        this.trace(o.getClass().getName());
        this.check(o instanceof Float);
        this.check(((Float)o).compareTo(new Float("-1.00")) == 0);
        rs.next();
        this.check(rs.getInt(1) == 2);
        this.check(!rs.wasNull());
        this.check(rs.getInt(2) == 0);
        this.check(!rs.wasNull());
        this.check(rs.getInt(3) == 0);
        this.check(!rs.wasNull());
        bd = rs.getBigDecimal(2);
        this.check(bd.compareTo(new BigDecimal("0.00")) == 0);
        this.check(!rs.wasNull());
        bd = rs.getBigDecimal(3);
        this.check(bd.compareTo(new BigDecimal("0.00")) == 0);
        this.check(!rs.wasNull());
        rs.next();
        this.check(rs.getDouble(2), 1.0);
        this.check(rs.getFloat(3), 1.0f);
        rs.next();
        this.check(rs.getDouble(2), 1.234567889E7);
        this.check(rs.getFloat(3), 1.2345679E7f);
        rs.next();
        this.check(rs.getDouble(2), 9.999999999E7);
        this.check(rs.getFloat(3), 1.0E8f);
        rs.next();
        this.check(rs.getDouble(2), -9.999999999E7);
        this.check(rs.getFloat(3), -1.0E8f);
        rs.next();
        this.checkColumnBigDecimal(rs, 2, 0, null);
        this.checkColumnBigDecimal(rs, 3, 0, null);
        this.check(!rs.next());
        this.stat.execute("DROP TABLE TEST");
    }

    void testDatetime() throws Exception {
        this.trace("Test DATETIME");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,VALUE DATETIME)");
        this.stat.execute("INSERT INTO TEST VALUES(1,DATE '2011-11-11')");
        this.stat.execute("INSERT INTO TEST VALUES(2,TIMESTAMP '2002-02-02 02:02:02')");
        this.stat.execute("INSERT INTO TEST VALUES(3,TIMESTAMP '1800-1-1 0:0:0')");
        this.stat.execute("INSERT INTO TEST VALUES(4,TIMESTAMP '9999-12-31 23:59:59')");
        this.stat.execute("INSERT INTO TEST VALUES(5,NULL)");
        ResultSet rs = this.stat.executeQuery("SELECT 0 ID, TIMESTAMP '9999-12-31 23:59:59' VALUE FROM TEST ORDER BY ID");
        this.testResultSetMeta(rs, 2, new String[]{"ID", "VALUE"}, new int[]{4, 93}, new int[]{10, 23}, new int[]{0, 10});
        rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        this.testResultSetMeta(rs, 2, new String[]{"ID", "VALUE"}, new int[]{4, 93}, new int[]{10, 23}, new int[]{0, 10});
        rs.next();
        Date date = rs.getDate(2);
        this.check(!rs.wasNull());
        Time time = rs.getTime(2);
        this.check(!rs.wasNull());
        Timestamp ts = rs.getTimestamp(2);
        this.check(!rs.wasNull());
        this.trace("Date: " + date.toString() + " Time:" + time.toString() + " Timestamp:" + ts.toString());
        this.trace("Date ms: " + date.getTime() + " Time ms:" + time.getTime() + " Timestamp ms:" + ts.getTime());
        this.trace("1970 ms: " + Timestamp.valueOf("1970-01-01 00:00:00.0").getTime());
        this.check(date.getTime(), Timestamp.valueOf("2011-11-11 00:00:00.0").getTime());
        this.check(time.getTime(), Timestamp.valueOf("1970-01-01 00:00:00.0").getTime());
        this.check(ts.getTime(), Timestamp.valueOf("2011-11-11 00:00:00.0").getTime());
        this.check(date.equals(Timestamp.valueOf("2011-11-11 00:00:00.0")));
        this.check(time.equals(Timestamp.valueOf("1970-01-01 00:00:00.0")));
        this.check(ts.equals(Timestamp.valueOf("2011-11-11 00:00:00.0")));
        this.checkFalse(rs.wasNull());
        Object o = rs.getObject(2);
        this.trace(o.getClass().getName());
        this.check(o instanceof Timestamp);
        this.check(((Timestamp)o).equals(Timestamp.valueOf("2011-11-11 00:00:00.0")));
        this.checkFalse(rs.wasNull());
        rs.next();
        date = rs.getDate("VALUE");
        this.check(!rs.wasNull());
        time = rs.getTime("VALUE");
        this.check(!rs.wasNull());
        ts = rs.getTimestamp("VALUE");
        this.check(!rs.wasNull());
        this.trace("Date: " + date.toString() + " Time:" + time.toString() + " Timestamp:" + ts.toString());
        this.check(date.toString(), "2002-02-02");
        this.check(time.toString(), "02:02:02");
        this.check(ts.toString(), "2002-02-02 02:02:02.0");
        rs.next();
        this.check(rs.getDate("value").toString(), "1800-01-01");
        this.check(rs.getTime("value").toString(), "00:00:00");
        this.check(rs.getTimestamp("value").toString(), "1800-01-01 00:00:00.0");
        rs.next();
        this.check(rs.getDate("Value").toString(), "9999-12-31");
        this.check(rs.getTime("Value").toString(), "23:59:59");
        this.check(rs.getTimestamp("Value").toString(), "9999-12-31 23:59:59.0");
        rs.next();
        this.check(rs.getDate("Value") == null && rs.wasNull());
        this.check(rs.getTime("vALUe") == null && rs.wasNull());
        this.check(rs.getTimestamp(2) == null && rs.wasNull());
        this.check(!rs.next());
        rs = this.stat.executeQuery("SELECT DATE '2001-02-03' D, TIME '14:15:16', TIMESTAMP '2007-08-09 10:11:12.141516171' TS FROM TEST");
        rs.next();
        date = (Date)rs.getObject(1);
        time = (Time)rs.getObject(2);
        ts = (Timestamp)rs.getObject(3);
        this.check(date.toString(), "2001-02-03");
        this.check(time.toString(), "14:15:16");
        this.check(ts.toString(), "2007-08-09 10:11:12.141516171");
        this.stat.execute("DROP TABLE TEST");
    }

    void testDatetimeWithCalendar() throws Exception {
        this.trace("Test DATETIME with Calendar");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, D DATE, T TIME, TS TIMESTAMP)");
        PreparedStatement prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?, ?, ?, ?)");
        Calendar regular = Calendar.getInstance();
        Calendar other = null;
        String[] timezones = TimeZone.getAvailableIDs();
        for (int i = 0; i < timezones.length; ++i) {
            TimeZone zone = TimeZone.getTimeZone(timezones[i]);
            if (regular.getTimeZone().getRawOffset() == zone.getRawOffset()) continue;
            other = Calendar.getInstance(zone);
            break;
        }
        this.trace("regular offset = " + regular.getTimeZone().getRawOffset() + " other = " + other.getTimeZone().getRawOffset());
        prep.setInt(1, 0);
        prep.setDate(2, null, regular);
        prep.setTime(3, null, regular);
        prep.setTimestamp(4, null, regular);
        prep.execute();
        prep.setInt(1, 1);
        prep.setDate(2, null, other);
        prep.setTime(3, null, other);
        prep.setTimestamp(4, null, other);
        prep.execute();
        prep.setInt(1, 2);
        prep.setDate(2, Date.valueOf("2001-02-03"), regular);
        prep.setTime(3, Time.valueOf("04:05:06"), regular);
        prep.setTimestamp(4, Timestamp.valueOf("2007-08-09 10:11:12.131415"), regular);
        prep.execute();
        prep.setInt(1, 3);
        prep.setDate(2, Date.valueOf("2101-02-03"), other);
        prep.setTime(3, Time.valueOf("14:05:06"), other);
        prep.setTimestamp(4, Timestamp.valueOf("2107-08-09 10:11:12.131415"), other);
        prep.execute();
        prep.setInt(1, 4);
        prep.setDate(2, Date.valueOf("2101-02-03"));
        prep.setTime(3, Time.valueOf("14:05:06"));
        prep.setTimestamp(4, Timestamp.valueOf("2107-08-09 10:11:12.131415"));
        prep.execute();
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        this.testResultSetMeta(rs, 4, new String[]{"ID", "D", "T", "TS"}, new int[]{4, 91, 92, 93}, new int[]{10, 8, 6, 23}, new int[]{0, 0, 0, 10});
        rs.next();
        this.check(rs.getInt(1), 0L);
        this.check(rs.getDate(2, regular) == null && rs.wasNull());
        this.check(rs.getTime(3, regular) == null && rs.wasNull());
        this.check(rs.getTimestamp(3, regular) == null && rs.wasNull());
        rs.next();
        this.check(rs.getInt(1), 1L);
        this.check(rs.getDate(2, other) == null && rs.wasNull());
        this.check(rs.getTime(3, other) == null && rs.wasNull());
        this.check(rs.getTimestamp(3, other) == null && rs.wasNull());
        rs.next();
        this.check(rs.getInt(1), 2L);
        this.check(rs.getDate(2, regular).toString(), "2001-02-03");
        this.check(rs.getTime(3, regular).toString(), "04:05:06");
        this.checkFalse(rs.getTime(3, other).toString(), "04:05:06");
        this.check(rs.getTimestamp(4, regular).toString(), "2007-08-09 10:11:12.131415");
        this.checkFalse(rs.getTimestamp(4, other).toString(), "2007-08-09 10:11:12.131415");
        rs.next();
        this.check(rs.getInt("ID"), 3L);
        this.checkFalse(rs.getTimestamp("TS", regular).toString(), "2107-08-09 10:11:12.131415");
        this.check(rs.getTimestamp("TS", other).toString(), "2107-08-09 10:11:12.131415");
        this.checkFalse(rs.getTime("T", regular).toString(), "14:05:06");
        this.check(rs.getTime("T", other).toString(), "14:05:06");
        rs.next();
        this.check(rs.getInt("ID"), 4L);
        this.check(rs.getTimestamp("TS").toString(), "2107-08-09 10:11:12.131415");
        this.check(rs.getTime("T").toString(), "14:05:06");
        this.check(rs.getDate("D").toString(), "2101-02-03");
        this.checkFalse(rs.next());
        this.stat.execute("DROP TABLE TEST");
    }

    void testBlob() throws Exception {
        this.trace("Test BLOB");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,VALUE BLOB)");
        this.stat.execute("INSERT INTO TEST VALUES(1,X'01010101')");
        this.stat.execute("INSERT INTO TEST VALUES(2,X'02020202')");
        this.stat.execute("INSERT INTO TEST VALUES(3,X'00')");
        this.stat.execute("INSERT INTO TEST VALUES(4,X'ffFFff')");
        this.stat.execute("INSERT INTO TEST VALUES(5,X'0bcec1')");
        this.stat.execute("INSERT INTO TEST VALUES(6,NULL)");
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        this.testResultSetMeta(rs, 2, new String[]{"ID", "VALUE"}, new int[]{4, 2004}, new int[]{10, Integer.MAX_VALUE}, new int[]{0, 0});
        rs.next();
        this.checkBytes(rs.getBytes(2), new byte[]{1, 1, 1, 1});
        this.check(!rs.wasNull());
        rs.next();
        this.checkBytes(rs.getBytes("value"), new byte[]{2, 2, 2, 2});
        this.check(!rs.wasNull());
        rs.next();
        this.checkBytes(this.readAllBytes(rs.getBinaryStream(2)), new byte[]{0});
        this.check(!rs.wasNull());
        rs.next();
        this.checkBytes(this.readAllBytes(rs.getBinaryStream("VaLuE")), new byte[]{-1, -1, -1});
        this.check(!rs.wasNull());
        rs.next();
        InputStream in = rs.getBinaryStream("value");
        byte[] b = this.readAllBytes(in);
        this.checkBytes(b, new byte[]{11, -50, -63});
        this.check(!rs.wasNull());
        rs.next();
        this.checkBytes(this.readAllBytes(rs.getBinaryStream("VaLuE")), null);
        this.check(rs.wasNull());
        this.check(!rs.next());
        this.stat.execute("DROP TABLE TEST");
    }

    void testClob() throws Exception {
        this.trace("Test CLOB");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,VALUE CLOB)");
        this.stat.execute("INSERT INTO TEST VALUES(1,'Test')");
        this.stat.execute("INSERT INTO TEST VALUES(2,'Hello')");
        this.stat.execute("INSERT INTO TEST VALUES(3,'World!')");
        this.stat.execute("INSERT INTO TEST VALUES(4,'Hallo')");
        this.stat.execute("INSERT INTO TEST VALUES(5,'Welt!')");
        this.stat.execute("INSERT INTO TEST VALUES(6,NULL)");
        this.stat.execute("INSERT INTO TEST VALUES(7,NULL)");
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        this.testResultSetMeta(rs, 2, new String[]{"ID", "VALUE"}, new int[]{4, 2005}, new int[]{10, Integer.MAX_VALUE}, new int[]{0, 0});
        rs.next();
        String string = rs.getString(2);
        this.check(string != null && string.equals("Test"));
        this.check(!rs.wasNull());
        rs.next();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(rs.getAsciiStream(2), "ISO-8859-1");
        }
        catch (Exception e) {
            this.check(false);
        }
        string = this.readString(reader);
        this.check(!rs.wasNull());
        this.trace(string);
        this.check(string != null && string.equals("Hello"));
        rs.next();
        try {
            reader = new InputStreamReader(rs.getAsciiStream("value"), "ISO-8859-1");
        }
        catch (Exception e) {
            this.check(false);
        }
        string = this.readString(reader);
        this.check(!rs.wasNull());
        this.trace(string);
        this.check(string != null && string.equals("World!"));
        rs.next();
        string = this.readString(rs.getCharacterStream(2));
        this.check(!rs.wasNull());
        this.trace(string);
        this.check(string != null && string.equals("Hallo"));
        rs.next();
        string = this.readString(rs.getCharacterStream("value"));
        this.check(!rs.wasNull());
        this.trace(string);
        this.check(string != null && string.equals("Welt!"));
        rs.next();
        this.check(rs.getCharacterStream(2) == null);
        this.check(rs.wasNull());
        rs.next();
        this.check(rs.getAsciiStream("Value") == null);
        this.check(rs.wasNull());
        this.check(rs.getStatement() == this.stat);
        this.check(rs.getWarnings() == null);
        rs.clearWarnings();
        this.check(rs.getWarnings() == null);
        this.check(rs.getFetchDirection(), 1000L);
        this.check(rs.getConcurrency(), 1008L);
        rs.next();
        this.stat.execute("DROP TABLE TEST");
    }

    byte[] readAllBytes(InputStream in) throws Exception {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int b;
            while ((b = in.read()) != -1) {
                out.write(b);
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            this.check(false);
            return null;
        }
    }

    void checkBytes(byte[] test, byte[] good) throws Exception {
        if (test == null || good == null) {
            this.check(test == null && good == null);
        } else {
            this.trace("test.length=" + test.length + " good.length=" + good.length);
            this.check(test.length, good.length);
            for (int i = 0; i < good.length; ++i) {
                this.check(test[i] == good[i]);
            }
        }
    }

    void checkColumnBigDecimal(ResultSet rs, int column, int i, String bd) throws Exception {
        BigDecimal bd1 = rs.getBigDecimal(column);
        int i1 = rs.getInt(column);
        if (bd == null) {
            this.trace("should be: null");
            this.check(rs.wasNull());
        } else {
            this.trace("BigDecimal i=" + i + " bd=" + bd + " ; i1=" + i1 + " bd1=" + bd1);
            this.check(!rs.wasNull());
            this.check(i1 == i);
            this.check(bd1.compareTo(new BigDecimal(bd)) == 0);
        }
    }
}

