/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.test.TestBase;

public class TestUpdatableResultSet
extends TestBase {
    public void test() throws Exception {
        this.testScroll();
        this.testUpdateDeleteInsert();
        this.testUpdateDataType();
    }

    private void testScroll() throws Exception {
        this.deleteDb("updatableResultSet");
        Connection conn = this.getConnection("updatableResultSet");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello'), (2, 'World'), (3, 'Test')");
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        this.check(rs.isBeforeFirst());
        this.checkFalse(rs.isAfterLast());
        this.check(rs.getRow(), 0L);
        rs.next();
        this.checkFalse(rs.isBeforeFirst());
        this.checkFalse(rs.isAfterLast());
        this.check(rs.getInt(1), 1L);
        this.check(rs.getRow(), 1L);
        rs.next();
        this.checkFalse(rs.isBeforeFirst());
        this.checkFalse(rs.isAfterLast());
        this.check(rs.getInt(1), 2L);
        this.check(rs.getRow(), 2L);
        rs.next();
        this.checkFalse(rs.isBeforeFirst());
        this.checkFalse(rs.isAfterLast());
        this.check(rs.getInt(1), 3L);
        this.check(rs.getRow(), 3L);
        this.checkFalse(rs.next());
        this.checkFalse(rs.isBeforeFirst());
        this.check(rs.isAfterLast());
        this.check(rs.getRow(), 0L);
        this.check(rs.first());
        this.check(rs.getInt(1), 1L);
        this.check(rs.getRow(), 1L);
        this.check(rs.last());
        this.check(rs.getInt(1), 3L);
        this.check(rs.getRow(), 3L);
        this.check(rs.relative(0));
        this.check(rs.getRow(), 3L);
        this.check(rs.relative(-1));
        this.check(rs.getRow(), 2L);
        this.check(rs.relative(1));
        this.check(rs.getRow(), 3L);
        this.checkFalse(rs.relative(100));
        this.check(rs.isAfterLast());
        this.checkFalse(rs.absolute(0));
        this.check(rs.getRow(), 0L);
        this.check(rs.absolute(1));
        this.check(rs.getRow(), 1L);
        this.check(rs.absolute(2));
        this.check(rs.getRow(), 2L);
        this.check(rs.absolute(3));
        this.check(rs.getRow(), 3L);
        this.checkFalse(rs.absolute(4));
        this.check(rs.getRow(), 0L);
        try {
            this.checkFalse(rs.absolute(0));
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        this.check(rs.absolute(3));
        this.check(rs.getRow(), 3L);
        this.check(rs.absolute(-1));
        this.check(rs.getRow(), 3L);
        this.checkFalse(rs.absolute(4));
        this.check(rs.isAfterLast());
        this.checkFalse(rs.absolute(5));
        this.check(rs.isAfterLast());
        this.check(rs.previous());
        this.check(rs.getRow(), 3L);
        this.check(rs.previous());
        this.check(rs.getRow(), 2L);
        conn.close();
    }

    private void testUpdateDataType() throws Exception {
        this.deleteDb("updatableResultSet");
        Connection conn = this.getConnection("updatableResultSet");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255), DEC DECIMAL(10,2), BOO BIT, BYE TINYINT, BIN BINARY(100), D DATE, T TIME, TS TIMESTAMP, DOU DOUBLE, REA REAL, LON BIGINT, OBI INT, SHO SMALLINT, CLO CLOB, BLO BLOB)");
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST");
        ResultSetMetaData meta = rs.getMetaData();
        this.check(meta.getColumnClassName(1), "java.lang.Integer");
        this.check(meta.getColumnClassName(2), "java.lang.String");
        this.check(meta.getColumnClassName(3), "java.math.BigDecimal");
        this.check(meta.getColumnClassName(4), "java.lang.Boolean");
        this.check(meta.getColumnClassName(5), "java.lang.Byte");
        this.check(meta.getColumnClassName(6), "[B");
        this.check(meta.getColumnClassName(7), "java.sql.Date");
        this.check(meta.getColumnClassName(8), "java.sql.Time");
        this.check(meta.getColumnClassName(9), "java.sql.Timestamp");
        this.check(meta.getColumnClassName(10), "java.lang.Double");
        this.check(meta.getColumnClassName(12), "java.lang.Long");
        this.check(meta.getColumnClassName(13), "java.lang.Integer");
        this.check(meta.getColumnClassName(14), "java.lang.Short");
        this.check(meta.getColumnClassName(15), "java.io.Reader");
        this.check(meta.getColumnClassName(16), "java.io.InputStream");
        rs.moveToInsertRow();
        rs.updateInt(1, 0);
        rs.updateNull(2);
        rs.updateNull("DEC");
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt(1, 1);
        rs.updateString(2, null);
        rs.updateBigDecimal(3, null);
        rs.updateBoolean(4, false);
        rs.updateByte(5, (byte)0);
        rs.updateBytes(6, null);
        rs.updateDate(7, null);
        rs.updateTime(8, null);
        rs.updateTimestamp(9, null);
        rs.updateDouble(10, 0.0);
        rs.updateFloat(11, 0.0f);
        rs.updateLong(12, 0L);
        rs.updateObject(13, null);
        rs.updateShort(14, (short)0);
        rs.updateCharacterStream(15, (Reader)new StringReader("test"), 0);
        rs.updateBinaryStream(16, (InputStream)new ByteArrayInputStream(new byte[]{-1, 0}), 0);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt("ID", 2);
        rs.updateString("NAME", "+");
        rs.updateBigDecimal("DEC", new BigDecimal("1.2"));
        rs.updateBoolean("BOO", true);
        rs.updateByte("BYE", (byte)-1);
        rs.updateBytes("BIN", new byte[]{0, -1});
        rs.updateDate("D", Date.valueOf("2005-09-21"));
        rs.updateTime("T", Time.valueOf("21:46:28"));
        rs.updateTimestamp("TS", Timestamp.valueOf("2005-09-21 21:47:09.567890123"));
        rs.updateDouble("DOU", 1.725);
        rs.updateFloat("REA", 2.5f);
        rs.updateLong("LON", Long.MAX_VALUE);
        rs.updateObject("OBI", (Object)new Integer(10));
        rs.updateShort("SHO", (short)Short.MIN_VALUE);
        rs.updateCharacterStream("CLO", (Reader)new StringReader("\u00ef\u00f6\u00fc"), 0);
        rs.updateBinaryStream("BLO", (InputStream)new ByteArrayInputStream(new byte[]{-85, 18}), 0);
        rs.insertRow();
        rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID NULLS FIRST");
        rs.next();
        this.check(rs.getInt(1) == 0);
        this.check(rs.getString(2) == null && rs.wasNull());
        this.check(rs.getBigDecimal(3) == null && rs.wasNull());
        this.check(!rs.getBoolean(4) && rs.wasNull());
        this.check(rs.getByte(5) == 0 && rs.wasNull());
        this.check(rs.getBytes(6) == null && rs.wasNull());
        this.check(rs.getDate(7) == null && rs.wasNull());
        this.check(rs.getTime(8) == null && rs.wasNull());
        this.check(rs.getTimestamp(9) == null && rs.wasNull());
        this.check(rs.getDouble(10) == 0.0 && rs.wasNull());
        this.check((double)rs.getFloat(11) == 0.0 && rs.wasNull());
        this.check(rs.getLong(12) == 0L && rs.wasNull());
        this.check(rs.getObject(13) == null && rs.wasNull());
        this.check(rs.getShort(14) == 0 && rs.wasNull());
        this.check(rs.getCharacterStream(15) == null && rs.wasNull());
        this.check(rs.getBinaryStream(16) == null && rs.wasNull());
        rs.next();
        this.check(rs.getInt(1) == 1);
        this.check(rs.getString(2) == null && rs.wasNull());
        this.check(rs.getBigDecimal(3) == null && rs.wasNull());
        this.check(!rs.getBoolean(4) && !rs.wasNull());
        this.check(rs.getByte(5) == 0 && !rs.wasNull());
        this.check(rs.getBytes(6) == null && rs.wasNull());
        this.check(rs.getDate(7) == null && rs.wasNull());
        this.check(rs.getTime(8) == null && rs.wasNull());
        this.check(rs.getTimestamp(9) == null && rs.wasNull());
        this.check(rs.getDouble(10) == 0.0 && !rs.wasNull());
        this.check((double)rs.getFloat(11) == 0.0 && !rs.wasNull());
        this.check(rs.getLong(12) == 0L && !rs.wasNull());
        this.check(rs.getObject(13) == null && rs.wasNull());
        this.check(rs.getShort(14) == 0 && !rs.wasNull());
        this.check(rs.getString(15), "test");
        this.check(rs.getBytes(16), new byte[]{-1, 0});
        rs.next();
        this.check(rs.getInt(1) == 2);
        this.check(rs.getString(2), "+");
        this.check(rs.getBigDecimal(3).toString(), "1.20");
        this.check(rs.getBoolean(4));
        this.check((rs.getByte(5) & 0xFF) == 255);
        this.check(rs.getBytes(6), new byte[]{0, -1});
        this.check(rs.getDate(7).toString(), "2005-09-21");
        this.check(rs.getTime(8).toString(), "21:46:28");
        this.check(rs.getTimestamp(9).toString(), "2005-09-21 21:47:09.567890123");
        this.check(rs.getDouble(10) == 1.725);
        this.check(rs.getFloat(11) == 2.5f);
        this.check(rs.getLong(12) == Long.MAX_VALUE);
        this.check(((Integer)rs.getObject(13)).intValue(), 10L);
        this.check(rs.getShort(14) == Short.MIN_VALUE);
        this.check(rs.getString(15), "\u00ef\u00f6\u00fc");
        this.check(rs.getBytes(16), new byte[]{-85, 18});
        this.checkFalse(rs.next());
        stat.execute("DROP TABLE TEST");
        conn.close();
    }

    private void testUpdateDeleteInsert() throws Exception {
        int id;
        this.deleteDb("updatableResultSet");
        Connection c1 = this.getConnection("updatableResultSet");
        Connection c2 = this.getConnection("updatableResultSet");
        Statement stat = c1.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        int max = 8;
        for (int i = 0; i < max; ++i) {
            stat.execute("INSERT INTO TEST VALUES(" + i + ", 'Hello" + i + "')");
        }
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST");
        int j = max;
        while (rs.next()) {
            id = rs.getInt(1);
            if (id % 2 == 0) {
                Statement s2 = c2.createStatement();
                s2.execute("UPDATE TEST SET NAME = NAME || '+' WHERE ID = " + rs.getInt(1));
                if (id % 4 == 0) {
                    rs.refreshRow();
                }
                rs.updateString(2, "Updated " + rs.getString(2));
                rs.updateRow();
            } else {
                rs.deleteRow();
            }
            rs.moveToInsertRow();
            rs.updateString(2, "Inserted " + j);
            rs.updateInt(1, j);
            j += 2;
            rs.insertRow();
        }
        rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        while (rs.next()) {
            id = rs.getInt(1);
            String name = rs.getString(2);
            this.check(id % 2, 0L);
            if (id >= max) {
                this.check("Inserted " + id, rs.getString(2));
            } else if (id % 4 == 0) {
                this.check(rs.getString(2), "Updated Hello" + id + "+");
            } else {
                this.check(rs.getString(2), "Updated Hello" + id);
            }
            this.trace("id=" + id + " name=" + name);
        }
        c2.close();
        c1.close();
        Connection conn = this.getConnection("updatableResultSet");
        for (int i = 0; i < 5; ++i) {
            this.testScrollable(conn, i);
        }
        conn.close();
    }

    void testScrollable(Connection conn, int rows) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE IF NOT EXISTS TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("DELETE FROM TEST");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        for (int i = 0; i < rows; ++i) {
            prep.setInt(1, i);
            prep.setString(2, "Data " + i);
            prep.execute();
        }
        Statement regular = conn.createStatement();
        this.testScrollResultSet(regular, 1003, rows);
        Statement scroll = conn.createStatement(1004, 1007);
        this.testScrollResultSet(scroll, 1004, rows);
    }

    void testScrollResultSet(Statement stat, int type, int rows) throws Exception {
        block15: {
            ResultSet rs;
            boolean error;
            block14: {
                block13: {
                    block12: {
                        error = false;
                        if (type == 1003) {
                            error = true;
                        }
                        rs = stat.executeQuery("SELECT * FROM TEST");
                        this.check(rs.getType(), type);
                        this.checkState(rs, true, false, false, rows == 0);
                        for (int i = 0; i < rows; ++i) {
                            rs.next();
                            this.checkState(rs, rows == 0, i == 0, i == rows - 1, rows == 0 || i == rows);
                        }
                        try {
                            rs.beforeFirst();
                            this.checkState(rs, true, false, false, rows == 0);
                        }
                        catch (SQLException e) {
                            if (error) break block12;
                            throw e;
                        }
                    }
                    try {
                        rs.afterLast();
                        this.checkState(rs, false, false, false, true);
                    }
                    catch (SQLException e) {
                        if (error) break block13;
                        throw e;
                    }
                }
                try {
                    boolean valid = rs.first();
                    this.check(valid, rows > 0);
                    if (valid) {
                        this.checkState(rs, false, true, rows == 1, rows == 0);
                    }
                }
                catch (SQLException e) {
                    if (error) break block14;
                    throw e;
                }
            }
            try {
                boolean valid = rs.last();
                this.check(valid, rows > 0);
                if (valid) {
                    this.checkState(rs, false, rows == 1, true, rows == 0);
                }
            }
            catch (SQLException e) {
                if (error) break block15;
                throw e;
            }
        }
    }

    void checkState(ResultSet rs, boolean beforeFirst, boolean first, boolean last, boolean afterLast) throws Exception {
        this.check(rs.isBeforeFirst(), beforeFirst);
        this.check(rs.isFirst(), first);
        this.check(rs.isLast(), last);
        this.check(rs.isAfterLast(), afterLast);
    }
}

