/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.poweroff;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class Listener
implements Runnable {
    volatile int maxValue;

    public static void main(String[] args) throws Exception {
        new Listener().test(args);
    }

    void test(String[] args) throws Exception {
        int port = 9099;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-port")) continue;
            port = Integer.parseInt(args[++i]);
        }
        this.listen(port);
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("Max=" + this.maxValue);
        }
    }

    void listen(int port) throws Exception {
        new Thread(this).start();
        ServerSocket serverSocket = new ServerSocket(port);
        System.out.println("Listening on " + serverSocket.toString());
        this.maxValue = 0;
        while (true) {
            Socket socket = serverSocket.accept();
            DataInputStream in = new DataInputStream(socket.getInputStream());
            System.out.println("Connected");
            long time = System.currentTimeMillis();
            try {
                int value;
                while ((value = in.readInt()) >= 0) {
                    this.maxValue = Math.max(this.maxValue, value);
                }
            }
            catch (IOException e) {
                System.out.println("Closed with Exception: " + e);
            }
            time = System.currentTimeMillis() - time;
            int ops = (int)((long)(1000 * this.maxValue) / time);
            System.out.println("Max=" + this.maxValue + " operations/sec=" + ops);
        }
    }
}

