/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.util.ArrayList;
import org.h2.test.synth.Column;
import org.h2.test.synth.Index;
import org.h2.test.synth.TestSynth;
import org.h2.test.synth.Value;

class Table {
    private TestSynth config;
    private String name;
    private boolean temporary;
    private boolean globalTemporary;
    private Column[] columns;
    private Column[] primaryKeys;
    private ArrayList indexes = new ArrayList();

    Table(TestSynth config) {
        this.config = config;
    }

    public static Table newRandomTable(TestSynth config) {
        Table table = new Table(config);
        table.name = "T_" + config.randomIdentifier();
        int len = config.random().getLog(10) + 1;
        table.columns = new Column[len];
        for (int i = 0; i < len; ++i) {
            Column col;
            table.columns[i] = col = Column.getRandomColumn(config);
        }
        if (config.random().getBoolean(90)) {
            int pkLen = config.random().getLog(len);
            table.primaryKeys = new Column[pkLen];
            for (int i = 0; i < pkLen; ++i) {
                Column pk = null;
                while ((pk = table.columns[config.random().getInt(len)]).isPrimaryKey()) {
                }
                table.primaryKeys[i] = pk;
                pk.setPrimaryKey(true);
                pk.setNullable(false);
            }
        }
        return table;
    }

    public Index newRandomIndex() {
        String indexName = "I_" + this.config.randomIdentifier();
        int len = this.config.random().getLog(this.getColumnCount() - 1) + 1;
        boolean unique = this.config.random().getBoolean(50);
        Column[] cols = this.getRandomColumns(len);
        Index index = new Index(this, indexName, cols, unique);
        return index;
    }

    public String getDropSQL() {
        return "DROP TABLE " + this.name;
    }

    public String getCreateSQL() {
        Column column;
        int i;
        String sql = "CREATE ";
        if (this.temporary) {
            sql = this.globalTemporary ? sql + "GLOBAL " : sql + "LOCAL ";
            sql = sql + "TEMPORARY ";
        }
        sql = sql + "TABLE " + this.name + "(";
        for (i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                sql = sql + ", ";
            }
            column = this.columns[i];
            sql = sql + column.getCreateSQL();
            if (this.primaryKeys == null || this.primaryKeys.length != 1 || this.primaryKeys[0] != column) continue;
            sql = sql + " PRIMARY KEY";
        }
        if (this.primaryKeys != null && this.primaryKeys.length > 1) {
            sql = sql + ", ";
            sql = sql + "PRIMARY KEY(";
            for (i = 0; i < this.primaryKeys.length; ++i) {
                if (i > 0) {
                    sql = sql + ", ";
                }
                column = this.primaryKeys[i];
                sql = sql + column.getName();
            }
            sql = sql + ")";
        }
        sql = sql + ")";
        return sql;
    }

    public String getInsertSQL(Column[] c, Value[] v) {
        int i;
        String sql = "INSERT INTO " + this.name;
        if (c != null) {
            sql = sql + "(";
            for (i = 0; i < c.length; ++i) {
                if (i > 0) {
                    sql = sql + ", ";
                }
                sql = sql + c[i].getName();
            }
            sql = sql + ")";
        }
        sql = sql + " VALUES(";
        for (i = 0; i < v.length; ++i) {
            if (i > 0) {
                sql = sql + ", ";
            }
            sql = sql + v[i].getSQL();
        }
        sql = sql + ")";
        return sql;
    }

    public String getName() {
        return this.name;
    }

    public Column getRandomConditionColumn() {
        ArrayList<Column> list = new ArrayList<Column>();
        for (int i = 0; i < this.columns.length; ++i) {
            if (!Column.isConditionType(this.config, this.columns[i].getType())) continue;
            list.add(this.columns[i]);
        }
        if (list.size() == 0) {
            return null;
        }
        return (Column)list.get(this.config.random().getInt(list.size()));
    }

    public Column getRandomColumn() {
        return this.columns[this.config.random().getInt(this.columns.length)];
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public Column getRandomColumnOfType(int type) {
        ArrayList<Column> list = new ArrayList<Column>();
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i].getType() != type) continue;
            list.add(this.columns[i]);
        }
        if (list.size() == 0) {
            return null;
        }
        return (Column)list.get(this.config.random().getInt(list.size()));
    }

    public Column[] getRandomColumns(int len) {
        int i;
        int[] index = new int[this.columns.length];
        for (i = 0; i < this.columns.length; ++i) {
            index[i] = i;
        }
        for (i = 0; i < this.columns.length; ++i) {
            int temp = index[i];
            int r = index[this.config.random().getInt(this.columns.length)];
            index[i] = index[r];
            index[r] = temp;
        }
        Column[] c = new Column[len];
        for (int i2 = 0; i2 < len; ++i2) {
            c[i2] = this.columns[index[i2]];
        }
        return c;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public void addIndex(Index index) {
        this.indexes.add(index);
    }

    public void removeIndex(Index index) {
        this.indexes.remove(index);
    }
}

