/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.synth.RandomGen;

public class TestSimpleIndex
extends TestBase {
    Connection conn;
    Statement stat;
    RandomGen random;

    public void test() throws Exception {
        this.deleteDb("simpleIndex");
        this.conn = this.getConnection("simpleIndex");
        this.random = new RandomGen(null);
        this.stat = this.conn.createStatement();
        for (int i = 0; i < 10000; ++i) {
            this.testIndex(i);
        }
    }

    private void testIndex(int seed) throws Exception {
        this.random.setSeed(seed);
        String unique = this.random.nextBoolean() ? "UNIQUE " : "";
        int len = this.random.getInt(2) + 1;
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append((char)(65 + this.random.getInt(3)));
        }
        String cols = buff.toString();
        this.execute("CREATE MEMORY TABLE TEST_M(A INT, B INT, C INT, DATA VARCHAR(255))");
        this.execute("CREATE CACHED TABLE TEST_D(A INT, B INT, C INT, DATA VARCHAR(255))");
        this.execute("CREATE MEMORY TABLE TEST_MI(A INT, B INT, C INT, DATA VARCHAR(255))");
        this.execute("CREATE CACHED TABLE TEST_DI(A INT, B INT, C INT, DATA VARCHAR(255))");
        this.execute("CREATE " + unique + "INDEX M ON TEST_MI(" + cols + ")");
        this.execute("CREATE " + unique + "INDEX D ON TEST_DI(" + cols + ")");
        for (int i = 0; i < 100; ++i) {
            this.println("i=" + i);
            this.testRows(i);
        }
        this.execute("DROP INDEX M");
        this.execute("DROP INDEX D");
        this.execute("DROP TABLE TEST_M");
        this.execute("DROP TABLE TEST_D");
        this.execute("DROP TABLE TEST_MI");
        this.execute("DROP TABLE TEST_DI");
    }

    private void testRows(int id) throws Exception {
        boolean ed;
        boolean em;
        String a = this.randomValue();
        String b = this.randomValue();
        String c = this.randomValue();
        String data = a + "/" + b + "/" + c;
        String sql = "VALUES(" + a + ", " + b + ", " + c + ", '" + data + "')";
        try {
            this.execute("INSERT INTO TEST_MI " + sql);
            em = false;
        }
        catch (SQLException e) {
            em = true;
        }
        try {
            this.execute("INSERT INTO TEST_DI " + sql);
            ed = false;
        }
        catch (SQLException e) {
            ed = true;
        }
        if (em != ed) {
            this.error("different result: ");
        }
        if (!em) {
            this.execute("INSERT INTO TEST_M " + sql);
            this.execute("INSERT INTO TEST_D " + sql);
        }
        StringBuffer buff = new StringBuffer("WHERE 1=1");
        int len = this.random.getLog(10);
        block13: for (int i = 0; i < len; ++i) {
            buff.append(" AND ");
            buff.append(65 + this.random.getInt(3));
            switch (this.random.getInt(10)) {
                case 0: {
                    buff.append("<");
                    buff.append(this.random.getInt(100) - 50);
                    continue block13;
                }
                case 1: {
                    buff.append("<=");
                    buff.append(this.random.getInt(100) - 50);
                    continue block13;
                }
                case 2: {
                    buff.append(">");
                    buff.append(this.random.getInt(100) - 50);
                    continue block13;
                }
                case 3: {
                    buff.append(">=");
                    buff.append(this.random.getInt(100) - 50);
                    continue block13;
                }
                case 4: {
                    buff.append("<>");
                    buff.append(this.random.getInt(100) - 50);
                    continue block13;
                }
                case 5: {
                    buff.append(" IS NULL");
                    continue block13;
                }
                case 6: {
                    buff.append(" IS NOT NULL");
                    continue block13;
                }
                default: {
                    buff.append("=");
                    buff.append(this.random.getInt(100) - 50);
                }
            }
        }
        String where = buff.toString();
        String r1 = this.getResult("SELECT DATA FROM TEST_M " + where + " ORDER BY DATA");
        String r2 = this.getResult("SELECT DATA FROM TEST_D " + where + " ORDER BY DATA");
        String r3 = this.getResult("SELECT DATA FROM TEST_MI " + where + " ORDER BY DATA");
        String r4 = this.getResult("SELECT DATA FROM TEST_DI " + where + " ORDER BY DATA");
        this.check(r1, r2);
        this.check(r1, r3);
        this.check(r1, r4);
    }

    private String getResult(String sql) throws Exception {
        ResultSet rs = this.stat.executeQuery(sql);
        StringBuffer buff = new StringBuffer();
        while (rs.next()) {
            buff.append(rs.getString(1));
            buff.append("; ");
        }
        rs.close();
        return buff.toString();
    }

    private String randomValue() {
        return this.random.getInt(10) == 0 ? "NULL" : "" + (this.random.getInt(100) - 50);
    }

    private void execute(String sql) throws Exception {
        try {
            this.println(sql + ";");
            this.stat.execute(sql);
            this.println("> update count: 1");
        }
        catch (SQLException e) {
            this.println("> exception");
            throw e;
        }
    }
}

