/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.sql.SQLException;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileStore;
import org.h2.test.TestBase;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class TestDataPage
extends TestBase
implements DataHandler {
    boolean text = false;

    public void test() throws Exception {
        this.testAll();
        this.text = true;
        this.testAll();
    }

    private void testAll() throws Exception {
        DataPage page = DataPage.create((DataHandler)this, 128);
        char[] data = new char[65536];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (char)i;
        }
        String s = new String(data);
        page.writeString(s);
        int len = page.length();
        this.check(page.getStringLen(s), len);
        page.reset();
        this.check(s, page.readString());
        page.reset();
        page.writeString("H\u1111!");
        page.writeString("John\tBrack's \"how are you\" M\u1111ller");
        page.writeValue(ValueInt.get(10));
        page.writeValue(ValueString.get("test"));
        page.writeValue(ValueFloat.get(-2.25f));
        page.writeValue(ValueDouble.get(10.4));
        page.writeValue(ValueNull.INSTANCE);
        this.trace(new String(page.getBytes()));
        page.reset();
        this.trace(page.readString());
        this.trace(page.readString());
        this.trace(page.readValue().getInt());
        this.trace(page.readValue().getString());
        this.trace("" + page.readValue().getFloat());
        this.trace("" + page.readValue().getDouble());
        this.trace(page.readValue().toString());
        page.reset();
        page.writeInt(0);
        page.writeInt(Integer.MAX_VALUE);
        page.writeInt(Integer.MIN_VALUE);
        page.writeInt(1);
        page.writeInt(-1);
        page.writeInt(1234567890);
        page.writeInt(54321);
        this.trace(new String(page.getBytes()));
        page.reset();
        this.trace(page.readInt());
        this.trace(page.readInt());
        this.trace(page.readInt());
        this.trace(page.readInt());
        this.trace(page.readInt());
        this.trace(page.readInt());
        this.trace(page.readInt());
        page = null;
    }

    public boolean getTextStorage() {
        return this.text;
    }

    public String getDatabasePath() {
        return null;
    }

    public FileStore openFile(String name) throws SQLException {
        return null;
    }

    public int getChecksum(byte[] data, int start, int end) {
        return end - start;
    }

    public void checkPowerOff() throws SQLException {
    }

    public void checkWritingAllowed() throws SQLException {
    }

    public void freeUpDiskSpace() throws SQLException {
    }

    public void handleInvalidChecksum() throws SQLException {
        throw new SQLException("CHECKSUM", "CHECKSUM ERROR");
    }
}

