/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.SQLException;
import org.h2.compress.CompressDeflate;
import org.h2.compress.CompressLZF;
import org.h2.compress.CompressNo;
import org.h2.compress.Compresser;
import org.h2.message.Message;

public class CompressTool {
    private static CompressTool instance = new CompressTool();
    private static byte[] buffer;
    private static int MAX_BUFFER_SIZE;

    private static byte[] getBuffer(int min) {
        if (min > MAX_BUFFER_SIZE) {
            return new byte[min];
        }
        if (buffer == null || buffer.length < min) {
            buffer = new byte[min];
        }
        return buffer;
    }

    private CompressTool() {
    }

    public static CompressTool getInstance() {
        return instance;
    }

    public synchronized byte[] compress(byte[] in, String algorithm) throws SQLException {
        int len = in.length;
        if (len < 5) {
            algorithm = "NO";
        }
        Compresser compress = this.getCompresser(algorithm);
        byte[] buff = CompressTool.getBuffer((len < 100 ? len + 100 : len) * 2);
        int newLen = 0;
        buff[0] = (byte)compress.getAlgorithm();
        int start = 1 + this.writeInt(buff, 1, len);
        try {
            newLen = compress.compress(in, buff, start);
        }
        catch (Throwable e) {
            throw Message.getSQLException(90104, null, e);
        }
        if (newLen > len + start || newLen <= 0) {
            buff[0] = 0;
            System.arraycopy(in, 0, buff, start, len);
            newLen = len + start;
        }
        byte[] out = new byte[newLen];
        System.arraycopy(buff, 0, out, 0, newLen);
        return out;
    }

    public byte[] expand(byte[] in) throws SQLException {
        byte algorithm = in[0];
        Compresser compress = this.getCompresser(algorithm);
        try {
            int len = this.readInt(in, 1);
            int start = 1 + this.getLength(len);
            byte[] buff = new byte[len];
            compress.expand(in, start, buff, len);
            return buff;
        }
        catch (Throwable e) {
            throw Message.getSQLException(90104, null, e);
        }
    }

    private int readInt(byte[] buff, int pos) {
        int x;
        if ((x = buff[pos++] & 0xFF) < 128) {
            return x;
        }
        if (x < 192) {
            return ((x & 0x3F) << 8) + (buff[pos++] & 0xFF);
        }
        if (x < 224) {
            return ((x & 0x1F) << 16) + ((buff[pos++] & 0xFF) << 8) + (buff[pos++] & 0xFF);
        }
        if (x < 240) {
            return ((x & 0xF) << 24) + ((buff[pos++] & 0xFF) << 16) + ((buff[pos++] & 0xFF) << 8) + (buff[pos++] & 0xFF);
        }
        return ((buff[pos++] & 0xFF) << 24) + ((buff[pos++] & 0xFF) << 16) + ((buff[pos++] & 0xFF) << 8) + (buff[pos++] & 0xFF);
    }

    private int writeInt(byte[] buff, int pos, int x) {
        if (x < 0) {
            buff[pos++] = -16;
            buff[pos++] = (byte)(x >> 24);
            buff[pos++] = (byte)(x >> 16);
            buff[pos++] = (byte)(x >> 8);
            buff[pos++] = (byte)x;
            return 5;
        }
        if (x < 128) {
            buff[pos++] = (byte)x;
            return 1;
        }
        if (x < 16384) {
            buff[pos++] = (byte)(0x80 | x >> 8);
            buff[pos++] = (byte)x;
            return 2;
        }
        if (x < 0x200000) {
            buff[pos++] = (byte)(0xC0 | x >> 16);
            buff[pos++] = (byte)(x >> 8);
            buff[pos++] = (byte)x;
            return 3;
        }
        if (x < 0x10000000) {
            buff[pos++] = (byte)(0xE0 | x >> 24);
            buff[pos++] = (byte)(x >> 16);
            buff[pos++] = (byte)(x >> 8);
            buff[pos++] = (byte)x;
            return 4;
        }
        buff[pos++] = -16;
        buff[pos++] = (byte)(x >> 24);
        buff[pos++] = (byte)(x >> 16);
        buff[pos++] = (byte)(x >> 8);
        buff[pos++] = (byte)x;
        return 5;
    }

    private int getLength(int x) {
        if (x < 0) {
            return 5;
        }
        if (x < 128) {
            return 1;
        }
        if (x < 16384) {
            return 2;
        }
        if (x < 0x200000) {
            return 3;
        }
        if (x < 0x10000000) {
            return 4;
        }
        return 5;
    }

    private Compresser getCompresser(String algorithm) throws SQLException {
        if (algorithm == null) {
            algorithm = "LZF";
        }
        int idx = algorithm.indexOf(32);
        String options = null;
        if (idx > 0) {
            options = algorithm.substring(idx + 1);
            algorithm = algorithm.substring(0, idx);
        }
        int a = this.getCompressAlgorithm(algorithm);
        Compresser compress = this.getCompresser(a);
        compress.setOptions(options);
        return compress;
    }

    private int getCompressAlgorithm(String algorithm) throws SQLException {
        if ("NO".equals(algorithm = algorithm.toUpperCase())) {
            return 0;
        }
        if ("LZF".equals(algorithm)) {
            return 1;
        }
        if ("DEFLATE".equals(algorithm)) {
            return 2;
        }
        throw Message.getSQLException(90103, algorithm);
    }

    private Compresser getCompresser(int algorithm) {
        switch (algorithm) {
            case 0: {
                return new CompressNo();
            }
            case 1: {
                return new CompressLZF();
            }
            case 2: {
                return new CompressDeflate();
            }
        }
        throw Message.internal("type=" + algorithm);
    }

    static {
        MAX_BUFFER_SIZE = 0x4000000;
    }
}

