/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.util.ByteUtils;
import org.h2.util.FileUtils;
import org.h2.util.RandomUtils;
import org.h2.util.StringUtils;
import org.h2.util.TypeConverter;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueLob
extends Value {
    private int type;
    private long precision;
    private DataHandler handler;
    private int tableId;
    private int objectId;
    private String fileName;
    private boolean linked;
    private byte[] small;
    private int hash;

    private ValueLob(int type, DataHandler handler, String fileName, int tableId, int objectId, boolean linked, long precision) {
        this.type = type;
        this.handler = handler;
        this.fileName = fileName;
        this.tableId = tableId;
        this.objectId = objectId;
        this.linked = linked;
        this.precision = precision;
    }

    private ValueLob(int type, byte[] small) throws SQLException {
        this.type = type;
        this.small = small;
        this.precision = type == 15 ? (long)small.length : (long)this.getString().length();
    }

    public static ValueLob createSmallLob(int type, byte[] small) throws SQLException {
        return new ValueLob(type, small);
    }

    private static String getFileName(DataHandler handler, int tableId, int objectId) {
        if (Constants.CHECK && tableId == 0 && objectId == 0) {
            throw Message.internal("0 LOB");
        }
        if (Constants.LOB_FILES_IN_DIRECTORIES) {
            String table = tableId < 0 ? ".temp" : ".t" + tableId;
            return ValueLob.getFileNamePrefix(handler.getDatabasePath(), objectId) + table + ".lob.db";
        }
        return handler.getDatabasePath() + "." + tableId + "." + objectId + ".lob.db";
    }

    public static ValueLob open(int type, DataHandler handler, int tableId, int objectId, long precision) {
        String fileName = ValueLob.getFileName(handler, tableId, objectId);
        return new ValueLob(type, handler, fileName, tableId, objectId, true, precision);
    }

    public static ValueLob createClobFromReader(Reader in, int length) throws SQLException {
        try {
            String s = ByteUtils.getStringAndClose(in, length);
            byte[] buff = StringUtils.utf8Encode(s);
            return new ValueLob(16, buff);
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    public static ValueLob createBlobFromInputStream(InputStream in, int length) throws SQLException {
        try {
            byte[] buff = ByteUtils.getBytesAndClose(in, length);
            return new ValueLob(15, buff);
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValueLob createClobFromReader(Reader in, int length, Database database) throws SQLException {
        try {
            FileStore store;
            String fileName;
            int objectId;
            long precision = 0L;
            long remaining = Long.MAX_VALUE;
            if (length > 0 && (long)length < remaining) {
                remaining = length;
            }
            int len = (int)Math.min(remaining, 4096L);
            char[] buff = new char[len];
            if ((len = TypeConverter.readFully(in, buff, len)) <= 128) {
                byte[] small = StringUtils.utf8Encode(new String(buff, 0, len));
                return ValueLob.createSmallLob(16, small);
            }
            Database database2 = database;
            synchronized (database2) {
                if (!Constants.LOB_FILES_IN_DIRECTORIES) {
                    objectId = database.allocateObjectId(false, true);
                    fileName = database.createTempFile();
                } else {
                    objectId = ValueLob.getNewObjectId(database.getDatabasePath());
                    fileName = ValueLob.getFileName(database, -1, objectId);
                }
                store = database.openFile(fileName);
            }
            FileStoreOutputStream out = new FileStoreOutputStream(store, database);
            do {
                precision += (long)len;
                byte[] b = StringUtils.utf8Encode(new String(buff, 0, len));
                out.write(b, 0, b.length);
                if ((remaining -= (long)len) <= 0L) break;
                len = (int)Math.min(remaining, 4096L);
            } while ((len = TypeConverter.readFully(in, buff, len)) > 0);
            out.close();
            return new ValueLob(16, database, fileName, 0, objectId, false, precision);
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    private static String getFileNamePrefix(String path, int objectId) {
        int f = objectId % Constants.LOB_FILES_PER_DIRECTORY;
        String name = f > 0 ? File.separator + objectId : "";
        objectId /= Constants.LOB_FILES_PER_DIRECTORY;
        while (objectId > 0) {
            f = objectId % Constants.LOB_FILES_PER_DIRECTORY;
            name = File.separator + f + ".lobs.db" + name;
            objectId /= Constants.LOB_FILES_PER_DIRECTORY;
        }
        name = path + ".lobs.db" + name;
        return name;
    }

    private static int getNewObjectId(String path) throws SQLException {
        int fileId;
        int objectId = 0;
        while (true) {
            String dir = ValueLob.getFileNamePrefix(path, objectId);
            String[] list = FileUtils.listFiles(dir);
            int fileCount = 0;
            boolean[] used = new boolean[Constants.LOB_FILES_PER_DIRECTORY];
            for (int i = 0; i < list.length; ++i) {
                int id;
                String name = list[i];
                if (!name.endsWith(".db")) continue;
                name = name.substring(name.lastIndexOf(File.separatorChar) + 1);
                String n = name.substring(0, name.indexOf(46));
                try {
                    id = Integer.parseInt(n);
                }
                catch (NumberFormatException e) {
                    id = -1;
                }
                if (id <= 0) continue;
                ++fileCount;
                used[id % Constants.LOB_FILES_PER_DIRECTORY] = true;
            }
            fileId = -1;
            if (fileCount < Constants.LOB_FILES_PER_DIRECTORY) {
                for (int i = 1; i < Constants.LOB_FILES_PER_DIRECTORY; ++i) {
                    if (used[i]) continue;
                    fileId = i;
                    break;
                }
            }
            if (fileId > 0) break;
            if (objectId > Integer.MAX_VALUE / Constants.LOB_FILES_PER_DIRECTORY) {
                objectId = 0;
                continue;
            }
            int dirId = RandomUtils.nextInt(Constants.LOB_FILES_PER_DIRECTORY - 1) + 1;
            objectId *= Constants.LOB_FILES_PER_DIRECTORY;
            objectId += dirId * Constants.LOB_FILES_PER_DIRECTORY;
        }
        return objectId += fileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValueLob createBlobFromInputStream(InputStream in, int length, Database database) throws SQLException {
        try {
            FileStore store;
            String fileName;
            int objectId;
            long precision = 0L;
            long remaining = Long.MAX_VALUE;
            if (length > 0 && (long)length < remaining) {
                remaining = length;
            }
            int len = (int)Math.min(remaining, 4096L);
            byte[] buff = new byte[len];
            if ((len = TypeConverter.readFully(in, buff, len)) <= 128) {
                byte[] small = new byte[len];
                System.arraycopy(buff, 0, small, 0, len);
                return ValueLob.createSmallLob(15, small);
            }
            Database database2 = database;
            synchronized (database2) {
                if (!Constants.LOB_FILES_IN_DIRECTORIES) {
                    objectId = database.allocateObjectId(false, true);
                    fileName = database.createTempFile();
                } else {
                    objectId = ValueLob.getNewObjectId(database.getDatabasePath());
                    fileName = ValueLob.getFileNamePrefix(database.getDatabasePath(), objectId) + ".temp.db";
                }
                store = database.openFile(fileName);
            }
            FileStoreOutputStream out = new FileStoreOutputStream(store, database);
            do {
                precision += (long)len;
                out.write(buff, 0, len);
                if ((remaining -= (long)len) <= 0L) break;
                len = (int)Math.min(remaining, 4096L);
            } while ((len = TypeConverter.readFully(in, buff, len)) > 0);
            out.close();
            return new ValueLob(15, database, fileName, 0, objectId, false, precision);
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    public Value convertTo(int t) throws SQLException {
        if (t == this.type) {
            return this;
        }
        if (t == 16 || t == 15) {
            this.type = t;
            this.precision = 0L;
        }
        return super.convertTo(t);
    }

    public void unlink(Database database) throws SQLException {
        if (this.linked && this.fileName != null) {
            String temp = !Constants.LOB_FILES_IN_DIRECTORIES ? database.createTempFile() : ValueLob.getFileName(database, -1, this.objectId);
            FileUtils.delete(temp);
            FileUtils.rename(this.fileName, temp);
            FileUtils.deleteOnExit(temp);
            this.fileName = temp;
            this.linked = false;
        }
    }

    public void link(Database database, int tabId) throws SQLException {
        if (!this.linked && this.fileName != null) {
            this.tableId = tabId;
            String live = ValueLob.getFileName(database, this.tableId, this.objectId);
            FileUtils.rename(this.fileName, live);
            this.fileName = live;
            this.linked = true;
        }
    }

    public int getTableId() {
        return this.tableId;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public int getType() {
        return this.type;
    }

    public long getPrecision() {
        return this.precision;
    }

    public String getString() throws SQLException {
        if (this.type == 16) {
            if (this.small != null) {
                return StringUtils.utf8Decode(this.small);
            }
            return TypeConverter.getString(this.getReader(), Integer.MAX_VALUE);
        }
        try {
            byte[] buff = this.small != null ? this.small : ByteUtils.getBytesAndClose(this.getInputStream(), 0);
            return ByteUtils.convertBytesToString(buff);
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    public byte[] getBytes() throws SQLException {
        if (this.small != null) {
            return this.small;
        }
        return TypeConverter.getBytes(this.getInputStream(), Integer.MAX_VALUE);
    }

    public int hashCode() {
        if (this.hash == 0) {
            try {
                this.hash = ByteUtils.getByteArrayHash(this.getBytes());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.hash;
    }

    protected int compareSecure(Value v, CompareMode mode) throws SQLException {
        if (this.type == 16) {
            int c = this.getString().compareTo(v.getString());
            return c == 0 ? 0 : (c < 0 ? -1 : 1);
        }
        byte[] v2 = v.getBytes();
        return ByteUtils.compareNotNull(this.getBytes(), v2);
    }

    public Object getObject() throws SQLException {
        if (this.type == 16) {
            return this.getReader();
        }
        return this.getInputStream();
    }

    public Reader getReader() throws SQLException {
        return TypeConverter.getReader(this.getInputStream());
    }

    public InputStream getInputStream() throws SQLException {
        if (this.fileName == null) {
            return new ByteArrayInputStream(this.small);
        }
        FileStore store = this.handler.openFile(this.fileName);
        return new BufferedInputStream(new FileStoreInputStream(store, this.handler));
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        long p = this.getPrecision();
        if (p > Integer.MAX_VALUE || p <= 0L) {
            p = -1L;
        }
        if (this.type == 15) {
            prep.setBinaryStream(parameterIndex, this.getInputStream(), (int)p);
        } else {
            prep.setCharacterStream(parameterIndex, this.getReader(), (int)p);
        }
    }

    public String getSQL() {
        try {
            if (this.type == 16) {
                String s = this.getString();
                return StringUtils.quoteStringSQL(s);
            }
            byte[] buff = this.getBytes();
            String s = ByteUtils.convertBytesToString(buff);
            return "X'" + s + "'";
        }
        catch (SQLException e) {
            throw Message.convertToInternal(e);
        }
    }

    public byte[] getSmall() {
        return this.small;
    }

    public int getDisplaySize() {
        return 40;
    }

    protected boolean isEqual(Value v) {
        try {
            return this.compareSecure(v, null) == 0;
        }
        catch (SQLException e) {
            throw Message.internal("compare", e);
        }
    }
}

