/*
 * Decompiled with CFR 0.152.
 */
package org.h2.web;

import org.h2.message.Message;
import org.h2.util.ObjectArray;

public class ScriptParser {
    String script;
    ObjectArray list;

    ScriptParser(String script) {
        this.script = script;
    }

    public Exception getSyntaxError(int index) {
        String s = this.script;
        if (this.script != null && index < this.script.length()) {
            s = this.script.substring(0, index) + "[*]" + this.script.substring(index);
        }
        return new Exception(s);
    }

    ObjectArray getScript() {
        return this.list;
    }

    void parse() throws Exception {
        this.list = new ObjectArray();
        int len = this.script.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            try {
                char c = this.script.charAt(i);
                switch (c) {
                    case '\'': {
                        int j = this.script.indexOf(39, i + 1);
                        if (j < 0) {
                            throw this.getSyntaxError(i);
                        }
                        i = j;
                        break;
                    }
                    case '\"': {
                        int j = this.script.indexOf(34, i + 1);
                        if (j < 0) {
                            throw this.getSyntaxError(i);
                        }
                        i = j;
                        break;
                    }
                    case '/': {
                        if (this.script.charAt(i + 1) != '*') break;
                        int j = this.script.indexOf("*/", i + 2);
                        if (j < 0) {
                            throw Message.getSyntaxError(this.script, i);
                        }
                        i = j + 1;
                        break;
                    }
                    case '-': {
                        if (this.script.charAt(i + 1) != '-') break;
                        i += 2;
                        while (i < len && (c = this.script.charAt(i)) != '\r' && c != '\n') {
                            ++i;
                        }
                        break;
                    }
                    case ';': {
                        this.add(this.script.substring(start, i));
                        start = ++i;
                    }
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw this.getSyntaxError(i);
            }
        }
        this.add(this.script.substring(start));
    }

    void add(String s) {
        if (s.trim().length() > 0) {
            this.list.add(s);
        }
    }
}

