/*
 * Decompiled with CFR 0.152.
 */
package snoozesoft.systray4j;

import snoozesoft.systray4j.SubMenu;
import snoozesoft.systray4j.SysTrayAccess;
import snoozesoft.systray4j.SysTrayMenu;

class NativeSysTray
implements SysTrayAccess {
    private boolean libraryLoaded = true;
    private static String libName = "systray4j";
    private boolean started;

    NativeSysTray() {
        try {
            System.loadLibrary(libName);
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("systray4j: " + e.getMessage());
            this.libraryLoaded = false;
        }
        this.started = false;
    }

    public boolean isAvailable() {
        return this.libraryLoaded;
    }

    public void addMainMenu(SysTrayMenu menu, String iconFileName, String toolTip) {
        if (!this.started) {
            this.initNative(SysTrayMenu.VERSION);
            this.started = true;
        }
        menu.id = this.addMainMenuNative(menu, iconFileName, toolTip);
    }

    public void addSubMenu(SubMenu menu) {
        if (!this.started) {
            this.initNative(SysTrayMenu.VERSION);
            this.started = true;
        }
        menu.id = this.addSubMenuNative(menu);
    }

    public void setToolTip(int menuId, String tip) {
        this.setToolTipNative(menuId, tip);
    }

    public void showIcon(int menuId, boolean show) {
        this.showIconNative(menuId, show);
    }

    public void setIcon(int menuId, String iconFileName) {
        this.setIconNative(menuId, iconFileName);
    }

    public void enableItem(int menuId, int itemIndex, boolean enable) {
        this.enableItemNative(menuId, itemIndex, enable);
    }

    public void checkItem(int menuId, int itemIndex, boolean check) {
        this.checkItemNative(menuId, itemIndex, check);
    }

    public void setItemLabel(int menuId, int itemIndex, String label) {
        this.setItemLabelNative(menuId, itemIndex, label);
    }

    public void addItem(int menuId, int itemIndex, String label, boolean checkable, boolean check, boolean enable) {
        this.addItemNative(menuId, itemIndex, label, checkable, check, enable);
    }

    public void removeItem(int menuId, int itemIndex) {
        this.removeItemNative(menuId, itemIndex);
    }

    public void removeAll(int menuId) {
        this.removeAllNative(menuId);
    }

    public void dispose() {
        if (this.started) {
            this.disposeNative();
        }
    }

    private native void initNative(String var1);

    private native int addMainMenuNative(SysTrayMenu var1, String var2, String var3);

    private native int addSubMenuNative(SubMenu var1);

    private native void setToolTipNative(int var1, String var2);

    private native void showIconNative(int var1, boolean var2);

    private native void setIconNative(int var1, String var2);

    private native void enableItemNative(int var1, int var2, boolean var3);

    private native void checkItemNative(int var1, int var2, boolean var3);

    private native void setItemLabelNative(int var1, int var2, String var3);

    private native void addItemNative(int var1, int var2, String var3, boolean var4, boolean var5, boolean var6);

    private native void removeItemNative(int var1, int var2);

    private native void removeAllNative(int var1);

    private native void disposeNative();
}

