/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.jdwp.XSLJDWPCommandSet;
import oracle.xml.jdwp.XSLJDWPConstants;
import oracle.xml.jdwp.XSLJDWPException;
import oracle.xml.jdwp.XSLJDWPNode;
import oracle.xml.jdwp.XSLJDWPPacket;
import oracle.xml.jdwp.XSLJDWPPacketStream;
import oracle.xml.jdwp.XSLJDWPPacketValue;
import oracle.xml.jdwp.XSLJDWPString;
import oracle.xml.jdwp.XSLJDWPUtil;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLNodeList;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLTContext;
import org.w3c.dom.NodeList;

public class XSLJDWPObjectReference
extends XSLJDWPCommandSet
implements XSLJDWPConstants {
    static final byte OBJECTID_CLASS = 0;
    static final byte OBJECTID_FIELD = 1;
    static final byte OBJECTID_STRING = 2;
    static final byte OBJECTID_NODEARRAY = 3;
    static final byte OBJECTID_NODE = 5;
    static final byte OBJECTID_CHARARRAY = 6;
    XSLTContext context;
    Vector hashcodes = new Vector();
    Hashtable ids2objs = new Hashtable();
    Hashtable objs2ids = new Hashtable();

    public XSLJDWPObjectReference(XSLTContext xSLTContext) {
        this.context = xSLTContext;
    }

    XSLJDWPPacket execute(XSLJDWPPacket xSLJDWPPacket) {
        this.cmd = xSLJDWPPacket;
        this.cmdStrm = new XSLJDWPPacketStream(this.cmd);
        XSLJDWPPacket xSLJDWPPacket2 = null;
        switch (this.cmd.cmd) {
            case 1: {
                xSLJDWPPacket2 = this.refTypeCmd();
                break;
            }
            case 2: {
                xSLJDWPPacket2 = this.getValuesCmd();
                break;
            }
            case 3: {
                xSLJDWPPacket2 = this.setValuesCmd();
                break;
            }
            case 9: {
                xSLJDWPPacket2 = this.isCollectedCmd();
                break;
            }
            default: {
                xSLJDWPPacket2 = this.cmd.createErrorReply((short)99);
            }
        }
        return xSLJDWPPacket2;
    }

    XSLJDWPPacket refTypeCmd() {
        int n = this.cmdStrm.readObjectID();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.writeByte(this.getRefTypeTag(n));
        xSLJDWPPacketStream.writeReferenceTypeID(this.getTypeID(n));
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket setValuesCmd() {
        int n = this.cmdStrm.readObjectID();
        int n2 = this.cmdStrm.readInt();
        block8: for (int i = 0; i < n2; ++i) {
            int n3 = this.cmdStrm.readFieldID();
            byte by = (byte)(n >> 24);
            switch (by) {
                case 6: {
                    continue block8;
                }
                case 0: {
                    continue block8;
                }
                case 1: {
                    continue block8;
                }
                case 5: {
                    this.setNodeFields(n, n3);
                    continue block8;
                }
                case 3: {
                    continue block8;
                }
                case 2: {
                    int n4 = this.cmdStrm.readInt();
                    Integer n5 = new Integer(n);
                    Object v = this.ids2objs.get(n5);
                    String string = XSLJDWPUtil.toString(v);
                    StringBuffer stringBuffer = new StringBuffer(string);
                    stringBuffer.setLength(n4);
                    String string2 = stringBuffer.toString();
                    XPathSequence.setStringValue((OXMLSequence)v, string2);
                    this.ids2objs.put(n5, v);
                    this.objs2ids.put(v, n5);
                }
            }
        }
        return this.cmd.createReply();
    }

    private void setNodeFields(int n, int n2) {
        XMLNode xMLNode = (XMLNode)this.ids2objs.get(new Integer(n));
        int n3 = this.cmdStrm.readInt();
        String string = XSLJDWPUtil.toString(this.ids2objs.get(new Integer(n3)));
        switch (n2) {
            case 7: {
                xMLNode.setNodeValue(string);
                break;
            }
            case 4: {
                xMLNode.setPrefix(string);
                break;
            }
        }
    }

    XSLJDWPPacket getValuesCmd() {
        int n = this.cmdStrm.readObjectID();
        int n2 = this.cmdStrm.readInt();
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.cmdStrm.readFieldID();
        }
        XSLJDWPPacketValue[] xSLJDWPPacketValueArray = null;
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        try {
            xSLJDWPPacketValueArray = this.generateValuesData(n, n2, nArray);
            int n3 = xSLJDWPPacketValueArray.length;
            xSLJDWPPacketStream.writeInt(n3);
            if (n3 == 0) {
                xSLJDWPPacketStream.close();
                return xSLJDWPPacketStream.packet();
            }
            this.generateIDs(xSLJDWPPacketValueArray);
            this.generateArrayElementData(null);
            for (int i = 0; i < n3; ++i) {
                xSLJDWPPacketStream.writeValue(xSLJDWPPacketValueArray[i]);
            }
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket isCollectedCmd() {
        this.cmdStrm.readObjectID();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.writeBoolean(false);
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    Vector getHashCodes() {
        return this.hashcodes;
    }

    Hashtable getIds2Objs() {
        return this.ids2objs;
    }

    Hashtable getObjs2Ids() {
        return this.objs2ids;
    }

    public void generateIDs(XSLJDWPPacketValue[] xSLJDWPPacketValueArray) {
        int n = xSLJDWPPacketValueArray.length;
        for (int i = 0; i < n; ++i) {
            XSLJDWPPacketValue xSLJDWPPacketValue = xSLJDWPPacketValueArray[i];
            byte by = xSLJDWPPacketValue.getType();
            Object object = xSLJDWPPacketValue.getValue();
            Integer n2 = null;
            switch (by) {
                case 76: {
                    Cloneable cloneable;
                    if (object instanceof XMLNode) {
                        n2 = this.generateUniqueNodeID((XMLNode)object);
                        break;
                    }
                    if (!(object instanceof String)) break;
                    if (xSLJDWPPacketValue.getData() == null) {
                        cloneable = XSLJDWPUtil.toOXMLSequence((String)object, this.context);
                        xSLJDWPPacketValue.setData((OXMLSequence)cloneable);
                    }
                    n2 = this.generateUniqueStringID(xSLJDWPPacketValue.getData());
                    break;
                }
                case 91: {
                    Cloneable cloneable;
                    if (object instanceof NodeList) {
                        cloneable = new XMLNodeList((NodeList)object);
                        n2 = this.generateUniqueArrayID((XMLNodeList)cloneable);
                        break;
                    }
                    if (!(object instanceof String)) break;
                    if (xSLJDWPPacketValue.getData() == null) {
                        cloneable = XSLJDWPUtil.toOXMLSequence((String)object, this.context);
                        xSLJDWPPacketValue.setData((OXMLSequence)cloneable);
                    }
                    n2 = this.generateUniqueCharArrayID(xSLJDWPPacketValue.getData());
                }
            }
            if (n2 == null) continue;
            xSLJDWPPacketValueArray[i].setValue(n2);
        }
    }

    void generateArrayElementData(XSLJDWPPacketValue[] xSLJDWPPacketValueArray) {
        if (xSLJDWPPacketValueArray == null) {
            Enumeration enumeration = this.ids2objs.elements();
            while (enumeration.hasMoreElements()) {
                Object v = enumeration.nextElement();
                if (!(v instanceof XMLNodeList)) continue;
                XMLNodeList xMLNodeList = (XMLNodeList)v;
                int n = xMLNodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    XMLNode xMLNode = (XMLNode)xMLNodeList.item(i);
                    this.generateUniqueNodeID(xMLNode);
                }
            }
        } else {
            for (int i = 0; i < xSLJDWPPacketValueArray.length; ++i) {
                if (!(xSLJDWPPacketValueArray[i].getValue() instanceof XMLNode)) continue;
                XMLNode xMLNode = (XMLNode)xSLJDWPPacketValueArray[i].getValue();
                Integer n = this.generateUniqueNodeID(xMLNode);
                xSLJDWPPacketValueArray[i].setValue(n);
            }
        }
    }

    private Integer generateUniqueID(Object object, byte by) {
        int n = object.hashCode();
        Integer n2 = new Integer(n);
        Integer n3 = XSLJDWPUtil.pos(n2, this.hashcodes);
        int n4 = n3;
        if (n4 == -1) {
            this.hashcodes.add(n2);
            n3 = XSLJDWPUtil.pos(n2, this.hashcodes);
            n4 = n3;
        }
        n3 = new Integer(n4 += by << 24);
        this.ids2objs.put(n3, object);
        this.objs2ids.put(object, n3);
        return n3;
    }

    Integer generateUniqueStringID(Object object) {
        if (object instanceof String) {
            object = XSLJDWPUtil.toOXMLSequence((String)object, this.context);
        }
        return this.generateUniqueID(object, (byte)2);
    }

    Integer generateUniqueCharArrayID(Object object) {
        return this.generateUniqueID(object, (byte)6);
    }

    Integer generateUniqueArrayID(XMLNodeList xMLNodeList) {
        return this.generateUniqueID(xMLNodeList, (byte)3);
    }

    Integer generateUniqueNodeID(XMLNode xMLNode) {
        return this.generateUniqueID(xMLNode, (byte)5);
    }

    private byte getRefTypeTag(int n) {
        byte by = (byte)(n >> 24);
        switch (by) {
            case 3: 
            case 6: {
                return 3;
            }
            case 0: 
            case 1: 
            case 2: 
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    private int getTypeID(int n) {
        if (XSLJDWPObjectReference.isXMLNodeObject(n)) {
            return this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLNode");
        }
        if (XSLJDWPObjectReference.isXMLNodeArrayObject(n)) {
            return this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLNode[]");
        }
        if (XSLJDWPObjectReference.isXMLStringObject(n)) {
            return this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLString");
        }
        if (XSLJDWPObjectReference.isCharArrayObject(n)) {
            return this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("char[]");
        }
        return n;
    }

    private XSLJDWPPacketValue[] generateValuesData(int n, int n2, int[] nArray) throws XSLJDWPException {
        if (n2 <= 0) {
            return new XSLJDWPPacketValue[0];
        }
        XSLJDWPPacketValue[] xSLJDWPPacketValueArray = new XSLJDWPPacketValue[n2];
        int n3 = n >> 24;
        switch (n3) {
            case 5: {
                XMLNode xMLNode = (XMLNode)this.ids2objs.get(new Integer(n));
                if (xMLNode == null) {
                    return new XSLJDWPPacketValue[0];
                }
                XSLJDWPNode xSLJDWPNode = new XSLJDWPNode(xMLNode);
                xSLJDWPPacketValueArray = xSLJDWPNode.generateValues(this, n2, nArray);
                break;
            }
            case 2: {
                Object v = this.ids2objs.get(new Integer(n));
                if (XSLJDWPUtil.toString(v) == null) {
                    return new XSLJDWPPacketValue[0];
                }
                XSLJDWPString xSLJDWPString = new XSLJDWPString((OXMLSequence)v);
                xSLJDWPPacketValueArray = xSLJDWPString.generateValues(this, n2, nArray);
                break;
            }
        }
        return xSLJDWPPacketValueArray;
    }

    static boolean isXMLNodeObject(int n) {
        return n >> 24 == 5;
    }

    static boolean isXMLStringObject(int n) {
        return n >> 24 == 2;
    }

    static boolean isXMLNodeArrayObject(int n) {
        return n >> 24 == 3;
    }

    static boolean isCharArrayObject(int n) {
        return n >> 24 == 6;
    }
}

