/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.parser.v2.XMLParser;
import oracle.xml.xpath.XPathItem;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLNodeSetExpr;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLTContext;

class UnaryExpr
extends XSLExprBase {
    UnaryExpr() {
        super.setExprType(1048632);
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        int n = 1;
        while (xSLParseString.peekToken(104)) {
            if (xSLParseString.getOperator() != 201) continue;
            n *= -1;
        }
        XSLExprBase xSLExprBase = XSLNodeSetExpr.parse(xSLParseString);
        if (n == -1) {
            UnaryExpr unaryExpr = new UnaryExpr();
            unaryExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
            unaryExpr.leftExpr = xSLExprBase;
            xSLExprBase = unaryExpr;
        }
        return xSLExprBase;
    }

    boolean checkPosLastFN() {
        return this.leftExpr.checkPosLastFN();
    }

    void cacheSubExpr() throws XQException {
        if (this.leftExpr.canCacheExpr()) {
            this.leftExpr = this.leftExpr.createCachedExpr();
        }
    }

    boolean canCacheExpr() {
        return this.leftExpr.canCacheExpr();
    }

    String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer(this.leftExpr.getNormalizedExpr());
        stringBuffer.insert(0, 201);
        return stringBuffer.toString();
    }

    public void evaluate(XSLTContext xSLTContext) throws XSLException, XQException {
        xSLTContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        this.leftExpr.evaluate(xSLTContext);
        if (this.getXSLTVersion() == 20 && !this.isBackwardCompatibilityMode() || this.getXSLTVersion() == 10 && this.isForwardCompatibilityMode()) {
            XPathSequence xPathSequence = new XPathSequence(xSLTContext);
            XPathItem xPathItem = xPathSequence.ctx.allocItem();
            if (XMLParser.getIs1010Compatible()) {
                xPathItem.setDouble(OXMLSequenceType.TDOUBLE, -1.0);
            } else {
                xPathItem.setInt(OXMLSequenceType.TINTEGER, -1);
            }
            xPathSequence.appendItem(xPathItem);
            XPathSequence.arithmetic20(xSLTContext.peekExprValue(), xPathSequence, 202);
        } else {
            XPathSequence xPathSequence = new XPathSequence(xSLTContext);
            XPathItem xPathItem = xPathSequence.ctx.allocItem();
            xPathItem.setDouble(OXMLSequenceType.TDOUBLE, -1.0);
            xPathSequence.appendItem(xPathItem);
            XPathSequence.arithmetic(xSLTContext.peekExprValue(), xPathSequence, 202);
        }
    }
}

