/*
 * Decompiled with CFR 0.152.
 */
package org.openamf.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class XMLUtils {
    protected static Log log = LogFactory.getLog((Class)(class$org$openamf$util$XMLUtils == null ? (class$org$openamf$util$XMLUtils = XMLUtils.class$("org.openamf.util.XMLUtils")) : class$org$openamf$util$XMLUtils));
    static /* synthetic */ Class class$org$openamf$util$XMLUtils;

    private XMLUtils() {
    }

    public static String convertDOMToString(Node node) {
        StringBuffer sb = new StringBuffer();
        if (node.getNodeType() == 3) {
            sb.append(node.getNodeValue());
        } else {
            String currentTag = node.getNodeName();
            sb.append('<');
            sb.append(currentTag);
            XMLUtils.appendAttributes(node, sb);
            sb.append('>');
            if (node.getNodeValue() != null) {
                sb.append(node.getNodeValue());
            }
            XMLUtils.appendChildren(node, sb);
            XMLUtils.appendEndTag(sb, currentTag);
        }
        return sb.toString();
    }

    private static void appendAttributes(Node node, StringBuffer sb) {
        if (node instanceof Element) {
            NamedNodeMap nodeMap = node.getAttributes();
            int i = 0;
            while (i < nodeMap.getLength()) {
                sb.append(' ');
                sb.append(nodeMap.item(i).getNodeName());
                sb.append('=');
                sb.append('\"');
                sb.append(nodeMap.item(i).getNodeValue());
                sb.append('\"');
                ++i;
            }
        }
    }

    private static void appendChildren(Node node, StringBuffer sb) {
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                sb.append(XMLUtils.convertDOMToString(children.item(i)));
                ++i;
            }
        }
    }

    private static void appendEndTag(StringBuffer sb, String currentTag) {
        sb.append('<');
        sb.append('/');
        sb.append(currentTag);
        sb.append('>');
    }

    public static Document convertToDOM(InputStream is) throws IOException {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        is.skip(4L);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(new InputSource(is));
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new IOException("Error while parsing xml: " + e.getMessage());
        }
        return document;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

