/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import java.util.ArrayList;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.ast.tree.BinaryLogicOperatorNode;
import org.hibernate.hql.ast.tree.BinaryOperatorNode;
import org.hibernate.hql.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.ast.tree.LiteralNode;
import org.hibernate.hql.ast.tree.Node;
import org.hibernate.hql.ast.tree.ParameterNode;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.type.Type;

public class InLogicOperatorNode
extends BinaryLogicOperatorNode
implements BinaryOperatorNode {
    static /* synthetic */ Class class$org$hibernate$hql$ast$tree$ExpectedTypeAwareNode;

    public Node getInList() {
        return this.getRightHandOperand();
    }

    public void initialize() throws SemanticException {
        SessionFactoryImplementor sessionFactory;
        Node lhs = this.getLeftHandOperand();
        if (lhs == null) {
            throw new SemanticException("left-hand operand of in operator was null");
        }
        Node inList = this.getInList();
        if (inList == null) {
            throw new SemanticException("right-hand operand of in operator was null");
        }
        if (SqlNode.class.isAssignableFrom(((Object)((Object)lhs)).getClass())) {
            Type lhsType = ((SqlNode)lhs).getDataType();
            for (AST inListChild = inList.getFirstChild(); inListChild != null; inListChild = inListChild.getNextSibling()) {
                if (!(class$org$hibernate$hql$ast$tree$ExpectedTypeAwareNode == null ? InLogicOperatorNode.class$("org.hibernate.hql.ast.tree.ExpectedTypeAwareNode") : class$org$hibernate$hql$ast$tree$ExpectedTypeAwareNode).isAssignableFrom(inListChild.getClass())) continue;
                ((ExpectedTypeAwareNode)inListChild).setExpectedType(lhsType);
            }
        }
        if ((sessionFactory = this.getSessionFactoryHelper().getFactory()).getDialect().supportsRowValueConstructorSyntaxInInList()) {
            return;
        }
        Type lhsType = this.extractDataType(lhs);
        if (lhsType == null) {
            return;
        }
        int lhsColumnSpan = lhsType.getColumnSpan(sessionFactory);
        Node rhsNode = (Node)inList.getFirstChild();
        if (!this.isNodeAcceptable(rhsNode)) {
            return;
        }
        int rhsColumnSpan = 0;
        if (rhsNode.getType() == 92) {
            rhsColumnSpan = rhsNode.getNumberOfChildren();
        } else {
            Type rhsType = this.extractDataType(rhsNode);
            if (rhsType == null) {
                return;
            }
            rhsColumnSpan = rhsType.getColumnSpan(sessionFactory);
        }
        if (lhsColumnSpan > 1 && rhsColumnSpan > 1) {
            this.mutateRowValueConstructorSyntaxInInListSyntax(lhsColumnSpan, rhsColumnSpan);
        }
    }

    private boolean isNodeAcceptable(Node rhsNode) {
        return rhsNode instanceof LiteralNode || rhsNode instanceof ParameterNode || rhsNode.getType() == 92;
    }

    private void mutateRowValueConstructorSyntaxInInListSyntax(int lhsColumnSpan, int rhsColumnSpan) {
        Node rhsNode;
        ParameterSpecification lhsEmbeddedCompositeParameterSpecification;
        String[] lhsElementTexts = InLogicOperatorNode.extractMutationTexts(this.getLeftHandOperand(), lhsColumnSpan);
        ParameterSpecification parameterSpecification = this.getLeftHandOperand() == null || !ParameterNode.class.isInstance((Object)this.getLeftHandOperand()) ? null : (lhsEmbeddedCompositeParameterSpecification = ((ParameterNode)this.getLeftHandOperand()).getHqlParameterSpecification());
        if (rhsNode != null && rhsNode.getNextSibling() == null) {
            String[] rhsElementTexts = InLogicOperatorNode.extractMutationTexts(rhsNode, rhsColumnSpan);
            this.setType(6);
            this.setText("AND");
            ParameterSpecification rhsEmbeddedCompositeParameterSpecification = rhsNode == null || !ParameterNode.class.isInstance((Object)rhsNode) ? null : ((ParameterNode)rhsNode).getHqlParameterSpecification();
            this.translate(lhsColumnSpan, 102, "=", lhsElementTexts, rhsElementTexts, lhsEmbeddedCompositeParameterSpecification, rhsEmbeddedCompositeParameterSpecification, (AST)this);
        } else {
            ArrayList<AST> andElementsNodeList = new ArrayList<AST>();
            for (rhsNode = (Node)this.getInList().getFirstChild(); rhsNode != null; rhsNode = (Node)rhsNode.getNextSibling()) {
                String[] rhsElementTexts = InLogicOperatorNode.extractMutationTexts(rhsNode, rhsColumnSpan);
                AST and = this.getASTFactory().create(6, "AND");
                ParameterSpecification rhsEmbeddedCompositeParameterSpecification = rhsNode == null || !(class$org$hibernate$hql$ast$tree$ParameterNode == null ? InLogicOperatorNode.class$("org.hibernate.hql.ast.tree.ParameterNode") : class$org$hibernate$hql$ast$tree$ParameterNode).isInstance((Object)rhsNode) ? null : ((ParameterNode)rhsNode).getHqlParameterSpecification();
                this.translate(lhsColumnSpan, 102, "=", lhsElementTexts, rhsElementTexts, lhsEmbeddedCompositeParameterSpecification, rhsEmbeddedCompositeParameterSpecification, and);
                andElementsNodeList.add(and);
            }
            this.setType(40);
            this.setText("OR");
            InLogicOperatorNode curNode = this;
            for (int i = andElementsNodeList.size() - 1; i > 1; --i) {
                AST or = this.getASTFactory().create(40, "OR");
                curNode.setFirstChild(or);
                curNode = or;
                AST and = (AST)andElementsNodeList.get(i);
                or.setNextSibling(and);
            }
            AST node0 = (AST)andElementsNodeList.get(0);
            AST node1 = (AST)andElementsNodeList.get(1);
            node0.setNextSibling(node1);
            curNode.setFirstChild(node0);
        }
    }
}

