/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;
import javax.naming.NamingException;
import javax.naming.directory.InvalidSearchFilterException;

final class Filter {
    private static final boolean dbg = false;
    private static int dbgIndent = 0;
    static final int LDAP_FILTER_AND = 160;
    static final int LDAP_FILTER_OR = 161;
    static final int LDAP_FILTER_NOT = 162;
    static final int LDAP_FILTER_EQUALITY = 163;
    static final int LDAP_FILTER_SUBSTRINGS = 164;
    static final int LDAP_FILTER_GE = 165;
    static final int LDAP_FILTER_LE = 166;
    static final int LDAP_FILTER_PRESENT = 135;
    static final int LDAP_FILTER_APPROX = 168;
    static final int LDAP_FILTER_EXT = 169;
    static final int LDAP_FILTER_EXT_RULE = 129;
    static final int LDAP_FILTER_EXT_TYPE = 130;
    static final int LDAP_FILTER_EXT_VAL = 131;
    static final int LDAP_FILTER_EXT_DN = 132;
    static final int LDAP_SUBSTRING_INITIAL = 128;
    static final int LDAP_SUBSTRING_ANY = 129;
    static final int LDAP_SUBSTRING_FINAL = 130;

    Filter() {
    }

    static void encodeFilterString(BerEncoder berEncoder, String string, boolean bl) throws IOException, NamingException {
        if (string == null || string.equals("")) {
            throw new InvalidSearchFilterException("Empty filter");
        }
        byte[] byArray = bl ? string.getBytes("UTF8") : string.getBytes("8859_1");
        int n = byArray.length;
        Filter.encodeFilter(berEncoder, byArray, 0, n);
    }

    private static void encodeFilter(BerEncoder berEncoder, byte[] byArray, int n, int n2) throws IOException, NamingException {
        if (n2 - n <= 0) {
            throw new InvalidSearchFilterException("Empty filter");
        }
        int n3 = 0;
        int[] nArray = new int[]{n};
        while (nArray[0] < n2) {
            block0 : switch (byArray[nArray[0]]) {
                case 40: {
                    nArray[0] = nArray[0] + 1;
                    ++n3;
                    switch (byArray[nArray[0]]) {
                        case 38: {
                            Filter.encodeComplexFilter(berEncoder, byArray, 160, nArray, n2);
                            --n3;
                            break block0;
                        }
                        case 124: {
                            Filter.encodeComplexFilter(berEncoder, byArray, 161, nArray, n2);
                            --n3;
                            break block0;
                        }
                        case 33: {
                            Filter.encodeComplexFilter(berEncoder, byArray, 162, nArray, n2);
                            --n3;
                            break block0;
                        }
                    }
                    int n4 = 1;
                    boolean bl = false;
                    int n5 = nArray[0];
                    while (n5 < n2 && n4 > 0) {
                        if (!bl) {
                            if (byArray[n5] == 40) {
                                ++n4;
                            } else if (byArray[n5] == 41) {
                                --n4;
                            }
                        }
                        bl = byArray[n5] == 92 && !bl;
                        if (n4 <= 0) continue;
                        ++n5;
                    }
                    if (n4 != 0) {
                        throw new InvalidSearchFilterException("Unbalanced parenthesis");
                    }
                    Filter.encodeSimpleFilter(berEncoder, byArray, nArray[0], n5);
                    nArray[0] = n5;
                    --n3;
                    break;
                }
                case 41: {
                    berEncoder.endSeq();
                    nArray[0] = nArray[0] + 1;
                    --n3;
                    break;
                }
                case 32: {
                    nArray[0] = nArray[0] + 1;
                    break;
                }
                default: {
                    Filter.encodeSimpleFilter(berEncoder, byArray, nArray[0], n2);
                    nArray[0] = n2;
                }
            }
            nArray[0] = nArray[0] + 1;
        }
        if (n3 > 0) {
            throw new InvalidSearchFilterException("Unbalanced parenthesis");
        }
    }

    private static int hexchar2int(byte by) {
        if (by >= 48 && by <= 57) {
            return by - 48;
        }
        if (by >= 65 && by <= 70) {
            return by - 65 + 10;
        }
        if (by >= 97 && by <= 102) {
            return by - 97 + 10;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static byte[] unescapeFilterValue(byte[] byArray, int n, int n2) throws NamingException {
        boolean bl = false;
        boolean bl2 = false;
        int n3 = n2 - n;
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            byte by = byArray[n5];
            if (bl) {
                int n6 = Filter.hexchar2int(by);
                if (n6 < 0) {
                    if (!bl2) throw new InvalidSearchFilterException("invalid escape sequence: " + byArray);
                    bl = false;
                    byArray2[n4++] = by;
                } else if (bl2) {
                    byArray2[n4] = (byte)(n6 << 4);
                    bl2 = false;
                } else {
                    int n7 = n4++;
                    byArray2[n7] = (byte)(byArray2[n7] | (byte)n6);
                    bl = false;
                }
            } else if (by != 92) {
                byArray2[n4++] = by;
                bl = false;
            } else {
                bl = true;
                bl2 = true;
            }
            ++n5;
        }
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray2, 0, byArray3, 0, n4);
        return byArray3;
    }

    private static int indexOf(byte[] byArray, char c, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            if (byArray[n3] == c) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private static int indexOf(byte[] byArray, String string, int n, int n2) {
        int n3 = Filter.indexOf(byArray, string.charAt(0), n, n2);
        if (n3 >= 0) {
            int n4 = 1;
            while (n4 < string.length()) {
                if (byArray[n3 + n4] != string.charAt(n4)) {
                    return -1;
                }
                ++n4;
            }
        }
        return n3;
    }

    private static int findUnescaped(byte[] byArray, char c, int n, int n2) {
        while (n < n2) {
            int n3 = Filter.indexOf(byArray, c, n, n2);
            if (n3 == n || n3 == -1 || byArray[n3 - 1] != 92) {
                return n3;
            }
            n = n3 + 1;
        }
        return -1;
    }

    private static void encodeSimpleFilter(BerEncoder berEncoder, byte[] byArray, int n, int n2) throws IOException, NamingException {
        int n3;
        int n4;
        int n5 = Filter.indexOf(byArray, '=', n, n2);
        if (n5 == -1) {
            throw new InvalidSearchFilterException("Missing 'equals'");
        }
        int n6 = n5 + 1;
        int n7 = n2;
        int n8 = n;
        switch (byArray[n5 - 1]) {
            case 60: {
                n4 = 166;
                n3 = n5 - 1;
                break;
            }
            case 62: {
                n4 = 165;
                n3 = n5 - 1;
                break;
            }
            case 126: {
                n4 = 168;
                n3 = n5 - 1;
                break;
            }
            case 58: {
                n4 = 169;
                n3 = n5 - 1;
                break;
            }
            default: {
                n3 = n5;
                if (Filter.findUnescaped(byArray, '*', n6, n7) == -1) {
                    n4 = 163;
                    break;
                }
                if (byArray[n6] == 42 && n6 == n7 - 1) {
                    n4 = 135;
                    break;
                }
                Filter.encodeSubstringFilter(berEncoder, byArray, n8, n3, n6, n7);
                return;
            }
        }
        if (n4 == 135) {
            berEncoder.encodeOctetString(byArray, n4, n8, n3 - n8);
        } else if (n4 == 169) {
            Filter.encodeExtensibleMatch(berEncoder, byArray, n8, n3, n6, n7);
        } else {
            berEncoder.beginSeq(n4);
            berEncoder.encodeOctetString(byArray, 4, n8, n3 - n8);
            berEncoder.encodeOctetString(Filter.unescapeFilterValue(byArray, n6, n7), 4);
            berEncoder.endSeq();
        }
    }

    private static void encodeSubstringFilter(BerEncoder berEncoder, byte[] byArray, int n, int n2, int n3, int n4) throws IOException, NamingException {
        int n5;
        berEncoder.beginSeq(164);
        berEncoder.encodeOctetString(byArray, 4, n, n2 - n);
        berEncoder.beginSeq(48);
        int n6 = n3;
        while ((n5 = Filter.findUnescaped(byArray, '*', n6, n4)) != -1) {
            if (n6 == n3) {
                if (n6 < n5) {
                    berEncoder.encodeOctetString(Filter.unescapeFilterValue(byArray, n6, n5), 128);
                }
            } else if (n6 < n5) {
                berEncoder.encodeOctetString(Filter.unescapeFilterValue(byArray, n6, n5), 129);
            }
            n6 = n5 + 1;
        }
        if (n6 < n4) {
            berEncoder.encodeOctetString(Filter.unescapeFilterValue(byArray, n6, n4), 130);
        }
        berEncoder.endSeq();
        berEncoder.endSeq();
    }

    private static void encodeComplexFilter(BerEncoder berEncoder, byte[] byArray, int n, int[] nArray, int n2) throws IOException, NamingException {
        nArray[0] = nArray[0] + 1;
        berEncoder.beginSeq(n);
        int[] nArray2 = Filter.findRightParen(byArray, nArray, n2);
        Filter.encodeFilterList(berEncoder, byArray, nArray2[0], nArray2[1]);
        berEncoder.endSeq();
    }

    private static int[] findRightParen(byte[] byArray, int[] nArray, int n) throws IOException, NamingException {
        int n2 = 1;
        boolean bl = false;
        int n3 = nArray[0];
        while (n3 < n && n2 > 0) {
            if (!bl) {
                if (byArray[n3] == 40) {
                    ++n2;
                } else if (byArray[n3] == 41) {
                    --n2;
                }
            }
            bl = byArray[n3] == 92 && !bl;
            if (n2 <= 0) continue;
            ++n3;
        }
        if (n2 != 0) {
            throw new InvalidSearchFilterException("Unbalanced parenthesis");
        }
        int[] nArray2 = new int[]{nArray[0], n3};
        nArray[0] = n3 + 1;
        return nArray2;
    }

    private static void encodeFilterList(BerEncoder berEncoder, byte[] byArray, int n, int n2) throws IOException, NamingException {
        int[] nArray = new int[]{n};
        while (nArray[0] < n2) {
            if (!Character.isSpaceChar((char)byArray[nArray[0]]) && byArray[nArray[0]] != 40) {
                int[] nArray2 = Filter.findRightParen(byArray, nArray, n2);
                int n3 = nArray2[1] - nArray2[0];
                byte[] byArray2 = new byte[n3 + 2];
                System.arraycopy(byArray, nArray2[0], byArray2, 1, n3);
                byArray2[0] = 40;
                byArray2[n3 + 1] = 41;
                Filter.encodeFilter(berEncoder, byArray2, 0, byArray2.length);
            }
            nArray[0] = nArray[0] + 1;
        }
    }

    private static void encodeExtensibleMatch(BerEncoder berEncoder, byte[] byArray, int n, int n2, int n3, int n4) throws IOException, NamingException {
        boolean bl = false;
        berEncoder.beginSeq(169);
        int n5 = Filter.indexOf(byArray, ':', n, n2);
        if (n5 >= 0) {
            int n6;
            int n7 = Filter.indexOf(byArray, ":dn", n5, n2);
            if (n7 >= 0) {
                bl = true;
            }
            if ((n6 = Filter.indexOf(byArray, ':', n5 + 1, n2)) >= 0 || n7 == -1) {
                if (n7 == n5) {
                    berEncoder.encodeOctetString(byArray, 129, n6 + 1, n2 - (n6 + 1));
                } else if (n7 == n6 && n7 >= 0) {
                    berEncoder.encodeOctetString(byArray, 129, n5 + 1, n6 - (n5 + 1));
                } else {
                    berEncoder.encodeOctetString(byArray, 129, n5 + 1, n2 - (n5 + 1));
                }
            }
            if (n5 > 0) {
                berEncoder.encodeOctetString(byArray, 130, n, n5 - n);
            }
        } else {
            berEncoder.encodeOctetString(byArray, 130, n, n2 - n);
        }
        berEncoder.encodeOctetString(Filter.unescapeFilterValue(byArray, n3, n4), 131);
        berEncoder.encodeBoolean(bl, 132);
        berEncoder.endSeq();
    }

    private static void dprint(String string, byte[] byArray) {
        Filter.dprint(string, byArray, 0, byArray.length);
    }

    private static void dprint(String string, byte[] byArray, int n, int n2) {
        String string2 = "  ";
        int n3 = dbgIndent;
        while (n3-- > 0) {
            string2 = string2 + "  ";
        }
        string2 = string2 + string;
        System.err.print(string2);
        int n4 = n;
        while (n4 < n2) {
            System.err.print((char)byArray[n4]);
            ++n4;
        }
        System.err.println();
    }
}

