/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.awt.Color;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.fonts.Font;
import org.icepdf.core.pobjects.graphics.ExtGState;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.Pattern;
import org.icepdf.core.pobjects.graphics.ShadingPattern;
import org.icepdf.core.pobjects.graphics.TilingPattern;
import org.icepdf.core.util.Library;

public class Resources
extends Dictionary {
    private static final Logger logger = Logger.getLogger(Resources.class.toString());
    Hashtable fonts;
    Hashtable xobjects;
    Hashtable colorspaces;
    Hashtable patterns;
    Hashtable shading;
    Hashtable extGStates;
    private Hashtable<String, Image> images = new Hashtable();

    public Resources(Library library, Hashtable hashtable) {
        super(library, hashtable);
        this.colorspaces = this.library.getDictionary(this.entries, "ColorSpace");
        this.fonts = this.library.getDictionary(this.entries, "Font");
        this.xobjects = this.library.getDictionary(this.entries, "XObject");
        this.patterns = this.library.getDictionary(this.entries, "Pattern");
        this.shading = this.library.getDictionary(this.entries, "Shading");
        this.extGStates = this.library.getDictionary(this.entries, "ExtGState");
    }

    public void dispose(boolean bl) {
        Object object;
        Image image;
        Enumeration<Image> enumeration;
        if (this.images != null) {
            enumeration = this.images.elements();
            while (enumeration.hasMoreElements()) {
                image = enumeration.nextElement();
                if (!(image instanceof Image)) continue;
                object = image;
                ((Image)object).flush();
            }
            this.images.clear();
        }
        if (this.xobjects != null) {
            enumeration = this.xobjects.elements();
            while (enumeration.hasMoreElements()) {
                Stream stream;
                image = enumeration.nextElement();
                if (image instanceof Stream) {
                    object = (Stream)((Object)image);
                    ((Stream)object).dispose(bl);
                }
                if (!(image instanceof Reference)) continue;
                object = this.library.getObject((Reference)((Object)image));
                if (object instanceof Form) {
                    stream = (Form)object;
                    ((Form)stream).dispose(bl);
                }
                if (!(object instanceof Stream)) continue;
                stream = (Stream)object;
                stream.dispose(bl);
            }
        }
    }

    public PColorSpace getColorSpace(Object object) {
        if (object == null) {
            return null;
        }
        if (this.colorspaces != null && this.colorspaces.get(object) != null) {
            Object v = this.colorspaces.get(object);
            PColorSpace pColorSpace = PColorSpace.getColorSpace(this.library, v);
            if (pColorSpace != null) {
                pColorSpace.init();
            }
            return pColorSpace;
        }
        if (this.patterns != null && this.patterns.get(object) != null) {
            Object v = this.patterns.get(object);
            PColorSpace pColorSpace = PColorSpace.getColorSpace(this.library, v);
            if (pColorSpace != null) {
                pColorSpace.init();
            }
            return pColorSpace;
        }
        PColorSpace pColorSpace = PColorSpace.getColorSpace(this.library, object);
        if (pColorSpace != null) {
            pColorSpace.init();
        }
        return pColorSpace;
    }

    public Font getFont(String string) {
        Font font = null;
        if (this.fonts != null) {
            Object v = this.fonts.get(string);
            if (v instanceof Font) {
                font = (Font)v;
            } else if (v instanceof Reference) {
                font = (Font)this.library.getObject((Reference)v);
            }
        }
        if (font != null) {
            font.init();
        }
        return font;
    }

    public Image getImage(String string, Color color) {
        Image image = this.images.get(string);
        if (image != null) {
            return image;
        }
        Stream stream = (Stream)this.library.getObject(this.xobjects, string);
        if (stream == null) {
            return null;
        }
        if (!stream.isImageSubtype()) {
            return null;
        }
        try {
            image = stream.getImage(color, this, true);
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Error getting image by name: " + string, exception);
        }
        if (image != null && !stream.isImageMask()) {
            this.images.put(string, image);
        }
        return image;
    }

    public boolean isForm(String string) {
        Object object = this.library.getObject(this.xobjects, string);
        return object instanceof Form;
    }

    public Form getForm(String string) {
        Form form = null;
        Object object = this.library.getObject(this.xobjects, string);
        if (object instanceof Form) {
            form = (Form)object;
        }
        return form;
    }

    public Pattern getPattern(String string) {
        if (this.patterns != null) {
            Object object = this.library.getObject(this.patterns, string);
            if (object != null && object instanceof TilingPattern) {
                return (TilingPattern)object;
            }
            if (object != null && object instanceof Hashtable) {
                return ShadingPattern.getShadingPattern(this.library, (Hashtable)object);
            }
        }
        return null;
    }

    public ShadingPattern getShading(String string) {
        Object object;
        if (this.shading != null && (object = this.library.getObject(this.shading, string)) != null && object instanceof Hashtable) {
            return ShadingPattern.getShadingPattern(this.library, this.entries, (Hashtable)object);
        }
        return null;
    }

    public ExtGState getExtGState(String string) {
        ExtGState extGState = null;
        if (this.extGStates != null) {
            Object object = this.library.getObject(this.extGStates, string);
            if (object instanceof Hashtable) {
                extGState = new ExtGState(this.library, (Hashtable)object);
            } else if (object instanceof Reference) {
                extGState = new ExtGState(this.library, (Hashtable)this.library.getObject((Reference)object));
            }
        }
        return extGState;
    }
}

