/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts;

import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.fonts.AFM;
import org.icepdf.core.pobjects.fonts.FontFactory;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.util.Library;

public class FontDescriptor
extends Dictionary {
    private static final Logger logger = Logger.getLogger(FontDescriptor.class.toString());
    private FontFile font;
    public static final String FONT_NAME = "FontName";
    public static final String FONT_FAMILY = "FontFamily";
    public static final String MISSING_Stretch = "FontStretch";
    public static final String FONT_WEIGHT = "FontWeight";
    public static final String FLAGS = "Flags";
    public static final String FONT_BBOX = "FontBBox";
    public static final String ITALIC_ANGLE = "ItalicAngle";
    public static final String ASCENT = "Ascent";
    public static final String DESCENT = "Descent";
    public static final String LEADING = "Leading";
    public static final String CAP_HEIGHT = "CapHeight";
    public static final String X_HEIGHT = "XHeight";
    public static final String STEM_V = "StemV";
    public static final String STEM_H = "StemH";
    public static final String AVG_WIDTH = "AvgWidth";
    public static final String MAX_WIDTH = "MaxWidth";
    public static final String MISSING_WIDTH = "MissingWidth";
    private static final String FONT_FILE = "FontFile";
    private static final String FONT_FILE_2 = "FontFile2";
    private static final String FONT_FILE_3 = "FontFile3";
    private static final String FONT_FILE_3_TYPE_1C = "Type1C";
    private static final String FONT_FILE_3_CID_FONT_TYPE_0 = "CIDFontType0";
    private static final String FONT_FILE_3_CID_FONT_TYPE_2 = "CIDFontType2";
    private static final String FONT_FILE_3_CID_FONT_TYPE_0C = "CIDFontType0C";
    private static final String FONT_FILE_3_OPEN_TYPE = "OpenType";

    public FontDescriptor(Library library, Hashtable hashtable) {
        super(library, hashtable);
    }

    public static FontDescriptor createDescriptor(Library library, AFM aFM) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(5);
        hashtable.put(FONT_NAME, aFM.getFontName());
        hashtable.put(FONT_FAMILY, aFM.getFamilyName());
        hashtable.put(FONT_BBOX, aFM.getFontBBox());
        hashtable.put(ITALIC_ANGLE, Float.valueOf(aFM.getItalicAngle()));
        hashtable.put(MAX_WIDTH, aFM.getMaxWidth());
        hashtable.put(AVG_WIDTH, aFM.getAvgWidth());
        hashtable.put(FLAGS, aFM.getFlags());
        return new FontDescriptor(library, hashtable);
    }

    public String getFontName() {
        Object object = this.library.getObject(this.entries, FONT_NAME);
        if (object instanceof Name) {
            return ((Name)object).getName();
        }
        return FONT_NAME;
    }

    public String getFontFamily() {
        Object object = this.library.getObject(this.entries, FONT_FAMILY);
        if (object instanceof StringObject) {
            StringObject stringObject = (StringObject)object;
            return stringObject.getDecryptedLiteralString(this.library.getSecurityManager());
        }
        return FONT_NAME;
    }

    public float getFontWeight() {
        Object object = this.library.getObject(this.entries, FONT_WEIGHT);
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        return 0.0f;
    }

    public float getMissingWidth() {
        Object object = this.library.getObject(this.entries, MISSING_WIDTH);
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        return 0.0f;
    }

    public float getAverageWidth() {
        Object object = this.library.getObject(this.entries, AVG_WIDTH);
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        return 0.0f;
    }

    public float getMaxWidth() {
        Object object = this.library.getObject(this.entries, MAX_WIDTH);
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        return 0.0f;
    }

    public float getAscent() {
        Object object = this.library.getObject(this.entries, ASCENT);
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        return 0.0f;
    }

    public float getDescent() {
        Object object = this.library.getObject(this.entries, DESCENT);
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        return 0.0f;
    }

    public FontFile getEmbeddedFont() {
        return this.font;
    }

    public PRectangle getFontBBox() {
        Object object = this.library.getObject(this.entries, FONT_BBOX);
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            return new PRectangle(vector);
        }
        return null;
    }

    public int getFlags() {
        Object object = this.library.getObject(this.entries, FLAGS);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return 0;
    }

    public void init() {
        try {
            Stream stream;
            FontFactory fontFactory = FontFactory.getInstance();
            if (this.entries.containsKey(FONT_FILE) && (stream = (Stream)this.library.getObject(this.entries, FONT_FILE)) != null) {
                this.font = fontFactory.createFontFile(stream, 1);
            }
            if (this.entries.containsKey(FONT_FILE_2) && (stream = (Stream)this.library.getObject(this.entries, FONT_FILE_2)) != null) {
                this.font = fontFactory.createFontFile(stream, 0);
            }
            if (this.entries.containsKey(FONT_FILE_3)) {
                stream = (Stream)this.library.getObject(this.entries, FONT_FILE_3);
                String string = stream.getObject("Subtype").toString();
                if (string != null && (string.equals(FONT_FILE_3_TYPE_1C) || string.equals(FONT_FILE_3_CID_FONT_TYPE_0) || string.equals(FONT_FILE_3_CID_FONT_TYPE_0C))) {
                    this.font = fontFactory.createFontFile(stream, 1);
                }
                if (string != null && string.equals(FONT_FILE_3_OPEN_TYPE)) {
                    this.font = fontFactory.createFontFile(stream, 5);
                }
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.FINE, "Error Reading Embedded Font ", throwable);
        }
    }

    public String toString() {
        String string = null;
        if (this.font != null) {
            string = this.font.getName();
        }
        return super.getPObjectReference() + " FONTDESCRIPTOR= " + this.entries.toString() + " - " + string;
    }
}

