/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.sprm;

import org.apache.poi.hwpf.sprm.SprmIterator;
import org.apache.poi.hwpf.sprm.SprmOperation;
import org.apache.poi.hwpf.usermodel.BorderCode;
import org.apache.poi.hwpf.usermodel.CharacterProperties;
import org.apache.poi.hwpf.usermodel.DateAndTime;
import org.apache.poi.hwpf.usermodel.ShadingDescriptor;
import org.apache.poi.util.LittleEndian;

public class CharacterSprmUncompressor {
    public static CharacterProperties uncompressCHP(CharacterProperties characterProperties, byte[] byArray, int n) {
        CharacterProperties characterProperties2 = null;
        try {
            characterProperties2 = (CharacterProperties)characterProperties.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("There is no way this exception should happen!!");
        }
        SprmIterator sprmIterator = new SprmIterator(byArray, n);
        while (sprmIterator.hasNext()) {
            SprmOperation sprmOperation = sprmIterator.next();
            CharacterSprmUncompressor.unCompressCHPOperation(characterProperties, characterProperties2, sprmOperation);
        }
        return characterProperties2;
    }

    static void unCompressCHPOperation(CharacterProperties characterProperties, CharacterProperties characterProperties2, SprmOperation sprmOperation) {
        switch (sprmOperation.getOperation()) {
            case 0: {
                characterProperties2.setFRMarkDel(CharacterSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 1: {
                characterProperties2.setFRMark(CharacterSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 2: {
                characterProperties2.setFFldVanish(CharacterSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 3: {
                characterProperties2.setFcPic(sprmOperation.getOperand());
                characterProperties2.setFSpec(true);
                break;
            }
            case 4: {
                characterProperties2.setIbstRMark((short)sprmOperation.getOperand());
                break;
            }
            case 5: {
                characterProperties2.setDttmRMark(new DateAndTime(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 6: {
                characterProperties2.setFData(CharacterSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                int n = sprmOperation.getOperand();
                short s = (short)(n & 0xFF);
                characterProperties2.setFChsDiff(CharacterSprmUncompressor.getFlag(s));
                characterProperties2.setChse((short)(n & 0xFFFF00));
                break;
            }
            case 9: {
                characterProperties2.setFSpec(true);
                characterProperties2.setFtcSym(LittleEndian.getShort(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                characterProperties2.setXchSym(LittleEndian.getShort(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset() + 2));
                break;
            }
            case 10: {
                characterProperties2.setFOle2(CharacterSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                characterProperties2.setIcoHighlight((byte)sprmOperation.getOperand());
                characterProperties2.setFHighlight(CharacterSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                characterProperties2.setFcObj(sprmOperation.getOperand());
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                break;
            }
            case 24: {
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                break;
            }
            case 35: {
                break;
            }
            case 36: {
                break;
            }
            case 37: {
                break;
            }
            case 38: {
                break;
            }
            case 39: {
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                break;
            }
            case 42: {
                break;
            }
            case 43: {
                break;
            }
            case 44: {
                break;
            }
            case 45: {
                break;
            }
            case 46: {
                break;
            }
            case 47: {
                break;
            }
            case 48: {
                characterProperties2.setIstd(sprmOperation.getOperand());
                break;
            }
            case 49: {
                break;
            }
            case 50: {
                characterProperties2.setFBold(false);
                characterProperties2.setFItalic(false);
                characterProperties2.setFOutline(false);
                characterProperties2.setFStrike(false);
                characterProperties2.setFShadow(false);
                characterProperties2.setFSmallCaps(false);
                characterProperties2.setFCaps(false);
                characterProperties2.setFVanish(false);
                characterProperties2.setKul((byte)0);
                characterProperties2.setIco((byte)0);
                break;
            }
            case 51: {
                try {
                    boolean bl = characterProperties2.isFSpec();
                    characterProperties2 = (CharacterProperties)characterProperties.clone();
                    characterProperties2.setFSpec(bl);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                return;
            }
            case 52: {
                break;
            }
            case 53: {
                characterProperties2.setFBold(CharacterSprmUncompressor.getCHPFlag((byte)sprmOperation.getOperand(), characterProperties.isFBold()));
                break;
            }
            case 54: {
                characterProperties2.setFItalic(CharacterSprmUncompressor.getCHPFlag((byte)sprmOperation.getOperand(), characterProperties.isFItalic()));
                break;
            }
            case 55: {
                characterProperties2.setFStrike(CharacterSprmUncompressor.getCHPFlag((byte)sprmOperation.getOperand(), characterProperties.isFStrike()));
                break;
            }
            case 56: {
                characterProperties2.setFOutline(CharacterSprmUncompressor.getCHPFlag((byte)sprmOperation.getOperand(), characterProperties.isFOutline()));
                break;
            }
            case 57: {
                characterProperties2.setFShadow(CharacterSprmUncompressor.getCHPFlag((byte)sprmOperation.getOperand(), characterProperties.isFShadow()));
                break;
            }
            case 58: {
                characterProperties2.setFSmallCaps(CharacterSprmUncompressor.getCHPFlag((byte)sprmOperation.getOperand(), characterProperties.isFSmallCaps()));
                break;
            }
            case 59: {
                characterProperties2.setFCaps(CharacterSprmUncompressor.getCHPFlag((byte)sprmOperation.getOperand(), characterProperties.isFCaps()));
                break;
            }
            case 60: {
                characterProperties2.setFVanish(CharacterSprmUncompressor.getCHPFlag((byte)sprmOperation.getOperand(), characterProperties.isFVanish()));
                break;
            }
            case 61: {
                characterProperties2.setFtcAscii((short)sprmOperation.getOperand());
                break;
            }
            case 62: {
                characterProperties2.setKul((byte)sprmOperation.getOperand());
                break;
            }
            case 63: {
                boolean bl;
                byte by;
                int n = sprmOperation.getOperand();
                int n2 = n & 0xFF;
                if (n2 != 0) {
                    characterProperties2.setHps(n2);
                }
                byte by2 = (byte)((n & 0xFF00) >>> 8);
                if ((by2 = (byte)(by2 >>> 1)) != 0) {
                    characterProperties2.setHps(Math.max(characterProperties2.getHps() + by2 * 2, 2));
                }
                if ((by = (byte)((n & 0xFF0000) >>> 16)) != 128) {
                    characterProperties2.setHpsPos(by);
                }
                boolean bl2 = bl = (n & 0x100) > 0;
                if (bl && by != 128 && by != 0 && characterProperties.getHpsPos() == 0) {
                    characterProperties2.setHps(Math.max(characterProperties2.getHps() + -2, 2));
                }
                if (!bl || by != 0 || characterProperties.getHpsPos() == 0) break;
                characterProperties2.setHps(Math.max(characterProperties2.getHps() + 2, 2));
                break;
            }
            case 64: {
                characterProperties2.setDxaSpace(sprmOperation.getOperand());
                break;
            }
            case 65: {
                characterProperties2.setLidDefault((short)sprmOperation.getOperand());
                break;
            }
            case 66: {
                characterProperties2.setIco((byte)sprmOperation.getOperand());
                break;
            }
            case 67: {
                characterProperties2.setHps(sprmOperation.getOperand());
                break;
            }
            case 68: {
                byte by = (byte)sprmOperation.getOperand();
                characterProperties2.setHps(Math.max(characterProperties2.getHps() + by * 2, 2));
                break;
            }
            case 69: {
                characterProperties2.setHpsPos((short)sprmOperation.getOperand());
                break;
            }
            case 70: {
                if (sprmOperation.getOperand() != 0) {
                    if (characterProperties.getHpsPos() != 0) break;
                    characterProperties2.setHps(Math.max(characterProperties2.getHps() + -2, 2));
                    break;
                }
                if (characterProperties.getHpsPos() == 0) break;
                characterProperties2.setHps(Math.max(characterProperties2.getHps() + 2, 2));
                break;
            }
            case 71: {
                break;
            }
            case 72: {
                characterProperties2.setIss((byte)sprmOperation.getOperand());
                break;
            }
            case 73: {
                characterProperties2.setHps(LittleEndian.getShort(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 74: {
                short s = LittleEndian.getShort(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset());
                characterProperties2.setHps(Math.max(characterProperties2.getHps() + s, 8));
                break;
            }
            case 75: {
                characterProperties2.setHpsKern(sprmOperation.getOperand());
                break;
            }
            case 76: {
                break;
            }
            case 77: {
                float f = (float)sprmOperation.getOperand() / 100.0f;
                int n = (int)(f * (float)characterProperties2.getHps());
                characterProperties2.setHps(characterProperties2.getHps() + n);
                break;
            }
            case 78: {
                characterProperties2.setYsr((byte)sprmOperation.getOperand());
                break;
            }
            case 79: {
                characterProperties2.setFtcAscii((short)sprmOperation.getOperand());
                break;
            }
            case 80: {
                characterProperties2.setFtcFE((short)sprmOperation.getOperand());
                break;
            }
            case 81: {
                characterProperties2.setFtcOther((short)sprmOperation.getOperand());
                break;
            }
            case 82: {
                break;
            }
            case 83: {
                characterProperties2.setFDStrike(CharacterSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 84: {
                characterProperties2.setFImprint(CharacterSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 85: {
                characterProperties2.setFSpec(CharacterSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 86: {
                characterProperties2.setFObj(CharacterSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 87: {
                byte[] byArray = sprmOperation.getGrpprl();
                int n = sprmOperation.getGrpprlOffset();
                characterProperties2.setFPropMark(byArray[n]);
                characterProperties2.setIbstPropRMark(LittleEndian.getShort(byArray, n + 1));
                characterProperties2.setDttmPropRMark(new DateAndTime(byArray, n + 3));
                break;
            }
            case 88: {
                characterProperties2.setFEmboss(CharacterSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 89: {
                characterProperties2.setSfxtText((byte)sprmOperation.getOperand());
                break;
            }
            case 90: {
                break;
            }
            case 91: {
                break;
            }
            case 92: {
                break;
            }
            case 93: {
                break;
            }
            case 94: {
                break;
            }
            case 95: {
                break;
            }
            case 96: {
                break;
            }
            case 97: {
                break;
            }
            case 98: {
                byte[] byArray = new byte[32];
                byte[] byArray2 = sprmOperation.getGrpprl();
                int n = sprmOperation.getGrpprlOffset();
                characterProperties2.setFDispFldRMark(byArray2[n]);
                characterProperties2.setIbstDispFldRMark(LittleEndian.getShort(byArray2, n + 1));
                characterProperties2.setDttmDispFldRMark(new DateAndTime(byArray2, n + 3));
                System.arraycopy(byArray2, n + 7, byArray, 0, 32);
                characterProperties2.setXstDispFldRMark(byArray);
                break;
            }
            case 99: {
                characterProperties2.setIbstRMarkDel((short)sprmOperation.getOperand());
                break;
            }
            case 100: {
                characterProperties2.setDttmRMarkDel(new DateAndTime(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 101: {
                characterProperties2.setBrc(new BorderCode(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 102: {
                characterProperties2.setShd(new ShadingDescriptor(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 103: {
                break;
            }
            case 104: {
                break;
            }
            case 105: {
                break;
            }
            case 106: {
                break;
            }
            case 107: {
                break;
            }
            case 108: {
                break;
            }
            case 109: {
                characterProperties2.setLidDefault((short)sprmOperation.getOperand());
                break;
            }
            case 110: {
                characterProperties2.setLidFE((short)sprmOperation.getOperand());
                break;
            }
            case 111: {
                characterProperties2.setIdctHint((byte)sprmOperation.getOperand());
            }
        }
    }

    public static boolean getFlag(int n) {
        return n != 0;
    }

    private static boolean getCHPFlag(byte by, boolean bl) {
        if (by == 0) {
            return false;
        }
        if (by == 1) {
            return true;
        }
        if ((by & 0x80) == 128) {
            return bl;
        }
        if ((by & 0x81) == 129) {
            return !bl;
        }
        return false;
    }
}

