/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.sprm;

import java.util.Arrays;
import org.apache.poi.util.LittleEndian;

public class SprmBuffer
implements Cloneable {
    byte[] _buf;
    int _offset;
    boolean _istd;

    public SprmBuffer(byte[] byArray, boolean bl) {
        this._offset = byArray.length;
        this._buf = byArray;
        this._istd = bl;
    }

    public SprmBuffer(byte[] byArray) {
        this(byArray, false);
    }

    public SprmBuffer() {
        this._buf = new byte[4];
        this._offset = 0;
    }

    public void addSprm(short s, byte by) {
        int n = 3;
        this.ensureCapacity(n);
        LittleEndian.putShort(this._buf, this._offset, s);
        this._offset += 2;
        this._buf[this._offset++] = by;
    }

    public void addSprm(short s, short s2) {
        int n = 4;
        this.ensureCapacity(n);
        LittleEndian.putShort(this._buf, this._offset, s);
        this._offset += 2;
        LittleEndian.putShort(this._buf, this._offset, s2);
        this._offset += 2;
    }

    public void addSprm(short s, int n) {
        int n2 = 6;
        this.ensureCapacity(n2);
        LittleEndian.putShort(this._buf, this._offset, s);
        this._offset += 2;
        LittleEndian.putInt(this._buf, this._offset, n);
        this._offset += 4;
    }

    public void addSprm(short s, byte[] byArray) {
        int n = 3 + byArray.length;
        this.ensureCapacity(n);
        LittleEndian.putShort(this._buf, this._offset, s);
        this._offset += 2;
        this._buf[this._offset++] = (byte)byArray.length;
        System.arraycopy(byArray, 0, this._buf, this._offset, byArray.length);
    }

    public byte[] toByteArray() {
        return this._buf;
    }

    public boolean equals(Object object) {
        SprmBuffer sprmBuffer = (SprmBuffer)object;
        return Arrays.equals(this._buf, sprmBuffer._buf);
    }

    public void append(byte[] byArray) {
        this.ensureCapacity(byArray.length);
        System.arraycopy(byArray, 0, this._buf, this._offset, byArray.length);
    }

    public Object clone() throws CloneNotSupportedException {
        SprmBuffer sprmBuffer = (SprmBuffer)super.clone();
        sprmBuffer._buf = new byte[this._buf.length];
        System.arraycopy(this._buf, 0, sprmBuffer._buf, 0, this._buf.length);
        return sprmBuffer;
    }

    private void ensureCapacity(int n) {
        if (this._offset + n >= this._buf.length) {
            byte[] byArray = new byte[this._offset + n + 6];
            System.arraycopy(this._buf, 0, byArray, 0, this._buf.length);
            this._buf = byArray;
        }
    }
}

