/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.poi.poifs.storage.BigBlock;
import org.apache.poi.poifs.storage.RawDataBlock;
import org.apache.poi.util.IOUtils;

public class DocumentBlock
extends BigBlock {
    private static final byte _default_value = -1;
    private byte[] _data;
    private int _bytes_read;

    public DocumentBlock(RawDataBlock rawDataBlock) throws IOException {
        this._data = rawDataBlock.getData();
        this._bytes_read = this._data.length;
    }

    public DocumentBlock(InputStream inputStream) throws IOException {
        this();
        int n = IOUtils.readFully(inputStream, this._data);
        this._bytes_read = n == -1 ? 0 : n;
    }

    private DocumentBlock() {
        this._data = new byte[512];
        Arrays.fill(this._data, (byte)-1);
    }

    public int size() {
        return this._bytes_read;
    }

    public boolean partiallyRead() {
        return this._bytes_read != 512;
    }

    public static byte getFillByte() {
        return -1;
    }

    public static DocumentBlock[] convert(byte[] byArray, int n) {
        DocumentBlock[] documentBlockArray = new DocumentBlock[(n + 512 - 1) / 512];
        int n2 = 0;
        for (int i = 0; i < documentBlockArray.length; ++i) {
            documentBlockArray[i] = new DocumentBlock();
            if (n2 < byArray.length) {
                int n3 = Math.min(512, byArray.length - n2);
                System.arraycopy(byArray, n2, documentBlockArray[i]._data, 0, n3);
                if (n3 != 512) {
                    Arrays.fill(documentBlockArray[i]._data, n3, 512, (byte)-1);
                }
            } else {
                Arrays.fill(documentBlockArray[i]._data, (byte)-1);
            }
            n2 += 512;
        }
        return documentBlockArray;
    }

    public static void read(DocumentBlock[] documentBlockArray, byte[] byArray, int n) {
        int n2 = n / 512;
        int n3 = n % 512;
        int n4 = (n + byArray.length - 1) / 512;
        if (n2 == n4) {
            System.arraycopy(documentBlockArray[n2]._data, n3, byArray, 0, byArray.length);
        } else {
            int n5 = 0;
            System.arraycopy(documentBlockArray[n2]._data, n3, byArray, n5, 512 - n3);
            n5 += 512 - n3;
            for (int i = n2 + 1; i < n4; ++i) {
                System.arraycopy(documentBlockArray[i]._data, 0, byArray, n5, 512);
                n5 += 512;
            }
            System.arraycopy(documentBlockArray[n4]._data, 0, byArray, n5, byArray.length - n5);
        }
    }

    void writeData(OutputStream outputStream) throws IOException {
        this.doWriteData(outputStream, this._data);
    }
}

