/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.util.FixedField;
import org.apache.poi.util.LittleEndian;

public class LongField
implements FixedField {
    private long _value;
    private final int _offset;

    public LongField(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Illegal offset: ".concat(String.valueOf(String.valueOf(n))));
        }
        this._offset = n;
    }

    public LongField(int n, long l) throws ArrayIndexOutOfBoundsException {
        this(n);
        this.set(l);
    }

    public LongField(int n, byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this(n);
        this.readFromBytes(byArray);
    }

    public LongField(int n, long l, byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this(n);
        this.set(l, byArray);
    }

    public long get() {
        return this._value;
    }

    public void set(long l) {
        this._value = l;
    }

    public void set(long l, byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this._value = l;
        this.writeToBytes(byArray);
    }

    public void readFromBytes(byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this._value = LittleEndian.getLong(byArray, this._offset);
    }

    public void readFromStream(InputStream inputStream) throws LittleEndian.BufferUnderrunException, IOException {
        this._value = LittleEndian.readLong(inputStream);
    }

    public void writeToBytes(byte[] byArray) throws ArrayIndexOutOfBoundsException {
        LittleEndian.putLong(byArray, this._offset, this._value);
    }

    public String toString() {
        return String.valueOf(this._value);
    }
}

