/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg;

import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import net.sourceforge.jffmpeg.JffmpegAudioFormat;
import net.sourceforge.jffmpeg.JffmpegVideoFormat;
import net.sourceforge.jffmpeg.ffmpegnative.NativeDecoder;

public class CodecManager {
    private ResourceBundle resources = ResourceBundle.getBundle("net.sourceforge.jffmpeg.Jffmpeg");
    private static final String JFFMPEG_RESOURCE = "net.sourceforge.jffmpeg.Jffmpeg";
    private static final String SUPPORTED_VIDEO_FORMATS = "SupportedVideoFormats";
    private static final String SUPPORTED_AUDIO_FORMATS = "SupportedAudioFormats";
    private static final String LIBRARY_NAME = "FFMpegNativeLibrary";
    private static final String SYS_LIBRARY_NAME = "net.sourceforge.jffmpeg.FFMpegNativeLibrary";
    private static volatile int isNativeLoaded = -1;

    public String getNativeLibraryName() {
        String string = null;
        try {
            string = System.getProperty(SYS_LIBRARY_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (string == null || string.length() == 0) {
                string = this.resources.getString(LIBRARY_NAME);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public VideoFormat[] getSupportedVideoFormats() {
        String string = this.resources.getString(SUPPORTED_VIDEO_FORMATS);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        VideoFormat[] videoFormatArray = new VideoFormat[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            videoFormatArray[n++] = new VideoFormat(stringTokenizer.nextToken());
        }
        return videoFormatArray;
    }

    public AudioFormat[] getSupportedAudioFormats() {
        String string = this.resources.getString(SUPPORTED_AUDIO_FORMATS);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        AudioFormat[] audioFormatArray = new AudioFormat[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            audioFormatArray[n++] = new AudioFormat(stringTokenizer.nextToken());
        }
        return audioFormatArray;
    }

    public JffmpegVideoFormat getVideoCodec(String string) {
        return new JffmpegVideoFormat(string, this.resources);
    }

    public JffmpegAudioFormat getAudioCodec(String string) {
        return new JffmpegAudioFormat(string, this.resources);
    }

    public static synchronized boolean isNativeAvailable() {
        if (isNativeLoaded == -1) {
            try {
                NativeDecoder nativeDecoder = new NativeDecoder();
                isNativeLoaded = nativeDecoder.isCodecAvailable() ? 1 : 0;
            }
            catch (Throwable throwable) {
                isNativeLoaded = 0;
            }
        }
        return isNativeLoaded > 0;
    }
}

