/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.audio.vorbis.residue;

import net.sourceforge.jffmpeg.codecs.audio.vorbis.CodeBook;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.OggReader;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.VorbisDecoder;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.residue.Residue;

public class Residue0
extends Residue {
    protected int begin;
    protected int end;
    protected int grouping;
    protected int partitions;
    protected int groupbook;
    protected int[] secondstages;
    protected int[] booklist = new int[256];
    protected int partvals;
    protected int stages;
    protected long[][] decodemap;
    protected CodeBook[][] partbooks;
    protected CodeBook phrasebook;

    private static int icount(int n) {
        int n2 = 0;
        while (n > 0) {
            n2 += n & 1;
            n >>= 1;
        }
        return n2;
    }

    public void unpack(OggReader oggReader) {
        int n;
        this.begin = (int)oggReader.getBits(24);
        this.end = (int)oggReader.getBits(24);
        this.grouping = (int)oggReader.getBits(24) + 1;
        this.partitions = (int)oggReader.getBits(6) + 1;
        this.groupbook = (int)oggReader.getBits(8);
        this.secondstages = new int[this.partitions];
        int n2 = 0;
        for (n = 0; n < this.partitions; ++n) {
            int n3 = (int)oggReader.getBits(3);
            if (oggReader.getBits(1) == 1L) {
                n3 |= (int)oggReader.getBits(5) << 3;
            }
            this.secondstages[n] = n3;
            n2 += Residue0.icount(n3);
        }
        for (n = 0; n < n2; ++n) {
            this.booklist[n] = (int)oggReader.getBits(8);
        }
    }

    public void look(VorbisDecoder vorbisDecoder) {
        int n;
        int n2 = this.partitions;
        this.partbooks = new CodeBook[n2][];
        this.phrasebook = vorbisDecoder.getCodeBook(this.groupbook);
        int n3 = this.phrasebook.getDim();
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < n2; ++n) {
            int n6 = Residue0.ilog(this.secondstages[n]);
            if (n6 == 0) continue;
            if (n6 > n4) {
                n4 = n6;
            }
            this.partbooks[n] = new CodeBook[n6];
            for (int i = 0; i < n6; ++i) {
                if ((this.secondstages[n] & 1 << i) == 0) continue;
                this.partbooks[n][i] = vorbisDecoder.getCodeBook(this.booklist[n5++]);
            }
        }
        this.partvals = (int)Math.rint(Math.pow(n2, n3));
        this.decodemap = new long[this.partvals][n3];
        this.stages = n4;
        for (n = 0; n < this.partvals; ++n) {
            long l = n;
            long l2 = this.partvals / n2;
            for (int i = 0; i < n3; ++i) {
                long l3 = l / l2;
                l -= l3 * l2;
                l2 /= (long)n2;
                this.decodemap[n][i] = l3;
            }
        }
    }

    private static final int ilog(int n) {
        int n2 = 0;
        while (n > 0) {
            ++n2;
            n >>= 1;
        }
        return n2;
    }

    public void inverse(OggReader oggReader, float[][] fArray, int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == 0) continue;
            fArray[n2++] = fArray[i];
        }
        if (n2 > 0) {
            this._01inverse(oggReader, fArray, n2);
        }
    }

    protected void _01inverse(OggReader oggReader, float[][] fArray, int n) {
        int n2 = this.grouping;
        int n3 = this.phrasebook.getDim();
        int n4 = this.end - this.begin;
        int n5 = n4 / n2;
        int n6 = (n5 + n3 - 1) / n3;
        long[][][] lArray = new long[n][n6][];
        for (int i = 0; i < this.stages; ++i) {
            int n7 = 0;
            int n8 = 0;
            while (n7 < n5) {
                int n9;
                int n10;
                if (i == 0) {
                    for (n10 = 0; n10 < n; ++n10) {
                        n9 = this.phrasebook.decode(oggReader);
                        lArray[n10][n8] = this.decodemap[n9];
                    }
                }
                for (n10 = 0; n10 < n3 && n7 < n5; ++n10, ++n7) {
                    for (n9 = 0; n9 < n; ++n9) {
                        CodeBook codeBook;
                        long l = this.begin + n7 * n2;
                        int n11 = (int)lArray[n9][n8][n10];
                        if ((this.secondstages[n11] & 1 << i) == 0 || (codeBook = this.partbooks[n11][i]) == null) continue;
                        this.decodepart(oggReader, codeBook, fArray[n9], (int)l, n2);
                    }
                }
                ++n8;
            }
        }
    }

    protected void decodepart(OggReader oggReader, CodeBook codeBook, float[] fArray, int n, int n2) {
        codeBook.decodevs_add(fArray, n, oggReader, n2);
    }
}

