/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.video.mpeg4.div3;

import net.sourceforge.jffmpeg.codecs.utils.BitStream;
import net.sourceforge.jffmpeg.codecs.utils.FFMpegException;
import net.sourceforge.jffmpeg.codecs.video.mpeg.DisplayOutput;

public abstract class Mpeg4 {
    public static final int I_FRAME_TYPE = 1;
    public static final int P_FRAME_TYPE = 2;
    public static final int B_FRAME_TYPE = 3;
    protected BitStream in = new BitStream();
    protected boolean truncatedFlag;
    protected int pictType;
    protected int qscale;
    protected int sliceHeight;
    protected int bitRate;
    protected boolean flipFlopRounding;
    protected boolean perMbRlTable;
    protected int rlChromaTableIndex;
    protected int rlTableIndex;
    protected int dcTableIndex;
    protected boolean interIntraPred;
    protected boolean ac_Pred;
    protected int h263_aic_dir;
    protected boolean inter_intra_pred;
    protected int mbWidth;
    protected int mbHeight;
    protected int[] blankBlock = new int[64];
    public static final int NUMBER_OF_BLOCKS = 6;
    protected int[] blockIndex = new int[6];
    protected int[] blockWrap = new int[6];
    protected int[][] block = new int[6][64];
    protected boolean[] skipBlock = new boolean[6];
    protected int[] yDcScaleTable;
    protected int[] cDcScaleTable;
    protected int y_dc_scale = 8;
    protected int c_dc_scale = 8;
    protected int[] dc_val;
    protected int[] ac_val;
    protected int[][] motion_val;
    protected int pel_motionX;
    protected int pel_motionY;
    protected int resync_mb_x;
    protected boolean use_skip_mb_code;
    protected boolean[][] skipTable;
    protected boolean mb_skipped;
    protected int mv_table_index;
    protected boolean mb_intra;
    protected int[] coded_block;
    protected boolean h263_pred = true;
    protected boolean h263_aic;
    protected int[] mbintra_table;
    protected boolean dc_pred_dir;
    protected boolean ac_pred;
    protected boolean no_rounding = true;
    protected DisplayOutput displayOutput;

    protected abstract void decodeFrame(byte[] var1, int var2) throws FFMpegException;

    protected void dct_unquantize_h263(int n) {
        int n2 = 0;
        if (this.mb_intra) {
            int[] nArray = this.block[n];
            nArray[0] = nArray[0] * (n < 4 ? this.y_dc_scale : this.c_dc_scale);
            n2 = 1;
        }
        int n3 = this.qscale << 1;
        int n4 = this.qscale - 1 | 1;
        while (n2 < 64) {
            if (this.block[n][n2] > 0) {
                this.block[n][n2] = this.block[n][n2] * n3 + n4;
            } else if (this.block[n][n2] < 0) {
                this.block[n][n2] = this.block[n][n2] * n3 - n4;
            }
            ++n2;
        }
    }

    protected void MPV_decode_mb(int n, int n2) {
        int n3;
        int n4;
        if (!this.mb_intra) {
            if ((this.h263_pred || this.h263_aic) && this.mbintra_table[n2 * this.mbWidth + n] != 0) {
                this.mbintra_table[n2 * this.mbWidth + n] = 0;
                n4 = this.blockIndex[0];
                n3 = this.blockWrap[0];
                this.dc_val[n4] = 1024;
                this.dc_val[n4 + 1] = 1024;
                this.dc_val[n4 + n3] = 1024;
                this.dc_val[n4 + 1 + n3] = 1024;
                System.arraycopy(this.blankBlock, 0, this.ac_val, n4 * 16, 32);
                System.arraycopy(this.blankBlock, 0, this.ac_val, (n4 + n3) * 16, 32);
                n3 = this.blockWrap[4];
                n4 = this.blockWrap[0] * (this.mbHeight * 2 + 2) + n + 1 + (n2 + 1) * n3;
                this.dc_val[n4] = 1024;
                this.dc_val[n4 + n3 * (this.mbHeight + 2)] = 1024;
                System.arraycopy(this.blankBlock, 0, this.ac_val, n4 * 16, 16);
                System.arraycopy(this.blankBlock, 0, this.ac_val, (n4 + n3 * (this.mbHeight + 2)) * 16, 16);
            }
            if (!this.mb_skipped || !this.skipTable[n][n2]) {
                this.skipTable[n][n2] = this.mb_skipped;
                this.displayOutput.move(n, n2, this.pel_motionX, this.pel_motionY, !this.no_rounding);
                this.displayOutput.addLuminanceIdct(n * 2, n2 * 2, this.block[0]);
                this.displayOutput.addLuminanceIdct(n * 2 + 1, n2 * 2, this.block[1]);
                this.displayOutput.addLuminanceIdct(n * 2, n2 * 2 + 1, this.block[2]);
                this.displayOutput.addLuminanceIdct(n * 2 + 1, n2 * 2 + 1, this.block[3]);
                this.displayOutput.addRedIdct(n, n2, this.block[5]);
                this.displayOutput.addBlueIdct(n, n2, this.block[4]);
            }
        } else {
            this.skipTable[n][n2] = false;
            if (this.h263_pred || this.h263_aic) {
                this.mbintra_table[n2 * this.mbWidth + n] = 1;
            }
            this.pel_motionX = 0;
            this.pel_motionY = 0;
            n4 = n;
            n3 = n2;
            this.dct_unquantize_h263(0);
            this.dct_unquantize_h263(1);
            this.dct_unquantize_h263(2);
            this.dct_unquantize_h263(3);
            this.dct_unquantize_h263(4);
            this.dct_unquantize_h263(5);
            this.displayOutput.putLuminanceIdct(n * 2, n2 * 2, this.block[0]);
            this.displayOutput.putLuminanceIdct(n * 2 + 1, n2 * 2, this.block[1]);
            this.displayOutput.putLuminanceIdct(n * 2, n2 * 2 + 1, this.block[2]);
            this.displayOutput.putLuminanceIdct(n * 2 + 1, n2 * 2 + 1, this.block[3]);
            this.displayOutput.putRedIdct(n, n2, this.block[5]);
            this.displayOutput.putBlueIdct(n, n2, this.block[4]);
        }
        for (n4 = 0; n4 < 4; ++n4) {
            this.motion_val[this.blockIndex[n4]][0] = this.pel_motionX;
            this.motion_val[this.blockIndex[n4]][1] = this.pel_motionY;
        }
        System.arraycopy(this.blankBlock, 0, this.block[0], 0, 64);
        System.arraycopy(this.blankBlock, 0, this.block[1], 0, 64);
        System.arraycopy(this.blankBlock, 0, this.block[2], 0, 64);
        System.arraycopy(this.blankBlock, 0, this.block[3], 0, 64);
        System.arraycopy(this.blankBlock, 0, this.block[4], 0, 64);
        System.arraycopy(this.blankBlock, 0, this.block[5], 0, 64);
    }

    protected Mpeg4() {
    }

    protected void initialise(int n, int n2) {
        int n3;
        this.mbWidth = (n + 15) / 16;
        this.mbHeight = (n2 + 15) / 16;
        this.blockWrap[0] = this.mbWidth * 2 + 2;
        this.blockWrap[1] = this.mbWidth * 2 + 2;
        this.blockWrap[2] = this.mbWidth * 2 + 2;
        this.blockWrap[3] = this.mbWidth * 2 + 2;
        this.blockWrap[4] = this.mbWidth + 2;
        this.blockWrap[5] = this.mbWidth + 2;
        this.dc_val = new int[1 + (this.mbWidth * 2 + 2) * this.mbHeight * 2 * 4];
        this.ac_val = new int[1 + (this.mbWidth * 2 + 2) * this.mbHeight * 16 * 4 * 16];
        this.motion_val = new int[1 + (this.mbWidth * 2 + 2) * this.mbHeight * 2 * 4][2];
        this.skipTable = new boolean[this.mbWidth][this.mbHeight];
        for (n3 = 0; n3 < this.dc_val.length; ++n3) {
            this.dc_val[n3] = 1024;
            this.ac_val[n3] = 0;
        }
        this.coded_block = new int[1 + (this.mbWidth * 2 + 2) * this.mbHeight * 16 * 4];
        this.mbintra_table = new int[1 + (this.mbWidth * 2 + 2) * this.mbHeight * 2 * 4];
        for (n3 = 0; n3 < this.mbintra_table.length; ++n3) {
            this.mbintra_table[n3] = 1;
        }
        this.displayOutput = new DisplayOutput(this.mbWidth, this.mbHeight);
    }
}

