/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints.amf;

import flex.messaging.FlexContext;
import flex.messaging.MessageException;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.io.MessageDeserializer;
import flex.messaging.io.MessageSerializer;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationException;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.MessagePerformanceInfo;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.List;
import javax.servlet.ServletInputStream;

public class SerializationFilter
extends AMFFilter {
    private static final int UNHANDLED_ERROR = 10306;
    private static final int REQUEST_ERROR = 10307;
    private static final int RESPONSE_ERROR = 10308;
    private boolean isDebug = Log.isDebug();
    private Logger logger;

    public SerializationFilter(String logCategory) {
        if (logCategory == null) {
            logCategory = "Endpoint.General";
        }
        this.logger = Log.getLogger((String)logCategory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(ActionContext context) throws IOException {
        ActionMessage respMesg2;
        ByteArrayOutputStream outBuffer2;
        SerializationContext sc;
        AmfTrace debugTrace;
        block46: {
            block45: {
                boolean success = false;
                debugTrace = this.isDebug ? new AmfTrace() : null;
                context.setResponseMessage(new ActionMessage());
                sc = SerializationContext.getSerializationContext();
                try {
                    MessageDeserializer deserializer = sc.newMessageDeserializer();
                    ServletInputStream in = FlexContext.getHttpRequest().getInputStream();
                    deserializer.initialize(sc, (InputStream)in, debugTrace);
                    int reqLen = FlexContext.getHttpRequest().getContentLength();
                    context.setDeserializedBytes(reqLen);
                    if (context.isMPIenabled()) {
                        MessagePerformanceInfo mpi = new MessagePerformanceInfo();
                        mpi.recordMessageSizes = context.isRecordMessageSizes();
                        mpi.recordMessageTimes = context.isRecordMessageTimes();
                        if (context.isRecordMessageTimes()) {
                            mpi.receiveTime = System.currentTimeMillis();
                        }
                        if (context.isRecordMessageSizes()) {
                            mpi.messageSize = reqLen;
                        }
                        context.setMPII(mpi);
                    }
                    ActionMessage m = new ActionMessage();
                    context.setRequestMessage(m);
                    deserializer.readMessage(m, context);
                    success = true;
                }
                catch (EOFException eof) {
                    context.setStatus(2);
                }
                catch (IOException exc) {
                    if (!this.isDebug) throw exc;
                    this.logger.debug("IOException reading message - client closed socket before sending the message?");
                    throw exc;
                }
                catch (Throwable t) {
                    this.deserializationError(context, t);
                }
                finally {
                    ActionMessage respMsg = context.getResponseMessage();
                    respMsg.setVersion(context.getVersion());
                    if (this.isDebug) {
                        this.logger.debug(debugTrace.toString());
                    }
                }
                if (!success) break block45;
                this.next.invoke(context);
            }
            Object var12_15 = null;
            if (context.getStatus() == 2) return;
            outBuffer2 = new ByteArrayOutputStream();
            respMesg2 = context.getResponseMessage();
            if (!this.isDebug) break block46;
            debugTrace = new AmfTrace();
        }
        try {
            block47: {
                long serializationOverhead = 0L;
                if (context.isRecordMessageTimes()) {
                    context.getMPIO().sendTime = System.currentTimeMillis();
                    if (context.isRecordMessageSizes()) {
                        serializationOverhead = System.currentTimeMillis();
                    }
                }
                MessageSerializer serializer = sc.newMessageSerializer();
                serializer.initialize(sc, outBuffer2, debugTrace);
                serializer.writeMessage(respMesg2);
                context.setSerializedBytes(outBuffer2.size());
                if (context.isRecordMessageSizes()) {
                    try {
                        context.getMPIO().messageSize = outBuffer2.size();
                        if (context.isRecordMessageTimes()) {
                            serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                            context.getMPIO().addToOverhead(serializationOverhead);
                            context.getMPIO().sendTime = System.currentTimeMillis();
                        }
                        outBuffer2 = new ByteArrayOutputStream();
                        respMesg2 = context.getResponseMessage();
                        serializer = sc.newMessageSerializer();
                        serializer.initialize(sc, outBuffer2, debugTrace);
                        serializer.writeMessage(respMesg2);
                    }
                    catch (Exception e) {
                        if (!this.isDebug) break block47;
                        this.logger.debug("MPI set up error: " + e.toString());
                    }
                }
            }
            context.setResponseOutput(outBuffer2);
            return;
        }
        catch (Exception e) {
            this.serializationError(context, e);
            return;
        }
        finally {
            if (this.isDebug) {
                this.logger.debug(debugTrace.toString());
            }
        }
        {
            catch (Throwable t) {
                this.unhandledError(context, t);
                Object var12_16 = null;
                if (context.getStatus() == 2) return;
                ByteArrayOutputStream outBuffer2 = new ByteArrayOutputStream();
                ActionMessage respMesg2 = context.getResponseMessage();
                if (this.isDebug) {
                    debugTrace = new AmfTrace();
                }
                try {
                    block48: {
                        long serializationOverhead = 0L;
                        if (context.isRecordMessageTimes()) {
                            context.getMPIO().sendTime = System.currentTimeMillis();
                            if (context.isRecordMessageSizes()) {
                                serializationOverhead = System.currentTimeMillis();
                            }
                        }
                        MessageSerializer serializer = sc.newMessageSerializer();
                        serializer.initialize(sc, outBuffer2, debugTrace);
                        serializer.writeMessage(respMesg2);
                        context.setSerializedBytes(outBuffer2.size());
                        if (context.isRecordMessageSizes()) {
                            try {
                                context.getMPIO().messageSize = outBuffer2.size();
                                if (context.isRecordMessageTimes()) {
                                    serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                                    context.getMPIO().addToOverhead(serializationOverhead);
                                    context.getMPIO().sendTime = System.currentTimeMillis();
                                }
                                outBuffer2 = new ByteArrayOutputStream();
                                respMesg2 = context.getResponseMessage();
                                serializer = sc.newMessageSerializer();
                                serializer.initialize(sc, outBuffer2, debugTrace);
                                serializer.writeMessage(respMesg2);
                            }
                            catch (Exception e) {
                                if (!this.isDebug) break block48;
                                this.logger.debug("MPI set up error: " + e.toString());
                            }
                        }
                    }
                    context.setResponseOutput(outBuffer2);
                    if (!this.isDebug) return;
                }
                catch (Exception e) {
                    try {}
                    catch (Throwable throwable) {
                        if (!this.isDebug) throw throwable;
                        this.logger.debug(debugTrace.toString());
                        throw throwable;
                    }
                    this.serializationError(context, e);
                    if (!this.isDebug) return;
                    this.logger.debug(debugTrace.toString());
                    return;
                }
                this.logger.debug(debugTrace.toString());
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (context.getStatus() == 2) throw throwable;
            ByteArrayOutputStream outBuffer2 = new ByteArrayOutputStream();
            ActionMessage respMesg2 = context.getResponseMessage();
            if (this.isDebug) {
                debugTrace = new AmfTrace();
            }
            try {
                block49: {
                    long serializationOverhead = 0L;
                    if (context.isRecordMessageTimes()) {
                        context.getMPIO().sendTime = System.currentTimeMillis();
                        if (context.isRecordMessageSizes()) {
                            serializationOverhead = System.currentTimeMillis();
                        }
                    }
                    MessageSerializer serializer = sc.newMessageSerializer();
                    serializer.initialize(sc, outBuffer2, debugTrace);
                    serializer.writeMessage(respMesg2);
                    context.setSerializedBytes(outBuffer2.size());
                    if (context.isRecordMessageSizes()) {
                        try {
                            context.getMPIO().messageSize = outBuffer2.size();
                            if (context.isRecordMessageTimes()) {
                                serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                                context.getMPIO().addToOverhead(serializationOverhead);
                                context.getMPIO().sendTime = System.currentTimeMillis();
                            }
                            outBuffer2 = new ByteArrayOutputStream();
                            respMesg2 = context.getResponseMessage();
                            serializer = sc.newMessageSerializer();
                            serializer.initialize(sc, outBuffer2, debugTrace);
                            serializer.writeMessage(respMesg2);
                        }
                        catch (Exception e) {
                            if (!this.isDebug) break block49;
                            this.logger.debug("MPI set up error: " + e.toString());
                        }
                    }
                }
                context.setResponseOutput(outBuffer2);
                if (!this.isDebug) throw throwable;
            }
            catch (Exception e) {
                try {}
                catch (Throwable throwable2) {
                    if (!this.isDebug) throw throwable2;
                    this.logger.debug(debugTrace.toString());
                    throw throwable2;
                }
                this.serializationError(context, e);
                if (!this.isDebug) throw throwable;
                this.logger.debug(debugTrace.toString());
                throw throwable;
            }
            this.logger.debug(debugTrace.toString());
            throw throwable;
        }
    }

    private void deserializationError(ActionContext context, Throwable t) {
        String message;
        MessageException methodResult;
        context.setStatus(1);
        MessageBody responseBody = new MessageBody();
        if (context.getMessageNumber() < context.getRequestMessage().getBodyCount()) {
            responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
        }
        if (context.getVersion() == 0) {
            context.setVersion(3);
        }
        context.getResponseMessage().addBody(responseBody);
        if (t instanceof MessageException) {
            methodResult = (MessageException)((Object)t);
            message = methodResult.getMessage();
        } else {
            methodResult = new SerializationException();
            methodResult.setMessage(10307);
            methodResult.setRootCause(t);
            message = methodResult.getMessage();
        }
        responseBody.setData(methodResult.createErrorMessage());
        responseBody.setReplyMethod("/onStatus");
        if (Log.isError()) {
            this.logger.error(message + StringUtils.NEWLINE + ExceptionUtil.toString((Throwable)t));
        }
    }

    private void unhandledError(ActionContext context, Throwable t) {
        MessageException methodResult;
        ActionMessage responseMessage = new ActionMessage();
        context.setResponseMessage(responseMessage);
        MessageBody responseBody = new MessageBody();
        responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
        context.getResponseMessage().addBody(responseBody);
        if (t instanceof MessageException) {
            methodResult = (MessageException)((Object)t);
        } else {
            methodResult = new SerializationException();
            methodResult.setMessage(10306);
            methodResult.setRootCause(t);
        }
        responseBody.setData((Object)methodResult);
        responseBody.setReplyMethod("/onStatus");
        this.logger.info(t.getMessage());
    }

    private void serializationError(ActionContext context, Throwable t) {
        ActionMessage responseMessage = new ActionMessage();
        context.setResponseMessage(responseMessage);
        int bodyCount = context.getRequestMessage().getBodyCount();
        context.setMessageNumber(0);
        while (context.getMessageNumber() < bodyCount) {
            Object methodResult;
            MessageBody responseBody = new MessageBody();
            responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
            context.getResponseMessage().addBody(responseBody);
            if (t instanceof MessageException) {
                methodResult = ((MessageException)((Object)t)).createErrorMessage();
            } else {
                String message = "An error occurred while serializing server response(s).";
                if (t.getMessage() != null && (message = t.getMessage()) == null) {
                    message = t.toString();
                }
                methodResult = new MessageException(message, t).createErrorMessage();
            }
            if (context.isLegacy()) {
                if (methodResult instanceof ErrorMessage) {
                    ErrorMessage error = methodResult;
                    ASObject aso = new ASObject();
                    aso.put("message", error.faultString);
                    aso.put("code", error.faultCode);
                    aso.put("details", error.faultDetail);
                    aso.put("rootCause", error.rootCause);
                    methodResult = aso;
                } else if (methodResult instanceof Message) {
                    methodResult = ((Message)methodResult).getBody();
                }
            } else {
                Object data = context.getRequestMessageBody().getData();
                if (data instanceof List) {
                    data = ((List)data).get(0);
                } else if (data.getClass().isArray()) {
                    data = Array.get(data, 0);
                }
                if (data instanceof Message) {
                    Message inMessage = (Message)data;
                    if (inMessage.getClientId() != null) {
                        ((ErrorMessage)methodResult).setClientId(inMessage.getClientId().toString());
                    }
                    if (inMessage.getMessageId() != null) {
                        ((ErrorMessage)methodResult).setCorrelationId(inMessage.getMessageId());
                        ((ErrorMessage)methodResult).setDestination(inMessage.getDestination());
                    }
                }
            }
            responseBody.setData(methodResult);
            responseBody.setReplyMethod("/onStatus");
            context.incrementMessageNumber();
        }
        if (Log.isError()) {
            this.logger.error("Exception occurred during serialization: " + ExceptionUtil.toString((Throwable)t));
        }
        SerializationContext sc = SerializationContext.getSerializationContext();
        MessageSerializer serializer = sc.newMessageSerializer();
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        AmfTrace debugTrace = this.isDebug ? new AmfTrace() : null;
        serializer.initialize(sc, outBuffer, debugTrace);
        try {
            serializer.writeMessage(context.getResponseMessage());
            context.setResponseOutput(outBuffer);
        }
        catch (IOException e) {
            MessageException ex = new MessageException();
            ex.setMessage(10308);
            ex.setRootCause(e);
            throw ex;
        }
    }
}

