/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.KeyStore;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.net.SecureNioChannel;
import org.apache.tomcat.util.net.SocketProperties;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.jsse.NioX509KeyManager;
import org.apache.tomcat.util.res.StringManager;

public class NioEndpoint {
    protected static Log log = LogFactory.getLog(NioEndpoint.class);
    protected static StringManager sm = StringManager.getManager("org.apache.tomcat.util.net.res");
    public static final String CIPHER_SUITE_KEY = "javax.servlet.request.cipher_suite";
    public static final String KEY_SIZE_KEY = "javax.servlet.request.key_size";
    public static final String CERTIFICATE_KEY = "javax.servlet.request.X509Certificate";
    public static final String SESSION_ID_KEY = "javax.servlet.request.ssl_session";
    public static final int OP_REGISTER = 256;
    public static final int OP_CALLBACK = 512;
    protected WorkerStack workers = null;
    protected volatile boolean running = false;
    protected volatile boolean paused = false;
    protected boolean initialized = false;
    protected int curThreadsBusy = 0;
    protected int curThreads = 0;
    protected int sequence = 0;
    protected NioSelectorPool selectorPool = new NioSelectorPool();
    protected ServerSocketChannel serverSock = null;
    protected boolean useSendfile = true;
    protected int oomParachute = 0x100000;
    protected byte[] oomParachuteData = null;
    protected static final String oomParachuteMsg = "SEVERE:Memory usage is low, parachute is non existent, your system may start failing.";
    long lastParachuteCheck = System.currentTimeMillis();
    protected AtomicInteger activeSocketProcessors = new AtomicInteger(0);
    protected volatile CountDownLatch stopLatch = null;
    protected ConcurrentLinkedQueue<SocketProcessor> processorCache = new ConcurrentLinkedQueue<SocketProcessor>(){
        protected AtomicInteger size = new AtomicInteger(0);

        @Override
        public boolean offer(SocketProcessor sc) {
            boolean offer;
            sc.reset(null, null);
            boolean bl = NioEndpoint.this.socketProperties.getProcessorCache() == -1 ? true : (offer = this.size.get() < NioEndpoint.this.socketProperties.getProcessorCache());
            if (NioEndpoint.this.running && !NioEndpoint.this.paused && offer) {
                boolean result = super.offer(sc);
                if (result) {
                    this.size.incrementAndGet();
                }
                return result;
            }
            return false;
        }

        @Override
        public SocketProcessor poll() {
            SocketProcessor result = (SocketProcessor)super.poll();
            if (result != null) {
                this.size.decrementAndGet();
            }
            return result;
        }

        @Override
        public void clear() {
            super.clear();
            this.size.set(0);
        }
    };
    protected ConcurrentLinkedQueue<KeyAttachment> keyCache = new ConcurrentLinkedQueue<KeyAttachment>(){
        protected AtomicInteger size = new AtomicInteger(0);

        @Override
        public boolean offer(KeyAttachment ka) {
            boolean offer;
            ka.reset();
            boolean bl = NioEndpoint.this.socketProperties.getKeyCache() == -1 ? true : (offer = this.size.get() < NioEndpoint.this.socketProperties.getKeyCache());
            if (NioEndpoint.this.running && !NioEndpoint.this.paused && offer) {
                boolean result = super.offer(ka);
                if (result) {
                    this.size.incrementAndGet();
                }
                return result;
            }
            return false;
        }

        @Override
        public KeyAttachment poll() {
            KeyAttachment result = (KeyAttachment)super.poll();
            if (result != null) {
                this.size.decrementAndGet();
            }
            return result;
        }

        @Override
        public void clear() {
            super.clear();
            this.size.set(0);
        }
    };
    protected ConcurrentLinkedQueue<PollerEvent> eventCache = new ConcurrentLinkedQueue<PollerEvent>(){
        protected AtomicInteger size = new AtomicInteger(0);

        @Override
        public boolean offer(PollerEvent pe) {
            boolean offer;
            pe.reset();
            boolean bl = NioEndpoint.this.socketProperties.getEventCache() == -1 ? true : (offer = this.size.get() < NioEndpoint.this.socketProperties.getEventCache());
            if (NioEndpoint.this.running && !NioEndpoint.this.paused && offer) {
                boolean result = super.offer(pe);
                if (result) {
                    this.size.incrementAndGet();
                }
                return result;
            }
            return false;
        }

        @Override
        public PollerEvent poll() {
            PollerEvent result = (PollerEvent)super.poll();
            if (result != null) {
                this.size.decrementAndGet();
            }
            return result;
        }

        @Override
        public void clear() {
            super.clear();
            this.size.set(0);
        }
    };
    protected ConcurrentLinkedQueue<NioChannel> nioChannels = new ConcurrentLinkedQueue<NioChannel>(){
        protected AtomicInteger size = new AtomicInteger(0);
        protected AtomicInteger bytes = new AtomicInteger(0);

        @Override
        public boolean offer(NioChannel socket) {
            boolean offer = NioEndpoint.this.socketProperties.getBufferPool() == -1 ? true : this.size.get() < NioEndpoint.this.socketProperties.getBufferPool();
            boolean bl = offer = offer && (NioEndpoint.this.socketProperties.getBufferPoolSize() == -1 || this.bytes.get() + socket.getBufferSize() < NioEndpoint.this.socketProperties.getBufferPoolSize());
            if (NioEndpoint.this.running && !NioEndpoint.this.paused && offer) {
                boolean result = super.offer(socket);
                if (result) {
                    this.size.incrementAndGet();
                    this.bytes.addAndGet(socket.getBufferSize());
                }
                return result;
            }
            return false;
        }

        @Override
        public NioChannel poll() {
            NioChannel result = (NioChannel)super.poll();
            if (result != null) {
                this.size.decrementAndGet();
                this.bytes.addAndGet(-result.getBufferSize());
            }
            return result;
        }

        @Override
        public void clear() {
            super.clear();
            this.size.set(0);
            this.bytes.set(0);
        }
    };
    protected Executor executor = null;
    protected boolean useExecutor = true;
    protected int maxThreads = 200;
    protected int threadPriority = 5;
    protected int acceptorThreadPriority = 5;
    protected int pollerThreadPriority = 5;
    protected int port;
    protected InetAddress address;
    protected Handler handler = null;
    protected int backlog = 100;
    protected SocketProperties socketProperties = new SocketProperties();
    protected boolean daemon = true;
    protected String name = "TP";
    protected boolean useComet = true;
    protected int acceptorThreadCount = 1;
    protected int pollerThreadCount = Runtime.getRuntime().availableProcessors();
    protected long selectorTimeout = 1000L;
    protected Poller[] pollers = null;
    protected AtomicInteger pollerRotater = new AtomicInteger(0);
    protected String truststoreFile = System.getProperty("javax.net.ssl.trustStore");
    protected String truststorePass = System.getProperty("javax.net.ssl.trustStorePassword");
    protected String truststoreType = System.getProperty("javax.net.ssl.trustStoreType");
    protected String keystoreFile = System.getProperty("user.home") + "/.keystore";
    String keyAlias = null;
    protected String algorithm = KeyManagerFactory.getDefaultAlgorithm();
    protected String clientAuth = "false";
    protected String keystorePass = "changeit";
    protected String keystoreType = "JKS";
    protected String sslProtocol = "TLS";
    protected String sslEnabledProtocols = null;
    protected String[] sslEnabledProtocolsarr = new String[0];
    protected String ciphers = null;
    protected String[] ciphersarr = new String[0];
    protected int sessionCacheSize = 0;
    protected int sessionTimeout = 86400;
    protected boolean SSLEnabled = false;
    protected boolean secure = false;
    protected SSLContext sslContext = null;

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setUseExecutor(boolean useexec) {
        this.useExecutor = useexec;
    }

    public boolean getUseExecutor() {
        return this.useExecutor || this.executor != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        if (this.running) {
            if (this.getUseExecutor() && this.executor != null) {
                if (this.executor instanceof ThreadPoolExecutor) {
                    ((ThreadPoolExecutor)this.executor).setMaximumPoolSize(maxThreads);
                }
            } else if (this.workers != null) {
                WorkerStack workerStack = this.workers;
                synchronized (workerStack) {
                    this.workers.resize(maxThreads);
                }
            }
        }
    }

    public int getMaxThreads() {
        if (this.running && this.getUseExecutor() && this.executor != null) {
            if (this.executor instanceof ThreadPoolExecutor) {
                return ((ThreadPoolExecutor)this.executor).getMaximumPoolSize();
            }
            return -1;
        }
        return this.maxThreads;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setAcceptorThreadPriority(int acceptorThreadPriority) {
        this.acceptorThreadPriority = acceptorThreadPriority;
    }

    public int getAcceptorThreadPriority() {
        return this.acceptorThreadPriority;
    }

    public void setPollerThreadPriority(int pollerThreadPriority) {
        this.pollerThreadPriority = pollerThreadPriority;
    }

    public int getPollerThreadPriority() {
        return this.pollerThreadPriority;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public boolean getTcpNoDelay() {
        return this.socketProperties.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.socketProperties.setTcpNoDelay(tcpNoDelay);
    }

    public int getSoLinger() {
        return this.socketProperties.getSoLingerTime();
    }

    public void setSoLinger(int soLinger) {
        this.socketProperties.setSoLingerTime(soLinger);
        this.socketProperties.setSoLingerOn(soLinger >= 0);
    }

    public int getSoTimeout() {
        return this.socketProperties.getSoTimeout();
    }

    public void setSoTimeout(int soTimeout) {
        this.socketProperties.setSoTimeout(soTimeout);
    }

    public void setDaemon(boolean b) {
        this.daemon = b;
    }

    public boolean getDaemon() {
        return this.daemon;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setUseComet(boolean useComet) {
        this.useComet = useComet;
    }

    public boolean getUseComet() {
        return this.useComet;
    }

    public void setAcceptorThreadCount(int acceptorThreadCount) {
        this.acceptorThreadCount = acceptorThreadCount;
    }

    public int getAcceptorThreadCount() {
        return this.acceptorThreadCount;
    }

    public void setPollerThreadCount(int pollerThreadCount) {
        this.pollerThreadCount = pollerThreadCount;
    }

    public int getPollerThreadCount() {
        return this.pollerThreadCount;
    }

    public void setSelectorTimeout(long timeout) {
        this.selectorTimeout = timeout;
    }

    public long getSelectorTimeout() {
        return this.selectorTimeout;
    }

    public Poller getPoller0() {
        int idx = Math.abs(this.pollerRotater.incrementAndGet()) % this.pollers.length;
        return this.pollers[idx];
    }

    public int getMaxSpareThreads() {
        return Math.min(this.getMaxThreads(), 5);
    }

    public int getMinSpareThreads() {
        return Math.min(this.getMaxThreads(), 5);
    }

    public boolean setProperty(String name, String value) {
        String selectorPoolName = "selectorPool.";
        String socketName = "socket.";
        try {
            if (name.startsWith("selectorPool.")) {
                return IntrospectionUtils.setProperty(this.selectorPool, name.substring("selectorPool.".length()), value);
            }
            if (name.startsWith("socket.")) {
                return IntrospectionUtils.setProperty(this.socketProperties, name.substring("socket.".length()), value);
            }
            return IntrospectionUtils.setProperty(this, name, value, false);
        }
        catch (Exception x) {
            log.error((Object)("Unable to set attribute \"" + name + "\" to \"" + value + "\""), (Throwable)x);
            return false;
        }
    }

    public String adjustRelativePath(String path, String relativeTo) {
        File f = new File(path);
        if (!f.isAbsolute()) {
            path = relativeTo + File.separator + path;
            f = new File(path);
        }
        if (!f.exists()) {
            log.warn((Object)("configured file:[" + path + "] does not exist."));
        }
        return path;
    }

    public String defaultIfNull(String val, String defaultValue) {
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public void setTruststoreFile(String s) {
        this.truststoreFile = s = this.adjustRelativePath(s, System.getProperty("catalina.base"));
    }

    public String getTruststoreFile() {
        return this.truststoreFile;
    }

    public void setTruststorePass(String truststorePass) {
        this.truststorePass = truststorePass;
    }

    public String getTruststorePass() {
        return this.truststorePass;
    }

    public void setTruststoreType(String truststoreType) {
        this.truststoreType = truststoreType;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String s) {
        this.keystoreFile = s = this.adjustRelativePath(s, System.getProperty("catalina.base"));
    }

    public void setKeystore(String s) {
        this.setKeystoreFile(s);
    }

    public String getKeystore() {
        return this.getKeystoreFile();
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String s) {
        this.keyAlias = s;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String s) {
        this.algorithm = s;
    }

    public String getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(String s) {
        this.clientAuth = s;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public void setKeystorePass(String s) {
        this.keystorePass = s;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String s) {
        this.keystoreType = s;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String s) {
        this.sslProtocol = s;
    }

    public void setSslEnabledProtocols(String s) {
        this.sslEnabledProtocols = s;
        StringTokenizer t = new StringTokenizer(s, ",");
        this.sslEnabledProtocolsarr = new String[t.countTokens()];
        for (int i = 0; i < this.sslEnabledProtocolsarr.length; ++i) {
            this.sslEnabledProtocolsarr[i] = t.nextToken();
        }
    }

    public String getCiphers() {
        return this.ciphers;
    }

    public void setCiphers(String s) {
        this.ciphers = s;
        if (s == null) {
            this.ciphersarr = new String[0];
        } else {
            StringTokenizer t = new StringTokenizer(s, ",");
            this.ciphersarr = new String[t.countTokens()];
            for (int i = 0; i < this.ciphersarr.length; ++i) {
                this.ciphersarr[i] = t.nextToken();
            }
        }
    }

    public int getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    public void setSessionCacheSize(int i) {
        this.sessionCacheSize = i;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int i) {
        this.sessionTimeout = i;
    }

    public boolean isSSLEnabled() {
        return this.SSLEnabled;
    }

    public void setSSLEnabled(boolean SSLEnabled) {
        this.SSLEnabled = SSLEnabled;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean b) {
        this.secure = b;
    }

    public void setSelectorPool(NioSelectorPool selectorPool) {
        this.selectorPool = selectorPool;
    }

    public void setSocketProperties(SocketProperties socketProperties) {
        this.socketProperties = socketProperties;
    }

    public void setUseSendfile(boolean useSendfile) {
        this.useSendfile = useSendfile;
    }

    public void setOomParachute(int oomParachute) {
        this.oomParachute = oomParachute;
    }

    public void setOomParachuteData(byte[] oomParachuteData) {
        this.oomParachuteData = oomParachuteData;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public void setSSLContext(SSLContext c) {
        this.sslContext = c;
    }

    protected void checkParachute() {
        boolean para = this.reclaimParachute(false);
        if (!para && System.currentTimeMillis() - this.lastParachuteCheck > 10000L) {
            try {
                log.fatal((Object)oomParachuteMsg);
            }
            catch (Throwable t) {
                System.err.println(oomParachuteMsg);
            }
            this.lastParachuteCheck = System.currentTimeMillis();
        }
    }

    protected boolean reclaimParachute(boolean force) {
        if (this.oomParachuteData != null) {
            return true;
        }
        if (this.oomParachute > 0 && (force || Runtime.getRuntime().freeMemory() > (long)(this.oomParachute * 2))) {
            this.oomParachuteData = new byte[this.oomParachute];
        }
        return this.oomParachuteData != null;
    }

    protected void releaseCaches() {
        this.keyCache.clear();
        this.nioChannels.clear();
        this.processorCache.clear();
        if (this.handler != null) {
            this.handler.releaseCaches();
        }
    }

    public int getKeepAliveCount() {
        if (this.pollers == null) {
            return 0;
        }
        int sum = 0;
        for (int i = 0; i < this.pollers.length; ++i) {
            sum += this.pollers[i].selector.keys().size();
        }
        return sum;
    }

    public int getCurrentThreadCount() {
        if (this.executor != null) {
            if (this.executor instanceof ThreadPoolExecutor) {
                return ((ThreadPoolExecutor)this.executor).getPoolSize();
            }
            return -1;
        }
        return this.curThreads;
    }

    public int getCurrentThreadsBusy() {
        if (this.executor != null) {
            if (this.executor instanceof ThreadPoolExecutor) {
                return ((ThreadPoolExecutor)this.executor).getActiveCount();
            }
            return -1;
        }
        return this.workers != null ? this.curThreads - this.workers.size() : 0;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void init() throws Exception {
        if (this.initialized) {
            return;
        }
        this.serverSock = ServerSocketChannel.open();
        this.serverSock.socket().setPerformancePreferences(this.socketProperties.getPerformanceConnectionTime(), this.socketProperties.getPerformanceLatency(), this.socketProperties.getPerformanceBandwidth());
        InetSocketAddress addr = this.address != null ? new InetSocketAddress(this.address, this.port) : new InetSocketAddress(this.port);
        this.serverSock.socket().bind(addr, this.backlog);
        this.serverSock.configureBlocking(true);
        this.serverSock.socket().setSoTimeout(this.getSocketProperties().getSoTimeout());
        if (this.acceptorThreadCount == 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.pollerThreadCount <= 0) {
            this.pollerThreadCount = 1;
        }
        this.stopLatch = new CountDownLatch(this.pollerThreadCount);
        if (this.isSSLEnabled()) {
            char[] passphrase = this.getKeystorePass().toCharArray();
            char[] tpassphrase = this.getTruststorePass() != null ? this.getTruststorePass().toCharArray() : passphrase;
            String ttype = this.getTruststoreType() != null ? this.getTruststoreType() : this.getKeystoreType();
            KeyStore ks = KeyStore.getInstance(this.getKeystoreType());
            ks.load(new FileInputStream(this.getKeystoreFile()), passphrase);
            KeyStore ts = null;
            if (this.getTruststoreFile() != null) {
                ts = KeyStore.getInstance(ttype);
                ts.load(new FileInputStream(this.getTruststoreFile()), tpassphrase);
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.getAlgorithm());
            kmf.init(ks, passphrase);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.getAlgorithm());
            tmf.init(ts);
            this.sslContext = SSLContext.getInstance(this.getSslProtocol());
            this.sslContext.init(this.wrap(kmf.getKeyManagers()), tmf.getTrustManagers(), null);
            SSLSessionContext sessionContext = this.sslContext.getServerSessionContext();
            if (sessionContext != null) {
                sessionContext.setSessionCacheSize(this.sessionCacheSize);
                sessionContext.setSessionTimeout(this.sessionTimeout);
            }
        }
        if (this.oomParachute > 0) {
            this.reclaimParachute(true);
        }
        this.selectorPool.open();
        this.initialized = true;
    }

    public KeyManager[] wrap(KeyManager[] managers) {
        if (managers == null) {
            return null;
        }
        KeyManager[] result = new KeyManager[managers.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = managers[i] instanceof X509KeyManager && this.getKeyAlias() != null ? new NioX509KeyManager((X509KeyManager)managers[i], this.getKeyAlias()) : managers[i];
        }
        return result;
    }

    public void start() throws Exception {
        if (!this.initialized) {
            this.init();
        }
        if (!this.running) {
            int i;
            this.running = true;
            this.paused = false;
            if (this.getUseExecutor()) {
                if (this.executor == null) {
                    TaskQueue taskqueue = new TaskQueue();
                    TaskThreadFactory tf = new TaskThreadFactory(this.getName() + "-exec-");
                    this.executor = new ThreadPoolExecutor(this.getMinSpareThreads(), this.getMaxThreads(), 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)taskqueue, tf);
                    taskqueue.setParent((ThreadPoolExecutor)this.executor, this);
                }
            } else if (this.executor == null) {
                this.workers = new WorkerStack(this.maxThreads);
            }
            this.pollers = new Poller[this.getPollerThreadCount()];
            for (i = 0; i < this.pollers.length; ++i) {
                this.pollers[i] = new Poller();
                Thread pollerThread = new Thread((Runnable)this.pollers[i], this.getName() + "-ClientPoller-" + i);
                pollerThread.setPriority(this.threadPriority);
                pollerThread.setDaemon(true);
                pollerThread.start();
            }
            for (i = 0; i < this.acceptorThreadCount; ++i) {
                Thread acceptorThread = new Thread((Runnable)new Acceptor(), this.getName() + "-Acceptor-" + i);
                acceptorThread.setPriority(this.threadPriority);
                acceptorThread.setDaemon(this.daemon);
                acceptorThread.start();
            }
        }
    }

    public void pause() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.unlockAccept();
        }
    }

    public void resume() {
        if (this.running) {
            this.paused = false;
        }
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            this.unlockAccept();
            for (int i = 0; this.pollers != null && i < this.pollers.length; ++i) {
                if (this.pollers[i] == null) continue;
                this.pollers[i].destroy();
                this.pollers[i] = null;
            }
            try {
                this.stopLatch.await(this.selectorTimeout + 100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
        this.eventCache.clear();
        this.keyCache.clear();
        this.nioChannels.clear();
        this.processorCache.clear();
        if (this.executor != null) {
            if (this.executor instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.executor;
                tpe.shutdownNow();
                TaskQueue queue = (TaskQueue)tpe.getQueue();
                queue.setParent(null, null);
            }
            this.executor = null;
        }
    }

    public void destroy() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroy initiated for " + new InetSocketAddress(this.address, this.port)));
        }
        if (this.running) {
            this.stop();
        }
        this.serverSock.socket().close();
        this.serverSock.close();
        this.serverSock = null;
        this.sslContext = null;
        this.initialized = false;
        this.releaseCaches();
        this.selectorPool.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroy completed for " + new InetSocketAddress(this.address, this.port)));
        }
    }

    protected int getSequence() {
        return this.sequence++;
    }

    public int getWriteBufSize() {
        return this.socketProperties.getTxBufSize();
    }

    public int getReadBufSize() {
        return this.socketProperties.getRxBufSize();
    }

    public NioSelectorPool getSelectorPool() {
        return this.selectorPool;
    }

    public SocketProperties getSocketProperties() {
        return this.socketProperties;
    }

    public boolean getUseSendfile() {
        return this.useSendfile;
    }

    public int getOomParachute() {
        return this.oomParachute;
    }

    public byte[] getOomParachuteData() {
        return this.oomParachuteData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void unlockAccept() {
        Socket s;
        block10: {
            s = null;
            InetSocketAddress saddr = null;
            saddr = this.address == null ? new InetSocketAddress("localhost", this.port) : new InetSocketAddress(this.address, this.port);
            s = new Socket();
            s.setSoTimeout(this.getSocketProperties().getSoTimeout());
            s.setSoLinger(this.getSocketProperties().getSoLingerOn(), this.getSocketProperties().getSoLingerTime());
            if (log.isDebugEnabled()) {
                log.debug((Object)("About to unlock socket for:" + saddr));
            }
            s.connect(saddr, this.getSocketProperties().getUnlockTimeout());
            if (!log.isDebugEnabled()) break block10;
            log.debug((Object)("Socket unlock completed for:" + saddr));
        }
        Object var5_3 = null;
        if (s == null) return;
        try {
            s.close();
            return;
        }
        catch (Exception e2) {}
        return;
        {
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("endpoint.debug.unlock", "" + this.port), (Throwable)e);
                }
                Object var5_4 = null;
                if (s == null) return;
                try {
                    s.close();
                    return;
                }
                catch (Exception e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (s == null) throw throwable;
            try {
                s.close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected boolean setSocketOptions(SocketChannel socket) {
        try {
            socket.configureBlocking(false);
            Socket sock = socket.socket();
            this.socketProperties.setProperties(sock);
            NioChannel channel = this.nioChannels.poll();
            if (channel == null) {
                if (this.sslContext != null) {
                    SSLEngine engine = this.createSSLEngine();
                    int appbufsize = engine.getSession().getApplicationBufferSize();
                    NioBufferHandler bufhandler = new NioBufferHandler(Math.max(appbufsize, this.socketProperties.getAppReadBufSize()), Math.max(appbufsize, this.socketProperties.getAppWriteBufSize()), this.socketProperties.getDirectBuffer());
                    channel = new SecureNioChannel(socket, engine, bufhandler, this.selectorPool);
                } else {
                    NioBufferHandler bufhandler = new NioBufferHandler(this.socketProperties.getAppReadBufSize(), this.socketProperties.getAppWriteBufSize(), this.socketProperties.getDirectBuffer());
                    channel = new NioChannel(socket, bufhandler);
                }
            } else {
                channel.setIOChannel(socket);
                if (channel instanceof SecureNioChannel) {
                    SSLEngine engine = this.createSSLEngine();
                    ((SecureNioChannel)channel).reset(engine);
                } else {
                    channel.reset();
                }
            }
            this.getPoller0().register(channel);
        }
        catch (Throwable t) {
            try {
                log.error((Object)"", t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    protected SSLEngine createSSLEngine() {
        SSLEngine engine = this.sslContext.createSSLEngine();
        if ("false".equals(this.getClientAuth())) {
            engine.setNeedClientAuth(false);
            engine.setWantClientAuth(false);
        } else if ("true".equals(this.getClientAuth()) || "yes".equals(this.getClientAuth())) {
            engine.setNeedClientAuth(true);
        } else if ("want".equals(this.getClientAuth())) {
            engine.setWantClientAuth(true);
        }
        engine.setUseClientMode(false);
        if (this.ciphersarr.length > 0) {
            engine.setEnabledCipherSuites(this.ciphersarr);
        }
        if (this.sslEnabledProtocolsarr.length > 0) {
            engine.setEnabledProtocols(this.sslEnabledProtocolsarr);
        }
        return engine;
    }

    protected boolean isWorkerAvailable() {
        if (this.executor != null) {
            return true;
        }
        if (this.workers.size() > 0) {
            return true;
        }
        if (this.maxThreads > 0 && this.curThreads < this.maxThreads) {
            return true;
        }
        return this.maxThreads < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Worker createWorkerThread() {
        WorkerStack workerStack = this.workers;
        synchronized (workerStack) {
            if (this.workers.size() > 0) {
                ++this.curThreadsBusy;
                return this.workers.pop();
            }
            if (this.maxThreads > 0 && this.curThreads < this.maxThreads) {
                ++this.curThreadsBusy;
                if (this.curThreadsBusy == this.maxThreads) {
                    log.info((Object)sm.getString("endpoint.info.maxThreads", Integer.toString(this.maxThreads), this.address, Integer.toString(this.port)));
                }
                return this.newWorkerThread();
            }
            if (this.maxThreads < 0) {
                ++this.curThreadsBusy;
                return this.newWorkerThread();
            }
            return null;
        }
    }

    protected Worker newWorkerThread() {
        Worker workerThread = new Worker();
        workerThread.start();
        return workerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Worker getWorkerThread() {
        WorkerStack workerStack = this.workers;
        synchronized (workerStack) {
            Worker workerThread;
            while ((workerThread = this.createWorkerThread()) == null) {
                try {
                    this.workers.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return workerThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleWorkerThread(Worker workerThread) {
        WorkerStack workerStack = this.workers;
        synchronized (workerStack) {
            this.workers.push(workerThread);
            --this.curThreadsBusy;
            this.workers.notify();
        }
    }

    protected boolean processSocket(NioChannel socket) {
        return this.processSocket(socket, null);
    }

    protected boolean processSocket(NioChannel socket, SocketStatus status) {
        return this.processSocket(socket, status, true);
    }

    protected boolean processSocket(NioChannel socket, SocketStatus status, boolean dispatch) {
        try {
            KeyAttachment attachment = (KeyAttachment)socket.getAttachment(false);
            attachment.setCometNotify(false);
            if (this.executor == null) {
                this.getWorkerThread().assign(socket, status);
            } else {
                SocketProcessor sc = this.processorCache.poll();
                if (sc == null) {
                    sc = new SocketProcessor(socket, status);
                } else {
                    sc.reset(socket, status);
                }
                if (dispatch) {
                    this.executor.execute(sc);
                } else {
                    sc.run();
                }
            }
        }
        catch (Throwable t) {
            log.error((Object)sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    public static class SendfileData {
        public String fileName;
        public FileChannel fchannel;
        public long pos;
        public long length;
        public boolean keepAlive;
    }

    class TaskThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        TaskThreadFactory(String namePrefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = namePrefix;
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement());
            t.setDaemon(NioEndpoint.this.daemon);
            t.setPriority(NioEndpoint.this.getThreadPriority());
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskQueue
    extends LinkedBlockingQueue<Runnable> {
        ThreadPoolExecutor parent = null;
        NioEndpoint endpoint = null;

        public TaskQueue() {
        }

        public TaskQueue(int initialCapacity) {
            super(initialCapacity);
        }

        public TaskQueue(Collection<? extends Runnable> c) {
            super(c);
        }

        public void setParent(ThreadPoolExecutor tp, NioEndpoint ep) {
            this.parent = tp;
            this.endpoint = ep;
        }

        @Override
        public boolean offer(Runnable o) {
            if (this.parent == null) {
                return super.offer(o);
            }
            if (this.parent.getPoolSize() == this.parent.getMaximumPoolSize()) {
                return super.offer(o);
            }
            if (this.endpoint.activeSocketProcessors.get() < this.parent.getPoolSize()) {
                return super.offer(o);
            }
            if (this.parent.getPoolSize() < this.parent.getMaximumPoolSize()) {
                return false;
            }
            return super.offer(o);
        }
    }

    protected class SocketProcessor
    implements Runnable {
        protected NioChannel socket = null;
        protected SocketStatus status = null;

        public SocketProcessor(NioChannel socket, SocketStatus status) {
            this.reset(socket, status);
        }

        public void reset(NioChannel socket, SocketStatus status) {
            this.socket = socket;
            this.status = status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            NioChannel nioChannel = this.socket;
            synchronized (nioChannel) {
                block31: {
                    NioEndpoint.this.activeSocketProcessors.addAndGet(1);
                    SelectionKey key = null;
                    try {
                        block30: {
                            try {
                                key = this.socket.getIOChannel().keyFor(this.socket.getPoller().getSelector());
                                int handshake = -1;
                                try {
                                    if (key != null) {
                                        handshake = this.socket.handshake(key.isReadable(), key.isWritable());
                                    }
                                }
                                catch (IOException x) {
                                    handshake = -1;
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)"Error during SSL handshake", (Throwable)x);
                                    }
                                }
                                catch (CancelledKeyException ckx) {
                                    handshake = -1;
                                }
                                if (handshake == 0) {
                                    boolean closed;
                                    boolean bl = this.status == null ? NioEndpoint.this.handler.process(this.socket) == Handler.SocketState.CLOSED : (closed = NioEndpoint.this.handler.event(this.socket, this.status) == Handler.SocketState.CLOSED);
                                    if (closed) {
                                        try {
                                            KeyAttachment ka = null;
                                            if (key != null) {
                                                ka = (KeyAttachment)key.attachment();
                                                if (ka != null) {
                                                    ka.setComet(false);
                                                }
                                                this.socket.getPoller().cancelledKey(key, SocketStatus.ERROR, false);
                                            }
                                            if (this.socket != null) {
                                                NioEndpoint.this.nioChannels.offer(this.socket);
                                            }
                                            this.socket = null;
                                            if (ka != null) {
                                                NioEndpoint.this.keyCache.offer(ka);
                                            }
                                            ka = null;
                                        }
                                        catch (Exception x) {
                                            log.error((Object)"", (Throwable)x);
                                        }
                                    }
                                    break block30;
                                }
                                if (handshake == -1) {
                                    KeyAttachment ka = null;
                                    if (key != null) {
                                        ka = (KeyAttachment)key.attachment();
                                        this.socket.getPoller().cancelledKey(key, SocketStatus.DISCONNECT, false);
                                    }
                                    if (this.socket != null) {
                                        NioEndpoint.this.nioChannels.offer(this.socket);
                                    }
                                    this.socket = null;
                                    if (ka != null) {
                                        NioEndpoint.this.keyCache.offer(ka);
                                    }
                                    ka = null;
                                } else {
                                    SelectionKey fk = key;
                                    int intops = handshake;
                                    KeyAttachment ka = (KeyAttachment)fk.attachment();
                                    ka.getPoller().add(this.socket, intops);
                                }
                            }
                            catch (CancelledKeyException cx) {
                                this.socket.getPoller().cancelledKey(key, null, false);
                                Object var8_18 = null;
                                this.socket = null;
                                this.status = null;
                                NioEndpoint.this.processorCache.offer(this);
                                NioEndpoint.this.activeSocketProcessors.addAndGet(-1);
                                break block31;
                            }
                            catch (OutOfMemoryError oom) {
                                try {
                                    NioEndpoint.this.oomParachuteData = null;
                                    this.socket.getPoller().cancelledKey(key, SocketStatus.ERROR, false);
                                    NioEndpoint.this.releaseCaches();
                                    log.error((Object)"", (Throwable)oom);
                                }
                                catch (Throwable oomt) {
                                    try {
                                        System.err.println(NioEndpoint.oomParachuteMsg);
                                        oomt.printStackTrace();
                                    }
                                    catch (Throwable letsHopeWeDontGetHere) {
                                    }
                                }
                                Object var8_19 = null;
                                this.socket = null;
                                this.status = null;
                                NioEndpoint.this.processorCache.offer(this);
                                NioEndpoint.this.activeSocketProcessors.addAndGet(-1);
                                break block31;
                            }
                            catch (Throwable t) {
                                log.error((Object)"", t);
                                this.socket.getPoller().cancelledKey(key, SocketStatus.ERROR, false);
                                Object var8_20 = null;
                                this.socket = null;
                                this.status = null;
                                NioEndpoint.this.processorCache.offer(this);
                                NioEndpoint.this.activeSocketProcessors.addAndGet(-1);
                                break block31;
                            }
                        }
                        Object var8_17 = null;
                        this.socket = null;
                        this.status = null;
                        NioEndpoint.this.processorCache.offer(this);
                    }
                    catch (Throwable throwable) {
                        Object var8_21 = null;
                        this.socket = null;
                        this.status = null;
                        NioEndpoint.this.processorCache.offer(this);
                        NioEndpoint.this.activeSocketProcessors.addAndGet(-1);
                        throw throwable;
                    }
                    NioEndpoint.this.activeSocketProcessors.addAndGet(-1);
                }
                return;
            }
        }
    }

    public class WorkerStack {
        protected Worker[] workers = null;
        protected int end = 0;

        public WorkerStack(int size) {
            this.workers = new Worker[size];
        }

        public void push(Worker worker) {
            if (this.end < this.workers.length) {
                this.workers[this.end++] = worker;
            } else {
                --NioEndpoint.this.curThreads;
            }
        }

        public Worker pop() {
            if (this.end > 0) {
                return this.workers[--this.end];
            }
            return null;
        }

        public Worker peek() {
            return this.workers[this.end];
        }

        public boolean isEmpty() {
            return this.end == 0;
        }

        public int size() {
            return this.end;
        }

        public void resize(int newSize) {
            Worker[] newWorkers = new Worker[newSize];
            int len = this.workers.length;
            if (newSize < len) {
                len = newSize;
            }
            System.arraycopy(this.workers, 0, newWorkers, 0, len);
            this.workers = newWorkers;
        }
    }

    public static interface Handler {
        public SocketState process(NioChannel var1);

        public SocketState event(NioChannel var1, SocketStatus var2);

        public void releaseCaches();

        public void release(NioChannel var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SocketState {
            OPEN,
            CLOSED,
            LONG;

        }
    }

    public class NioBufferHandler
    implements SecureNioChannel.ApplicationBufferHandler {
        protected ByteBuffer readbuf = null;
        protected ByteBuffer writebuf = null;

        public NioBufferHandler(int readsize, int writesize, boolean direct) {
            if (direct) {
                this.readbuf = ByteBuffer.allocateDirect(readsize);
                this.writebuf = ByteBuffer.allocateDirect(writesize);
            } else {
                this.readbuf = ByteBuffer.allocate(readsize);
                this.writebuf = ByteBuffer.allocate(writesize);
            }
        }

        public ByteBuffer expand(ByteBuffer buffer, int remaining) {
            return buffer;
        }

        public ByteBuffer getReadBuffer() {
            return this.readbuf;
        }

        public ByteBuffer getWriteBuffer() {
            return this.writebuf;
        }
    }

    protected class Worker
    implements Runnable {
        protected Thread thread = null;
        protected boolean available = false;
        protected Object socket = null;
        protected SocketStatus status = null;

        protected Worker() {
        }

        protected synchronized void assign(Object socket) {
            while (this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.socket = socket;
            this.status = null;
            this.available = true;
            this.notifyAll();
        }

        protected synchronized void assign(Object socket, SocketStatus status) {
            while (this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.socket = socket;
            this.status = status;
            this.available = true;
            this.notifyAll();
        }

        protected synchronized Object await() {
            while (!this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            Object socket = this.socket;
            this.available = false;
            this.notifyAll();
            return socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                Object var7_11;
                NioChannel socket;
                block20: {
                    if (!NioEndpoint.this.running) {
                        return;
                    }
                    socket = null;
                    SelectionKey key = null;
                    try {
                        block19: {
                            try {
                                Object sc;
                                Object channel = this.await();
                                if (channel == null) {
                                    var7_11 = null;
                                    socket = null;
                                    break block19;
                                }
                                if (channel instanceof SocketChannel) {
                                    sc = (SocketChannel)channel;
                                    if (NioEndpoint.this.setSocketOptions((SocketChannel)sc)) break block20;
                                    try {
                                        ((SocketChannel)sc).socket().close();
                                        ((AbstractInterruptibleChannel)sc).close();
                                    }
                                    catch (IOException ix) {
                                        if (log.isDebugEnabled()) {
                                            log.debug((Object)"", (Throwable)ix);
                                        }
                                        break block20;
                                    }
                                }
                                socket = (NioChannel)channel;
                                sc = NioEndpoint.this.processorCache.poll();
                                if (sc == null) {
                                    sc = new SocketProcessor(socket, this.status);
                                } else {
                                    ((SocketProcessor)sc).reset(socket, this.status);
                                }
                                ((SocketProcessor)sc).run();
                                break block20;
                            }
                            catch (CancelledKeyException cx) {
                                if (socket != null && key != null) {
                                    socket.getPoller().cancelledKey(key, null, false);
                                }
                                var7_11 = null;
                                socket = null;
                                NioEndpoint.this.recycleWorkerThread(this);
                                continue;
                            }
                            catch (OutOfMemoryError oom) {
                                try {
                                    NioEndpoint.this.oomParachuteData = null;
                                    NioEndpoint.this.releaseCaches();
                                    log.error((Object)"", (Throwable)oom);
                                }
                                catch (Throwable oomt) {
                                    try {
                                        System.err.println(NioEndpoint.oomParachuteMsg);
                                        oomt.printStackTrace();
                                    }
                                    catch (Throwable letsHopeWeDontGetHere) {
                                    }
                                }
                                var7_11 = null;
                                socket = null;
                                NioEndpoint.this.recycleWorkerThread(this);
                                continue;
                            }
                        }
                        NioEndpoint.this.recycleWorkerThread(this);
                        continue;
                    }
                    catch (Throwable throwable) {
                        var7_11 = null;
                        socket = null;
                        NioEndpoint.this.recycleWorkerThread(this);
                        throw throwable;
                    }
                }
                var7_11 = null;
                socket = null;
                NioEndpoint.this.recycleWorkerThread(this);
            }
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setName(NioEndpoint.this.getName() + "-" + ++NioEndpoint.this.curThreads);
            this.thread.setDaemon(true);
            this.thread.setPriority(NioEndpoint.this.getThreadPriority());
            this.thread.start();
        }
    }

    public static class KeyAttachment {
        protected Poller poller = null;
        protected int interestOps = 0;
        protected long lastAccess = -1L;
        protected boolean currentAccess = false;
        protected boolean comet = false;
        protected int cometOps = 1;
        protected boolean cometNotify = false;
        protected long timeout = -1L;
        protected boolean error = false;
        protected NioChannel channel = null;
        protected CountDownLatch readLatch = null;
        protected CountDownLatch writeLatch = null;
        protected long lastRegistered = 0L;
        protected SendfileData sendfileData = null;

        public void reset(Poller poller, NioChannel channel, long soTimeout) {
            int i;
            this.channel = channel;
            this.poller = poller;
            this.lastAccess = System.currentTimeMillis();
            this.currentAccess = false;
            this.comet = false;
            this.timeout = soTimeout;
            this.error = false;
            this.lastRegistered = 0L;
            this.sendfileData = null;
            if (this.readLatch != null) {
                try {
                    for (i = 0; i < (int)this.readLatch.getCount(); ++i) {
                        this.readLatch.countDown();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            this.readLatch = null;
            if (this.writeLatch != null) {
                try {
                    for (i = 0; i < (int)this.writeLatch.getCount(); ++i) {
                        this.writeLatch.countDown();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            this.writeLatch = null;
            this.cometNotify = false;
            this.cometOps = 1;
            this.sendfileData = null;
        }

        public void reset() {
            this.reset(null, null, -1L);
        }

        public Poller getPoller() {
            return this.poller;
        }

        public void setPoller(Poller poller) {
            this.poller = poller;
        }

        public long getLastAccess() {
            return this.lastAccess;
        }

        public void access() {
            this.access(System.currentTimeMillis());
        }

        public void access(long access) {
            this.lastAccess = access;
        }

        public void setComet(boolean comet) {
            this.comet = comet;
        }

        public boolean getComet() {
            return this.comet;
        }

        public void setCometNotify(boolean notify) {
            this.cometNotify = notify;
        }

        public boolean getCometNotify() {
            return this.cometNotify;
        }

        public void setCometOps(int ops) {
            this.cometOps = ops;
        }

        public int getCometOps() {
            return this.cometOps;
        }

        public boolean getCurrentAccess() {
            return this.currentAccess;
        }

        public void setCurrentAccess(boolean access) {
            this.currentAccess = access;
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public boolean getError() {
            return this.error;
        }

        public void setError(boolean error) {
            this.error = error;
        }

        public NioChannel getChannel() {
            return this.channel;
        }

        public void setChannel(NioChannel channel) {
            this.channel = channel;
        }

        public int interestOps() {
            return this.interestOps;
        }

        public int interestOps(int ops) {
            this.interestOps = ops;
            return ops;
        }

        public CountDownLatch getReadLatch() {
            return this.readLatch;
        }

        public CountDownLatch getWriteLatch() {
            return this.writeLatch;
        }

        protected CountDownLatch resetLatch(CountDownLatch latch) {
            if (latch == null || latch.getCount() == 0L) {
                return null;
            }
            throw new IllegalStateException("Latch must be at count 0");
        }

        public void resetReadLatch() {
            this.readLatch = this.resetLatch(this.readLatch);
        }

        public void resetWriteLatch() {
            this.writeLatch = this.resetLatch(this.writeLatch);
        }

        protected CountDownLatch startLatch(CountDownLatch latch, int cnt) {
            if (latch == null || latch.getCount() == 0L) {
                return new CountDownLatch(cnt);
            }
            throw new IllegalStateException("Latch must be at count 0 or null.");
        }

        public void startReadLatch(int cnt) {
            this.readLatch = this.startLatch(this.readLatch, cnt);
        }

        public void startWriteLatch(int cnt) {
            this.writeLatch = this.startLatch(this.writeLatch, cnt);
        }

        protected void awaitLatch(CountDownLatch latch, long timeout, TimeUnit unit) throws InterruptedException {
            if (latch == null) {
                throw new IllegalStateException("Latch cannot be null");
            }
            latch.await(timeout, unit);
        }

        public void awaitReadLatch(long timeout, TimeUnit unit) throws InterruptedException {
            this.awaitLatch(this.readLatch, timeout, unit);
        }

        public void awaitWriteLatch(long timeout, TimeUnit unit) throws InterruptedException {
            this.awaitLatch(this.writeLatch, timeout, unit);
        }

        public long getLastRegistered() {
            return this.lastRegistered;
        }

        public void setLastRegistered(long reg) {
            this.lastRegistered = reg;
        }

        public void setSendfileData(SendfileData sf) {
            this.sendfileData = sf;
        }

        public SendfileData getSendfileData() {
            return this.sendfileData;
        }
    }

    public class Poller
    implements Runnable {
        protected Selector selector;
        protected ConcurrentLinkedQueue<Runnable> events = new ConcurrentLinkedQueue();
        protected volatile boolean close = false;
        protected long nextExpiration = 0L;
        protected AtomicLong wakeupCounter = new AtomicLong(0L);
        protected CountDownLatch stopLatch = new CountDownLatch(1);

        public Poller() throws IOException {
            this.selector = Selector.open();
        }

        public Selector getSelector() {
            return this.selector;
        }

        protected void destroy() {
            this.close = true;
            this.events.clear();
            this.selector.wakeup();
        }

        public void addEvent(Runnable event) {
            this.events.offer(event);
            if (this.wakeupCounter.incrementAndGet() == 0L) {
                this.selector.wakeup();
            }
        }

        public void cometInterest(NioChannel socket) {
            KeyAttachment att = (KeyAttachment)socket.getAttachment(false);
            this.add(socket, att.getCometOps());
            if ((att.getCometOps() & 0x200) == 512) {
                this.nextExpiration = 0L;
                this.selector.wakeup();
            }
        }

        public void wakeup() {
            this.selector.wakeup();
        }

        public void add(NioChannel socket) {
            this.add(socket, 1);
        }

        public void add(NioChannel socket, int interestOps) {
            PollerEvent r = NioEndpoint.this.eventCache.poll();
            if (r == null) {
                r = new PollerEvent(socket, null, interestOps);
            } else {
                r.reset(socket, null, interestOps);
            }
            this.addEvent(r);
        }

        public boolean events() {
            boolean result = false;
            Runnable r = null;
            while ((r = this.events.poll()) != null) {
                result = true;
                try {
                    r.run();
                    if (!(r instanceof PollerEvent)) continue;
                    ((PollerEvent)r).reset();
                    NioEndpoint.this.eventCache.offer((PollerEvent)r);
                }
                catch (Throwable x) {
                    log.error((Object)"", x);
                }
            }
            return result;
        }

        public void register(NioChannel socket) {
            socket.setPoller(this);
            KeyAttachment key = NioEndpoint.this.keyCache.poll();
            KeyAttachment ka = key != null ? key : new KeyAttachment();
            ka.reset(this, socket, NioEndpoint.this.getSocketProperties().getSoTimeout());
            PollerEvent r = NioEndpoint.this.eventCache.poll();
            ka.interestOps(1);
            if (r == null) {
                r = new PollerEvent(socket, ka, 256);
            } else {
                r.reset(socket, ka, 256);
            }
            this.addEvent(r);
        }

        public void cancelledKey(SelectionKey key, SocketStatus status, boolean dispatch) {
            block17: {
                try {
                    if (key == null) {
                        return;
                    }
                    KeyAttachment ka = (KeyAttachment)key.attachment();
                    if (ka != null && ka.getComet() && status != null) {
                        ka.setComet(false);
                        if (status == SocketStatus.TIMEOUT) {
                            NioEndpoint.this.processSocket(ka.getChannel(), status, true);
                            return;
                        }
                        NioEndpoint.this.processSocket(ka.getChannel(), status, false);
                    }
                    key.attach(null);
                    if (ka != null) {
                        NioEndpoint.this.handler.release(ka.getChannel());
                    }
                    if (key.isValid()) {
                        key.cancel();
                    }
                    if (key.channel().isOpen()) {
                        try {
                            key.channel().close();
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                    try {
                        if (ka != null) {
                            ka.channel.close(true);
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    try {
                        if (ka != null && ka.getSendfileData() != null && ka.getSendfileData().fchannel != null && ka.getSendfileData().fchannel.isOpen()) {
                            ka.getSendfileData().fchannel.close();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    if (ka != null) {
                        ka.reset();
                    }
                }
                catch (Throwable e) {
                    if (!log.isDebugEnabled()) break block17;
                    log.error((Object)"", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (NioEndpoint.this.running) {
                try {
                    Iterator<SelectionKey> iterator;
                    while (NioEndpoint.this.paused && !this.close) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {}
                    }
                    boolean hasEvents = false;
                    hasEvents |= this.events();
                    if (this.close) {
                        this.timeout(0, false);
                        break;
                    }
                    int keyCount = 0;
                    try {
                        if (!this.close) {
                            keyCount = this.wakeupCounter.getAndSet(-1L) > 0L ? this.selector.selectNow() : this.selector.select(NioEndpoint.this.selectorTimeout);
                            this.wakeupCounter.set(0L);
                        }
                        if (this.close) {
                            this.timeout(0, false);
                            this.selector.close();
                            break;
                        }
                    }
                    catch (NullPointerException x) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Possibly encountered sun bug 5076772 on windows JDK 1.5", (Throwable)x);
                        }
                        if (this.wakeupCounter != null && this.selector != null) continue;
                        throw x;
                    }
                    catch (CancelledKeyException x) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Possibly encountered sun bug 5076772 on windows JDK 1.5", (Throwable)x);
                        }
                        if (this.wakeupCounter != null && this.selector != null) continue;
                        throw x;
                    }
                    catch (Throwable x) {
                        log.error((Object)"", x);
                        continue;
                    }
                    if (keyCount == 0) {
                        hasEvents |= this.events();
                    }
                    Iterator<SelectionKey> iterator2 = iterator = keyCount > 0 ? this.selector.selectedKeys().iterator() : null;
                    while (iterator != null && iterator.hasNext()) {
                        SelectionKey sk = iterator.next();
                        KeyAttachment attachment = (KeyAttachment)sk.attachment();
                        if (attachment == null) {
                            iterator.remove();
                            continue;
                        }
                        attachment.access();
                        iterator.remove();
                        this.processKey(sk, attachment);
                    }
                    this.timeout(keyCount, hasEvents);
                    if (NioEndpoint.this.oomParachute <= 0 || NioEndpoint.this.oomParachuteData != null) continue;
                    NioEndpoint.this.checkParachute();
                }
                catch (OutOfMemoryError oom) {
                    try {
                        NioEndpoint.this.oomParachuteData = null;
                        NioEndpoint.this.releaseCaches();
                        log.error((Object)"", (Throwable)oom);
                    }
                    catch (Throwable oomt) {
                        try {
                            System.err.println(NioEndpoint.oomParachuteMsg);
                            oomt.printStackTrace();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            Poller poller = this;
            synchronized (poller) {
                this.notifyAll();
            }
            this.stopLatch.countDown();
        }

        protected boolean processKey(SelectionKey sk, KeyAttachment attachment) {
            boolean result = true;
            try {
                if (this.close) {
                    this.cancelledKey(sk, SocketStatus.STOP, false);
                } else if (sk.isValid() && attachment != null) {
                    attachment.access();
                    sk.attach(attachment);
                    NioChannel channel = attachment.getChannel();
                    if (sk.isReadable() || sk.isWritable()) {
                        if (attachment.getSendfileData() != null) {
                            this.processSendfile(sk, attachment, true, false);
                        } else if (attachment.getComet()) {
                            if (NioEndpoint.this.isWorkerAvailable()) {
                                this.reg(sk, attachment, 0);
                                if (sk.isReadable()) {
                                    if (!NioEndpoint.this.processSocket(channel, SocketStatus.OPEN)) {
                                        NioEndpoint.this.processSocket(channel, SocketStatus.DISCONNECT);
                                    }
                                } else if (!NioEndpoint.this.processSocket(channel, SocketStatus.OPEN)) {
                                    NioEndpoint.this.processSocket(channel, SocketStatus.DISCONNECT);
                                }
                            } else {
                                result = false;
                            }
                        } else if (NioEndpoint.this.isWorkerAvailable()) {
                            boolean close;
                            this.unreg(sk, attachment, sk.readyOps());
                            boolean bl = close = !NioEndpoint.this.processSocket(channel);
                            if (close) {
                                this.cancelledKey(sk, SocketStatus.DISCONNECT, false);
                            }
                        } else {
                            result = false;
                        }
                    }
                } else {
                    this.cancelledKey(sk, SocketStatus.ERROR, false);
                }
            }
            catch (CancelledKeyException ckx) {
                this.cancelledKey(sk, SocketStatus.ERROR, false);
            }
            catch (Throwable t) {
                log.error((Object)"", t);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean processSendfile(SelectionKey sk, KeyAttachment attachment, boolean reg, boolean event) {
            NioChannel sc;
            block28: {
                boolean bl;
                block29: {
                    sc = null;
                    try {
                        try {
                            ByteChannel byteChannel;
                            SendfileData sd = attachment.getSendfileData();
                            if (sd.fchannel == null) {
                                File file = new File(sd.fileName);
                                if (!file.exists()) {
                                    this.cancelledKey(sk, SocketStatus.ERROR, false);
                                    boolean bl2 = false;
                                    Object var11_17 = null;
                                    if (sc == null) return bl2;
                                    sc.setSendFile(false);
                                    return bl2;
                                }
                                sd.fchannel = new FileInputStream(file).getChannel();
                            }
                            sc = attachment.getChannel();
                            sc.setSendFile(true);
                            ByteChannel byteChannel2 = byteChannel = sc instanceof SecureNioChannel ? sc : sc.getIOChannel();
                            if (sc.getOutboundRemaining() > 0) {
                                if (sc.flushOutbound()) {
                                    attachment.access();
                                }
                            } else {
                                long written = sd.fchannel.transferTo(sd.pos, sd.length, byteChannel);
                                if (written > 0L) {
                                    sd.pos += written;
                                    sd.length -= written;
                                    attachment.access();
                                } else if (sd.fchannel.size() <= sd.pos) {
                                    throw new IOException("Sendfile configured to send more data than was available");
                                }
                            }
                            if (sd.length <= 0L && sc.getOutboundRemaining() <= 0) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Send file complete for:" + sd.fileName));
                                }
                                attachment.setSendfileData(null);
                                try {
                                    sd.fchannel.close();
                                }
                                catch (Exception ignore) {
                                    // empty catch block
                                }
                                if (sd.keepAlive) {
                                    if (reg) {
                                        if (log.isDebugEnabled()) {
                                            log.debug((Object)"Connection is keep alive, registering back for OP_READ");
                                        }
                                        if (event) {
                                            this.add(attachment.getChannel(), 1);
                                            break block28;
                                        } else {
                                            this.reg(sk, attachment, 1);
                                        }
                                    }
                                    break block28;
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"Send file connection is being closed");
                                }
                                this.cancelledKey(sk, SocketStatus.STOP, false);
                                bl = false;
                                break block29;
                            }
                            if (attachment.interestOps() != 0 || !reg) break block28;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("OP_WRITE for sendilfe:" + sd.fileName));
                            }
                            if (event) {
                                this.add(attachment.getChannel(), 4);
                                break block28;
                            } else {
                                this.reg(sk, attachment, 4);
                            }
                            break block28;
                        }
                        catch (IOException x) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Unable to complete sendfile request:", (Throwable)x);
                            }
                            this.cancelledKey(sk, SocketStatus.ERROR, false);
                            boolean bl3 = false;
                            Object var11_20 = null;
                            if (sc == null) return bl3;
                            sc.setSendFile(false);
                            return bl3;
                        }
                        catch (Throwable t) {
                            log.error((Object)"", t);
                            this.cancelledKey(sk, SocketStatus.ERROR, false);
                            boolean bl4 = false;
                            Object var11_21 = null;
                            if (sc == null) return bl4;
                            sc.setSendFile(false);
                            return bl4;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_22 = null;
                        if (sc == null) throw throwable;
                        sc.setSendFile(false);
                        throw throwable;
                    }
                }
                Object var11_18 = null;
                if (sc == null) return bl;
                sc.setSendFile(false);
                return bl;
            }
            Object var11_19 = null;
            if (sc == null) return true;
            sc.setSendFile(false);
            return true;
        }

        protected void unreg(SelectionKey sk, KeyAttachment attachment, int readyOps) {
            this.reg(sk, attachment, sk.interestOps() & ~readyOps);
        }

        protected void reg(SelectionKey sk, KeyAttachment attachment, int intops) {
            sk.interestOps(intops);
            attachment.interestOps(intops);
        }

        protected void timeout(int keyCount, boolean hasEvents) {
            long now = System.currentTimeMillis();
            if ((keyCount > 0 || hasEvents || now < this.nextExpiration) && !this.close) {
                return;
            }
            long prevExp = this.nextExpiration;
            this.nextExpiration = now + NioEndpoint.this.socketProperties.getTimeoutInterval();
            Set<SelectionKey> keys = this.selector.keys();
            int keycount = 0;
            for (SelectionKey key : keys) {
                ++keycount;
                try {
                    boolean isTimedout;
                    KeyAttachment ka = (KeyAttachment)key.attachment();
                    if (ka == null) {
                        this.cancelledKey(key, SocketStatus.ERROR, false);
                        continue;
                    }
                    if (ka.getError()) {
                        this.cancelledKey(key, SocketStatus.ERROR, true);
                        continue;
                    }
                    if (ka.getComet() && ka.getCometNotify()) {
                        ka.setCometNotify(false);
                        this.reg(key, ka, 0);
                        if (NioEndpoint.this.processSocket(ka.getChannel(), SocketStatus.OPEN)) continue;
                        NioEndpoint.this.processSocket(ka.getChannel(), SocketStatus.DISCONNECT);
                        continue;
                    }
                    if ((ka.interestOps() & 1) != 1 && (ka.interestOps() & 4) != 4) continue;
                    long delta = now - ka.getLastAccess();
                    long timeout = ka.getTimeout() == -1L ? (long)NioEndpoint.this.socketProperties.getSoTimeout() : ka.getTimeout();
                    boolean bl = isTimedout = delta > timeout;
                    if (this.close) {
                        key.interestOps(0);
                        ka.interestOps(0);
                        this.processKey(key, ka);
                        continue;
                    }
                    if (isTimedout) {
                        key.interestOps(0);
                        ka.interestOps(0);
                        this.cancelledKey(key, SocketStatus.TIMEOUT, true);
                        continue;
                    }
                    long nextTime = now + (timeout - delta);
                    this.nextExpiration = nextTime < this.nextExpiration ? nextTime : this.nextExpiration;
                }
                catch (CancelledKeyException ckx) {
                    this.cancelledKey(key, SocketStatus.ERROR, false);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("timeout completed: keys processed=" + keycount + "; now=" + now + "; nextExpiration=" + prevExp + "; " + "keyCount=" + keyCount + "; hasEvents=" + hasEvents + "; eval=" + (now < prevExp && (keyCount > 0 || hasEvents) && !this.close)));
            }
        }
    }

    public class PollerEvent
    implements Runnable {
        protected NioChannel socket;
        protected int interestOps;
        protected KeyAttachment key;

        public PollerEvent(NioChannel ch, KeyAttachment k, int intOps) {
            this.reset(ch, k, intOps);
        }

        public void reset(NioChannel ch, KeyAttachment k, int intOps) {
            this.socket = ch;
            this.interestOps = intOps;
            this.key = k;
        }

        public void reset() {
            this.reset(null, null, 0);
        }

        public void run() {
            if (this.interestOps == 256) {
                try {
                    this.socket.getIOChannel().register(this.socket.getPoller().getSelector(), 1, this.key);
                }
                catch (Exception x) {
                    log.error((Object)"", (Throwable)x);
                }
            } else {
                SelectionKey key = this.socket.getIOChannel().keyFor(this.socket.getPoller().getSelector());
                try {
                    boolean cancel = false;
                    if (key != null) {
                        KeyAttachment att = (KeyAttachment)key.attachment();
                        if (att != null) {
                            if (att.getComet() && (this.interestOps & 0x200) == 512) {
                                att.setCometNotify(true);
                            } else {
                                att.setCometNotify(false);
                            }
                            this.interestOps &= 0xFFFFFDFF;
                            att.access();
                            int ops = key.interestOps() | this.interestOps;
                            att.interestOps(ops);
                            key.interestOps(ops);
                            att.setCometOps(ops);
                        } else {
                            cancel = true;
                        }
                    } else {
                        cancel = true;
                    }
                    if (cancel) {
                        this.socket.getPoller().cancelledKey(key, SocketStatus.ERROR, false);
                    }
                }
                catch (CancelledKeyException ckx) {
                    try {
                        this.socket.getPoller().cancelledKey(key, SocketStatus.DISCONNECT, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public String toString() {
            return super.toString() + "[intOps=" + this.interestOps + "]";
        }
    }

    protected class Acceptor
    implements Runnable {
        protected Acceptor() {
        }

        public void run() {
            while (NioEndpoint.this.running) {
                while (NioEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                try {
                    SocketChannel socket = NioEndpoint.this.serverSock.accept();
                    if (!NioEndpoint.this.running || NioEndpoint.this.paused || socket == null || NioEndpoint.this.setSocketOptions(socket)) continue;
                    try {
                        socket.socket().close();
                        socket.close();
                    }
                    catch (IOException ix) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"", (Throwable)ix);
                    }
                }
                catch (SocketTimeoutException sx) {
                }
                catch (IOException x) {
                    if (!NioEndpoint.this.running) continue;
                    log.error((Object)sm.getString("endpoint.accept.fail"), (Throwable)x);
                }
                catch (OutOfMemoryError oom) {
                    try {
                        NioEndpoint.this.oomParachuteData = null;
                        NioEndpoint.this.releaseCaches();
                        log.error((Object)"", (Throwable)oom);
                    }
                    catch (Throwable oomt) {
                        try {
                            try {
                                System.err.println(NioEndpoint.oomParachuteMsg);
                                oomt.printStackTrace();
                            }
                            catch (Throwable letsHopeWeDontGetHere) {}
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
                catch (Throwable t) {
                    log.error((Object)sm.getString("endpoint.accept.fail"), t);
                }
            }
        }
    }
}

