/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.filters;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.zip.InflaterInputStream;
import org.icepdf.core.pobjects.filters.ChunkingInputStream;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;

public class FlateDecode
extends ChunkingInputStream {
    private static final int LZW_FLATE_PREDICTOR_NONE = 1;
    private static final int LZW_FLATE_PREDICTOR_TIFF_2 = 2;
    private static final int LZW_FLATE_PREDICTOR_PNG_NONE = 10;
    private static final int LZW_FLATE_PREDICTOR_PNG_SUB = 11;
    private static final int LZW_FLATE_PREDICTOR_PNG_UP = 12;
    private static final int LZW_FLATE_PREDICTOR_PNG_AVG = 13;
    private static final int LZW_FLATE_PREDICTOR_PNG_PAETH = 14;
    private static final int LZW_FLATE_PREDICTOR_PNG_OPTIMUM = 15;
    private InputStream originalInputKeptSolelyForDebugging;
    private int width;
    private int numComponents;
    private int bitsPerComponent;
    private int bpp = 1;
    private int predictor;
    private byte[] aboveBuffer;

    public FlateDecode(Library library, Hashtable hashtable, InputStream inputStream) {
        this.originalInputKeptSolelyForDebugging = inputStream;
        this.width = 0;
        this.numComponents = 0;
        this.bitsPerComponent = 0;
        this.bpp = 1;
        int n = 4096;
        Hashtable hashtable2 = library.getDictionary(hashtable, "DecodeParms");
        this.predictor = library.getInt(hashtable2, "Predictor");
        if (this.predictor != 1 && this.predictor != 2 && this.predictor != 10 && this.predictor != 11 && this.predictor != 12 && this.predictor != 13 && this.predictor != 14 && this.predictor != 15) {
            this.predictor = 1;
        }
        if (this.predictor != 1) {
            Object object;
            Number number = library.getNumber(hashtable, "Width");
            this.width = number != null ? number.intValue() : library.getInt(hashtable2, "Columns");
            this.numComponents = 1;
            this.bitsPerComponent = 8;
            Object object2 = library.getObject(hashtable2, "Colors");
            if (object2 instanceof Number) {
                this.numComponents = ((Number)object2).intValue();
            }
            if ((object = library.getObject(hashtable2, "BitsPerComponent")) instanceof Number) {
                this.bitsPerComponent = ((Number)object).intValue();
            }
            this.bpp = Math.max(1, Utils.numBytesToHoldBits(this.numComponents * this.bitsPerComponent));
            n = Utils.numBytesToHoldBits(this.width * this.numComponents * this.bitsPerComponent);
        }
        this.setInputStream(new InflaterInputStream(inputStream));
        this.setBufferSize(n);
        this.aboveBuffer = new byte[n];
    }

    protected int fillInternalBuffer() throws IOException {
        byte[] byArray = this.aboveBuffer;
        this.aboveBuffer = this.buffer;
        this.buffer = byArray;
        if (this.predictor == 1) {
            int n = this.fillBufferFromInputStream();
            if (n <= 0) {
                return -1;
            }
            return n;
        }
        if (this.predictor == 2) {
            int n = this.fillBufferFromInputStream();
            if (n <= 0) {
                return -1;
            }
            if (this.bitsPerComponent == 8) {
                for (int i = 0; i < n; ++i) {
                    int n2 = i - this.numComponents;
                    if (n2 < 0) continue;
                    int n3 = i;
                    this.buffer[n3] = (byte)(this.buffer[n3] + this.buffer[n2]);
                }
            }
            return n;
        }
        if (this.predictor >= 10 && this.predictor <= 15) {
            int n = this.predictor;
            int n4 = this.in.read();
            if (n4 < 0) {
                return -1;
            }
            n = n4 + 10;
            int n5 = this.fillBufferFromInputStream();
            if (n5 <= 0) {
                return -1;
            }
            for (int i = 0; i < n5 && n != 10; ++i) {
                int n6;
                int n7;
                int n8;
                int n9;
                if (n == 11) {
                    if (i - this.bpp < 0) continue;
                    int n10 = i;
                    this.buffer[n10] = (byte)(this.buffer[n10] + this.buffer[i - this.bpp]);
                    continue;
                }
                if (n == 12) {
                    if (this.aboveBuffer == null) continue;
                    int n11 = i;
                    this.buffer[n11] = (byte)(this.buffer[n11] + this.aboveBuffer[i]);
                    continue;
                }
                if (n == 13) {
                    n9 = 0;
                    if (i - this.bpp >= 0) {
                        n9 = this.buffer[i - this.bpp] & 0xFF;
                    }
                    n8 = 0;
                    if (this.aboveBuffer != null) {
                        n8 = this.aboveBuffer[i] & 0xFF;
                    }
                    n7 = n9 + n8;
                    n6 = n7 >>> 1 & 0xFF;
                    int n12 = i;
                    this.buffer[n12] = (byte)(this.buffer[n12] + n6);
                    continue;
                }
                if (n != 14) continue;
                n9 = 0;
                if (i - this.bpp >= 0) {
                    n9 = this.buffer[i - this.bpp] & 0xFF;
                }
                n8 = 0;
                if (this.aboveBuffer != null) {
                    n8 = this.aboveBuffer[i] & 0xFF;
                }
                n7 = 0;
                if (i - this.bpp >= 0 && this.aboveBuffer != null) {
                    n7 = this.aboveBuffer[i - this.bpp] & 0xFF;
                }
                n6 = n9 + n8 - n7;
                int n13 = Math.abs(n6 - n9);
                int n14 = Math.abs(n6 - n8);
                int n15 = Math.abs(n6 - n7);
                int n16 = n13 <= n14 && n13 <= n15 ? n9 : (n14 <= n15 ? n8 : n7);
                int n17 = i;
                this.buffer[n17] = (byte)(this.buffer[n17] + (byte)(n16 & 0xFF));
            }
            return n5;
        }
        return -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(", orig: ");
        if (this.originalInputKeptSolelyForDebugging == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.originalInputKeptSolelyForDebugging.toString());
        }
        return stringBuffer.toString();
    }
}

