/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.functions.Function;
import org.icepdf.core.pobjects.graphics.DeviceN;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.ShadingPattern;
import org.icepdf.core.pobjects.graphics.batik.ext.awt.LinearGradientPaint;
import org.icepdf.core.pobjects.graphics.batik.ext.awt.MultipleGradientPaint;
import org.icepdf.core.util.Library;

public class ShadingType2Pattern
extends ShadingPattern {
    private static final Logger logger = Logger.getLogger(ShadingType2Pattern.class.toString());
    protected Function function;
    protected Vector<Float> domain;
    protected Vector coords;
    protected Vector<Boolean> extend;
    private LinearGradientPaint linearGradientPaint;

    public ShadingType2Pattern(Library library, Hashtable hashtable) {
        super(library, hashtable);
    }

    public synchronized void init() {
        if (this.inited) {
            return;
        }
        if (this.shading == null) {
            this.shading = this.library.getDictionary(this.entries, "Shading");
        }
        this.shadingType = this.library.getInt(this.shading, "ShadingType");
        this.bBox = this.library.getRectangle(this.shading, "BBox");
        this.colorSpace = PColorSpace.getColorSpace(this.library, this.library.getObject(this.shading, "ColorSpace"));
        if (this.library.getObject(this.shading, "Background") != null && this.library.getObject(this.shading, "Background") instanceof Vector) {
            this.background = (Vector)this.library.getObject(this.shading, "Background");
        }
        this.antiAlias = this.library.getBoolean(this.shading, "AntiAlias");
        if (this.library.getObject(this.shading, "Domain") instanceof Vector) {
            this.domain = (Vector)this.library.getObject(this.shading, "Domain");
        } else {
            this.domain = new Vector(2);
            this.domain.add(new Float(0.0));
            this.domain.add(new Float(1.0));
        }
        if (this.library.getObject(this.shading, "Coords") instanceof Vector) {
            this.coords = (Vector)this.library.getObject(this.shading, "Coords");
        }
        if (this.library.getObject(this.shading, "Extend") instanceof Vector) {
            this.extend = (Vector)this.library.getObject(this.shading, "Extend");
        } else {
            this.extend = new Vector(2);
            this.extend.add(false);
            this.extend.add(false);
        }
        Object object = this.library.getObject(this.shading, "Function");
        if (object != null) {
            this.function = Function.getFunction(this.library, object);
        }
        float f = ((Number)this.domain.get(0)).floatValue();
        float f2 = ((Number)this.domain.get(1)).floatValue();
        Point2D.Float float_ = new Point2D.Float(((Number)this.coords.get(0)).floatValue(), ((Number)this.coords.get(1)).floatValue());
        Point2D.Float float_2 = new Point2D.Float(((Number)this.coords.get(2)).floatValue(), ((Number)this.coords.get(3)).floatValue());
        Point2D.Float float_3 = new Point2D.Float((float_2.x + float_.x) / 2.0f, (float_2.y + float_.y) / 2.0f);
        Point2D.Float float_4 = new Point2D.Float((float_3.x + float_.x) / 2.0f, (float_3.y + float_.y) / 2.0f);
        Point2D.Float float_5 = new Point2D.Float((float_2.x + float_3.x) / 2.0f, (float_2.y + float_3.y) / 2.0f);
        Color color = this.calculateColour(this.colorSpace, float_, float_, float_2, f, f2);
        Color color2 = this.calculateColour(this.colorSpace, float_2, float_, float_2, f, f2);
        Color color3 = this.calculateColour(this.colorSpace, float_3, float_, float_2, f, f2);
        if (color == null || color2 == null || color3 == null) {
            return;
        }
        float[] fArray = new float[]{f, f2 / 2.0f, f2};
        Color[] colorArray = new Color[]{color, color3, color2};
        this.linearGradientPaint = new LinearGradientPaint(float_, float_2, fArray, colorArray, MultipleGradientPaint.NO_CYCLE, MultipleGradientPaint.LINEAR_RGB, this.matrix);
        this.inited = true;
    }

    private Color calculateColour(PColorSpace pColorSpace, Point2D.Float float_, Point2D.Float float_2, Point2D.Float float_3, float f, float f2) {
        float f3 = this.linearMapping(float_, float_2, float_3);
        float f4 = this.parametrixValue(f3, f, f2, this.extend);
        float[] fArray = new float[]{f4};
        if (this.function != null) {
            float[] fArray2 = this.function.calculate(fArray);
            if (fArray2 != null) {
                if (!(pColorSpace instanceof DeviceN)) {
                    fArray2 = PColorSpace.reverse(fArray2);
                }
                return pColorSpace.getColor(fArray2);
            }
            return null;
        }
        logger.fine("Error processing Shading Type 2 Pattern.");
        return null;
    }

    private float linearMapping(Point2D.Float float_, Point2D.Float float_2, Point2D.Float float_3) {
        float f = float_.x;
        float f2 = float_.y;
        float f3 = float_2.x;
        float f4 = float_2.y;
        float f5 = float_3.x;
        float f6 = float_3.y;
        float f7 = (f5 - f3) * (f - f3) + (f6 - f4) * (f2 - f4);
        float f8 = (f5 - f3) * (f5 - f3) + (f6 - f4) * (f6 - f4);
        return f7 / f8;
    }

    private float parametrixValue(float f, float f2, float f3, Vector vector) {
        if (f < 0.0f && ((Boolean)vector.get(0)).booleanValue()) {
            return f2;
        }
        if (f > 1.0f && ((Boolean)vector.get(1)).booleanValue()) {
            return f3;
        }
        return f2 + (f3 - f2) * f;
    }

    public Paint getPaint() {
        this.init();
        return this.linearGradientPaint;
    }

    public String toString() {
        return super.toString() + "\n                    domain: " + this.domain + "\n                    coords: " + this.coords + "\n                    extend: " + this.extend + "\n                 function: " + this.function;
    }
}

