/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import java.util.HashMap;
import org.h2.constraint.Constraint;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.SchemaObject;
import org.h2.engine.Sequence;
import org.h2.engine.Session;
import org.h2.engine.TriggerObject;
import org.h2.engine.User;
import org.h2.index.Index;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.table.Table;
import org.h2.util.ObjectArray;

public class Schema
extends DbObject {
    private User owner;
    private boolean system;
    private HashMap tablesAndViews = new HashMap();
    private HashMap indexes = new HashMap();
    private HashMap sequences = new HashMap();
    private HashMap triggers = new HashMap();
    private HashMap constraints = new HashMap();

    public Schema(Database database, int id, String schemaName, User owner, boolean system) {
        super(database, id, schemaName, "schema");
        this.owner = owner;
        this.system = system;
    }

    public String getCreateSQLForCopy(Table table, String quotedTable, String quotedName) {
        throw Message.internal();
    }

    public String getCreateSQL() {
        if (this.system) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE SCHEMA ");
        buff.append(this.getSQL());
        buff.append(" AUTHORIZATION ");
        buff.append(this.owner.getSQL());
        return buff.toString();
    }

    public int getType() {
        return 10;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        SchemaObject obj;
        if (this.triggers != null && this.triggers.size() > 0) {
            obj = (TriggerObject)this.triggers.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        if (this.constraints != null && this.constraints.size() > 0) {
            obj = (Constraint)this.constraints.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        if (this.tablesAndViews != null && this.tablesAndViews.size() > 0) {
            obj = (Table)this.tablesAndViews.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        if (this.indexes != null && this.indexes.size() > 0) {
            obj = (Index)this.indexes.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        if (this.sequences != null && this.sequences.size() > 0) {
            obj = (Sequence)this.sequences.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        this.owner = null;
        this.invalidate();
    }

    public void checkRename() throws SQLException {
    }

    public User getOwner() {
        return this.owner;
    }

    private HashMap getMap(int type) {
        switch (type) {
            case 0: {
                return this.tablesAndViews;
            }
            case 3: {
                return this.sequences;
            }
            case 1: {
                return this.indexes;
            }
            case 4: {
                return this.triggers;
            }
            case 5: {
                return this.constraints;
            }
        }
        throw Message.internal("type=" + type);
    }

    public void add(SchemaObject obj) throws SQLException {
        if (Constants.CHECK && obj.getSchema() != this) {
            throw Message.internal("wrong schema");
        }
        String name = obj.getName();
        HashMap map = this.getMap(obj.getType());
        if (Constants.CHECK && map.get(name) != null) {
            throw Message.internal("object already exists");
        }
        map.put(name, obj);
    }

    public void rename(SchemaObject obj, String newName) throws SQLException {
        int type = obj.getType();
        HashMap map = this.getMap(type);
        if (Constants.CHECK) {
            if (!map.containsKey(obj.getName())) {
                throw Message.internal("not found: " + obj.getName());
            }
            if (obj.getName().equals(newName) || map.containsKey(newName)) {
                throw Message.internal("object already exists: " + newName);
            }
        }
        map.remove(obj.getName());
        obj.rename(newName);
        map.put(newName, obj);
    }

    public Table findTableOrView(Session session, String name) {
        Table table = (Table)this.tablesAndViews.get(name);
        if (table == null && session != null) {
            table = session.findLocalTempTable(name);
        }
        return table;
    }

    public Index findIndex(String name) {
        return (Index)this.indexes.get(name);
    }

    public TriggerObject findTrigger(String name) {
        return (TriggerObject)this.triggers.get(name);
    }

    public Sequence findSequence(String sequenceName) {
        return (Sequence)this.sequences.get(sequenceName);
    }

    public Constraint findConstraint(String constraintName) {
        return (Constraint)this.constraints.get(constraintName);
    }

    private String getUniqueName(HashMap map, String prefix) {
        int i = 0;
        String name;
        while (map.get(name = prefix + i) != null) {
            ++i;
        }
        return name;
    }

    public String getUniqueConstraintName() {
        return this.getUniqueName(this.constraints, "CONSTRAINT_");
    }

    public String getUniqueIndexName(String prefix) {
        return this.getUniqueName(this.indexes, prefix);
    }

    public Table getTableOrView(Session session, String name) throws SQLException {
        Table table = (Table)this.tablesAndViews.get(name);
        if (table == null && session != null) {
            table = session.findLocalTempTable(name);
        }
        if (table == null) {
            throw Message.getSQLException(42102, name);
        }
        return table;
    }

    public Index getIndex(String name) throws JdbcSQLException {
        Index index = (Index)this.indexes.get(name);
        if (index == null) {
            throw Message.getSQLException(42112, name);
        }
        return index;
    }

    public Constraint getConstraint(String name) throws SQLException {
        Constraint constraint = (Constraint)this.constraints.get(name);
        if (constraint == null) {
            throw Message.getSQLException(90057, name);
        }
        return constraint;
    }

    public Sequence getSequence(String sequenceName) throws SQLException {
        Sequence sequence = (Sequence)this.sequences.get(sequenceName);
        if (sequence == null) {
            throw Message.getSQLException(90036, sequenceName);
        }
        return sequence;
    }

    public ObjectArray getAll(int type) {
        HashMap map = this.getMap(type);
        return new ObjectArray(map.values());
    }

    public void remove(SchemaObject obj) {
        String objName = obj.getName();
        HashMap map = this.getMap(obj.getType());
        if (Constants.CHECK && !map.containsKey(objName)) {
            throw Message.internal("not found: " + objName);
        }
        map.remove(objName);
    }
}

