/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.SessionInterface;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.Function;
import org.h2.expression.ValueExpression;
import org.h2.index.IndexCondition;
import org.h2.message.Message;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class Comparison
extends Condition {
    public static final int EQUAL = 0;
    public static final int BIGGER_EQUAL = 1;
    public static final int BIGGER = 2;
    public static final int SMALLER_EQUAL = 3;
    public static final int SMALLER = 4;
    public static final int NOT_EQUAL = 5;
    public static final int IS_NULL = 6;
    public static final int IS_NOT_NULL = 7;
    public static final int FALSE = 8;
    private Expression left;
    private Expression right;
    private int compareType;
    private int dataType = -1;
    private Session session;
    private Database database;

    public Comparison(Session session, int compareType, Expression left, Expression right) {
        this.session = session;
        this.database = session.getDatabase();
        this.left = left;
        this.right = right;
        this.compareType = compareType;
    }

    /*
     * WARNING - void declaration
     */
    public String getSQL() {
        void var1_1;
        switch (this.compareType) {
            case 0: {
                String sql = this.left.getSQL() + " = " + this.right.getSQL();
                break;
            }
            case 1: {
                String sql = this.left.getSQL() + " >= " + this.right.getSQL();
                break;
            }
            case 2: {
                String sql = this.left.getSQL() + " > " + this.right.getSQL();
                break;
            }
            case 3: {
                String sql = this.left.getSQL() + " <= " + this.right.getSQL();
                break;
            }
            case 4: {
                String sql = this.left.getSQL() + " < " + this.right.getSQL();
                break;
            }
            case 5: {
                String sql = this.left.getSQL() + " <> " + this.right.getSQL();
                break;
            }
            case 6: {
                String sql = this.left.getSQL() + " IS NULL";
                break;
            }
            case 7: {
                String sql = this.left.getSQL() + " IS NOT NULL";
                break;
            }
            default: {
                throw Message.internal("compareType=" + this.compareType);
            }
        }
        return "(" + (String)var1_1 + ")";
    }

    private Expression getCast(Expression expr, int dataType, long precision, int scale) throws SQLException {
        Function function = Function.getFunction(this.session.getDatabase(), "CAST");
        function.setParameter(0, expr);
        function.setDataType(dataType, precision, scale);
        return function;
    }

    public Expression optimize(Session session) throws SQLException {
        this.left = this.left.optimize(session);
        if (this.right == null) {
            this.dataType = this.left.getType();
        } else {
            this.right = this.right.optimize(session);
            this.dataType = Value.getHigherOrder(this.left.getType(), this.right.getType());
            if (this.dataType != this.left.getType()) {
                this.left = this.getCast(this.left, this.dataType, this.right.getPrecision(), this.right.getScale());
            }
            if (this.dataType != this.right.getType()) {
                this.right = this.getCast(this.right, this.dataType, this.left.getPrecision(), this.left.getScale());
            }
        }
        if (this.compareType == 6 || this.compareType == 7) {
            if (this.left.isConstant()) {
                return ValueExpression.get(this.getValue(session));
            }
        } else {
            if (Constants.CHECK && (this.left == null || this.right == null)) {
                throw Message.internal();
            }
            if (this.left == ValueExpression.NULL || this.right == ValueExpression.NULL) {
                return ValueExpression.NULL;
            }
            if (this.left.isConstant() && this.right.isConstant()) {
                return ValueExpression.get(this.getValue(session));
            }
        }
        return this;
    }

    public Value getValue(SessionInterface session) throws SQLException {
        Value l = this.left.getValue(session);
        if (this.right == null) {
            boolean result;
            switch (this.compareType) {
                case 6: {
                    result = l == ValueNull.INSTANCE;
                    break;
                }
                case 7: {
                    result = l != ValueNull.INSTANCE;
                    break;
                }
                default: {
                    throw Message.internal("type=" + this.compareType);
                }
            }
            return ValueBoolean.get(result);
        }
        l = l.convertTo(this.dataType);
        Value r = this.right.getValue(session).convertTo(this.dataType);
        if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        boolean result = Comparison.compareNotNull(this.database, l, r, this.compareType);
        return ValueBoolean.get(result);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean compareNotNull(Database database, Value l, Value r, int compareType) throws SQLException {
        void var4_4;
        switch (compareType) {
            case 0: {
                boolean result = database.areEqual(l, r);
                break;
            }
            case 5: {
                boolean result = !database.areEqual(l, r);
                break;
            }
            case 1: {
                boolean result = database.compare(l, r) >= 0;
                break;
            }
            case 2: {
                boolean result = database.compare(l, r) > 0;
                break;
            }
            case 3: {
                boolean result = database.compare(l, r) <= 0;
                break;
            }
            case 4: {
                boolean result = database.compare(l, r) < 0;
                break;
            }
            default: {
                throw Message.internal("type=" + compareType);
            }
        }
        return (boolean)var4_4;
    }

    private int getReversedCompareType(int type) {
        switch (this.compareType) {
            case 0: 
            case 5: {
                return type;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        throw Message.internal("type=" + this.compareType);
    }

    public void mapColumns(TableFilter tableFilter, int level) throws SQLException {
        this.left.mapColumns(tableFilter, level);
        if (this.right != null) {
            this.right.mapColumns(tableFilter, level);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createIndexConditions(TableFilter filter) {
        void var4_4;
        if (this.right == null) {
            return;
        }
        ExpressionColumn l = null;
        if (this.left instanceof ExpressionColumn && filter != (l = (ExpressionColumn)this.left).getTableFilter()) {
            l = null;
        }
        ExpressionColumn r = null;
        if (this.right instanceof ExpressionColumn && filter != (r = (ExpressionColumn)this.right).getTableFilter()) {
            r = null;
        }
        if (l == null && r == null) {
            return;
        }
        if (l != null && r != null) {
            return;
        }
        switch (this.compareType) {
            case 5: {
                boolean addIndex = false;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                boolean addIndex = true;
                break;
            }
            default: {
                throw Message.internal("type=" + this.compareType);
            }
        }
        if (var4_4 != false) {
            if (l != null) {
                filter.addIndexCondition(new IndexCondition(this.compareType, l, this.right));
            } else if (r != null) {
                int compareRev = this.getReversedCompareType(this.compareType);
                filter.addIndexCondition(new IndexCondition(compareRev, r, this.left));
            }
        }
    }

    public boolean isEvaluatable(int filterLevel) {
        if (this.right == null) {
            return this.left.isEvaluatable(filterLevel);
        }
        return this.left.isEvaluatable(filterLevel) && this.right.isEvaluatable(filterLevel);
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        if (this.right != null) {
            this.right.setEvaluatable(tableFilter, b);
        }
    }

    public void updateAggregate(Session session) throws SQLException {
        this.left.updateAggregate(session);
        if (this.right != null) {
            this.right.updateAggregate(session);
        }
    }
}

