/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Properties;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.InternalException;
import org.h2.message.TraceSystem;
import org.h2.util.Resources;
import org.h2.util.StringUtils;

public class Message {
    private static final Properties MESSAGES = new Properties();
    public static final int NO_DATA_AVAILABLE = 2000;
    public static final int INVALID_PARAMETER_COUNT = 7001;
    public static final int ERROR_OPENING_DATABASE = 8000;
    public static final int WRONG_USER_OR_PASSWORD = 8004;
    public static final int COLUMN_COUNT_DOES_NOT_MATCH = 21002;
    public static final int NUMERIC_VALUE_OUT_OF_RANGE = 22003;
    public static final int DIVISION_BY_ZERO = 22012;
    public static final int LIKE_ESCAPE_ERROR = 22025;
    public static final int CHECK_CONSTRAINT_VIOLATED_1 = 23000;
    public static final int DUPLICATE_KEY_1 = 23001;
    public static final int SYNTAX_ERROR_1 = 42000;
    public static final int SYNTAX_ERROR_2 = 42001;
    public static final int TABLE_OR_VIEW_ALREADY_EXISTS_1 = 42101;
    public static final int TABLE_OR_VIEW_NOT_FOUND_1 = 42102;
    public static final int INDEX_ALREADY_EXISTS_1 = 42111;
    public static final int INDEX_NOT_FOUND_1 = 42112;
    public static final int DUPLICATE_COLUMN_NAME_1 = 42121;
    public static final int COLUMN_NOT_FOUND_1 = 42122;
    public static final int SETTING_NOT_FOUND_1 = 42132;
    public static final int GENERAL_ERROR_1 = 50000;
    public static final int UNKNOWN_DATA_TYPE_1 = 50004;
    public static final int FEATURE_NOT_SUPPORTED = 50100;
    public static final int LOCK_TIMEOUT_1 = 50200;
    public static final int FUNCTION_MUST_RETURN_RESULT_SET_1 = 90001;
    public static final int METHOD_NOT_ALLOWED_FOR_QUERY = 90002;
    public static final int METHOD_ONLY_ALLOWED_FOR_QUERY = 90003;
    public static final int HEX_STRING_ODD_1 = 90004;
    public static final int HEX_STRING_WRONG_1 = 90005;
    public static final int VALUE_TOO_LONG_1 = 90006;
    public static final int NULL_NOT_ALLOWED = 90007;
    public static final int OBJECT_CLOSED = 90008;
    public static final int INVALID_VALUE_2 = 90009;
    public static final int DATE_CONSTANT_1 = 90010;
    public static final int TIMESTAMP_CONSTANT_1 = 90011;
    public static final int PARAMETER_NOT_SET_1 = 90012;
    public static final int DATABASE_NOT_FOUND_1 = 90013;
    public static final int PARSE_ERROR_1 = 90014;
    public static final int SUM_OR_AVG_ON_WRONG_DATATYPE = 90015;
    public static final int MUST_GROUP_BY_COLUMN_1 = 90016;
    public static final int SECOND_PRIMARY_KEY = 90017;
    public static final int TRACE_CONNECTION_NOT_CLOSED = 90018;
    public static final int CANT_DROP_CURRENT_USER = 90019;
    public static final int DATABASE_ALREADY_OPEN_1 = 90020;
    public static final int DATA_CONVERSION_ERROR_1 = 90021;
    public static final int FUNCTION_NOT_FOUND_1 = 90022;
    public static final int COLUMN_MUST_NOT_BE_NULLABLE_1 = 90023;
    public static final int FILE_RENAME_FAILED_2 = 90024;
    public static final int FILE_DELETE_FAILED_1 = 90025;
    public static final int SERIALIZATION_FAILED = 90026;
    public static final int DESERIALIZATION_FAILED = 90027;
    public static final int IO_EXCEPTION = 90028;
    public static final int NOT_ON_UPDATABLE_ROW = 90029;
    public static final int FILE_CORRUPTED_1 = 90030;
    public static final int CONNECTION_NOT_CLOSED = 90031;
    public static final int USER_NOT_FOUND_1 = 90032;
    public static final int USER_ALREADY_EXISTS_1 = 90033;
    public static final int LOG_FILE_ERROR_1 = 90034;
    public static final int SEQUENCE_ALREADY_EXISTS_1 = 90035;
    public static final int SEQUENCE_NOT_FOUND_1 = 90036;
    public static final int VIEW_NOT_FOUND_1 = 90037;
    public static final int VIEW_ALREADY_EXISTS_1 = 90038;
    public static final int VALUE_TOO_LARGE_FOR_PRECISION_1 = 90039;
    public static final int ADMIN_RIGHTS_REQUIRED = 90040;
    public static final int TRIGGER_ALREADY_EXISTS_1 = 90041;
    public static final int TRIGGER_NOT_FOUND_1 = 90042;
    public static final int ERROR_CREATING_TRIGGER_OBJECT_2 = 90043;
    public static final int ERROR_EXECUTING_TRIGGER_2 = 90044;
    public static final int CONSTRAINT_ALREADY_EXISTS_1 = 90045;
    public static final int URL_FORMAT_ERROR_2 = 90046;
    public static final int DRIVER_VERSION_ERROR_2 = 90047;
    public static final int FILE_VERSION_ERROR_1 = 90048;
    public static final int FILE_ENCRYPTION_ERROR = 90049;
    public static final int WRONG_PASSWORD_FORMAT = 90050;
    public static final int STATEMENT_WAS_CANCELLED = 90051;
    public static final int SUBQUERY_IS_NOT_SINGLE_COLUMN = 90052;
    public static final int SCALAR_SUBQUERY_CONTAINS_TOO_MANY_ROWS = 90053;
    public static final int SCALAR_SUBQUERY_CONTAINS_NO_ROWS = 90054;
    public static final int UNSUPPORTED_CIPHER = 90055;
    public static final int NO_DEFAULT_SET_1 = 90056;
    public static final int CONSTRAINT_NOT_FOUND_1 = 90057;
    public static final int DUPLICATE_TABLE_ALIAS = 90058;
    public static final int AMBIGUOUS_COLUMN_NAME_1 = 90059;
    public static final int UNSUPPORTED_LOCK_METHOD_1 = 90060;
    public static final int EXCEPTION_OPENING_PORT_1 = 90061;
    public static final int FILE_CREATION_FAILED_1 = 90062;
    public static final int SAVEPOINT_IS_INVALID = 90063;
    public static final int SAVEPOINT_IS_UNNAMED = 90064;
    public static final int SAVEPOINT_IS_NAMED = 90065;
    public static final int DUPLICATE_PROPERTY_1 = 90066;
    public static final int CONNECTION_BROCKEN = 90067;
    public static final int ORDER_BY_NOT_IN_RESULT = 90068;
    public static final int ROLE_ALREADY_EXISTS_1 = 90069;
    public static final int ROLE_NOT_FOUND_1 = 90070;
    public static final int USER_OR_ROLE_NOT_FOUND_1 = 90071;
    public static final int ROLES_AND_RIGHT_CANNOT_BE_MIXED = 90072;
    public static final int RIGHT_NOT_FOUND = 90073;
    public static final int ROLE_ALREADY_GRANTED_1 = 90074;
    public static final int COLUMN_IS_PART_OF_INDEX_1 = 90075;
    public static final int FUNCTION_ALIAS_ALREADY_EXISTS_1 = 90076;
    public static final int FUNCTION_ALIAS_NOT_FOUND_1 = 90077;
    public static final int SCHEMA_ALREADY_EXISTS_1 = 90078;
    public static final int SCHEMA_NOT_FOUND_1 = 90079;
    public static final int SCHEMA_NAME_MUST_MATCH = 90080;
    public static final int COLUMN_CONTAINS_NULL_VALUES_1 = 90081;
    public static final int SEQUENCE_BELONGS_TO_A_TABLE_1 = 90082;
    public static final int COLUMN_MAY_BE_REFERENCED_1 = 90083;
    public static final int CANT_DROP_LAST_COLUMN = 90084;
    public static final int INDEX_BELONGS_TO_CONSTRAINT_1 = 90085;
    public static final int CLASS_NOT_FOUND = 90086;
    public static final int METHOD_NOT_FOUND = 90087;
    public static final int UNKNOWN_MODE = 90088;
    public static final int COLLATION_CHANGE_WITH_DATA_TABLE_1 = 90089;
    public static final int SCHEMA_CAN_NOT_BE_DROPPED_1 = 90090;
    public static final int ROLE_CAN_NOT_BE_DROPPED_1 = 90091;
    public static final int UNSUPPORTED_JAVA_VERSION = 90092;
    public static final int CLUSTER_ERROR_DATABASE_RUNS_ALONE = 90093;
    public static final int CLUSTER_ERROR_DATABASE_RUNS_CLUSTERED_1 = 90094;
    public static final int STRING_FORMAT_ERROR_1 = 90095;
    public static final int NOT_ENOUGH_RIGHTS_FOR_1 = 90096;
    public static final int DATABASE_IS_READ_ONLY = 90097;
    public static final int SIMULATED_POWER_OFF = 90098;
    public static final int ERROR_SETTING_DATABASE_EVENT_LISTENER = 90099;
    public static final int NO_DISK_SPACE_AVAILABLE = 90100;
    public static final int WRONG_XID_FORMAT_1 = 90101;
    public static final int UNSUPPORTED_COMPRESSION_OPTIONS_1 = 90102;
    public static final int UNSUPPORTED_COMPRESSION_ALGORITHM_1 = 90103;
    public static final int COMPRESSION_ERROR = 90104;
    private static final int EXCEPTION_IN_FUNCTION = 90105;
    public static final int CANT_TRUNCATE = 90106;
    public static final int CANT_DROP_2 = 90107;

    public static JdbcSQLException getSQLException(int sqlstate, String p1) {
        return Message.getSQLException(sqlstate, new String[]{p1}, null);
    }

    public static String translate(String key, String[] param) {
        String message = MESSAGES.getProperty(key);
        if (message == null) {
            message = "(Message " + key + " not found)";
        }
        if (param != null) {
            Object[] o = param;
            message = MessageFormat.format(message, o);
        }
        return message;
    }

    public static JdbcSQLException getSQLException(int errorCode, String[] param, Throwable cause) {
        String sqlstate = Message.getState(errorCode);
        String message = Message.translate(sqlstate, param);
        return new JdbcSQLException(message, sqlstate, errorCode, cause);
    }

    public static SQLException getSyntaxError(String sql, int index) {
        sql = StringUtils.addAsterix(sql, index);
        return Message.getSQLException(42000, sql);
    }

    public static SQLException getSyntaxError(String sql, int index, String expected) {
        sql = StringUtils.addAsterix(sql, index);
        return Message.getSQLException(42001, new String[]{sql, expected}, null);
    }

    public static JdbcSQLException getSQLException(int sqlstate) {
        return Message.getSQLException(sqlstate, null);
    }

    public static JdbcSQLException getUnsupportedException() {
        return Message.getSQLException(50100);
    }

    public static JdbcSQLException getInvalidValueException(String value, String param) {
        return Message.getSQLException(90009, new String[]{value, param}, null);
    }

    public static Error internal(String s) {
        Error e = new Error(s);
        TraceSystem.traceThrowable(e);
        return e;
    }

    public static Error internal(String s, Exception e) {
        Error e2 = new Error(s, e);
        TraceSystem.traceThrowable(e2);
        return e2;
    }

    private static String getState(int errorCode) {
        switch (errorCode) {
            case 2000: {
                return "02000";
            }
            case 7001: {
                return "07001";
            }
            case 8000: {
                return "08000";
            }
            case 8004: {
                return "08004";
            }
            case 21002: {
                return "21S02";
            }
            case 22003: {
                return "22003";
            }
            case 22012: {
                return "22012";
            }
            case 22025: {
                return "22025";
            }
            case 23000: {
                return "23000";
            }
            case 23001: {
                return "23001";
            }
            case 42000: {
                return "42000";
            }
            case 42001: {
                return "42001";
            }
            case 42101: {
                return "42S01";
            }
            case 42102: {
                return "42S02";
            }
            case 42111: {
                return "42S11";
            }
            case 42112: {
                return "42S12";
            }
            case 42121: {
                return "42S21";
            }
            case 42122: {
                return "42S22";
            }
            case 42132: {
                return "42S32";
            }
            case 50000: {
                return "HY000";
            }
            case 50004: {
                return "HY004";
            }
            case 50100: {
                return "HYC00";
            }
            case 50200: {
                return "HYT00";
            }
        }
        return "" + errorCode;
    }

    public static SQLException convert(Throwable e) {
        if (e instanceof SQLException) {
            return (SQLException)e;
        }
        if (e instanceof InvocationTargetException) {
            InvocationTargetException ite = (InvocationTargetException)e;
            Throwable t = ite.getTargetException();
            if (t instanceof SQLException) {
                return (SQLException)t;
            }
            return Message.getSQLException(90105, null, e);
        }
        if (e instanceof IOException) {
            return Message.getSQLException(90028, null, e);
        }
        return Message.getSQLException(50000, new String[]{e.toString()}, e);
    }

    public static Error internal() {
        return Message.internal("unexpected code path");
    }

    public static InternalException convertToInternal(Exception e) {
        return new InternalException(e);
    }

    public static IOException convertToIOException(SQLException e) {
        IOException io = new IOException(e.toString());
        io.fillInStackTrace();
        return io;
    }

    static {
        try {
            byte[] messages = Resources.get("/org/h2/res/messages.properties");
            if (messages != null) {
                MESSAGES.load(new ByteArrayInputStream(messages));
            }
        }
        catch (IOException e) {
            TraceSystem.traceThrowable(e);
        }
    }
}

