/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.bench;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.HashMap;
import org.h2.test.bench.BenchC;
import org.h2.test.bench.BenchCRandom;
import org.h2.test.bench.Database;

public class BenchCThread {
    private Database db;
    private int warehouseId;
    private int terminalId;
    private HashMap prepared = new HashMap();
    private static final int OP_NEW_ORDER = 0;
    private static final int OP_PAYMENT = 1;
    private static final int OP_ORDER_STATUS = 2;
    private static final int OP_DELIVERY = 3;
    private static final int OP_STOCK_LEVEL = 4;
    private static final BigDecimal ONE = new BigDecimal("1");
    private BenchCRandom random;
    private BenchC bench;

    BenchCThread(Database db, BenchC bench, BenchCRandom random, int terminal) throws Exception {
        this.db = db;
        this.bench = bench;
        this.terminalId = terminal;
        db.setAutoCommit(false);
        this.random = random;
        this.warehouseId = random.getInt(1, bench.warehouses);
    }

    void process() throws Exception {
        int i;
        int[] deck = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 4};
        int len = deck.length;
        for (i = 0; i < len; ++i) {
            int temp = deck[i];
            int j = this.random.getInt(0, len);
            deck[i] = deck[j];
            deck[j] = temp;
        }
        block8: for (i = 0; i < len; ++i) {
            int op = deck[i];
            switch (op) {
                case 0: {
                    this.processNewOrder();
                    continue block8;
                }
                case 1: {
                    this.processPayment();
                    continue block8;
                }
                case 2: {
                    this.processOrderStatus();
                    continue block8;
                }
                case 3: {
                    this.processDelivery();
                    continue block8;
                }
                case 4: {
                    this.processStockLevel();
                    continue block8;
                }
                default: {
                    throw new Error("op=" + op);
                }
            }
        }
    }

    private void processNewOrder() throws Exception {
        int d_id = this.random.getInt(1, this.bench.districtsPerWarehouse);
        int c_id = this.random.getNonUniform(1023, 1, this.bench.customersPerDistrict);
        int o_ol_cnt = this.random.getInt(5, 15);
        boolean rollback = this.random.getInt(1, 100) == 1;
        int[] supply_w_id = new int[o_ol_cnt];
        int[] item_id = new int[o_ol_cnt];
        int[] quantity = new int[o_ol_cnt];
        int o_all_local = 1;
        for (int i = 0; i < o_ol_cnt; ++i) {
            int w;
            if (this.bench.warehouses > 1 && this.random.getInt(1, 100) == 1) {
                while ((w = this.random.getInt(1, this.bench.warehouses)) != this.warehouseId) {
                }
                o_all_local = 0;
            } else {
                w = this.warehouseId;
            }
            supply_w_id[i] = w;
            int item = rollback && i == o_ol_cnt - 1 ? -1 : this.random.getNonUniform(8191, 1, this.bench.items);
            item_id[i] = item;
            quantity[i] = this.random.getInt(1, 10);
        }
        char[] bg = new char[o_ol_cnt];
        int[] stock = new int[o_ol_cnt];
        BigDecimal[] amt = new BigDecimal[o_ol_cnt];
        Timestamp datetime = new Timestamp(System.currentTimeMillis());
        PreparedStatement prep = this.prepare("UPDATE DISTRICT SET D_NEXT_O_ID=D_NEXT_O_ID+1 WHERE D_ID=? AND D_W_ID=?");
        prep.setInt(1, d_id);
        prep.setInt(2, this.warehouseId);
        this.db.update(prep);
        prep = this.prepare("SELECT D_NEXT_O_ID, D_TAX FROM DISTRICT WHERE D_ID=? AND D_W_ID=?");
        prep.setInt(1, d_id);
        prep.setInt(2, this.warehouseId);
        ResultSet rs = this.db.query(prep);
        rs.next();
        int o_id = rs.getInt(1) - 1;
        BigDecimal d_tax = rs.getBigDecimal(2);
        rs.close();
        prep = this.prepare("SELECT C_DISCOUNT, C_LAST, C_CREDIT, W_TAX FROM CUSTOMER, WAREHOUSE WHERE C_ID=? AND C_W_ID=? AND C_W_ID=W_ID AND C_D_ID=?");
        prep.setInt(1, c_id);
        prep.setInt(2, this.warehouseId);
        prep.setInt(3, d_id);
        rs = this.db.query(prep);
        rs.next();
        BigDecimal c_discount = rs.getBigDecimal(1);
        rs.getString(2);
        rs.getString(3);
        BigDecimal w_tax = rs.getBigDecimal(4);
        rs.close();
        BigDecimal total = new BigDecimal("0");
        for (int ol_number = 1; ol_number <= o_ol_cnt; ++ol_number) {
            int ol_i_id = item_id[ol_number - 1];
            int ol_supply_w_id = supply_w_id[ol_number - 1];
            int ol_quantity = quantity[ol_number - 1];
            prep = this.prepare("SELECT I_PRICE, I_NAME, I_DATA FROM ITEM WHERE I_ID=?");
            prep.setInt(1, ol_i_id);
            rs = this.db.query(prep);
            if (!rs.next()) {
                if (rollback) {
                    this.db.rollback();
                    return;
                }
                throw new Exception("item not found: " + ol_i_id + " " + ol_supply_w_id);
            }
            BigDecimal i_price = rs.getBigDecimal(1);
            rs.getString(2);
            String i_data = rs.getString(3);
            rs.close();
            prep = this.prepare("SELECT S_QUANTITY, S_DATA, S_DIST_01, S_DIST_02, S_DIST_03, S_DIST_04, S_DIST_05, S_DIST_06, S_DIST_07, S_DIST_08, S_DIST_09, S_DIST_10 FROM STOCK WHERE S_I_ID=? AND S_W_ID=?");
            prep.setInt(1, ol_i_id);
            prep.setInt(2, ol_supply_w_id);
            rs = this.db.query(prep);
            if (!rs.next()) {
                if (rollback) {
                    this.db.rollback();
                    return;
                }
                throw new Exception("item not found: " + ol_i_id + " " + ol_supply_w_id);
            }
            int s_quantity = rs.getInt(1);
            String s_data = rs.getString(2);
            String[] s_dist = new String[10];
            for (int i = 0; i < 10; ++i) {
                s_dist[i] = rs.getString(3 + i);
            }
            rs.close();
            String ol_dist_info = s_dist[d_id - 1];
            stock[ol_number - 1] = s_quantity;
            bg[ol_number - 1] = i_data.indexOf("original") != -1 && s_data.indexOf("original") != -1 ? 66 : 71;
            s_quantity = s_quantity > ol_quantity ? (s_quantity -= ol_quantity) : s_quantity - ol_quantity + 91;
            prep = this.prepare("UPDATE STOCK SET S_QUANTITY=? WHERE S_W_ID=? AND S_I_ID=?");
            prep.setInt(1, s_quantity);
            prep.setInt(2, ol_supply_w_id);
            prep.setInt(3, ol_i_id);
            this.db.update(prep);
            BigDecimal ol_amount = new BigDecimal((double)ol_quantity).multiply(i_price).multiply(ONE.add(w_tax).add(d_tax)).multiply(ONE.subtract(c_discount));
            amt[ol_number - 1] = ol_amount = ol_amount.setScale(2, 4);
            total = total.add(ol_amount);
            prep = this.prepare("INSERT INTO ORDER_LINE (OL_O_ID, OL_D_ID, OL_W_ID, OL_NUMBER, OL_I_ID, OL_SUPPLY_W_ID, OL_QUANTITY, OL_AMOUNT, OL_DIST_INFO) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            prep.setInt(1, o_id);
            prep.setInt(2, d_id);
            prep.setInt(3, this.warehouseId);
            prep.setInt(4, ol_number);
            prep.setInt(5, ol_i_id);
            prep.setInt(6, ol_supply_w_id);
            prep.setInt(7, ol_quantity);
            prep.setBigDecimal(8, ol_amount);
            prep.setString(9, ol_dist_info);
            this.db.update(prep);
        }
        prep = this.prepare("INSERT INTO ORDERS (O_ID, O_D_ID, O_W_ID, O_C_ID, O_ENTRY_D, O_OL_CNT, O_ALL_LOCAL) VALUES (?, ?, ?, ?, ?, ?, ?)");
        prep.setInt(1, o_id);
        prep.setInt(2, d_id);
        prep.setInt(3, this.warehouseId);
        prep.setInt(4, c_id);
        prep.setTimestamp(5, datetime);
        prep.setInt(6, o_ol_cnt);
        prep.setInt(7, o_all_local);
        this.db.update(prep);
        prep = this.prepare("INSERT INTO NEW_ORDER (NO_O_ID, NO_D_ID, NO_W_ID) VALUES (?, ?, ?)");
        prep.setInt(1, o_id);
        prep.setInt(2, d_id);
        prep.setInt(3, this.warehouseId);
        this.db.update(prep);
        this.db.commit();
    }

    private void processPayment() throws Exception {
        BigDecimal c_balance;
        String c_credit;
        String c_last;
        boolean byname;
        int c_d_id;
        int c_w_id;
        int d_id = this.random.getInt(1, this.bench.districtsPerWarehouse);
        if (this.bench.warehouses > 1 && this.random.getInt(1, 100) <= 15) {
            while ((c_w_id = this.random.getInt(1, this.bench.warehouses)) != this.warehouseId) {
            }
            c_d_id = this.random.getInt(1, this.bench.districtsPerWarehouse);
        } else {
            c_w_id = this.warehouseId;
            c_d_id = d_id;
        }
        int c_id = 1;
        if (this.random.getInt(1, 100) <= 60) {
            byname = true;
            c_last = this.random.getLastname(this.random.getNonUniform(255, 0, 999));
        } else {
            byname = false;
            c_last = "";
            c_id = this.random.getNonUniform(1023, 1, this.bench.customersPerDistrict);
        }
        BigDecimal h_amount = this.random.getBigDecimal(this.random.getInt(100, 500000), 2);
        Timestamp datetime = new Timestamp(System.currentTimeMillis());
        PreparedStatement prep = this.prepare("UPDATE DISTRICT SET D_YTD = D_YTD+? WHERE D_ID=? AND D_W_ID=?");
        prep.setBigDecimal(1, h_amount);
        prep.setInt(2, d_id);
        prep.setInt(3, this.warehouseId);
        this.db.update(prep);
        prep = this.prepare("UPDATE WAREHOUSE SET W_YTD=W_YTD+? WHERE W_ID=?");
        prep.setBigDecimal(1, h_amount);
        prep.setInt(2, this.warehouseId);
        this.db.update(prep);
        prep = this.prepare("SELECT W_STREET_1, W_STREET_2, W_CITY, W_STATE, W_ZIP, W_NAME FROM WAREHOUSE WHERE W_ID=?");
        prep.setInt(1, this.warehouseId);
        ResultSet rs = this.db.query(prep);
        rs.next();
        rs.getString(1);
        rs.getString(2);
        rs.getString(3);
        rs.getString(4);
        rs.getString(5);
        String w_name = rs.getString(6);
        rs.close();
        prep = this.prepare("SELECT D_STREET_1, D_STREET_2, D_CITY, D_STATE, D_ZIP, D_NAME FROM DISTRICT WHERE D_ID=? AND D_W_ID=?");
        prep.setInt(1, d_id);
        prep.setInt(2, this.warehouseId);
        rs = this.db.query(prep);
        rs.next();
        rs.getString(1);
        rs.getString(2);
        rs.getString(3);
        rs.getString(4);
        rs.getString(5);
        String d_name = rs.getString(6);
        rs.close();
        if (byname) {
            prep = this.prepare("SELECT COUNT(C_ID) FROM CUSTOMER WHERE C_LAST=? AND C_D_ID=? AND C_W_ID=?");
            prep.setString(1, c_last);
            prep.setInt(2, c_d_id);
            prep.setInt(3, c_w_id);
            rs = this.db.query(prep);
            rs.next();
            int namecnt = rs.getInt(1);
            rs.close();
            if (namecnt == 0) {
                this.db.rollback();
                return;
            }
            prep = this.prepare("SELECT C_FIRST, C_MIDDLE, C_ID, C_STREET_1, C_STREET_2, C_CITY, C_STATE, C_ZIP, C_PHONE, C_CREDIT, C_CREDIT_LIM, C_DISCOUNT, C_BALANCE, C_SINCE FROM CUSTOMER WHERE C_LAST=? AND C_D_ID=? AND C_W_ID=? ORDER BY C_FIRST");
            prep.setString(1, c_last);
            prep.setInt(2, c_d_id);
            prep.setInt(3, c_w_id);
            rs = this.db.query(prep);
            if (namecnt % 2 != 0) {
                ++namecnt;
            }
            for (int n = 0; n < namecnt / 2; ++n) {
                rs.next();
            }
            rs.getString(1);
            rs.getString(2);
            c_id = rs.getInt(3);
            rs.getString(4);
            rs.getString(5);
            rs.getString(6);
            rs.getString(7);
            rs.getString(8);
            rs.getString(9);
            c_credit = rs.getString(10);
            rs.getString(11);
            rs.getBigDecimal(12);
            c_balance = rs.getBigDecimal(13);
            rs.getTimestamp(14);
            rs.close();
        } else {
            prep = this.prepare("SELECT C_FIRST, C_MIDDLE, C_LAST, C_STREET_1, C_STREET_2, C_CITY, C_STATE, C_ZIP, C_PHONE, C_CREDIT, C_CREDIT_LIM, C_DISCOUNT, C_BALANCE, C_SINCE FROM CUSTOMER WHERE C_ID=? AND C_D_ID=? AND C_W_ID=?");
            prep.setInt(1, c_id);
            prep.setInt(2, c_d_id);
            prep.setInt(3, c_w_id);
            rs = this.db.query(prep);
            rs.next();
            rs.getString(1);
            rs.getString(2);
            c_last = rs.getString(3);
            rs.getString(4);
            rs.getString(5);
            rs.getString(6);
            rs.getString(7);
            rs.getString(8);
            rs.getString(9);
            c_credit = rs.getString(10);
            rs.getString(11);
            rs.getBigDecimal(12);
            c_balance = rs.getBigDecimal(13);
            rs.getTimestamp(14);
            rs.close();
        }
        c_balance = c_balance.add(h_amount);
        if (c_credit.equals("BC")) {
            prep = this.prepare("SELECT C_DATA INTO FROM CUSTOMER WHERE C_ID=? AND C_D_ID=? AND C_W_ID=?");
            prep.setInt(1, c_id);
            prep.setInt(2, c_d_id);
            prep.setInt(3, c_w_id);
            rs = this.db.query(prep);
            rs.next();
            String c_data = rs.getString(1);
            rs.close();
            String c_new_data = "| " + c_id + " " + c_d_id + " " + c_w_id + " " + d_id + " " + this.warehouseId + " " + h_amount + " " + c_data;
            if (c_new_data.length() > 500) {
                c_new_data = c_new_data.substring(0, 500);
            }
            prep = this.prepare("UPDATE CUSTOMER SET C_BALANCE=?, C_DATA=? WHERE C_ID=? AND C_D_ID=? AND C_W_ID=?");
            prep.setBigDecimal(1, c_balance);
            prep.setString(2, c_new_data);
            prep.setInt(3, c_id);
            prep.setInt(4, c_d_id);
            prep.setInt(5, c_w_id);
            this.db.update(prep);
        } else {
            prep = this.prepare("UPDATE CUSTOMER SET C_BALANCE=? WHERE C_ID=? AND C_D_ID=? AND C_W_ID=?");
            prep.setBigDecimal(1, c_balance);
            prep.setInt(2, c_id);
            prep.setInt(3, c_d_id);
            prep.setInt(4, c_w_id);
            this.db.update(prep);
        }
        String h_data = w_name + " " + d_name;
        prep = this.prepare("INSERT INTO HISTORY (H_C_D_ID, H_C_W_ID, H_C_ID, H_D_ID, H_W_ID, H_DATE, H_AMOUNT, H_DATA) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        prep.setInt(1, c_d_id);
        prep.setInt(2, c_w_id);
        prep.setInt(3, c_id);
        prep.setInt(4, d_id);
        prep.setInt(5, this.warehouseId);
        prep.setTimestamp(6, datetime);
        prep.setBigDecimal(7, h_amount);
        prep.setString(8, h_data);
        this.db.update(prep);
        this.db.commit();
    }

    private void processOrderStatus() throws Exception {
        ResultSet rs;
        boolean byname;
        int d_id = this.random.getInt(1, this.bench.districtsPerWarehouse);
        String c_last = null;
        int c_id = -1;
        if (this.random.getInt(1, 100) <= 60) {
            byname = true;
            c_last = this.random.getLastname(this.random.getNonUniform(255, 0, 999));
        } else {
            byname = false;
            c_id = this.random.getNonUniform(1023, 1, this.bench.customersPerDistrict);
        }
        PreparedStatement prep = this.prepare("UPDATE DISTRICT SET D_NEXT_O_ID=-1 WHERE D_ID=-1");
        this.db.update(prep);
        if (byname) {
            prep = this.prepare("SELECT COUNT(C_ID) FROM CUSTOMER WHERE C_LAST=? AND C_D_ID=? AND C_W_ID=?");
            prep.setString(1, c_last);
            prep.setInt(2, d_id);
            prep.setInt(3, this.warehouseId);
            rs = this.db.query(prep);
            rs.next();
            int namecnt = rs.getInt(1);
            rs.close();
            if (namecnt == 0) {
                this.db.rollback();
                return;
            }
            prep = this.prepare("SELECT C_BALANCE, C_FIRST, C_MIDDLE, C_ID FROM CUSTOMER WHERE C_LAST=? AND C_D_ID=? AND C_W_ID=? ORDER BY C_FIRST");
            prep.setString(1, c_last);
            prep.setInt(2, d_id);
            prep.setInt(3, this.warehouseId);
            rs = this.db.query(prep);
            if (namecnt % 2 != 0) {
                ++namecnt;
            }
            for (int n = 0; n < namecnt / 2; ++n) {
                rs.next();
            }
            rs.getBigDecimal(1);
            rs.getString(2);
            rs.getString(3);
            rs.close();
        } else {
            prep = this.prepare("SELECT C_BALANCE, C_FIRST, C_MIDDLE, C_LAST FROM CUSTOMER WHERE C_ID=? AND C_D_ID=? AND C_W_ID=?");
            prep.setInt(1, c_id);
            prep.setInt(2, d_id);
            prep.setInt(3, this.warehouseId);
            rs = this.db.query(prep);
            rs.next();
            rs.getBigDecimal(1);
            rs.getString(2);
            rs.getString(3);
            c_last = rs.getString(4);
            rs.close();
        }
        prep = this.prepare("SELECT MAX(O_ID) FROM ORDERS WHERE O_C_ID=? AND O_D_ID=? AND O_W_ID=?");
        prep.setInt(1, c_id);
        prep.setInt(2, d_id);
        prep.setInt(3, this.warehouseId);
        rs = this.db.query(prep);
        int o_id = -1;
        if (rs.next()) {
            o_id = rs.getInt(1);
            if (rs.wasNull()) {
                o_id = -1;
            }
        }
        rs.close();
        if (o_id != -1) {
            prep = this.prepare("SELECT O_ID, O_CARRIER_ID, O_ENTRY_D FROM ORDERS WHERE O_ID=?");
            prep.setInt(1, o_id);
            rs = this.db.query(prep);
            rs.next();
            o_id = rs.getInt(1);
            rs.getInt(2);
            rs.getTimestamp(3);
            rs.close();
            prep = this.prepare("SELECT OL_I_ID, OL_SUPPLY_W_ID, OL_QUANTITY, OL_AMOUNT, OL_DELIVERY_D FROM ORDER_LINE WHERE OL_O_ID=? AND OL_D_ID=? AND OL_W_ID=?");
            prep.setInt(1, o_id);
            prep.setInt(2, d_id);
            prep.setInt(3, this.warehouseId);
            rs = this.db.query(prep);
            while (rs.next()) {
                rs.getInt(1);
                rs.getInt(2);
                rs.getInt(3);
                rs.getBigDecimal(4);
                rs.getTimestamp(5);
            }
            rs.close();
        }
        this.db.commit();
    }

    private void processDelivery() throws Exception {
        int o_carrier_id = this.random.getInt(1, 10);
        Timestamp datetime = new Timestamp(System.currentTimeMillis());
        PreparedStatement prep = this.prepare("UPDATE DISTRICT SET D_NEXT_O_ID=-1 WHERE D_ID=-1");
        this.db.update(prep);
        for (int d_id = 1; d_id <= this.bench.districtsPerWarehouse; ++d_id) {
            prep = this.prepare("SELECT MIN(NO_O_ID) FROM NEW_ORDER WHERE NO_D_ID=? AND NO_W_ID=?");
            prep.setInt(1, d_id);
            prep.setInt(2, this.warehouseId);
            ResultSet rs = this.db.query(prep);
            int no_o_id = -1;
            if (rs.next()) {
                no_o_id = rs.getInt(1);
                if (rs.wasNull()) {
                    no_o_id = -1;
                }
            }
            rs.close();
            if (no_o_id == -1) continue;
            prep = this.prepare("DELETE FROM NEW_ORDER WHERE NO_O_ID=? AND NO_D_ID=? AND NO_W_ID=?");
            prep.setInt(1, no_o_id);
            prep.setInt(2, d_id);
            prep.setInt(3, this.warehouseId);
            this.db.update(prep);
            prep = this.prepare("SELECT O_C_ID FROM ORDERS WHERE O_ID=? AND O_D_ID=? AND O_W_ID=?");
            prep.setInt(1, no_o_id);
            prep.setInt(2, d_id);
            prep.setInt(3, this.warehouseId);
            rs = this.db.query(prep);
            rs.next();
            rs.getInt(1);
            rs.close();
            prep = this.prepare("UPDATE ORDERS SET O_CARRIER_ID=? WHERE O_ID=? AND O_D_ID=? AND O_W_ID=?");
            prep.setInt(1, o_carrier_id);
            prep.setInt(2, no_o_id);
            prep.setInt(3, d_id);
            prep.setInt(4, this.warehouseId);
            this.db.update(prep);
            prep = this.prepare("UPDATE ORDER_LINE SET OL_DELIVERY_D=? WHERE OL_O_ID=? AND OL_D_ID=? AND OL_W_ID=?");
            prep.setTimestamp(1, datetime);
            prep.setInt(2, no_o_id);
            prep.setInt(3, d_id);
            prep.setInt(4, this.warehouseId);
            this.db.update(prep);
            prep = this.prepare("SELECT SUM(OL_AMOUNT) FROM ORDER_LINE WHERE OL_O_ID=? AND OL_D_ID=? AND OL_W_ID=?");
            prep.setInt(1, no_o_id);
            prep.setInt(2, d_id);
            prep.setInt(3, this.warehouseId);
            rs = this.db.query(prep);
            rs.next();
            BigDecimal ol_amount = rs.getBigDecimal(1);
            rs.close();
            prep = this.prepare("UPDATE CUSTOMER SET C_BALANCE=C_BALANCE+? WHERE C_ID=? AND C_D_ID=? AND C_W_ID=?");
            prep.setBigDecimal(1, ol_amount);
            prep.setInt(2, no_o_id);
            prep.setInt(3, d_id);
            prep.setInt(4, this.warehouseId);
            this.db.update(prep);
        }
        this.db.commit();
    }

    private void processStockLevel() throws Exception {
        int d_id = this.terminalId % this.bench.districtsPerWarehouse + 1;
        int threshold = this.random.getInt(10, 20);
        PreparedStatement prep = this.prepare("UPDATE DISTRICT SET D_NEXT_O_ID=-1 WHERE D_ID=-1");
        this.db.update(prep);
        prep = this.prepare("SELECT D_NEXT_O_ID FROM DISTRICT WHERE D_ID=? AND D_W_ID=?");
        prep.setInt(1, d_id);
        prep.setInt(2, this.warehouseId);
        ResultSet rs = this.db.query(prep);
        rs.next();
        int o_id = rs.getInt(1);
        rs.close();
        prep = this.prepare("SELECT COUNT(DISTINCT S_I_ID) FROM ORDER_LINE, STOCK WHERE OL_W_ID=? AND OL_D_ID=? AND OL_O_ID<? AND OL_O_ID>=? AND S_W_ID=? AND S_I_ID=OL_I_ID AND S_QUANTITY<?");
        prep.setInt(1, this.warehouseId);
        prep.setInt(2, d_id);
        prep.setInt(3, o_id);
        prep.setInt(4, o_id - 20);
        prep.setInt(5, this.warehouseId);
        prep.setInt(6, threshold);
        rs = this.db.query(prep);
        rs.next();
        rs.getInt(1);
        rs.close();
        this.db.commit();
    }

    private PreparedStatement prepare(String sql) throws Exception {
        PreparedStatement prep = (PreparedStatement)this.prepared.get(sql);
        if (prep == null) {
            prep = this.db.prepare(sql);
            this.prepared.put(sql, prep);
        }
        return prep;
    }
}

