/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.SQLException;
import org.h2.message.Message;

public class ByteUtils {
    private static final int BUFFER_BLOCK_SIZE = 4096;

    public static int indexOf(byte[] bytes, byte[] pattern, int start) {
        if (pattern.length == 0) {
            return start;
        }
        if (start > bytes.length) {
            return -1;
        }
        int last = bytes.length - pattern.length + 1;
        while (start < last) {
            block5: {
                for (int i = 0; i < pattern.length; ++i) {
                    if (bytes[start + i] == pattern[i]) {
                        continue;
                    }
                    break block5;
                }
                return start;
            }
            ++start;
        }
        return -1;
    }

    public static byte[] convertStringToBytes(String s) throws SQLException {
        int len = s.length();
        if (len % 2 == 1) {
            throw Message.getSQLException(90004, s);
        }
        byte[] buff = new byte[len /= 2];
        try {
            for (int i = 0; i < len; ++i) {
                String t = s.substring(i + i, i + i + 2);
                buff[i] = (byte)Integer.parseInt(t, 16);
            }
        }
        catch (NumberFormatException e) {
            throw Message.getSQLException(90005, s);
        }
        return buff;
    }

    public static int getByteArrayHash(byte[] value) {
        int h = 1;
        int i = 0;
        while (i < value.length) {
            h = 31 * h + value[i++];
        }
        return h;
    }

    public static String convertBytesToString(byte[] value) {
        StringBuffer buff = new StringBuffer(value.length * 2);
        for (int i = 0; value != null && i < value.length; ++i) {
            int c = value[i] & 0xFF;
            buff.append(Integer.toHexString(c >> 4 & 0xF));
            buff.append(Integer.toHexString(c & 0xF));
        }
        return buff.toString();
    }

    public static boolean compareSecure(byte[] test, byte[] good) {
        if (test == null || good == null) {
            return test == null && good == null;
        }
        if (test.length != good.length) {
            return false;
        }
        boolean correct = true;
        for (int i = 0; i < good.length; ++i) {
            if (test[i] == good[i]) continue;
            correct = false;
        }
        return correct;
    }

    public static void clear(byte[] buff) {
        for (int i = 0; i < buff.length; ++i) {
            buff[i] = 0;
        }
    }

    public static int compareNotNull(byte[] data1, byte[] data2) {
        int len = Math.min(data1.length, data2.length);
        for (int i = 0; i < len; ++i) {
            byte b = data1[i];
            byte b2 = data2[i];
            if (b == b2) continue;
            return b > b2 ? 1 : -1;
        }
        int c = data1.length - data2.length;
        return c == 0 ? 0 : (c < 0 ? -1 : 1);
    }

    public static byte[] getBytesAndClose(InputStream in, int length) throws IOException {
        if (length <= 0) {
            length = Integer.MAX_VALUE;
        }
        int block = Math.min(4096, length);
        ByteArrayOutputStream out = new ByteArrayOutputStream(block);
        byte[] buff = new byte[block];
        while (length > 0) {
            int len = Math.min(block, length);
            if ((len = in.read(buff, 0, len)) < 0) break;
            out.write(buff, 0, len);
            length -= len;
        }
        in.close();
        return out.toByteArray();
    }

    public static String getStringAndClose(Reader in, int length) throws IOException {
        if (length <= 0) {
            length = Integer.MAX_VALUE;
        }
        int block = Math.min(4096, length);
        StringWriter out = new StringWriter(block);
        char[] buff = new char[block];
        while (length > 0) {
            int len = Math.min(block, length);
            if ((len = in.read(buff, 0, len)) < 0) break;
            out.write(buff, 0, len);
            length -= len;
        }
        in.close();
        return out.toString();
    }

    public static String convertToBinString(byte[] buff) {
        char[] chars = new char[buff.length];
        for (int i = 0; i < buff.length; ++i) {
            chars[i] = (char)(buff[i] & 0xFF);
        }
        return new String(chars);
    }

    public static byte[] convertBinStringToBytes(String data) {
        byte[] buff = new byte[data.length()];
        for (int i = 0; i < data.length(); ++i) {
            buff[i] = (byte)(data.charAt(i) & 0xFF);
        }
        return buff;
    }
}

