/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;
import org.h2.message.Message;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueTime
extends Value {
    public static final int PRECISION = 6;
    private Time value;

    private ValueTime(Time value) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        cal.get(11);
        cal.set(1970, 0, 1);
        this.value = new Time(cal.getTime().getTime());
    }

    public static Time parseTime(String s) throws SQLException {
        try {
            return Time.valueOf(s);
        }
        catch (Exception e) {
            throw Message.getSQLException(90010, s);
        }
    }

    public Time getTime() {
        return (Time)this.value.clone();
    }

    public String getSQL() {
        return "TIME '" + this.getString() + "'";
    }

    public int getType() {
        return 9;
    }

    protected int compareSecure(Value o, CompareMode mode) {
        ValueTime v = (ValueTime)o;
        int c = this.value.compareTo(v.value);
        return c == 0 ? 0 : (c < 0 ? -1 : 1);
    }

    public String getString() {
        return this.value.toString();
    }

    public long getPrecision() {
        return 6L;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object getObject() {
        return this.getTime();
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setTime(parameterIndex, this.value);
    }

    public static ValueTime get(Time date) {
        return (ValueTime)Value.cache(new ValueTime(date));
    }

    public int getDisplaySize() {
        return "23:59:59".length();
    }

    protected boolean isEqual(Value v) {
        return v instanceof ValueTime && this.value.equals(((ValueTime)v).value);
    }
}

