/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.builtIns.CodepointsToString;
import oracle.xml.xqxp.functions.builtIns.Compare;
import oracle.xml.xqxp.functions.builtIns.Concat;
import oracle.xml.xqxp.functions.builtIns.Contains;
import oracle.xml.xqxp.functions.builtIns.EndsWith;
import oracle.xml.xqxp.functions.builtIns.EscapeURI;
import oracle.xml.xqxp.functions.builtIns.LowerCase;
import oracle.xml.xqxp.functions.builtIns.NormalizeSpace;
import oracle.xml.xqxp.functions.builtIns.NormalizeUnicode;
import oracle.xml.xqxp.functions.builtIns.StartsWith;
import oracle.xml.xqxp.functions.builtIns.StringJoin;
import oracle.xml.xqxp.functions.builtIns.StringLength;
import oracle.xml.xqxp.functions.builtIns.StringPad;
import oracle.xml.xqxp.functions.builtIns.StringToCodepoints;
import oracle.xml.xqxp.functions.builtIns.Substring;
import oracle.xml.xqxp.functions.builtIns.SubstringAfter;
import oracle.xml.xqxp.functions.builtIns.SubstringBefore;
import oracle.xml.xqxp.functions.builtIns.Translate;
import oracle.xml.xqxp.functions.builtIns.UpperCase;

class FNStrings {
    static final int codepoints_to_string = 0;
    static final int string_to_codepoints = 1;
    static final int compare = 2;
    static final int concat = 3;
    static final int string_join = 4;
    static final int starts_with = 5;
    static final int ends_with = 6;
    static final int contains = 7;
    static final int substring = 8;
    static final int string_length = 9;
    static final int substring_before = 10;
    static final int substring_after = 11;
    static final int normalize_space = 12;
    static final int normalize_unicode = 13;
    static final int upper_case = 14;
    static final int lower_case = 15;
    static final int translate = 16;
    static final int string_pad = 17;
    static final int escape_uri = 18;

    private FNStrings() {
    }

    static OXMLFunction getFunction(int n, int n2) {
        OXMLFunction oXMLFunction = null;
        switch (n) {
            case 0: {
                oXMLFunction = new CodepointsToString();
                break;
            }
            case 1: {
                oXMLFunction = new StringToCodepoints();
                break;
            }
            case 2: {
                oXMLFunction = new Compare(n2);
                break;
            }
            case 3: {
                oXMLFunction = new Concat();
                break;
            }
            case 4: {
                oXMLFunction = new StringJoin();
                break;
            }
            case 5: {
                oXMLFunction = new StartsWith(n2);
                break;
            }
            case 6: {
                oXMLFunction = new EndsWith(n2);
                break;
            }
            case 7: {
                oXMLFunction = new Contains(n2);
                break;
            }
            case 8: {
                oXMLFunction = new Substring(n2);
                break;
            }
            case 9: {
                oXMLFunction = new StringLength(n2);
                break;
            }
            case 10: {
                oXMLFunction = new SubstringBefore(n2);
                break;
            }
            case 11: {
                oXMLFunction = new SubstringAfter(n2);
                break;
            }
            case 12: {
                oXMLFunction = new NormalizeSpace(n2);
                break;
            }
            case 13: {
                oXMLFunction = new NormalizeUnicode(n2);
                break;
            }
            case 14: {
                oXMLFunction = new UpperCase();
                break;
            }
            case 15: {
                oXMLFunction = new LowerCase();
                break;
            }
            case 16: {
                oXMLFunction = new Translate();
                break;
            }
            case 17: {
                oXMLFunction = new StringPad();
                break;
            }
            case 18: {
                oXMLFunction = new EscapeURI();
            }
        }
        return oXMLFunction;
    }
}

