/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.text.extraction.sprm;

import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class SprmOperation {
    private static final BitField OP_BITFIELD = new BitField(511);
    private static final BitField SPECIAL_BITFIELD = new BitField(512);
    private static final BitField TYPE_BITFIELD = new BitField(7168);
    private static final BitField SIZECODE_BITFIELD = new BitField(57344);
    private int _type;
    private int _operation;
    private int _operand;
    private byte[] _varOperand;
    private int _sizeNeeded;

    public SprmOperation(byte[] byArray, int n) {
        short s = LittleEndian.getShort(byArray, n);
        n += 2;
        this._operation = OP_BITFIELD.getValue(s);
        this._type = TYPE_BITFIELD.getValue(s);
        int n2 = SIZECODE_BITFIELD.getValue(s);
        switch (n2) {
            case 0: 
            case 1: {
                this._operand = LittleEndian.getUnsignedByte(byArray, n);
                this._sizeNeeded = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                this._operand = LittleEndian.getShort(byArray, n);
                this._sizeNeeded = 4;
                break;
            }
            case 3: {
                this._operand = LittleEndian.getInt(byArray, n);
                this._sizeNeeded = 6;
                break;
            }
            case 6: {
                this._varOperand = new byte[byArray[n++]];
                System.arraycopy(byArray, n, this._varOperand, 0, this._varOperand.length);
                this._sizeNeeded = this._varOperand.length + 3;
                break;
            }
            case 7: {
                byte[] byArray2 = new byte[]{byArray[n], byArray[n + 1], byArray[n + 2], 0};
                this._operand = LittleEndian.getInt(byArray2, 0);
                this._sizeNeeded = 5;
            }
        }
    }

    public int getType() {
        return this._type;
    }

    public int getOperation() {
        return this._operation;
    }

    public int getOperand() {
        return this._operand;
    }

    public int size() {
        return this._sizeNeeded;
    }
}

