<?php

# This file is a part of RackTables, a datacenter and server room management
# framework. See accompanying file "COPYING" for the full copyright and
# licensing information.

function renderInstallerHTML()
{
$stepfunc[1] = 'not_already_installed';
$stepfunc[2] = 'platform_is_ok';
$stepfunc[3] = 'init_config';
$stepfunc[4] = 'init_database_static';
$stepfunc[5] = 'init_database_dynamic';
$stepfunc[6] = 'congrats';

if (isset ($_REQUEST['step']))
	$step = $_REQUEST['step'];
else
	$step = 1;

if ($step > count ($stepfunc))
{
	$root = (empty($_SERVER['HTTPS']) or $_SERVER['HTTPS'] == 'off') ? 'http://' : 'https://';
	$root .= isset ($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : ($_SERVER['SERVER_NAME'].($_SERVER['SERVER_PORT']=='80'?'':$_SERVER['SERVER_PORT']));
	// "Since PHP 4.3.0, you will often get a slash or a dot back from
	// dirname() in situations where the older functionality would have given
	// you the empty string."
	// "On Windows, both slash (/) and backslash (\) are used as directory
	// separator character."
	$root .= strtr (dirname ($_SERVER['PHP_SELF']), '\\', '/');
	if (substr ($root, -1) != '/')
		$root .= '/';
	header ("Location: ${root}");
	exit;
}
$title = "RackTables installation: step ${step} of " . count ($stepfunc);
header ('Content-Type: text/html; charset=UTF-8');
?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head><title><?php echo $title; ?></title>
<style type="text/css">
.tdleft {
	text-align: left;
}

.trok {
	background-color: #80FF80;
}

.trwarning {
	background-color: #FFFF80;
}

.trerror {
	background-color: #FF8080;
}
</style>
</head>
<body>
<center>
<?php
echo "<h1>${title}</h1><p>";

echo "</p><form method=post>\n";
$testres = $stepfunc[$step] ();
if ($testres)
{
	$next_step = $step + 1;
	echo "<br><input type=submit value='proceed'>";
}
else
{
	$next_step = $step;
	echo "<br><input type=submit value='retry'>";
}
echo "<input type=hidden name=step value='${next_step}'>\n";

?>
</form>
</center>
</body>
</html>

<?php
}

// Check if the software is already installed.
function not_already_installed()
{
	global $found_secret_file, $pdo_dsn;
	if ($found_secret_file and isset ($pdo_dsn))
	{
		echo 'Your configuration file exists and seems to hold necessary data already.<br>';
		return FALSE;
	}
	else
	{
		echo 'There seem to be no existing installation here, I am going to setup one now.<br>';
		return TRUE;
	}
}

// Check that we can write to configuration file.
// If so, ask for DB connection paramaters and test
// the connection. Neither save the parameters nor allow
// going further until we succeed with the given 
// credentials.
function init_config ()
{
	function print_form
	(
		$use_tcp = TRUE,
		$tcp_host = 'localhost',
		$tcp_port = '',
		$unix_socket = '/var/lib/mysql/mysql.sock',
		$database = 'racktables_db',
		$username = 'racktables_user',
		$password = ''
	)
	{
		echo "<input type=hidden name=save_config value=1>\n";
		echo '<h3>Server-side MySQL setup of the database:</h3><div align=left><pre class=trok>';
		echo "mysql&gt;\nCREATE DATABASE racktables_db CHARACTER SET utf8 COLLATE utf8_general_ci;\n";
		echo "GRANT ALL PRIVILEGES ON racktables_db.* TO racktables_user@localhost IDENTIFIED BY 'MY_SECRET_PASSWORD';\n</pre></div>";
		echo '<table>';
		echo '<tr><td><label for=conn_tcp>TCP connection</label></td>';
		echo '<td><input type=radio name=conn value=conn_tcp id=conn_tcp' . ($use_tcp ? ' checked' : '') . '></td></tr>';
		echo '<tr><td><label for=conn_unix>UNIX socket</label></td>';
		echo '<td><input type=radio name=conn value=conn_unix id=conn_unix' . ($use_tcp ? '' : ' checked') . '></td></tr>';
		echo "<tr><td><label for=mysql_host>TCP host:</label></td>";
		echo "<td><input type=text name=mysql_host id=mysql_host value='${tcp_host}'></td></tr>\n";
		echo "<tr><td><label for=mysql_port>TCP port (if not 3306):</label></td>";
		echo "<td><input type=text name=mysql_port id=mysql_port value='${tcp_port}'></td></tr>\n";
		echo "<tr><td><label for=mysql_socket>UNIX socket:</label></td>";
		echo "<td><input type=text name=mysql_socket id=mysql_socket value='${unix_socket}'></td></tr>\n";
		echo "<tr><td><label for=mysql_db>database:</label></td>";
		echo "<td><input type=text name=mysql_db id=mysql_db value='${database}'></td></tr>\n";
		echo "<tr><td><label for=mysql_username>username:</label></td>";
		echo "<td><input type=text name=mysql_username id=mysql_username value='${username}'></td></tr>\n";
		echo "<tr><td><label for=mysql_password>password:</label></td>";
		echo "<td><input type=password name=mysql_password id=mysql_password value='${password}'></td></tr>\n";
		echo '</table>';
	}
	global $path_to_secret_php;
	if (!is_writable ($path_to_secret_php))
	{
		echo "The $path_to_secret_php file is not writable by web-server. Make sure it is.";
		echo "The following commands should suffice:<pre>touch '$path_to_secret_php'; chmod 666 '$path_to_secret_php'</pre>";
		echo 'Fedora Linux with SELinux may require this file to be owned by specific user (apache) and/or executing "setenforce 0" for the time of installation. ';
		echo 'SELinux may be turned back on with "setenforce 1" command.<br>';
		return FALSE;
	}
	if (! array_key_exists ('save_config', $_REQUEST))
	{
		print_form();
		return FALSE;
	}
	if (empty ($_REQUEST['mysql_db']) or empty ($_REQUEST['mysql_username']))
	{
		print_form
		(
			$_REQUEST['conn'] == 'conn_tcp',
			$_REQUEST['mysql_host'],
			$_REQUEST['mysql_port'],
			$_REQUEST['mysql_socket'],
			$_REQUEST['mysql_db'],
			$_REQUEST['mysql_username'],
			$_REQUEST['mysql_password']
		);
		echo '<h2 class=trerror>Missing database/username parameter!</h2>';
		return FALSE;
	}
	if ($_REQUEST['conn'] == 'conn_tcp' and empty ($_REQUEST['mysql_host']))
	{
		print_form
		(
			$_REQUEST['conn'] == 'conn_tcp',
			$_REQUEST['mysql_host'],
			$_REQUEST['mysql_port'],
			$_REQUEST['mysql_socket'],
			$_REQUEST['mysql_db'],
			$_REQUEST['mysql_username'],
			$_REQUEST['mysql_password']
		);
		echo '<h2 class=trerror>Missing TCP hostname parameter!</h2>';
		return FALSE;
	}
	if ($_REQUEST['conn'] == 'conn_unix' and empty ($_REQUEST['mysql_socket']))
	{
		print_form
		(
			$_REQUEST['conn'] == 'conn_tcp',
			$_REQUEST['mysql_host'],
			$_REQUEST['mysql_port'],
			$_REQUEST['mysql_socket'],
			$_REQUEST['mysql_db'],
			$_REQUEST['mysql_username'],
			$_REQUEST['mysql_password']
		);
		echo '<h2 class=trerror>Missing UNIX socket parameter!</h2>';
		return FALSE;
	}
	# finally OK to make a connection attempt
	$pdo_dsn = 'mysql:';
	switch ($_REQUEST['conn'])
	{
	case 'conn_tcp':
		$pdo_dsn .= 'host=' . $_REQUEST['mysql_host'];
		if (!empty ($_REQUEST['mysql_port']) and $_REQUEST['mysql_port'] != '3306')
			$pdo_dsn .= ';port=' . $_REQUEST['mysql_port'];
		break;
	case 'conn_unix':
		$pdo_dsn .= 'unix_socket=' . $_REQUEST['mysql_socket'];
		break;
	default:
		print_form();
		echo '<h2 class=trerror>form error</h2>';
		return FALSE;
	}
	$pdo_dsn .= ';dbname=' . $_REQUEST['mysql_db'];
	try
	{
		$dbxlink = new PDO ($pdo_dsn, $_REQUEST['mysql_username'], $_REQUEST['mysql_password']);
	}
	catch (PDOException $e)
	{
		print_form
		(
			$_REQUEST['conn'] == 'conn_tcp',
			$_REQUEST['mysql_host'],
			$_REQUEST['mysql_port'],
			$_REQUEST['mysql_socket'],
			$_REQUEST['mysql_db'],
			$_REQUEST['mysql_username'],
			$_REQUEST['mysql_password']
		);
		echo "<h2 class=trerror>Datase connection failed. Check parameters and try again.</h2>\n";
		echo "PDO DSN: <tt class=trwarning>${pdo_dsn}</tt><br>";
		return FALSE;
	}

	$conf = fopen ($path_to_secret_php, 'w+');
	if ($conf === FALSE)
	{
		echo "Error: failed to open $path_to_secret_php for writing";
		return FALSE;
	}
	fwrite ($conf, "<?php\n# This file has been generated automatically by RackTables installer.\n");
	fwrite ($conf, "\$pdo_dsn = '${pdo_dsn}';\n");
	fwrite ($conf, "\$db_username = '" . $_REQUEST['mysql_username'] . "';\n");
	fwrite ($conf, "\$db_password = '" . $_REQUEST['mysql_password'] . "';\n\n");
	fwrite ($conf, <<<ENDOFTEXT

\$user_auth_src = 'database';
\$require_local_account = TRUE;
# Default setting is to authenticate users locally, but it is possible to
# employ existing LDAP or Apache user accounts. Check RackTables wiki for
# more information, in particular, this page for LDAP configuration details:
# http://sourceforge.net/apps/mediawiki/racktables/index.php?title=LDAP

#\$LDAP_options = array
#(
#	'server' => 'localhost',
#	'domain' => 'example.com',
#	'search_attr' => '',
#	'search_dn' => '',
# // The following credentials will be used when searching for the user's DN:
#	'search_bind_rdn' => NULL,
#	'search_bind_password' => NULL,
#	'displayname_attrs' => '',
#	'options' => array (LDAP_OPT_PROTOCOL_VERSION => 3),
#	'use_tls' => 2,         // 0 == don't attempt, 1 == attempt, 2 == require
#);

# This HTML banner is intended to assist users in dispatching their issues
# to the local tech support service. Its text (in its verbatim form) will
# be appended to assorted error messages visible in user's browser (including
# "not authenticated" message). Beware of placing any sensitive information
# here, it will be readable by unauthorized visitors.
#\$helpdesk_banner = '<B>This RackTables instance is supported by Example Inc. IT helpdesk, dial ext. 1234 to report a problem.</B>';


ENDOFTEXT
);
	fwrite ($conf, "?>\n");
	fclose ($conf);
	echo "The configuration file has been written successfully.<br>";
	return TRUE;
}

function connect_to_db_or_die ()
{
	try
	{
		connectDB();
	}
	catch (RackTablesError $e)
	{
		die ('Error connecting to the database');
	}
}

function init_database_static ()
{
	connect_to_db_or_die();
	global $dbxlink;
	if (!isInnoDBSupported())
	{
		echo 'InnoDB test failed! Please configure MySQL server properly and retry.';
		return FALSE;
	}
	$result = $dbxlink->query ('show tables');
	$tables = $result->fetchAll (PDO::FETCH_NUM);
	$result->closeCursor();
	unset ($result);
	if (count ($tables))
	{
		echo 'Your database is already holding ' . count ($tables);
		echo ' tables, so I will stop here and let you check it yourself.<br>';
		echo 'There is some important data there probably.<br>';
		return FALSE;
	}
	echo 'Initializing the database...<br>';
	echo '<table border=1>';
	echo "<tr><th>section</th><th>queries</th><th>errors</th></tr>";
	$errlist = array();
	foreach (array ('structure', 'dictbase') as $part)
	{
		echo "<tr><td>${part}</td>";
		$nq = $nerrs = 0;
		foreach (preg_split ("/;\s*\n/", get_pseudo_file ($part)) as $query)
		{
			$query = trim($query);
			if (empty ($query) or '--' == substr ($query, 0, 2))
				continue;
			$nq++;
			if ($dbxlink->exec ($query) === FALSE)
			{
				$nerrs++;
				$errlist[] = $query;
			}
		}
		echo "<td>${nq}</td><td>${nerrs}</td></tr>\n";
	}
	// (re)load dictionary by pure PHP means w/o any external file
	echo "<tr><td>dictionary</td>";
	$nq = $nerrs = 0;
	$dictq = array();
	foreach (reloadDictionary() as $query)
	{
		$nq++;
		if ($dbxlink->exec ($query) === FALSE)
		{
			$nerrs++;
			$errlist[] = $query;
		}
	}
	echo "<td>${nq}</td><td>${nerrs}</td></tr>\n";
			
	echo '</table>';
	if (count ($errlist))
	{
		echo '<pre>The following queries failed:\n';
		foreach ($errlist as $q)
			echo "${q}\n\n";
		echo '</pre>';
		return FALSE;
	}
	return TRUE;
}

function init_database_dynamic ()
{
	connect_to_db_or_die();
	global $dbxlink;
	if (!isset ($_REQUEST['password']) or empty ($_REQUEST['password']))
	{
		$result = $dbxlink->query ('select count(user_id) from UserAccount where user_id = 1');
		$row = $result->fetch (PDO::FETCH_NUM);
		$nrecs = $row[0];
		$result->closeCursor();
		if (!$nrecs)
		{
			echo '<table border=1>';
			echo '<caption>Administrator password not set</caption>';
			echo '<tr><td><input type=password name=password></td></tr>';
			echo '</table>';
		}
		return FALSE;
	}
	else
	{
		// Never send cleartext password over the wire.
		$hash = sha1 ($_REQUEST['password']);
		$query = "INSERT INTO `UserAccount` (`user_id`, `user_name`, `user_password_hash`, `user_realname`) " .
			"VALUES (1,'admin','${hash}','RackTables Administrator')";
		$result = $dbxlink->exec ($query);
		echo "Administrator password has been set successfully.<br>";
		return TRUE;
	}
}

function congrats ()
{
	echo 'Congratulations! RackTables installation is complete. After pressing Proceed you will ';
	echo 'enter the system. Authenticate with <strong>admin</strong> username.<br>RackTables project has a ';
	echo "<a href='http://sourceforge.net/apps/mediawiki/racktables/index.php?title=RackTablesAdminGuide'>";
	echo "wiki</a> and a ";
	echo "<a href='http://www.freelists.org/list/racktables-users'>mailing list</a> for users. Have fun.<br>";
	return TRUE;
}

function get_pseudo_file ($name)
{
	switch ($name)
	{
	case 'structure':
		return <<<END_OF_FILE
alter database character set utf8;
set names 'utf8';
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;

CREATE TABLE `Atom` (
  `molecule_id` int(10) unsigned default NULL,
  `rack_id` int(10) unsigned default NULL,
  `unit_no` int(10) unsigned default NULL,
  `atom` enum('front','interior','rear') default NULL
) ENGINE=InnoDB;

CREATE TABLE `Attribute` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `type` enum('string','uint','float','dict') default NULL,
  `name` char(64) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB;

CREATE TABLE `AttributeMap` (
  `objtype_id` int(10) unsigned NOT NULL default '1',
  `attr_id` int(10) unsigned NOT NULL default '1',
  `chapter_id` int(10) unsigned default NULL,
  UNIQUE KEY `objtype_id` (`objtype_id`,`attr_id`),
  KEY `attr_id` (`attr_id`),
  KEY `chapter_id` (`chapter_id`),
  CONSTRAINT `AttributeMap-FK-chapter_id` FOREIGN KEY (`chapter_id`) REFERENCES `Chapter` (`id`),
  CONSTRAINT `AttributeMap-FK-attr_id` FOREIGN KEY (`attr_id`) REFERENCES `Attribute` (`id`)
) ENGINE=InnoDB;

CREATE TABLE `AttributeValue` (
  `object_id` int(10) unsigned default NULL,
  -- Default value intentionally breaks the constraint, this blocks
  -- any insertion, which doesn't have 'object_tid' on the column list.
  `object_tid` int(10) unsigned NOT NULL default '0',
  `attr_id` int(10) unsigned default NULL,
  `string_value` char(255) default NULL,
  `uint_value` int(10) unsigned default NULL,
  `float_value` float default NULL,
  UNIQUE KEY `object_id` (`object_id`,`attr_id`),
  KEY `attr_id-uint_value` (`attr_id`,`uint_value`),
  KEY `attr_id-string_value` (`attr_id`,`string_value`(12)),
  KEY `id-tid` (`object_id`,`object_tid`),
  KEY `object_tid-attr_id` (`object_tid`,`attr_id`),
  CONSTRAINT `AttributeValue-FK-map` FOREIGN KEY (`object_tid`, `attr_id`) REFERENCES `AttributeMap` (`objtype_id`, `attr_id`),
  CONSTRAINT `AttributeValue-FK-object` FOREIGN KEY (`object_id`, `object_tid`) REFERENCES `RackObject` (`id`, `objtype_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `CachedPAV` (
  `object_id` int(10) unsigned NOT NULL,
  `port_name` char(255) NOT NULL,
  `vlan_id` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`object_id`,`port_name`,`vlan_id`),
  KEY `vlan_id` (`vlan_id`),
  CONSTRAINT `CachedPAV-FK-object-port` FOREIGN KEY (`object_id`, `port_name`) REFERENCES `CachedPVM` (`object_id`, `port_name`) ON DELETE CASCADE,
  CONSTRAINT `CachedPAV-FK-vlan_id` FOREIGN KEY (`vlan_id`) REFERENCES `VLANValidID` (`vlan_id`)
) ENGINE=InnoDB;

CREATE TABLE `CachedPNV` (
  `object_id` int(10) unsigned NOT NULL,
  `port_name` char(255) NOT NULL,
  `vlan_id` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`object_id`,`port_name`,`vlan_id`),
  UNIQUE KEY `port_id` (`object_id`,`port_name`),
  CONSTRAINT `CachedPNV-FK-compound` FOREIGN KEY (`object_id`, `port_name`, `vlan_id`) REFERENCES `CachedPAV` (`object_id`, `port_name`, `vlan_id`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `CachedPVM` (
  `object_id` int(10) unsigned NOT NULL,
  `port_name` char(255) NOT NULL,
  `vlan_mode` enum('access','trunk') NOT NULL default 'access',
  PRIMARY KEY  (`object_id`,`port_name`),
  CONSTRAINT `CachedPVM-FK-object_id` FOREIGN KEY (`object_id`) REFERENCES `RackObject` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `CactiGraph` (
  `object_id` int(10) unsigned NOT NULL,
  `graph_id` int(10) unsigned NOT NULL,
  `caption`  char(255) DEFAULT NULL,
  PRIMARY KEY  (`graph_id`),
  KEY `object_id` (`object_id`),
  CONSTRAINT `CactiGraph-FK-object_id` FOREIGN KEY (`object_id`) REFERENCES `RackObject` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `Chapter` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `sticky` enum('yes','no') default 'no',
  `name` char(128) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB;

CREATE TABLE `Config` (
  `varname` char(32) NOT NULL,
  `varvalue` text NOT NULL,
  `vartype` enum('string','uint') NOT NULL default 'string',
  `emptyok` enum('yes','no') NOT NULL default 'no',
  `is_hidden` enum('yes','no') NOT NULL default 'yes',
  `is_userdefined` enum('yes','no') NOT NULL default 'no',
  `description` text,
  PRIMARY KEY  (`varname`)
) ENGINE=InnoDB;

CREATE TABLE `Dictionary` (
  `chapter_id` int(10) unsigned NOT NULL,
  `dict_key` int(10) unsigned NOT NULL auto_increment,
  `dict_value` char(255) default NULL,
  PRIMARY KEY  (`dict_key`),
  UNIQUE KEY `chap_to_val` (`chapter_id`,`dict_value`),
  CONSTRAINT `Dictionary-FK-chapter_id` FOREIGN KEY (`chapter_id`) REFERENCES `Chapter` (`id`)
) ENGINE=InnoDB;

CREATE TABLE `EntityLink` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_entity_type` enum('ipv4net','ipv4rspool','ipv4vs','ipv6net','object','rack','user') NOT NULL,
  `parent_entity_id` int(10) unsigned NOT NULL,
  `child_entity_type` enum('file','object') NOT NULL,
  `child_entity_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `EntityLink-unique` (`parent_entity_type`,`parent_entity_id`,`child_entity_type`,`child_entity_id`),
  KEY `EntityLink-compound` (`parent_entity_type`,`child_entity_type`,`child_entity_id`)
) ENGINE=InnoDB;

CREATE TABLE `File` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` char(255) NOT NULL,
  `type` char(255) NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `ctime` datetime NOT NULL,
  `mtime` datetime NOT NULL,
  `atime` datetime NOT NULL,
  `thumbnail` longblob,
  `contents` longblob NOT NULL,
  `comment` text,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB;

CREATE TABLE `FileLink` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `file_id` int(10) unsigned NOT NULL,
  `entity_type` enum('ipv4net','ipv4rspool','ipv4vs','object','rack','user','ipv6net') NOT NULL default 'object',
  `entity_id` int(10) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `FileLink-file_id` (`file_id`),
  UNIQUE KEY `FileLink-unique` (`file_id`,`entity_type`,`entity_id`),
  CONSTRAINT `FileLink-File_fkey` FOREIGN KEY (`file_id`) REFERENCES `File` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `IPv4Address` (
  `ip` int(10) unsigned NOT NULL default '0',
  `name` char(255) NOT NULL default '',
  `reserved` enum('yes','no') default NULL,
  PRIMARY KEY  (`ip`)
) ENGINE=InnoDB;

CREATE TABLE `IPv4Allocation` (
  `object_id` int(10) unsigned NOT NULL default '0',
  `ip` int(10) unsigned NOT NULL default '0',
  `name` char(255) NOT NULL default '',
  `type` enum('regular','shared','virtual','router') default NULL,
  PRIMARY KEY  (`object_id`,`ip`),
  KEY `ip` (`ip`),
  CONSTRAINT `IPv4Allocation-FK-object_id` FOREIGN KEY (`object_id`) REFERENCES `RackObject` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `IPv4LB` (
  `object_id` int(10) unsigned default NULL,
  `rspool_id` int(10) unsigned default NULL,
  `vs_id` int(10) unsigned default NULL,
  `prio` int(10) unsigned default NULL,
  `vsconfig` text,
  `rsconfig` text,
  UNIQUE KEY `LB-VS` (`object_id`,`vs_id`),
  KEY `IPv4LB-FK-rspool_id` (`rspool_id`),
  KEY `IPv4LB-FK-vs_id` (`vs_id`),
  CONSTRAINT `IPv4LB-FK-vs_id` FOREIGN KEY (`vs_id`) REFERENCES `IPv4VS` (`id`),
  CONSTRAINT `IPv4LB-FK-object_id` FOREIGN KEY (`object_id`) REFERENCES `RackObject` (`id`),
  CONSTRAINT `IPv4LB-FK-rspool_id` FOREIGN KEY (`rspool_id`) REFERENCES `IPv4RSPool` (`id`)
) ENGINE=InnoDB;

CREATE TABLE `IPv4NAT` (
  `object_id` int(10) unsigned NOT NULL default '0',
  `proto` enum('TCP','UDP') NOT NULL default 'TCP',
  `localip` int(10) unsigned NOT NULL default '0',
  `localport` smallint(5) unsigned NOT NULL default '0',
  `remoteip` int(10) unsigned NOT NULL default '0',
  `remoteport` smallint(5) unsigned NOT NULL default '0',
  `description` char(255) default NULL,
  PRIMARY KEY  (`object_id`,`proto`,`localip`,`localport`,`remoteip`,`remoteport`),
  KEY `localip` (`localip`),
  KEY `remoteip` (`remoteip`),
  KEY `object_id` (`object_id`),
  CONSTRAINT `IPv4NAT-FK-object_id` FOREIGN KEY (`object_id`) REFERENCES `RackObject` (`id`)
) ENGINE=InnoDB;

CREATE TABLE `IPv4Network` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `ip` int(10) unsigned NOT NULL default '0',
  `mask` int(10) unsigned NOT NULL default '0',
  `name` char(255) default NULL,
  `comment` text,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `base-len` (`ip`,`mask`)
) ENGINE=InnoDB;

CREATE TABLE `IPv4RS` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `inservice` enum('yes','no') NOT NULL default 'no',
  `rsip` int(10) unsigned default NULL,
  `rsport` smallint(5) unsigned default NULL,
  `rspool_id` int(10) unsigned default NULL,
  `rsconfig` text,
  PRIMARY KEY  (`id`),
  KEY `rsip` (`rsip`),
  UNIQUE KEY `pool-endpoint` (`rspool_id`,`rsip`,`rsport`),
  CONSTRAINT `IPv4RS-FK` FOREIGN KEY (`rspool_id`) REFERENCES `IPv4RSPool` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `IPv4RSPool` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` char(255) default NULL,
  `vsconfig` text,
  `rsconfig` text,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB;

CREATE TABLE `IPv4VS` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `vip` int(10) unsigned default NULL,
  `vport` smallint(5) unsigned default NULL,
  `proto` enum('TCP','UDP') NOT NULL default 'TCP',
  `name` char(255) default NULL,
  `vsconfig` text,
  `rsconfig` text,
  PRIMARY KEY  (`id`),
  KEY `vip` (`vip`)
) ENGINE=InnoDB;

CREATE TABLE `IPv6Address` (
  `ip` binary(16) NOT NULL,
  `name` char(255) NOT NULL default '',
  `reserved` enum('yes','no') default NULL,
  PRIMARY KEY  (`ip`)
) ENGINE=InnoDB;

CREATE TABLE `IPv6Allocation` (
  `object_id` int(10) unsigned NOT NULL default '0',
  `ip` binary(16) NOT NULL,
  `name` char(255) NOT NULL default '',
  `type` enum('regular','shared','virtual','router') default NULL,
  PRIMARY KEY  (`object_id`,`ip`),
  KEY `ip` (`ip`),
  CONSTRAINT `IPv6Allocation-FK-object_id` FOREIGN KEY (`object_id`) REFERENCES `RackObject` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `IPv6Network` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `ip` binary(16) NOT NULL,
  `mask` int(10) unsigned NOT NULL,
  `last_ip` binary(16) NOT NULL,
  `name` char(255) default NULL,
  `comment` text,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `ip` (`ip`,`mask`)
) ENGINE=InnoDB;

CREATE TABLE `LDAPCache` (
  `presented_username` char(64) NOT NULL,
  `successful_hash` char(40) NOT NULL,
  `first_success` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `last_retry` timestamp NOT NULL default '0000-00-00 00:00:00',
  `displayed_name` char(128) default NULL,
  `memberof` text,
  UNIQUE KEY `presented_username` (`presented_username`),
  KEY `scanidx` (`presented_username`,`successful_hash`)
) ENGINE=InnoDB;

CREATE TABLE `Link` (
  `porta` int(10) unsigned NOT NULL default '0',
  `portb` int(10) unsigned NOT NULL default '0',
  `cable` char(64) DEFAULT NULL,
  PRIMARY KEY  (`porta`,`portb`),
  UNIQUE KEY `porta` (`porta`),
  UNIQUE KEY `portb` (`portb`),
  CONSTRAINT `Link-FK-a` FOREIGN KEY (`porta`) REFERENCES `Port` (`id`) ON DELETE CASCADE,
  CONSTRAINT `Link-FK-b` FOREIGN KEY (`portb`) REFERENCES `Port` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `Molecule` (
  `id` int(10) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB;

CREATE TABLE `MountOperation` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `object_id` int(10) unsigned NOT NULL default '0',
  `ctime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `user_name` char(64) default NULL,
  `old_molecule_id` int(10) unsigned default NULL,
  `new_molecule_id` int(10) unsigned default NULL,
  `comment` text,
  PRIMARY KEY  (`id`),
  KEY `object_id` (`object_id`),
  CONSTRAINT `MountOperation-FK-object_id` FOREIGN KEY (`object_id`) REFERENCES `RackObject` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `ObjectLog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `object_id` int(10) unsigned NOT NULL,
  `user` char(64) NOT NULL,
  `date` datetime NOT NULL,
  `content` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `object_id` (`object_id`),
  KEY `date` (`date`),
  CONSTRAINT `ObjectLog-FK-object_id` FOREIGN KEY (`object_id`) REFERENCES `RackObject` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `ObjectParentCompat` (
  `parent_objtype_id` int(10) unsigned NOT NULL,
  `child_objtype_id` int(10) unsigned NOT NULL,
  UNIQUE KEY `parent_child` (`parent_objtype_id`,`child_objtype_id`)
) ENGINE=InnoDB;

CREATE TABLE `Port` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `object_id` int(10) unsigned NOT NULL default '0',
  `name` char(255) NOT NULL default '',
  `iif_id` int(10) unsigned NOT NULL,
  `type` int(10) unsigned NOT NULL default '0',
  `l2address` char(64) default NULL,
  `reservation_comment` char(255) default NULL,
  `label` char(255) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `object_iif_oif_name` (`object_id`,`iif_id`,`type`,`name`),
  KEY `type` (`type`),
  KEY `comment` (`reservation_comment`),
  KEY `l2address` (`l2address`),
  KEY `Port-FK-iif-oif` (`iif_id`,`type`),
  CONSTRAINT `Port-FK-iif-oif` FOREIGN KEY (`iif_id`, `type`) REFERENCES `PortInterfaceCompat` (`iif_id`, `oif_id`),
  CONSTRAINT `Port-FK-object_id` FOREIGN KEY (`object_id`) REFERENCES `RackObject` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `PortAllowedVLAN` (
  `object_id` int(10) unsigned NOT NULL,
  `port_name` char(255) NOT NULL,
  `vlan_id` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`object_id`,`port_name`,`vlan_id`),
  KEY `vlan_id` (`vlan_id`),
  CONSTRAINT `PortAllowedVLAN-FK-object-port` FOREIGN KEY (`object_id`, `port_name`) REFERENCES `PortVLANMode` (`object_id`, `port_name`) ON DELETE CASCADE,
  CONSTRAINT `PortAllowedVLAN-FK-vlan_id` FOREIGN KEY (`vlan_id`) REFERENCES `VLANValidID` (`vlan_id`)
) ENGINE=InnoDB;

CREATE TABLE `PortCompat` (
  `type1` int(10) unsigned NOT NULL default '0',
  `type2` int(10) unsigned NOT NULL default '0',
  UNIQUE KEY `type1_2` (`type1`,`type2`),
  KEY `type2` (`type2`)
) ENGINE=InnoDB;

CREATE TABLE `PortInnerInterface` (
  `id` int(10) unsigned NOT NULL,
  `iif_name` char(16) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `iif_name` (`iif_name`)
) ENGINE=InnoDB;

CREATE TABLE `PortInterfaceCompat` (
  `iif_id` int(10) unsigned NOT NULL,
  `oif_id` int(10) unsigned NOT NULL,
  UNIQUE KEY `pair` (`iif_id`,`oif_id`),
  CONSTRAINT `PortInterfaceCompat-FK-iif_id` FOREIGN KEY (`iif_id`) REFERENCES `PortInnerInterface` (`id`)
) ENGINE=InnoDB;

CREATE TABLE `PortNativeVLAN` (
  `object_id` int(10) unsigned NOT NULL,
  `port_name` char(255) NOT NULL,
  `vlan_id` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`object_id`,`port_name`,`vlan_id`),
  UNIQUE KEY `port_id` (`object_id`,`port_name`),
  CONSTRAINT `PortNativeVLAN-FK-compound` FOREIGN KEY (`object_id`, `port_name`, `vlan_id`) REFERENCES `PortAllowedVLAN` (`object_id`, `port_name`, `vlan_id`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `PortVLANMode` (
  `object_id` int(10) unsigned NOT NULL,
  `port_name` char(255) NOT NULL,
  `vlan_mode` enum('access','trunk') NOT NULL default 'access',
  PRIMARY KEY  (`object_id`,`port_name`),
  CONSTRAINT `PortVLANMode-FK-object-port` FOREIGN KEY (`object_id`, `port_name`) REFERENCES `CachedPVM` (`object_id`, `port_name`)
) ENGINE=InnoDB;

CREATE TABLE `Rack` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` char(255) default NULL,
  `row_id` int(10) unsigned NOT NULL default '1',
  `height` tinyint(3) unsigned NOT NULL default '42',
  `comment` text,
  `thumb_data` blob,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name_in_row` (`row_id`,`name`),
  CONSTRAINT `Rack-FK-row_id` FOREIGN KEY (`row_id`) REFERENCES `RackRow` (`id`)
) ENGINE=InnoDB;

CREATE TABLE `RackHistory` (
  `id` int(10) unsigned default NULL,
  `name` char(255) default NULL,
  `row_id` int(10) unsigned default NULL,
  `height` tinyint(3) unsigned default NULL,
  `comment` text,
  `thumb_data` blob,
  `ctime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `user_name` char(64) default NULL
) ENGINE=InnoDB;

CREATE TABLE `RackObject` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` char(255) default NULL,
  `label` char(255) default NULL,
  `objtype_id` int(10) unsigned NOT NULL default '1',
  `asset_no` char(64) default NULL,
  `has_problems` enum('yes','no') NOT NULL default 'no',
  `comment` text,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `RackObject_asset_no` (`asset_no`),
  UNIQUE KEY `name` (`name`),
  KEY `id-tid` (`id`,`objtype_id`)
) ENGINE=InnoDB;

CREATE TABLE `RackObjectHistory` (
  `id` int(10) unsigned default NULL,
  `name` char(255) default NULL,
  `label` char(255) default NULL,
  `objtype_id` int(10) unsigned default NULL,
  `asset_no` char(64) default NULL,
  `has_problems` enum('yes','no') NOT NULL default 'no',
  `comment` text,
  `ctime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `user_name` char(64) default NULL,
  KEY `id` (`id`),
  CONSTRAINT `RackObjectHistory-FK-object_id` FOREIGN KEY (`id`) REFERENCES `RackObject` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `RackRow` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` char(255) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB;

CREATE TABLE `RackSpace` (
  `rack_id` int(10) unsigned NOT NULL default '0',
  `unit_no` int(10) unsigned NOT NULL default '0',
  `atom` enum('front','interior','rear') NOT NULL default 'interior',
  `state` enum('A','U','T','W') NOT NULL default 'A',
  `object_id` int(10) unsigned default NULL,
  PRIMARY KEY  (`rack_id`,`unit_no`,`atom`),
  KEY `RackSpace_object_id` (`object_id`),
  CONSTRAINT `RackSpace-FK-rack_id` FOREIGN KEY (`rack_id`) REFERENCES `Rack` (`id`),
  CONSTRAINT `RackSpace-FK-object_id` FOREIGN KEY (`object_id`) REFERENCES `RackObject` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `Script` (
  `script_name` char(64) NOT NULL,
  `script_text` longtext,
  PRIMARY KEY  (`script_name`)
) ENGINE=InnoDB;

CREATE TABLE `TagStorage` (
  `entity_realm` enum('file','ipv4net','ipv4vs','ipv4rspool','object','rack','user','ipv6net') NOT NULL default 'object',
  `entity_id` int(10) unsigned NOT NULL,
  `tag_id` int(10) unsigned NOT NULL default '0',
  UNIQUE KEY `entity_tag` (`entity_realm`,`entity_id`,`tag_id`),
  KEY `entity_id` (`entity_id`),
  KEY `TagStorage-FK-tag_id` (`tag_id`),
  CONSTRAINT `TagStorage-FK-tag_id` FOREIGN KEY (`tag_id`) REFERENCES `TagTree` (`id`)
) ENGINE=InnoDB;

CREATE TABLE `TagTree` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `parent_id` int(10) unsigned default NULL,
  `tag` char(255) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `tag` (`tag`),
  KEY `TagTree-K-parent_id` (`parent_id`),
  CONSTRAINT `TagTree-K-parent_id` FOREIGN KEY (`parent_id`) REFERENCES `TagTree` (`id`)
) ENGINE=InnoDB;

CREATE TABLE `UserAccount` (
  `user_id` int(10) unsigned NOT NULL auto_increment,
  `user_name` char(64) NOT NULL default '',
  `user_password_hash` char(40) default NULL,
  `user_realname` char(64) default NULL,
  PRIMARY KEY  (`user_id`),
  UNIQUE KEY `user_name` (`user_name`)
) ENGINE=InnoDB;

CREATE TABLE `UserConfig` (
  `varname` char(32) NOT NULL,
  `varvalue` text NOT NULL,
  `user` char(64) NOT NULL,
  UNIQUE KEY `user_varname` (`user`,`varname`),
  KEY `varname` (`varname`),
  CONSTRAINT `UserConfig-FK-varname` FOREIGN KEY (`varname`) REFERENCES `Config` (`varname`) ON DELETE CASCADE,
  CONSTRAINT `UserConfig-FK-user` FOREIGN KEY (`user`) REFERENCES `UserAccount` (`user_name`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `VLANDescription` (
  `domain_id` int(10) unsigned NOT NULL,
  `vlan_id` int(10) unsigned NOT NULL default '0',
  `vlan_type` enum('ondemand','compulsory','alien') NOT NULL default 'ondemand',
  `vlan_descr` char(255) default NULL,
  PRIMARY KEY  (`domain_id`,`vlan_id`),
  KEY `vlan_id` (`vlan_id`),
  CONSTRAINT `VLANDescription-FK-domain_id` FOREIGN KEY (`domain_id`) REFERENCES `VLANDomain` (`id`) ON DELETE CASCADE,
  CONSTRAINT `VLANDescription-FK-vlan_id` FOREIGN KEY (`vlan_id`) REFERENCES `VLANValidID` (`vlan_id`)
) ENGINE=InnoDB;

CREATE TABLE `VLANDomain` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `description` char(255) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB;

CREATE TABLE `VLANIPv4` (
  `domain_id` int(10) unsigned NOT NULL,
  `vlan_id` int(10) unsigned NOT NULL,
  `ipv4net_id` int(10) unsigned NOT NULL,
  UNIQUE KEY `network-domain` (`ipv4net_id`,`domain_id`),
  KEY `VLANIPv4-FK-compound` (`domain_id`,`vlan_id`),
  CONSTRAINT `VLANIPv4-FK-compound` FOREIGN KEY (`domain_id`, `vlan_id`) REFERENCES `VLANDescription` (`domain_id`, `vlan_id`) ON DELETE CASCADE,
  CONSTRAINT `VLANIPv4-FK-ipv4net_id` FOREIGN KEY (`ipv4net_id`) REFERENCES `IPv4Network` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `VLANIPv6` (
  `domain_id` int(10) unsigned NOT NULL,
  `vlan_id` int(10) unsigned NOT NULL,
  `ipv6net_id` int(10) unsigned NOT NULL,
  UNIQUE KEY `network-domain` (`ipv6net_id`,`domain_id`),
  KEY `VLANIPv6-FK-compound` (`domain_id`,`vlan_id`),
  CONSTRAINT `VLANIPv6-FK-compound` FOREIGN KEY (`domain_id`, `vlan_id`) REFERENCES `VLANDescription` (`domain_id`, `vlan_id`) ON DELETE CASCADE,
  CONSTRAINT `VLANIPv6-FK-ipv6net_id` FOREIGN KEY (`ipv6net_id`) REFERENCES `IPv6Network` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `VLANSTRule` (
  `vst_id` int(10) unsigned NOT NULL,
  `rule_no` int(10) unsigned NOT NULL,
  `port_pcre` char(255) NOT NULL,
  `port_role` enum('access','trunk','anymode','uplink','downlink','none') NOT NULL default 'none',
  `wrt_vlans` char(255) default NULL,
  `description` char(255) default NULL,
  UNIQUE KEY `vst-rule` (`vst_id`,`rule_no`),
  CONSTRAINT `VLANSTRule-FK-vst_id` FOREIGN KEY (`vst_id`) REFERENCES `VLANSwitchTemplate` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE `VLANSwitch` (
  `object_id` int(10) unsigned NOT NULL,
  `domain_id` int(10) unsigned NOT NULL,
  `template_id` int(10) unsigned NOT NULL,
  `mutex_rev` int(10) unsigned NOT NULL default '0',
  `out_of_sync` enum('yes','no') NOT NULL default 'yes',
  `last_errno` int(10) unsigned NOT NULL default '0',
  `last_change` timestamp NOT NULL default '0000-00-00 00:00:00',
  `last_push_started` timestamp NOT NULL default '0000-00-00 00:00:00',
  `last_push_finished` timestamp NOT NULL default '0000-00-00 00:00:00',
  `last_error_ts` timestamp NOT NULL default '0000-00-00 00:00:00',
  UNIQUE KEY `object_id` (`object_id`),
  KEY `domain_id` (`domain_id`),
  KEY `template_id` (`template_id`),
  KEY `out_of_sync` (`out_of_sync`),
  KEY `last_errno` (`last_errno`),
  CONSTRAINT `VLANSwitch-FK-domain_id` FOREIGN KEY (`domain_id`) REFERENCES `VLANDomain` (`id`),
  CONSTRAINT `VLANSwitch-FK-object_id` FOREIGN KEY (`object_id`) REFERENCES `RackObject` (`id`),
  CONSTRAINT `VLANSwitch-FK-template_id` FOREIGN KEY (`template_id`) REFERENCES `VLANSwitchTemplate` (`id`)
) ENGINE=InnoDB;

CREATE TABLE `VLANSwitchTemplate` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `mutex_rev` int(10) NOT NULL,
  `description` char(255) default NULL,
  `saved_by` char(64) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB;

CREATE TABLE `VLANValidID` (
  `vlan_id` int(10) unsigned NOT NULL default '1',
  PRIMARY KEY  (`vlan_id`)
) ENGINE=InnoDB;

SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
END_OF_FILE;
##########################################################################
	case 'dictbase':
		$db_version = CODE_VERSION;
		return <<<END_OF_FILE
INSERT INTO `Attribute` (`id`, `type`, `name`) VALUES
(1,'string','OEM S/N 1'),
(2,'dict','HW type'),
(3,'string','FQDN'),
(4,'dict','SW type'),
(5,'string','SW version'),
(6,'uint','number of ports'),
(7,'float','max. current, Ampers'),
(8,'float','power load, percents'),
(14,'string','contact person'),
(13,'float','max power, Watts'),
(16,'uint','flash memory, MB'),
(17,'uint','DRAM, MB'),
(18,'uint','CPU, MHz'),
(20,'string','OEM S/N 2'),
(21,'string','support contract expiration'),
(22,'string','HW warranty expiration'),
(24,'string','SW warranty expiration'),
(25,'string','UUID'),
(26,'dict','Hypervisor'),
(28,'string','Slot number'),
-- ^^^^^ Any new "default" attributes must go above this line! ^^^^^
-- Primary key value 9999 makes sure, that AUTO_INCREMENT on server restart
-- doesn't drop below 10000 (other code relies on this, site-specific
-- attributes are assigned IDs starting from 10000).
(9999,'string','base MAC address');

INSERT INTO `Chapter` (`id`, `sticky`, `name`) VALUES
(1,'yes','RackObjectType'),
(2,'yes','PortOuterInterface'),
(11,'no','server models'),
(12,'no','network switch models'),
(13,'no','server OS type'),
(14,'no','switch OS type'),
(16,'no','router OS type'),
(17,'no','router models'),
(18,'no','disk array models'),
(19,'no','tape library models'),
(21,'no','KVM switch models'),
(23,'no','console models'),
(24,'no','network security models'),
(25,'no','wireless models'),
(26,'no','fibre channel switch models'),
(27,'no','PDU models'),
(28,'no','Voice/video hardware'),
(29,'no','Yes/No'),
(30,'no','network chassis models'),
(31,'no','server chassis models'),
(32,'no','virtual switch models'),
(33,'no','virtual switch OS type'),
(34,'no','power supply chassis models'),
(35,'no','power supply models'),
(36,'no','serial console server models'),
(37,'no','wireless OS type'),
-- Default chapters must have ID less than 10000, add them above this line.
(9999,'no','multiplexer models');

INSERT INTO `AttributeMap` (`objtype_id`, `attr_id`, `chapter_id`) VALUES
(2,1,NULL),
(2,2,27),
(2,3,NULL),
(2,5,NULL),
(4,1,NULL),
(4,2,11),
(4,3,NULL),
(4,4,13),
(4,14,NULL),
(4,21,NULL),
(4,22,NULL),
(4,24,NULL),
(4,25,NULL),
(4,26,29),
(4,28,NULL),
(5,1,NULL),
(5,2,18),
(6,1,NULL),
(6,2,19),
(6,20,NULL),
(7,1,NULL),
(7,2,17),
(7,3,NULL),
(7,4,16),
(7,5,NULL),
(7,14,NULL),
(7,16,NULL),
(7,17,NULL),
(7,18,NULL),
(7,21,NULL),
(7,22,NULL),
(7,24,NULL),
(8,1,NULL),
(8,2,12),
(8,3,NULL),
(8,4,14),
(8,5,NULL),
(8,14,NULL),
(8,16,NULL),
(8,17,NULL),
(8,18,NULL),
(8,20,NULL),
(8,21,NULL),
(8,22,NULL),
(8,24,NULL),
(8,28,NULL),
(9,6,NULL),
(12,1,NULL),
(12,3,NULL),
(12,7,NULL),
(12,8,NULL),
(12,13,NULL),
(12,20,NULL),
(445,1,NULL),
(445,2,21),
(445,3,NULL),
(445,5,NULL),
(445,14,NULL),
(445,22,NULL),
(447,1,NULL),
(447,2,9999),
(447,3,NULL),
(447,5,NULL),
(447,14,NULL),
(447,22,NULL),
(15,2,23),
(798,1,NULL),
(798,2,24),
(798,3,NULL),
(798,5,NULL),
(798,14,NULL),
(798,16,NULL),
(798,17,NULL),
(798,18,NULL),
(798,20,NULL),
(798,21,NULL),
(798,22,NULL),
(798,24,NULL),
(798,28,NULL),
(965,1,NULL),
(965,3,NULL),
(965,2,25),
(965,4,37),
(1055,2,26),
(1055,28,NULL),
(1323,1,NULL),
(1323,2,28),
(1323,3,NULL),
(1323,5,NULL),
(1397,1,NULL),
(1397,2,34),
(1397,14,NULL),
(1397,21,NULL),
(1397,22,NULL),
(1398,1,NULL),
(1398,2,35),
(1398,14,NULL),
(1398,21,NULL),
(1398,22,NULL),
(1502,1,NULL),
(1502,2,31),
(1502,3,NULL),
(1502,14,NULL),
(1502,20,NULL),
(1502,21,NULL),
(1502,22,NULL),
(1503,1,NULL),
(1503,2,30),
(1503,3,NULL),
(1503,4,14),
(1503,5,NULL),
(1503,14,NULL),
(1503,16,NULL),
(1503,17,NULL),
(1503,18,NULL),
(1503,20,NULL),
(1503,21,NULL),
(1503,22,NULL),
(1503,24,NULL),
(1504,3,NULL),
(1504,4,13),
(1504,14,NULL),
(1504,24,NULL),
(1505,14,NULL),
(1506,14,NULL),
(1506,17,NULL),
(1506,18,NULL),
(1507,1,NULL),
(1507,2,32),
(1507,3,NULL),
(1507,4,33),
(1507,5,NULL),
(1507,14,NULL),
(1507,20,NULL),
(1507,21,NULL),
(1507,22,NULL),
(1644, 1, NULL),
(1644, 2, 36),
(1644, 3, NULL);

INSERT INTO `PortInnerInterface` VALUES
(1,'hardwired'),
(2,'SFP-100'),
(3,'GBIC'),
(4,'SFP-1000'),
(5,'XENPAK'),
(6,'X2'),
(7,'XPAK'),
(8,'XFP'),
(9,'SFP+'),
(10,'QSFP+'),
(11,'CFP');

INSERT INTO `ObjectParentCompat` VALUES
(3,13),
(4,1504),
(4,1507),
(1397,1398),
(1502,4),
(1503,8),
(1505,4),
(1505,1504),
(1505,1506),
(1505,1507),
(1506,4),
(1506,1504);

INSERT INTO `PortInterfaceCompat` VALUES
(2,1208),(2,1195),(2,1196),(2,1197),(2,1198),(2,1199),(2,1200),(2,1201),
(3,1078),(3,24),(3,34),(3,1202),(3,1203),(3,1204),(3,1205),(3,1206),(3,1207),
(4,1077),(4,24),(4,34),(4,1202),(4,1203),(4,1204),(4,1205),(4,1206),(4,1207),
(5,1079),(5,30),(5,35),(5,36),(5,37),(5,38),(5,39),(5,40),
(6,1080),(6,30),(6,35),(6,36),(6,37),(6,38),(6,39),(6,40),
(7,1081),(7,30),(7,35),(7,36),(7,37),(7,38),(7,39),(7,40),
(8,1082),(8,30),(8,35),(8,36),(8,37),(8,38),(8,39),(8,40),
(9,1084),(9,30),(9,35),(9,36),(9,37),(9,38),(9,39),(9,40),
(10,1588),(10,1663),(10,1664),
(11,1668),(11,1669),(11,1670),(11,1671),
(1,16),(1,19),(1,24),(1,29),(1,31),(1,33),(1,446),(1,681),(1,682),(1,1322),(1,1399),(1,1469);

INSERT INTO `PortCompat` (`type1`, `type2`) VALUES
(17,17),
(18,18),
(19,19),
(24,24),
(18,19),
(19,18),
(18,24),
(24,18),
(19,24),
(24,19),
(29,29),
(30,30),
(16,1322),
(1322,16),
(29,681),
(29,682),
(32,32),
(33,446),
(34,34),
(35,35),
(36,36),
(37,37),
(38,38),
(39,39),
(40,40),
(41,41),
(439,439),
(446,33),
(681,29),
(681,681),
(681,682),
(682,29),
(682,681),
(682,682),
(1077,1077),
(1084,1084),
(1087,1087),
(1195,1195),
(1196,1196),
(1197,1197),
(1198,1199),
(1199,1198),
(1200,1200),
(1201,1201),
(1202,1202),
(1203,1203),
(1204,1204),
(1205,1205),
(1206,1207),
(1207,1206),
(1209,1209),
(1210,1210),
(1211,1211),
(1212,1212),
(1213,1213),
(1214,1214),
(1215,1215),
(1216,1216),
(1217,1217),
(1218,1218),
(1219,1219),
(1220,1220),
(1221,1221),
(1222,1222),
(1223,1223),
(1224,1224),
(1225,1225),
(1226,1226),
(1227,1227),
(1228,1228),
(1229,1229),
(1230,1230),
(1231,1231),
(1232,1232),
(1233,1233),
(1234,1234),
(1235,1235),
(1236,1236),
(1237,1237),
(1238,1238),
(1239,1239),
(1240,1240),
(1241,1241),
(1242,1242),
(1243,1243),
(1244,1244),
(1245,1245),
(1246,1246),
(1247,1247),
(1248,1248),
(1249,1249),
(1250,1250),
(1251,1251),
(1252,1252),
(1253,1253),
(1254,1254),
(1255,1255),
(1256,1256),
(1257,1257),
(1258,1258),
(1259,1259),
(1260,1260),
(1261,1261),
(1262,1262),
(1263,1263),
(1264,1264),
(1265,1265),
(1266,1266),
(1267,1267),
(1268,1268),
(1269,1269),
(1270,1270),
(1271,1271),
(1272,1272),
(1273,1273),
(1274,1274),
(1275,1275),
(1276,1276),
(1277,1277),
(1278,1278),
(1279,1279),
(1280,1280),
(1281,1281),
(1282,1282),
(1283,1283),
(1284,1284),
(1285,1285),
(1286,1286),
(1287,1287),
(1288,1288),
(1289,1289),
(1290,1290),
(1291,1291),
(1292,1292),
(1293,1293),
(1294,1294),
(1295,1295),
(1296,1296),
(1297,1297),
(1298,1298),
(1299,1299),
(1300,1300),
(1316,1316),
(1424,1424),
(1425,1425),
(1426,1426),
(1427,1427),
(1428,1428),
(1429,1429),
(1430,1430),
(1431,1431),
(1432,1432),
(1433,1433),
(1434,1434),
(1435,1435),
(1436,1436),
(1437,1437),
(1438,1438),
(1439,1439),
(1440,1440),
(1441,1441),
(1442,1442),
(1443,1443),
(1444,1444),
(1445,1445),
(1446,1446),
(1447,1447),
(1448,1448),
(1449,1449),
(1450,1450),
(1451,1451),
(1452,1452),
(1453,1453),
(1454,1454),
(1455,1455),
(1456,1456),
(1457,1457),
(1458,1458),
(1459,1459),
(1460,1460),
(1461,1461),
(1462,1462),
(1463,1463),
(1464,1464),
(1465,1465),
(1466,1466),
(1469,1469),
(1399,1399),
(1588,1588),
(1603,1603),
(1661,1661),
(1663,1663),
(1664,1664),
(1668,1668),
(1669,1669),
(1670,1670),
(1671,1671),
(1642,1642);

INSERT INTO `Config` (varname, varvalue, vartype, emptyok, is_hidden, is_userdefined, description) VALUES
('MASSCOUNT','8','uint','no','no','yes','&quot;Fast&quot; form is this many records tall'),
('MAXSELSIZE','30','uint','no','no','yes','&lt;SELECT&gt; lists height'),
('enterprise','MyCompanyName','string','no','no','no','Organization name'),
('ROW_SCALE','2','uint','no','no','yes','Picture scale for rack row display'),
('PORTS_PER_ROW','12','uint','no','no','yes','Ports per row in VLANs tab'),
('IPV4_ADDRS_PER_PAGE','256','uint','no','no','yes','IPv4 addresses per page'),
('DEFAULT_RACK_HEIGHT','42','uint','yes','no','yes','Default rack height'),
('DEFAULT_SLB_VS_PORT','','uint','yes','no','yes','Default port of SLB virtual service'),
('DEFAULT_SLB_RS_PORT','','uint','yes','no','yes','Default port of SLB real server'),
('DETECT_URLS','no','string','yes','no','yes','Detect URLs in text fields'),
('RACK_PRESELECT_THRESHOLD','1','uint','no','no','yes','Rack pre-selection threshold'),
('DEFAULT_IPV4_RS_INSERVICE','no','string','no','no','yes','Inservice status for new SLB real servers'),
('AUTOPORTS_CONFIG','4 = 1*33*kvm + 2*24*eth%u;15 = 1*446*kvm','string','yes','no','no','AutoPorts configuration'),
('DEFAULT_OBJECT_TYPE','4','uint','yes','no','yes','Default object type for new objects'),
('SHOW_EXPLICIT_TAGS','yes','string','no','no','yes','Show explicit tags'),
('SHOW_IMPLICIT_TAGS','yes','string','no','no','yes','Show implicit tags'),
('SHOW_AUTOMATIC_TAGS','no','string','no','no','yes','Show automatic tags'),
('IPV4_AUTO_RELEASE','1','uint','no','no','yes','Auto-release IPv4 addresses on allocation'),
('SHOW_LAST_TAB','no','string','yes','no','yes','Remember last tab shown for each page'),
('EXT_IPV4_VIEW','yes','string','no','no','yes','Extended IPv4 view'),
('TREE_THRESHOLD','25','uint','yes','no','yes','Tree view auto-collapse threshold'),
('IPV4_JAYWALK','no','string','no','no','no','Enable IPv4 address allocations w/o covering network'),
('ADDNEW_AT_TOP','yes','string','no','no','yes','Render "add new" line at top of the list'),
('IPV4_TREE_SHOW_USAGE','yes','string','no','no','yes','Show address usage in IPv4 tree'),
('PREVIEW_TEXT_MAXCHARS','10240','uint','yes','no','yes','Max chars for text file preview'),
('PREVIEW_TEXT_ROWS','25','uint','yes','no','yes','Rows for text file preview'),
('PREVIEW_TEXT_COLS','80','uint','yes','no','yes','Columns for text file preview'),
('PREVIEW_IMAGE_MAXPXS','320','uint','yes','no','yes','Max pixels per axis for image file preview'),
('VENDOR_SIEVE','','string','yes','no','yes','Vendor sieve configuration'),
('IPV4LB_LISTSRC','{\$typeid_4}','string','yes','no','no','List source: IPv4 load balancers'),
('IPV4OBJ_LISTSRC','{\$typeid_4} or {\$typeid_7} or {\$typeid_8} or {\$typeid_12} or {\$typeid_445} or {\$typeid_447} or {\$typeid_798} or {\$typeid_1397} or {\$typeid_1502} or {\$typeid_1503} or {\$typeid_1504} or {\$typeid_1507}','string','yes','no','no','List source: IPv4-enabled objects'),
('IPV4NAT_LISTSRC','{\$typeid_4} or {\$typeid_7} or {\$typeid_8} or {\$typeid_798}','string','yes','no','no','List source: IPv4 NAT performers'),
('ASSETWARN_LISTSRC','{\$typeid_4} or {\$typeid_7} or {\$typeid_8}','string','yes','no','no','List source: object, for which asset tag should be set'),
('NAMEWARN_LISTSRC','{\$typeid_4} or {\$typeid_7} or {\$typeid_8}','string','yes','no','no','List source: object, for which common name should be set'),
('RACKS_PER_ROW','12','uint','yes','no','yes','Racks per row'),
('FILTER_PREDICATE_SIEVE','','string','yes','no','no','Predicate sieve regex(7)'),
('FILTER_DEFAULT_ANDOR','or','string','no','no','no','Default list filter boolean operation (or/and)'),
('FILTER_SUGGEST_ANDOR','yes','string','no','no','no','Suggest and/or selector in list filter'),
('FILTER_SUGGEST_TAGS','yes','string','no','no','no','Suggest tags in list filter'),
('FILTER_SUGGEST_PREDICATES','yes','string','no','no','no','Suggest predicates in list filter'),
('FILTER_SUGGEST_EXTRA','no','string','no','no','no','Suggest extra expression in list filter'),
('DEFAULT_SNMP_COMMUNITY','public','string','no','no','no','Default SNMP Community string'),
('IPV4_ENABLE_KNIGHT','yes','string','no','no','no','Enable IPv4 knight feature'),
('TAGS_TOPLIST_SIZE','50','uint','yes','no','no','Tags top list size'),
('TAGS_QUICKLIST_SIZE','20','uint','no','no','no','Tags quick list size'),
('TAGS_QUICKLIST_THRESHOLD','50','uint','yes','no','no','Tags quick list threshold'),
('ENABLE_MULTIPORT_FORM','no','string','no','no','no','Enable "Add/update multiple ports" form'),
('DEFAULT_PORT_IIF_ID','1','uint','no','no','no','Default port inner interface ID'),
('DEFAULT_PORT_OIF_IDS','1=24; 3=1078; 4=1077; 5=1079; 6=1080; 8=1082; 9=1084; 10=1588; 11=1668','string','no','no','no','Default port outer interface IDs'),
('IPV4_TREE_RTR_AS_CELL','yes','string','no','no','no','Show full router info for each network in IPv4 tree view'),
('PROXIMITY_RANGE','0','uint','yes','no','no','Proximity range (0 is current rack only)'),
('VLANSWITCH_LISTSRC', '', 'string', 'yes', 'no', 'yes', 'List of VLAN running switches'),
('VLANIPV4NET_LISTSRC', '', 'string', 'yes', 'no', 'yes', 'List of VLAN-based IPv4 networks'),
('IPV4_TREE_SHOW_VLAN','yes','string','no','no','yes','Show VLAN for each network in IPv4 tree'),
('DEFAULT_VDOM_ID','','uint','yes','no','yes','Default VLAN domain ID'),
('DEFAULT_VST_ID','','uint','yes','no','yes','Default VLAN switch template ID'),
('8021Q_DEPLOY_MINAGE','300','uint','no','no','no','802.1Q deploy minimum age'),
('8021Q_DEPLOY_MAXAGE','3600','uint','no','no','no','802.1Q deploy maximum age'),
('8021Q_DEPLOY_RETRY','10800','uint','no','no','no','802.1Q deploy retry timer'),
('8021Q_WRI_AFTER_CONFT_LISTSRC','false','string','no','no','no','802.1Q: save device configuration after deploy (RackCode)'),
('8021Q_INSTANT_DEPLOY','no','string','no','no','yes','802.1Q: instant deploy'),
('STATIC_FILTER','yes','string','no','no','yes','Enable Filter Caching'),
('ENABLE_BULKPORT_FORM','yes','string','no','no','yes','Enable "Bulk Port" form'),
('CDP_RUNNERS_LISTSRC', '', 'string', 'yes', 'no', 'no', 'List of devices running CDP'),
('LLDP_RUNNERS_LISTSRC', '', 'string', 'yes', 'no', 'no', 'List of devices running LLDP'),
('SHRINK_TAG_TREE_ON_CLICK','yes','string','no','no','yes','Dynamically hide useless tags in tagtree'),
('MAX_UNFILTERED_ENTITIES','0','uint','no','no','yes','Max item count to display on unfiltered result page'),
('SYNCDOMAIN_MAX_PROCESSES','0','uint','yes','no', 'no', 'How many worker proceses syncdomain cron script should create'),
('PORT_EXCLUSION_LISTSRC','{\$typeid_3} or {\$typeid_10} or {\$typeid_11} or {\$typeid_1505} or {\$typeid_1506}','string','yes','no','no','List source: objects without ports'),
('FILTER_RACKLIST_BY_TAGS','yes','string','yes','no','yes','Rackspace: show only racks matching the current object\'s tags'),
('SSH_OBJS_LISTSRC','none','string','yes','no','yes','Rackcode filter for SSH-managed objects'),
('TELNET_OBJS_LISTSRC','none','string','yes','no','yes','Rackcode filter for telnet-managed objects'),
('CACTI_LISTSRC','false','string','yes','no','no','List of object with Cacti graphs'),
('CACTI_URL','','string','yes','no','no','Cacti server base URL'),
('CACTI_USERNAME','','string','yes','no','no','Cacti user account'),
('CACTI_USERPASS','','string','yes','no','no','Cacti user password'),
('VIRTUAL_OBJ_LISTSRC','1504,1505,1506,1507','string','no','no','no','List source: virtual objects'),
('DB_VERSION','${db_version}','string','no','yes','no','Database version.');

INSERT INTO `Script` VALUES ('RackCode','allow {\$userid_1}');

INSERT INTO VLANValidID (vlan_id) VALUES
(1),
(2),
(3),
(4),
(5),
(6),
(7),
(8),
(9),
(10),
(11),
(12),
(13),
(14),
(15),
(16),
(17),
(18),
(19),
(20),
(21),
(22),
(23),
(24),
(25),
(26),
(27),
(28),
(29),
(30),
(31),
(32),
(33),
(34),
(35),
(36),
(37),
(38),
(39),
(40),
(41),
(42),
(43),
(44),
(45),
(46),
(47),
(48),
(49),
(50),
(51),
(52),
(53),
(54),
(55),
(56),
(57),
(58),
(59),
(60),
(61),
(62),
(63),
(64),
(65),
(66),
(67),
(68),
(69),
(70),
(71),
(72),
(73),
(74),
(75),
(76),
(77),
(78),
(79),
(80),
(81),
(82),
(83),
(84),
(85),
(86),
(87),
(88),
(89),
(90),
(91),
(92),
(93),
(94),
(95),
(96),
(97),
(98),
(99),
(100),
(101),
(102),
(103),
(104),
(105),
(106),
(107),
(108),
(109),
(110),
(111),
(112),
(113),
(114),
(115),
(116),
(117),
(118),
(119),
(120),
(121),
(122),
(123),
(124),
(125),
(126),
(127),
(128),
(129),
(130),
(131),
(132),
(133),
(134),
(135),
(136),
(137),
(138),
(139),
(140),
(141),
(142),
(143),
(144),
(145),
(146),
(147),
(148),
(149),
(150),
(151),
(152),
(153),
(154),
(155),
(156),
(157),
(158),
(159),
(160),
(161),
(162),
(163),
(164),
(165),
(166),
(167),
(168),
(169),
(170),
(171),
(172),
(173),
(174),
(175),
(176),
(177),
(178),
(179),
(180),
(181),
(182),
(183),
(184),
(185),
(186),
(187),
(188),
(189),
(190),
(191),
(192),
(193),
(194),
(195),
(196),
(197),
(198),
(199),
(200),
(201),
(202),
(203),
(204),
(205),
(206),
(207),
(208),
(209),
(210),
(211),
(212),
(213),
(214),
(215),
(216),
(217),
(218),
(219),
(220),
(221),
(222),
(223),
(224),
(225),
(226),
(227),
(228),
(229),
(230),
(231),
(232),
(233),
(234),
(235),
(236),
(237),
(238),
(239),
(240),
(241),
(242),
(243),
(244),
(245),
(246),
(247),
(248),
(249),
(250),
(251),
(252),
(253),
(254),
(255),
(256),
(257),
(258),
(259),
(260),
(261),
(262),
(263),
(264),
(265),
(266),
(267),
(268),
(269),
(270),
(271),
(272),
(273),
(274),
(275),
(276),
(277),
(278),
(279),
(280),
(281),
(282),
(283),
(284),
(285),
(286),
(287),
(288),
(289),
(290),
(291),
(292),
(293),
(294),
(295),
(296),
(297),
(298),
(299),
(300),
(301),
(302),
(303),
(304),
(305),
(306),
(307),
(308),
(309),
(310),
(311),
(312),
(313),
(314),
(315),
(316),
(317),
(318),
(319),
(320),
(321),
(322),
(323),
(324),
(325),
(326),
(327),
(328),
(329),
(330),
(331),
(332),
(333),
(334),
(335),
(336),
(337),
(338),
(339),
(340),
(341),
(342),
(343),
(344),
(345),
(346),
(347),
(348),
(349),
(350),
(351),
(352),
(353),
(354),
(355),
(356),
(357),
(358),
(359),
(360),
(361),
(362),
(363),
(364),
(365),
(366),
(367),
(368),
(369),
(370),
(371),
(372),
(373),
(374),
(375),
(376),
(377),
(378),
(379),
(380),
(381),
(382),
(383),
(384),
(385),
(386),
(387),
(388),
(389),
(390),
(391),
(392),
(393),
(394),
(395),
(396),
(397),
(398),
(399),
(400),
(401),
(402),
(403),
(404),
(405),
(406),
(407),
(408),
(409),
(410),
(411),
(412),
(413),
(414),
(415),
(416),
(417),
(418),
(419),
(420),
(421),
(422),
(423),
(424),
(425),
(426),
(427),
(428),
(429),
(430),
(431),
(432),
(433),
(434),
(435),
(436),
(437),
(438),
(439),
(440),
(441),
(442),
(443),
(444),
(445),
(446),
(447),
(448),
(449),
(450),
(451),
(452),
(453),
(454),
(455),
(456),
(457),
(458),
(459),
(460),
(461),
(462),
(463),
(464),
(465),
(466),
(467),
(468),
(469),
(470),
(471),
(472),
(473),
(474),
(475),
(476),
(477),
(478),
(479),
(480),
(481),
(482),
(483),
(484),
(485),
(486),
(487),
(488),
(489),
(490),
(491),
(492),
(493),
(494),
(495),
(496),
(497),
(498),
(499),
(500),
(501),
(502),
(503),
(504),
(505),
(506),
(507),
(508),
(509),
(510),
(511),
(512),
(513),
(514),
(515),
(516),
(517),
(518),
(519),
(520),
(521),
(522),
(523),
(524),
(525),
(526),
(527),
(528),
(529),
(530),
(531),
(532),
(533),
(534),
(535),
(536),
(537),
(538),
(539),
(540),
(541),
(542),
(543),
(544),
(545),
(546),
(547),
(548),
(549),
(550),
(551),
(552),
(553),
(554),
(555),
(556),
(557),
(558),
(559),
(560),
(561),
(562),
(563),
(564),
(565),
(566),
(567),
(568),
(569),
(570),
(571),
(572),
(573),
(574),
(575),
(576),
(577),
(578),
(579),
(580),
(581),
(582),
(583),
(584),
(585),
(586),
(587),
(588),
(589),
(590),
(591),
(592),
(593),
(594),
(595),
(596),
(597),
(598),
(599),
(600),
(601),
(602),
(603),
(604),
(605),
(606),
(607),
(608),
(609),
(610),
(611),
(612),
(613),
(614),
(615),
(616),
(617),
(618),
(619),
(620),
(621),
(622),
(623),
(624),
(625),
(626),
(627),
(628),
(629),
(630),
(631),
(632),
(633),
(634),
(635),
(636),
(637),
(638),
(639),
(640),
(641),
(642),
(643),
(644),
(645),
(646),
(647),
(648),
(649),
(650),
(651),
(652),
(653),
(654),
(655),
(656),
(657),
(658),
(659),
(660),
(661),
(662),
(663),
(664),
(665),
(666),
(667),
(668),
(669),
(670),
(671),
(672),
(673),
(674),
(675),
(676),
(677),
(678),
(679),
(680),
(681),
(682),
(683),
(684),
(685),
(686),
(687),
(688),
(689),
(690),
(691),
(692),
(693),
(694),
(695),
(696),
(697),
(698),
(699),
(700),
(701),
(702),
(703),
(704),
(705),
(706),
(707),
(708),
(709),
(710),
(711),
(712),
(713),
(714),
(715),
(716),
(717),
(718),
(719),
(720),
(721),
(722),
(723),
(724),
(725),
(726),
(727),
(728),
(729),
(730),
(731),
(732),
(733),
(734),
(735),
(736),
(737),
(738),
(739),
(740),
(741),
(742),
(743),
(744),
(745),
(746),
(747),
(748),
(749),
(750),
(751),
(752),
(753),
(754),
(755),
(756),
(757),
(758),
(759),
(760),
(761),
(762),
(763),
(764),
(765),
(766),
(767),
(768),
(769),
(770),
(771),
(772),
(773),
(774),
(775),
(776),
(777),
(778),
(779),
(780),
(781),
(782),
(783),
(784),
(785),
(786),
(787),
(788),
(789),
(790),
(791),
(792),
(793),
(794),
(795),
(796),
(797),
(798),
(799),
(800),
(801),
(802),
(803),
(804),
(805),
(806),
(807),
(808),
(809),
(810),
(811),
(812),
(813),
(814),
(815),
(816),
(817),
(818),
(819),
(820),
(821),
(822),
(823),
(824),
(825),
(826),
(827),
(828),
(829),
(830),
(831),
(832),
(833),
(834),
(835),
(836),
(837),
(838),
(839),
(840),
(841),
(842),
(843),
(844),
(845),
(846),
(847),
(848),
(849),
(850),
(851),
(852),
(853),
(854),
(855),
(856),
(857),
(858),
(859),
(860),
(861),
(862),
(863),
(864),
(865),
(866),
(867),
(868),
(869),
(870),
(871),
(872),
(873),
(874),
(875),
(876),
(877),
(878),
(879),
(880),
(881),
(882),
(883),
(884),
(885),
(886),
(887),
(888),
(889),
(890),
(891),
(892),
(893),
(894),
(895),
(896),
(897),
(898),
(899),
(900),
(901),
(902),
(903),
(904),
(905),
(906),
(907),
(908),
(909),
(910),
(911),
(912),
(913),
(914),
(915),
(916),
(917),
(918),
(919),
(920),
(921),
(922),
(923),
(924),
(925),
(926),
(927),
(928),
(929),
(930),
(931),
(932),
(933),
(934),
(935),
(936),
(937),
(938),
(939),
(940),
(941),
(942),
(943),
(944),
(945),
(946),
(947),
(948),
(949),
(950),
(951),
(952),
(953),
(954),
(955),
(956),
(957),
(958),
(959),
(960),
(961),
(962),
(963),
(964),
(965),
(966),
(967),
(968),
(969),
(970),
(971),
(972),
(973),
(974),
(975),
(976),
(977),
(978),
(979),
(980),
(981),
(982),
(983),
(984),
(985),
(986),
(987),
(988),
(989),
(990),
(991),
(992),
(993),
(994),
(995),
(996),
(997),
(998),
(999),
(1000),
(1001),
(1002),
(1003),
(1004),
(1005),
(1006),
(1007),
(1008),
(1009),
(1010),
(1011),
(1012),
(1013),
(1014),
(1015),
(1016),
(1017),
(1018),
(1019),
(1020),
(1021),
(1022),
(1023),
(1024),
(1025),
(1026),
(1027),
(1028),
(1029),
(1030),
(1031),
(1032),
(1033),
(1034),
(1035),
(1036),
(1037),
(1038),
(1039),
(1040),
(1041),
(1042),
(1043),
(1044),
(1045),
(1046),
(1047),
(1048),
(1049),
(1050),
(1051),
(1052),
(1053),
(1054),
(1055),
(1056),
(1057),
(1058),
(1059),
(1060),
(1061),
(1062),
(1063),
(1064),
(1065),
(1066),
(1067),
(1068),
(1069),
(1070),
(1071),
(1072),
(1073),
(1074),
(1075),
(1076),
(1077),
(1078),
(1079),
(1080),
(1081),
(1082),
(1083),
(1084),
(1085),
(1086),
(1087),
(1088),
(1089),
(1090),
(1091),
(1092),
(1093),
(1094),
(1095),
(1096),
(1097),
(1098),
(1099),
(1100),
(1101),
(1102),
(1103),
(1104),
(1105),
(1106),
(1107),
(1108),
(1109),
(1110),
(1111),
(1112),
(1113),
(1114),
(1115),
(1116),
(1117),
(1118),
(1119),
(1120),
(1121),
(1122),
(1123),
(1124),
(1125),
(1126),
(1127),
(1128),
(1129),
(1130),
(1131),
(1132),
(1133),
(1134),
(1135),
(1136),
(1137),
(1138),
(1139),
(1140),
(1141),
(1142),
(1143),
(1144),
(1145),
(1146),
(1147),
(1148),
(1149),
(1150),
(1151),
(1152),
(1153),
(1154),
(1155),
(1156),
(1157),
(1158),
(1159),
(1160),
(1161),
(1162),
(1163),
(1164),
(1165),
(1166),
(1167),
(1168),
(1169),
(1170),
(1171),
(1172),
(1173),
(1174),
(1175),
(1176),
(1177),
(1178),
(1179),
(1180),
(1181),
(1182),
(1183),
(1184),
(1185),
(1186),
(1187),
(1188),
(1189),
(1190),
(1191),
(1192),
(1193),
(1194),
(1195),
(1196),
(1197),
(1198),
(1199),
(1200),
(1201),
(1202),
(1203),
(1204),
(1205),
(1206),
(1207),
(1208),
(1209),
(1210),
(1211),
(1212),
(1213),
(1214),
(1215),
(1216),
(1217),
(1218),
(1219),
(1220),
(1221),
(1222),
(1223),
(1224),
(1225),
(1226),
(1227),
(1228),
(1229),
(1230),
(1231),
(1232),
(1233),
(1234),
(1235),
(1236),
(1237),
(1238),
(1239),
(1240),
(1241),
(1242),
(1243),
(1244),
(1245),
(1246),
(1247),
(1248),
(1249),
(1250),
(1251),
(1252),
(1253),
(1254),
(1255),
(1256),
(1257),
(1258),
(1259),
(1260),
(1261),
(1262),
(1263),
(1264),
(1265),
(1266),
(1267),
(1268),
(1269),
(1270),
(1271),
(1272),
(1273),
(1274),
(1275),
(1276),
(1277),
(1278),
(1279),
(1280),
(1281),
(1282),
(1283),
(1284),
(1285),
(1286),
(1287),
(1288),
(1289),
(1290),
(1291),
(1292),
(1293),
(1294),
(1295),
(1296),
(1297),
(1298),
(1299),
(1300),
(1301),
(1302),
(1303),
(1304),
(1305),
(1306),
(1307),
(1308),
(1309),
(1310),
(1311),
(1312),
(1313),
(1314),
(1315),
(1316),
(1317),
(1318),
(1319),
(1320),
(1321),
(1322),
(1323),
(1324),
(1325),
(1326),
(1327),
(1328),
(1329),
(1330),
(1331),
(1332),
(1333),
(1334),
(1335),
(1336),
(1337),
(1338),
(1339),
(1340),
(1341),
(1342),
(1343),
(1344),
(1345),
(1346),
(1347),
(1348),
(1349),
(1350),
(1351),
(1352),
(1353),
(1354),
(1355),
(1356),
(1357),
(1358),
(1359),
(1360),
(1361),
(1362),
(1363),
(1364),
(1365),
(1366),
(1367),
(1368),
(1369),
(1370),
(1371),
(1372),
(1373),
(1374),
(1375),
(1376),
(1377),
(1378),
(1379),
(1380),
(1381),
(1382),
(1383),
(1384),
(1385),
(1386),
(1387),
(1388),
(1389),
(1390),
(1391),
(1392),
(1393),
(1394),
(1395),
(1396),
(1397),
(1398),
(1399),
(1400),
(1401),
(1402),
(1403),
(1404),
(1405),
(1406),
(1407),
(1408),
(1409),
(1410),
(1411),
(1412),
(1413),
(1414),
(1415),
(1416),
(1417),
(1418),
(1419),
(1420),
(1421),
(1422),
(1423),
(1424),
(1425),
(1426),
(1427),
(1428),
(1429),
(1430),
(1431),
(1432),
(1433),
(1434),
(1435),
(1436),
(1437),
(1438),
(1439),
(1440),
(1441),
(1442),
(1443),
(1444),
(1445),
(1446),
(1447),
(1448),
(1449),
(1450),
(1451),
(1452),
(1453),
(1454),
(1455),
(1456),
(1457),
(1458),
(1459),
(1460),
(1461),
(1462),
(1463),
(1464),
(1465),
(1466),
(1467),
(1468),
(1469),
(1470),
(1471),
(1472),
(1473),
(1474),
(1475),
(1476),
(1477),
(1478),
(1479),
(1480),
(1481),
(1482),
(1483),
(1484),
(1485),
(1486),
(1487),
(1488),
(1489),
(1490),
(1491),
(1492),
(1493),
(1494),
(1495),
(1496),
(1497),
(1498),
(1499),
(1500),
(1501),
(1502),
(1503),
(1504),
(1505),
(1506),
(1507),
(1508),
(1509),
(1510),
(1511),
(1512),
(1513),
(1514),
(1515),
(1516),
(1517),
(1518),
(1519),
(1520),
(1521),
(1522),
(1523),
(1524),
(1525),
(1526),
(1527),
(1528),
(1529),
(1530),
(1531),
(1532),
(1533),
(1534),
(1535),
(1536),
(1537),
(1538),
(1539),
(1540),
(1541),
(1542),
(1543),
(1544),
(1545),
(1546),
(1547),
(1548),
(1549),
(1550),
(1551),
(1552),
(1553),
(1554),
(1555),
(1556),
(1557),
(1558),
(1559),
(1560),
(1561),
(1562),
(1563),
(1564),
(1565),
(1566),
(1567),
(1568),
(1569),
(1570),
(1571),
(1572),
(1573),
(1574),
(1575),
(1576),
(1577),
(1578),
(1579),
(1580),
(1581),
(1582),
(1583),
(1584),
(1585),
(1586),
(1587),
(1588),
(1589),
(1590),
(1591),
(1592),
(1593),
(1594),
(1595),
(1596),
(1597),
(1598),
(1599),
(1600),
(1601),
(1602),
(1603),
(1604),
(1605),
(1606),
(1607),
(1608),
(1609),
(1610),
(1611),
(1612),
(1613),
(1614),
(1615),
(1616),
(1617),
(1618),
(1619),
(1620),
(1621),
(1622),
(1623),
(1624),
(1625),
(1626),
(1627),
(1628),
(1629),
(1630),
(1631),
(1632),
(1633),
(1634),
(1635),
(1636),
(1637),
(1638),
(1639),
(1640),
(1641),
(1642),
(1643),
(1644),
(1645),
(1646),
(1647),
(1648),
(1649),
(1650),
(1651),
(1652),
(1653),
(1654),
(1655),
(1656),
(1657),
(1658),
(1659),
(1660),
(1661),
(1662),
(1663),
(1664),
(1665),
(1666),
(1667),
(1668),
(1669),
(1670),
(1671),
(1672),
(1673),
(1674),
(1675),
(1676),
(1677),
(1678),
(1679),
(1680),
(1681),
(1682),
(1683),
(1684),
(1685),
(1686),
(1687),
(1688),
(1689),
(1690),
(1691),
(1692),
(1693),
(1694),
(1695),
(1696),
(1697),
(1698),
(1699),
(1700),
(1701),
(1702),
(1703),
(1704),
(1705),
(1706),
(1707),
(1708),
(1709),
(1710),
(1711),
(1712),
(1713),
(1714),
(1715),
(1716),
(1717),
(1718),
(1719),
(1720),
(1721),
(1722),
(1723),
(1724),
(1725),
(1726),
(1727),
(1728),
(1729),
(1730),
(1731),
(1732),
(1733),
(1734),
(1735),
(1736),
(1737),
(1738),
(1739),
(1740),
(1741),
(1742),
(1743),
(1744),
(1745),
(1746),
(1747),
(1748),
(1749),
(1750),
(1751),
(1752),
(1753),
(1754),
(1755),
(1756),
(1757),
(1758),
(1759),
(1760),
(1761),
(1762),
(1763),
(1764),
(1765),
(1766),
(1767),
(1768),
(1769),
(1770),
(1771),
(1772),
(1773),
(1774),
(1775),
(1776),
(1777),
(1778),
(1779),
(1780),
(1781),
(1782),
(1783),
(1784),
(1785),
(1786),
(1787),
(1788),
(1789),
(1790),
(1791),
(1792),
(1793),
(1794),
(1795),
(1796),
(1797),
(1798),
(1799),
(1800),
(1801),
(1802),
(1803),
(1804),
(1805),
(1806),
(1807),
(1808),
(1809),
(1810),
(1811),
(1812),
(1813),
(1814),
(1815),
(1816),
(1817),
(1818),
(1819),
(1820),
(1821),
(1822),
(1823),
(1824),
(1825),
(1826),
(1827),
(1828),
(1829),
(1830),
(1831),
(1832),
(1833),
(1834),
(1835),
(1836),
(1837),
(1838),
(1839),
(1840),
(1841),
(1842),
(1843),
(1844),
(1845),
(1846),
(1847),
(1848),
(1849),
(1850),
(1851),
(1852),
(1853),
(1854),
(1855),
(1856),
(1857),
(1858),
(1859),
(1860),
(1861),
(1862),
(1863),
(1864),
(1865),
(1866),
(1867),
(1868),
(1869),
(1870),
(1871),
(1872),
(1873),
(1874),
(1875),
(1876),
(1877),
(1878),
(1879),
(1880),
(1881),
(1882),
(1883),
(1884),
(1885),
(1886),
(1887),
(1888),
(1889),
(1890),
(1891),
(1892),
(1893),
(1894),
(1895),
(1896),
(1897),
(1898),
(1899),
(1900),
(1901),
(1902),
(1903),
(1904),
(1905),
(1906),
(1907),
(1908),
(1909),
(1910),
(1911),
(1912),
(1913),
(1914),
(1915),
(1916),
(1917),
(1918),
(1919),
(1920),
(1921),
(1922),
(1923),
(1924),
(1925),
(1926),
(1927),
(1928),
(1929),
(1930),
(1931),
(1932),
(1933),
(1934),
(1935),
(1936),
(1937),
(1938),
(1939),
(1940),
(1941),
(1942),
(1943),
(1944),
(1945),
(1946),
(1947),
(1948),
(1949),
(1950),
(1951),
(1952),
(1953),
(1954),
(1955),
(1956),
(1957),
(1958),
(1959),
(1960),
(1961),
(1962),
(1963),
(1964),
(1965),
(1966),
(1967),
(1968),
(1969),
(1970),
(1971),
(1972),
(1973),
(1974),
(1975),
(1976),
(1977),
(1978),
(1979),
(1980),
(1981),
(1982),
(1983),
(1984),
(1985),
(1986),
(1987),
(1988),
(1989),
(1990),
(1991),
(1992),
(1993),
(1994),
(1995),
(1996),
(1997),
(1998),
(1999),
(2000),
(2001),
(2002),
(2003),
(2004),
(2005),
(2006),
(2007),
(2008),
(2009),
(2010),
(2011),
(2012),
(2013),
(2014),
(2015),
(2016),
(2017),
(2018),
(2019),
(2020),
(2021),
(2022),
(2023),
(2024),
(2025),
(2026),
(2027),
(2028),
(2029),
(2030),
(2031),
(2032),
(2033),
(2034),
(2035),
(2036),
(2037),
(2038),
(2039),
(2040),
(2041),
(2042),
(2043),
(2044),
(2045),
(2046),
(2047),
(2048),
(2049),
(2050),
(2051),
(2052),
(2053),
(2054),
(2055),
(2056),
(2057),
(2058),
(2059),
(2060),
(2061),
(2062),
(2063),
(2064),
(2065),
(2066),
(2067),
(2068),
(2069),
(2070),
(2071),
(2072),
(2073),
(2074),
(2075),
(2076),
(2077),
(2078),
(2079),
(2080),
(2081),
(2082),
(2083),
(2084),
(2085),
(2086),
(2087),
(2088),
(2089),
(2090),
(2091),
(2092),
(2093),
(2094),
(2095),
(2096),
(2097),
(2098),
(2099),
(2100),
(2101),
(2102),
(2103),
(2104),
(2105),
(2106),
(2107),
(2108),
(2109),
(2110),
(2111),
(2112),
(2113),
(2114),
(2115),
(2116),
(2117),
(2118),
(2119),
(2120),
(2121),
(2122),
(2123),
(2124),
(2125),
(2126),
(2127),
(2128),
(2129),
(2130),
(2131),
(2132),
(2133),
(2134),
(2135),
(2136),
(2137),
(2138),
(2139),
(2140),
(2141),
(2142),
(2143),
(2144),
(2145),
(2146),
(2147),
(2148),
(2149),
(2150),
(2151),
(2152),
(2153),
(2154),
(2155),
(2156),
(2157),
(2158),
(2159),
(2160),
(2161),
(2162),
(2163),
(2164),
(2165),
(2166),
(2167),
(2168),
(2169),
(2170),
(2171),
(2172),
(2173),
(2174),
(2175),
(2176),
(2177),
(2178),
(2179),
(2180),
(2181),
(2182),
(2183),
(2184),
(2185),
(2186),
(2187),
(2188),
(2189),
(2190),
(2191),
(2192),
(2193),
(2194),
(2195),
(2196),
(2197),
(2198),
(2199),
(2200),
(2201),
(2202),
(2203),
(2204),
(2205),
(2206),
(2207),
(2208),
(2209),
(2210),
(2211),
(2212),
(2213),
(2214),
(2215),
(2216),
(2217),
(2218),
(2219),
(2220),
(2221),
(2222),
(2223),
(2224),
(2225),
(2226),
(2227),
(2228),
(2229),
(2230),
(2231),
(2232),
(2233),
(2234),
(2235),
(2236),
(2237),
(2238),
(2239),
(2240),
(2241),
(2242),
(2243),
(2244),
(2245),
(2246),
(2247),
(2248),
(2249),
(2250),
(2251),
(2252),
(2253),
(2254),
(2255),
(2256),
(2257),
(2258),
(2259),
(2260),
(2261),
(2262),
(2263),
(2264),
(2265),
(2266),
(2267),
(2268),
(2269),
(2270),
(2271),
(2272),
(2273),
(2274),
(2275),
(2276),
(2277),
(2278),
(2279),
(2280),
(2281),
(2282),
(2283),
(2284),
(2285),
(2286),
(2287),
(2288),
(2289),
(2290),
(2291),
(2292),
(2293),
(2294),
(2295),
(2296),
(2297),
(2298),
(2299),
(2300),
(2301),
(2302),
(2303),
(2304),
(2305),
(2306),
(2307),
(2308),
(2309),
(2310),
(2311),
(2312),
(2313),
(2314),
(2315),
(2316),
(2317),
(2318),
(2319),
(2320),
(2321),
(2322),
(2323),
(2324),
(2325),
(2326),
(2327),
(2328),
(2329),
(2330),
(2331),
(2332),
(2333),
(2334),
(2335),
(2336),
(2337),
(2338),
(2339),
(2340),
(2341),
(2342),
(2343),
(2344),
(2345),
(2346),
(2347),
(2348),
(2349),
(2350),
(2351),
(2352),
(2353),
(2354),
(2355),
(2356),
(2357),
(2358),
(2359),
(2360),
(2361),
(2362),
(2363),
(2364),
(2365),
(2366),
(2367),
(2368),
(2369),
(2370),
(2371),
(2372),
(2373),
(2374),
(2375),
(2376),
(2377),
(2378),
(2379),
(2380),
(2381),
(2382),
(2383),
(2384),
(2385),
(2386),
(2387),
(2388),
(2389),
(2390),
(2391),
(2392),
(2393),
(2394),
(2395),
(2396),
(2397),
(2398),
(2399),
(2400),
(2401),
(2402),
(2403),
(2404),
(2405),
(2406),
(2407),
(2408),
(2409),
(2410),
(2411),
(2412),
(2413),
(2414),
(2415),
(2416),
(2417),
(2418),
(2419),
(2420),
(2421),
(2422),
(2423),
(2424),
(2425),
(2426),
(2427),
(2428),
(2429),
(2430),
(2431),
(2432),
(2433),
(2434),
(2435),
(2436),
(2437),
(2438),
(2439),
(2440),
(2441),
(2442),
(2443),
(2444),
(2445),
(2446),
(2447),
(2448),
(2449),
(2450),
(2451),
(2452),
(2453),
(2454),
(2455),
(2456),
(2457),
(2458),
(2459),
(2460),
(2461),
(2462),
(2463),
(2464),
(2465),
(2466),
(2467),
(2468),
(2469),
(2470),
(2471),
(2472),
(2473),
(2474),
(2475),
(2476),
(2477),
(2478),
(2479),
(2480),
(2481),
(2482),
(2483),
(2484),
(2485),
(2486),
(2487),
(2488),
(2489),
(2490),
(2491),
(2492),
(2493),
(2494),
(2495),
(2496),
(2497),
(2498),
(2499),
(2500),
(2501),
(2502),
(2503),
(2504),
(2505),
(2506),
(2507),
(2508),
(2509),
(2510),
(2511),
(2512),
(2513),
(2514),
(2515),
(2516),
(2517),
(2518),
(2519),
(2520),
(2521),
(2522),
(2523),
(2524),
(2525),
(2526),
(2527),
(2528),
(2529),
(2530),
(2531),
(2532),
(2533),
(2534),
(2535),
(2536),
(2537),
(2538),
(2539),
(2540),
(2541),
(2542),
(2543),
(2544),
(2545),
(2546),
(2547),
(2548),
(2549),
(2550),
(2551),
(2552),
(2553),
(2554),
(2555),
(2556),
(2557),
(2558),
(2559),
(2560),
(2561),
(2562),
(2563),
(2564),
(2565),
(2566),
(2567),
(2568),
(2569),
(2570),
(2571),
(2572),
(2573),
(2574),
(2575),
(2576),
(2577),
(2578),
(2579),
(2580),
(2581),
(2582),
(2583),
(2584),
(2585),
(2586),
(2587),
(2588),
(2589),
(2590),
(2591),
(2592),
(2593),
(2594),
(2595),
(2596),
(2597),
(2598),
(2599),
(2600),
(2601),
(2602),
(2603),
(2604),
(2605),
(2606),
(2607),
(2608),
(2609),
(2610),
(2611),
(2612),
(2613),
(2614),
(2615),
(2616),
(2617),
(2618),
(2619),
(2620),
(2621),
(2622),
(2623),
(2624),
(2625),
(2626),
(2627),
(2628),
(2629),
(2630),
(2631),
(2632),
(2633),
(2634),
(2635),
(2636),
(2637),
(2638),
(2639),
(2640),
(2641),
(2642),
(2643),
(2644),
(2645),
(2646),
(2647),
(2648),
(2649),
(2650),
(2651),
(2652),
(2653),
(2654),
(2655),
(2656),
(2657),
(2658),
(2659),
(2660),
(2661),
(2662),
(2663),
(2664),
(2665),
(2666),
(2667),
(2668),
(2669),
(2670),
(2671),
(2672),
(2673),
(2674),
(2675),
(2676),
(2677),
(2678),
(2679),
(2680),
(2681),
(2682),
(2683),
(2684),
(2685),
(2686),
(2687),
(2688),
(2689),
(2690),
(2691),
(2692),
(2693),
(2694),
(2695),
(2696),
(2697),
(2698),
(2699),
(2700),
(2701),
(2702),
(2703),
(2704),
(2705),
(2706),
(2707),
(2708),
(2709),
(2710),
(2711),
(2712),
(2713),
(2714),
(2715),
(2716),
(2717),
(2718),
(2719),
(2720),
(2721),
(2722),
(2723),
(2724),
(2725),
(2726),
(2727),
(2728),
(2729),
(2730),
(2731),
(2732),
(2733),
(2734),
(2735),
(2736),
(2737),
(2738),
(2739),
(2740),
(2741),
(2742),
(2743),
(2744),
(2745),
(2746),
(2747),
(2748),
(2749),
(2750),
(2751),
(2752),
(2753),
(2754),
(2755),
(2756),
(2757),
(2758),
(2759),
(2760),
(2761),
(2762),
(2763),
(2764),
(2765),
(2766),
(2767),
(2768),
(2769),
(2770),
(2771),
(2772),
(2773),
(2774),
(2775),
(2776),
(2777),
(2778),
(2779),
(2780),
(2781),
(2782),
(2783),
(2784),
(2785),
(2786),
(2787),
(2788),
(2789),
(2790),
(2791),
(2792),
(2793),
(2794),
(2795),
(2796),
(2797),
(2798),
(2799),
(2800),
(2801),
(2802),
(2803),
(2804),
(2805),
(2806),
(2807),
(2808),
(2809),
(2810),
(2811),
(2812),
(2813),
(2814),
(2815),
(2816),
(2817),
(2818),
(2819),
(2820),
(2821),
(2822),
(2823),
(2824),
(2825),
(2826),
(2827),
(2828),
(2829),
(2830),
(2831),
(2832),
(2833),
(2834),
(2835),
(2836),
(2837),
(2838),
(2839),
(2840),
(2841),
(2842),
(2843),
(2844),
(2845),
(2846),
(2847),
(2848),
(2849),
(2850),
(2851),
(2852),
(2853),
(2854),
(2855),
(2856),
(2857),
(2858),
(2859),
(2860),
(2861),
(2862),
(2863),
(2864),
(2865),
(2866),
(2867),
(2868),
(2869),
(2870),
(2871),
(2872),
(2873),
(2874),
(2875),
(2876),
(2877),
(2878),
(2879),
(2880),
(2881),
(2882),
(2883),
(2884),
(2885),
(2886),
(2887),
(2888),
(2889),
(2890),
(2891),
(2892),
(2893),
(2894),
(2895),
(2896),
(2897),
(2898),
(2899),
(2900),
(2901),
(2902),
(2903),
(2904),
(2905),
(2906),
(2907),
(2908),
(2909),
(2910),
(2911),
(2912),
(2913),
(2914),
(2915),
(2916),
(2917),
(2918),
(2919),
(2920),
(2921),
(2922),
(2923),
(2924),
(2925),
(2926),
(2927),
(2928),
(2929),
(2930),
(2931),
(2932),
(2933),
(2934),
(2935),
(2936),
(2937),
(2938),
(2939),
(2940),
(2941),
(2942),
(2943),
(2944),
(2945),
(2946),
(2947),
(2948),
(2949),
(2950),
(2951),
(2952),
(2953),
(2954),
(2955),
(2956),
(2957),
(2958),
(2959),
(2960),
(2961),
(2962),
(2963),
(2964),
(2965),
(2966),
(2967),
(2968),
(2969),
(2970),
(2971),
(2972),
(2973),
(2974),
(2975),
(2976),
(2977),
(2978),
(2979),
(2980),
(2981),
(2982),
(2983),
(2984),
(2985),
(2986),
(2987),
(2988),
(2989),
(2990),
(2991),
(2992),
(2993),
(2994),
(2995),
(2996),
(2997),
(2998),
(2999),
(3000),
(3001),
(3002),
(3003),
(3004),
(3005),
(3006),
(3007),
(3008),
(3009),
(3010),
(3011),
(3012),
(3013),
(3014),
(3015),
(3016),
(3017),
(3018),
(3019),
(3020),
(3021),
(3022),
(3023),
(3024),
(3025),
(3026),
(3027),
(3028),
(3029),
(3030),
(3031),
(3032),
(3033),
(3034),
(3035),
(3036),
(3037),
(3038),
(3039),
(3040),
(3041),
(3042),
(3043),
(3044),
(3045),
(3046),
(3047),
(3048),
(3049),
(3050),
(3051),
(3052),
(3053),
(3054),
(3055),
(3056),
(3057),
(3058),
(3059),
(3060),
(3061),
(3062),
(3063),
(3064),
(3065),
(3066),
(3067),
(3068),
(3069),
(3070),
(3071),
(3072),
(3073),
(3074),
(3075),
(3076),
(3077),
(3078),
(3079),
(3080),
(3081),
(3082),
(3083),
(3084),
(3085),
(3086),
(3087),
(3088),
(3089),
(3090),
(3091),
(3092),
(3093),
(3094),
(3095),
(3096),
(3097),
(3098),
(3099),
(3100),
(3101),
(3102),
(3103),
(3104),
(3105),
(3106),
(3107),
(3108),
(3109),
(3110),
(3111),
(3112),
(3113),
(3114),
(3115),
(3116),
(3117),
(3118),
(3119),
(3120),
(3121),
(3122),
(3123),
(3124),
(3125),
(3126),
(3127),
(3128),
(3129),
(3130),
(3131),
(3132),
(3133),
(3134),
(3135),
(3136),
(3137),
(3138),
(3139),
(3140),
(3141),
(3142),
(3143),
(3144),
(3145),
(3146),
(3147),
(3148),
(3149),
(3150),
(3151),
(3152),
(3153),
(3154),
(3155),
(3156),
(3157),
(3158),
(3159),
(3160),
(3161),
(3162),
(3163),
(3164),
(3165),
(3166),
(3167),
(3168),
(3169),
(3170),
(3171),
(3172),
(3173),
(3174),
(3175),
(3176),
(3177),
(3178),
(3179),
(3180),
(3181),
(3182),
(3183),
(3184),
(3185),
(3186),
(3187),
(3188),
(3189),
(3190),
(3191),
(3192),
(3193),
(3194),
(3195),
(3196),
(3197),
(3198),
(3199),
(3200),
(3201),
(3202),
(3203),
(3204),
(3205),
(3206),
(3207),
(3208),
(3209),
(3210),
(3211),
(3212),
(3213),
(3214),
(3215),
(3216),
(3217),
(3218),
(3219),
(3220),
(3221),
(3222),
(3223),
(3224),
(3225),
(3226),
(3227),
(3228),
(3229),
(3230),
(3231),
(3232),
(3233),
(3234),
(3235),
(3236),
(3237),
(3238),
(3239),
(3240),
(3241),
(3242),
(3243),
(3244),
(3245),
(3246),
(3247),
(3248),
(3249),
(3250),
(3251),
(3252),
(3253),
(3254),
(3255),
(3256),
(3257),
(3258),
(3259),
(3260),
(3261),
(3262),
(3263),
(3264),
(3265),
(3266),
(3267),
(3268),
(3269),
(3270),
(3271),
(3272),
(3273),
(3274),
(3275),
(3276),
(3277),
(3278),
(3279),
(3280),
(3281),
(3282),
(3283),
(3284),
(3285),
(3286),
(3287),
(3288),
(3289),
(3290),
(3291),
(3292),
(3293),
(3294),
(3295),
(3296),
(3297),
(3298),
(3299),
(3300),
(3301),
(3302),
(3303),
(3304),
(3305),
(3306),
(3307),
(3308),
(3309),
(3310),
(3311),
(3312),
(3313),
(3314),
(3315),
(3316),
(3317),
(3318),
(3319),
(3320),
(3321),
(3322),
(3323),
(3324),
(3325),
(3326),
(3327),
(3328),
(3329),
(3330),
(3331),
(3332),
(3333),
(3334),
(3335),
(3336),
(3337),
(3338),
(3339),
(3340),
(3341),
(3342),
(3343),
(3344),
(3345),
(3346),
(3347),
(3348),
(3349),
(3350),
(3351),
(3352),
(3353),
(3354),
(3355),
(3356),
(3357),
(3358),
(3359),
(3360),
(3361),
(3362),
(3363),
(3364),
(3365),
(3366),
(3367),
(3368),
(3369),
(3370),
(3371),
(3372),
(3373),
(3374),
(3375),
(3376),
(3377),
(3378),
(3379),
(3380),
(3381),
(3382),
(3383),
(3384),
(3385),
(3386),
(3387),
(3388),
(3389),
(3390),
(3391),
(3392),
(3393),
(3394),
(3395),
(3396),
(3397),
(3398),
(3399),
(3400),
(3401),
(3402),
(3403),
(3404),
(3405),
(3406),
(3407),
(3408),
(3409),
(3410),
(3411),
(3412),
(3413),
(3414),
(3415),
(3416),
(3417),
(3418),
(3419),
(3420),
(3421),
(3422),
(3423),
(3424),
(3425),
(3426),
(3427),
(3428),
(3429),
(3430),
(3431),
(3432),
(3433),
(3434),
(3435),
(3436),
(3437),
(3438),
(3439),
(3440),
(3441),
(3442),
(3443),
(3444),
(3445),
(3446),
(3447),
(3448),
(3449),
(3450),
(3451),
(3452),
(3453),
(3454),
(3455),
(3456),
(3457),
(3458),
(3459),
(3460),
(3461),
(3462),
(3463),
(3464),
(3465),
(3466),
(3467),
(3468),
(3469),
(3470),
(3471),
(3472),
(3473),
(3474),
(3475),
(3476),
(3477),
(3478),
(3479),
(3480),
(3481),
(3482),
(3483),
(3484),
(3485),
(3486),
(3487),
(3488),
(3489),
(3490),
(3491),
(3492),
(3493),
(3494),
(3495),
(3496),
(3497),
(3498),
(3499),
(3500),
(3501),
(3502),
(3503),
(3504),
(3505),
(3506),
(3507),
(3508),
(3509),
(3510),
(3511),
(3512),
(3513),
(3514),
(3515),
(3516),
(3517),
(3518),
(3519),
(3520),
(3521),
(3522),
(3523),
(3524),
(3525),
(3526),
(3527),
(3528),
(3529),
(3530),
(3531),
(3532),
(3533),
(3534),
(3535),
(3536),
(3537),
(3538),
(3539),
(3540),
(3541),
(3542),
(3543),
(3544),
(3545),
(3546),
(3547),
(3548),
(3549),
(3550),
(3551),
(3552),
(3553),
(3554),
(3555),
(3556),
(3557),
(3558),
(3559),
(3560),
(3561),
(3562),
(3563),
(3564),
(3565),
(3566),
(3567),
(3568),
(3569),
(3570),
(3571),
(3572),
(3573),
(3574),
(3575),
(3576),
(3577),
(3578),
(3579),
(3580),
(3581),
(3582),
(3583),
(3584),
(3585),
(3586),
(3587),
(3588),
(3589),
(3590),
(3591),
(3592),
(3593),
(3594),
(3595),
(3596),
(3597),
(3598),
(3599),
(3600),
(3601),
(3602),
(3603),
(3604),
(3605),
(3606),
(3607),
(3608),
(3609),
(3610),
(3611),
(3612),
(3613),
(3614),
(3615),
(3616),
(3617),
(3618),
(3619),
(3620),
(3621),
(3622),
(3623),
(3624),
(3625),
(3626),
(3627),
(3628),
(3629),
(3630),
(3631),
(3632),
(3633),
(3634),
(3635),
(3636),
(3637),
(3638),
(3639),
(3640),
(3641),
(3642),
(3643),
(3644),
(3645),
(3646),
(3647),
(3648),
(3649),
(3650),
(3651),
(3652),
(3653),
(3654),
(3655),
(3656),
(3657),
(3658),
(3659),
(3660),
(3661),
(3662),
(3663),
(3664),
(3665),
(3666),
(3667),
(3668),
(3669),
(3670),
(3671),
(3672),
(3673),
(3674),
(3675),
(3676),
(3677),
(3678),
(3679),
(3680),
(3681),
(3682),
(3683),
(3684),
(3685),
(3686),
(3687),
(3688),
(3689),
(3690),
(3691),
(3692),
(3693),
(3694),
(3695),
(3696),
(3697),
(3698),
(3699),
(3700),
(3701),
(3702),
(3703),
(3704),
(3705),
(3706),
(3707),
(3708),
(3709),
(3710),
(3711),
(3712),
(3713),
(3714),
(3715),
(3716),
(3717),
(3718),
(3719),
(3720),
(3721),
(3722),
(3723),
(3724),
(3725),
(3726),
(3727),
(3728),
(3729),
(3730),
(3731),
(3732),
(3733),
(3734),
(3735),
(3736),
(3737),
(3738),
(3739),
(3740),
(3741),
(3742),
(3743),
(3744),
(3745),
(3746),
(3747),
(3748),
(3749),
(3750),
(3751),
(3752),
(3753),
(3754),
(3755),
(3756),
(3757),
(3758),
(3759),
(3760),
(3761),
(3762),
(3763),
(3764),
(3765),
(3766),
(3767),
(3768),
(3769),
(3770),
(3771),
(3772),
(3773),
(3774),
(3775),
(3776),
(3777),
(3778),
(3779),
(3780),
(3781),
(3782),
(3783),
(3784),
(3785),
(3786),
(3787),
(3788),
(3789),
(3790),
(3791),
(3792),
(3793),
(3794),
(3795),
(3796),
(3797),
(3798),
(3799),
(3800),
(3801),
(3802),
(3803),
(3804),
(3805),
(3806),
(3807),
(3808),
(3809),
(3810),
(3811),
(3812),
(3813),
(3814),
(3815),
(3816),
(3817),
(3818),
(3819),
(3820),
(3821),
(3822),
(3823),
(3824),
(3825),
(3826),
(3827),
(3828),
(3829),
(3830),
(3831),
(3832),
(3833),
(3834),
(3835),
(3836),
(3837),
(3838),
(3839),
(3840),
(3841),
(3842),
(3843),
(3844),
(3845),
(3846),
(3847),
(3848),
(3849),
(3850),
(3851),
(3852),
(3853),
(3854),
(3855),
(3856),
(3857),
(3858),
(3859),
(3860),
(3861),
(3862),
(3863),
(3864),
(3865),
(3866),
(3867),
(3868),
(3869),
(3870),
(3871),
(3872),
(3873),
(3874),
(3875),
(3876),
(3877),
(3878),
(3879),
(3880),
(3881),
(3882),
(3883),
(3884),
(3885),
(3886),
(3887),
(3888),
(3889),
(3890),
(3891),
(3892),
(3893),
(3894),
(3895),
(3896),
(3897),
(3898),
(3899),
(3900),
(3901),
(3902),
(3903),
(3904),
(3905),
(3906),
(3907),
(3908),
(3909),
(3910),
(3911),
(3912),
(3913),
(3914),
(3915),
(3916),
(3917),
(3918),
(3919),
(3920),
(3921),
(3922),
(3923),
(3924),
(3925),
(3926),
(3927),
(3928),
(3929),
(3930),
(3931),
(3932),
(3933),
(3934),
(3935),
(3936),
(3937),
(3938),
(3939),
(3940),
(3941),
(3942),
(3943),
(3944),
(3945),
(3946),
(3947),
(3948),
(3949),
(3950),
(3951),
(3952),
(3953),
(3954),
(3955),
(3956),
(3957),
(3958),
(3959),
(3960),
(3961),
(3962),
(3963),
(3964),
(3965),
(3966),
(3967),
(3968),
(3969),
(3970),
(3971),
(3972),
(3973),
(3974),
(3975),
(3976),
(3977),
(3978),
(3979),
(3980),
(3981),
(3982),
(3983),
(3984),
(3985),
(3986),
(3987),
(3988),
(3989),
(3990),
(3991),
(3992),
(3993),
(3994),
(3995),
(3996),
(3997),
(3998),
(3999),
(4000),
(4001),
(4002),
(4003),
(4004),
(4005),
(4006),
(4007),
(4008),
(4009),
(4010),
(4011),
(4012),
(4013),
(4014),
(4015),
(4016),
(4017),
(4018),
(4019),
(4020),
(4021),
(4022),
(4023),
(4024),
(4025),
(4026),
(4027),
(4028),
(4029),
(4030),
(4031),
(4032),
(4033),
(4034),
(4035),
(4036),
(4037),
(4038),
(4039),
(4040),
(4041),
(4042),
(4043),
(4044),
(4045),
(4046),
(4047),
(4048),
(4049),
(4050),
(4051),
(4052),
(4053),
(4054),
(4055),
(4056),
(4057),
(4058),
(4059),
(4060),
(4061),
(4062),
(4063),
(4064),
(4065),
(4066),
(4067),
(4068),
(4069),
(4070),
(4071),
(4072),
(4073),
(4074),
(4075),
(4076),
(4077),
(4078),
(4079),
(4080),
(4081),
(4082),
(4083),
(4084),
(4085),
(4086),
(4087),
(4088),
(4089),
(4090),
(4091),
(4092),
(4093),
(4094);
END_OF_FILE;
	}
}

?>
