/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.audio.vorbis;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.sourceforge.jffmpeg.JMFCodec;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.CodeBook;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.Mode;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.OggReader;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.floor.Floor;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.floor.Floor0;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.floor.Floor1;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.mapping.Mapping;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.mapping.Mapping0;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.mapping.Mdct;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.residue.Residue;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.residue.Residue0;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.residue.Residue1;
import net.sourceforge.jffmpeg.codecs.audio.vorbis.residue.Residue2;

public class VorbisDecoder
implements Codec,
JMFCodec {
    public static final boolean debug = false;
    private AudioFormat inputFormat;
    private int headersRequired = 3;
    private int channels;
    private int[] blocksize = new int[2];
    private CodeBook[] codeBooks;
    private Floor[] floor_param;
    private Residue[] residue_param;
    private Mapping[] mapping_param;
    private Mode[] modes_param;
    private Mdct[] mdct = new Mdct[2];
    private OggReader oggRead = new OggReader();
    private int modebits;
    private boolean W;
    private int lW;
    private int nW;
    private static final int HEADER_INFO = 1;
    private static final int HEADER_COMMENT = 3;
    private static final int HEADER_BOOKS = 5;
    private byte[] packetBuffer = new byte[0];
    private int packetBufferLength = 0;

    public CodeBook getCodeBook(int n) {
        return this.codeBooks[n];
    }

    public Floor getFloor(int n) {
        return this.floor_param[n];
    }

    public Residue getResidue(int n) {
        return this.residue_param[n];
    }

    public Mapping getMapping(int n) {
        return this.mapping_param[n];
    }

    public Mode getMode(int n) {
        return this.modes_param[n];
    }

    public Mdct getMdct() {
        return this.mdct[this.W ? 1 : 0];
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new AudioFormat("vorbis")};
    }

    public Format[] getSupportedOutputFormats(Format format) {
        return new Format[]{new AudioFormat("LINEAR")};
    }

    public Format setInputFormat(Format format) {
        this.inputFormat = (AudioFormat)format;
        return format;
    }

    public Format setOutputFormat(Format format) {
        return new AudioFormat("LINEAR", this.inputFormat.getSampleRate(), this.inputFormat.getSampleSizeInBits() > 0 ? this.inputFormat.getSampleSizeInBits() : 16, this.inputFormat.getChannels(), 0, 1);
    }

    private static final int ilog2(int n) {
        int n2 = 0;
        while (n > 0) {
            ++n2;
            n >>= 1;
        }
        return n2;
    }

    private int readInt(byte[] byArray, int n) {
        int n2 = 0;
        n2 = n2 << 8 | byArray[n + 3] & 0xFF;
        n2 = n2 << 8 | byArray[n + 2] & 0xFF;
        n2 = n2 << 8 | byArray[n + 1] & 0xFF;
        n2 = n2 << 8 | byArray[n + 0] & 0xFF;
        return n2;
    }

    private int read24Bits(byte[] byArray, int n) {
        int n2 = 0;
        n2 = n2 << 8 | byArray[n + 2] & 0xFF;
        n2 = n2 << 8 | byArray[n + 1] & 0xFF;
        n2 = n2 << 8 | byArray[n + 0] & 0xFF;
        return n2;
    }

    private int read16Bits(byte[] byArray, int n) {
        int n2 = 0;
        n2 = n2 << 8 | byArray[n + 1] & 0xFF;
        n2 = n2 << 8 | byArray[n + 0] & 0xFF;
        return n2;
    }

    private void vorbis_unpack_info(byte[] byArray, int n, int n2) {
        int n3 = this.readInt(byArray, n);
        this.channels = byArray[n + 4] & 0xFF;
        int n4 = this.readInt(byArray, n + 5);
        int n5 = this.readInt(byArray, n + 9);
        int n6 = this.readInt(byArray, n + 13);
        int n7 = this.readInt(byArray, n + 17);
        this.blocksize[0] = 1 << (byArray[n + 21] & 0xF);
        this.blocksize[1] = 1 << (byArray[n + 21] >> 4 & 0xF);
        int n8 = byArray[n + 22] & 1;
        if (n3 != 0) {
            throw new Error("Unsupported Vorbis version");
        }
        if (this.channels < 1) {
            throw new Error("Illegal number of channels");
        }
        if (n4 < 1) {
            throw new Error("Illegal rate");
        }
        if (this.blocksize[0] < 8 || this.blocksize[1] < this.blocksize[0]) {
            throw new Error("Illegal Block Size");
        }
        if (n8 != 1) {
            throw new Error("Illegal pad");
        }
        this.mdct[0] = new Mdct(this.blocksize[0]);
        this.mdct[1] = new Mdct(this.blocksize[1]);
    }

    private void vorbis_unpack_comment(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = this.readInt(byArray, n);
        String string = new String(byArray, n + 4, n4);
        String[] stringArray = new String[this.readInt(byArray, n += 4 + n4)];
        n += 4;
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            int n5 = this.readInt(byArray, n);
            stringArray[n3] = new String(byArray, n + 4, n5);
            n += 4 + n5;
        }
        n3 = byArray[n] & 1;
        if (n3 != 1) {
            throw new Error("Illegal pad");
        }
    }

    private void vorbis_unpack_books(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        this.oggRead.setData(byArray, n);
        int n9 = (int)this.oggRead.getBits(8) + 1;
        this.codeBooks = new CodeBook[n9];
        for (n8 = 0; n8 < n9; ++n8) {
            this.codeBooks[n8] = new CodeBook();
            this.codeBooks[n8].unpack(this.oggRead);
        }
        n8 = (int)this.oggRead.getBits(6) + 1;
        for (n7 = 0; n7 < n8; ++n7) {
            this.oggRead.getBits(16);
        }
        n7 = (int)this.oggRead.getBits(6) + 1;
        this.floor_param = new Floor[n7];
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = (int)this.oggRead.getBits(16);
            switch (n5) {
                case 0: {
                    this.floor_param[n6] = new Floor0();
                    break;
                }
                case 1: {
                    this.floor_param[n6] = new Floor1();
                    break;
                }
                default: {
                    throw new Error("Unrecognised Floor");
                }
            }
            this.floor_param[n6].unpack(this.oggRead);
        }
        n6 = (int)this.oggRead.getBits(6) + 1;
        this.residue_param = new Residue[n6];
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = (int)this.oggRead.getBits(16);
            switch (n4) {
                case 0: {
                    this.residue_param[n5] = new Residue0();
                    break;
                }
                case 1: {
                    this.residue_param[n5] = new Residue1();
                    break;
                }
                case 2: {
                    this.residue_param[n5] = new Residue2();
                    break;
                }
                default: {
                    throw new Error("Unrecognised Residue");
                }
            }
            this.residue_param[n5].unpack(this.oggRead);
        }
        n5 = (int)this.oggRead.getBits(6) + 1;
        this.mapping_param = new Mapping[n6];
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = (int)this.oggRead.getBits(16);
            switch (n3) {
                case 0: {
                    this.mapping_param[n4] = new Mapping0(this);
                    break;
                }
                default: {
                    throw new Error("Unrecognised Mapping");
                }
            }
            this.mapping_param[n4].unpack(this.oggRead, this.channels);
        }
        n4 = (int)this.oggRead.getBits(6) + 1;
        this.modebits = VorbisDecoder.ilog2(n4 - 1);
        this.modes_param = new Mode[n6];
        for (n3 = 0; n3 < n4; ++n3) {
            this.modes_param[n3] = new Mode();
            this.modes_param[n3].unpack(this.oggRead);
        }
        if (this.oggRead.getBits(1) != 1L) {
            throw new Error("Padding error");
        }
        for (n3 = 0; n3 < n9; ++n3) {
            this.codeBooks[n3].initDecode();
        }
        for (n3 = 0; n3 < this.floor_param.length; ++n3) {
            this.floor_param[n3].look();
        }
        for (n3 = 0; n3 < this.residue_param.length; ++n3) {
            this.residue_param[n3].look(this);
        }
    }

    public boolean getW() {
        return this.W;
    }

    public int getlW() {
        return this.lW;
    }

    public int getnW() {
        return this.nW;
    }

    public int getBlockSize(int n) {
        return this.blocksize[n];
    }

    private void vorbis_synthesis(byte[] byArray, int n, int n2, Buffer buffer) {
        this.oggRead.setData(byArray, n);
        if (this.oggRead.getBits(1) != 0L) {
            return;
        }
        int n3 = (int)this.oggRead.getBits(this.modebits);
        this.W = this.modes_param[n3].getBlockFlag();
        this.lW = 0;
        this.nW = 0;
        if (this.W) {
            this.lW = (int)this.oggRead.getBits(1);
            this.nW = (int)this.oggRead.getBits(1);
        }
        int n4 = this.modes_param[n3].getMapping();
        this.mapping_param[n4].inverse(this.oggRead, this);
        this.mapping_param[n4].vorbis_synthesis_blockin(this);
        this.mapping_param[n4].soundOutput(buffer);
    }

    private void decodeSegment(byte[] byArray, int n, int n2, Buffer buffer) {
        if (this.headersRequired != 0) {
            byte by = byArray[n];
            if (byArray[n + 1] != 118 || byArray[n + 2] != 111 || byArray[n + 3] != 114 || byArray[n + 4] != 98 || byArray[n + 5] != 105 || byArray[n + 6] != 115) {
                return;
            }
            n += 7;
            n2 -= 7;
            switch (by) {
                case 1: {
                    this.vorbis_unpack_info(byArray, n, n2);
                    break;
                }
                case 3: {
                    this.vorbis_unpack_comment(byArray, n, n2);
                    break;
                }
                case 5: {
                    this.vorbis_unpack_books(byArray, n, n2);
                    break;
                }
                default: {
                    throw new Error("Invalid header ID: " + by);
                }
            }
            --this.headersRequired;
            return;
        }
        this.vorbis_synthesis(byArray, n, n2, buffer);
    }

    public int process(Buffer buffer, Buffer buffer2) {
        buffer2.setFlags(buffer.getFlags());
        buffer2.setTimeStamp(buffer.getTimeStamp());
        buffer2.setDuration(buffer.getDuration());
        buffer2.setLength(0);
        try {
            byte[] byArray = (byte[])buffer.getData();
            int n = buffer.getLength();
            int n2 = byArray[26] & 0xFF;
            int n3 = 0;
            int n4 = 27 + n2;
            while (n3 < n2) {
                int n5 = 0;
                do {
                    n5 += byArray[27 + n3] & 0xFF;
                } while (byArray[27 + (++n3 - 1)] == -1 && n3 < n2);
                if (this.packetBuffer.length < n5 + this.packetBufferLength) {
                    byte[] byArray2 = this.packetBuffer;
                    this.packetBuffer = new byte[n5 + this.packetBufferLength];
                    System.arraycopy(byArray2, 0, this.packetBuffer, 0, this.packetBufferLength);
                }
                System.arraycopy(byArray, n4, this.packetBuffer, this.packetBufferLength, n5);
                this.packetBufferLength += n5;
                if (byArray[27 + (n3 - 1)] == -1) continue;
                this.decodeSegment(this.packetBuffer, 0, this.packetBufferLength, buffer2);
                n4 += n5;
                this.packetBufferLength = 0;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            return 1;
        }
        catch (Error error) {
            System.out.println(error);
            error.printStackTrace();
        }
        return 0;
    }

    public void open() {
    }

    public void close() {
    }

    public void reset() {
    }

    public String getName() {
        return "Vorbis";
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String string) {
        return null;
    }

    public boolean isCodecAvailable() {
        return true;
    }

    public void setVideoSize(Dimension dimension) {
    }

    public void setEncoding(String string) {
    }

    public void setIsRtp(boolean bl) {
    }

    public void setIsTruncated(boolean bl) {
    }
}

