/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import java.util.HashMap;
import org.h2.command.CommandInterface;
import org.h2.command.Parser;
import org.h2.command.dml.Set;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.message.Message;
import org.h2.util.StringUtils;

public class Engine {
    private HashMap databases = new HashMap();
    private static Engine instance = new Engine();

    private Engine() {
    }

    public static Engine getInstance() {
        return instance;
    }

    public synchronized Session getSession(ConnectionInfo ci) throws SQLException {
        boolean ifExists = ci.removeProperty("IFEXISTS", false);
        String cipher = ci.removeProperty("CIPHER", null);
        String name = ci.getName();
        Database database = (Database)this.databases.get(name);
        User user = null;
        if (database == null) {
            if (ifExists && !Database.exists(name)) {
                throw Message.getSQLException(90013, name);
            }
            database = new Database(name, ci, cipher);
            if (database.getAllUsers().size() == 0) {
                user = new User(database, database.allocateObjectId(false, true), ci.getUserName(), false);
                user.setAdmin(true);
                user.setUserPasswordHash(ci.getUserPasswordHash());
                database.setMasterUser(user);
            }
            this.databases.put(name, database);
        }
        if (user == null) {
            try {
                database.checkFilePasswordHash(cipher, ci.getFilePasswordHash());
                user = database.getUser(ci.getUserName());
                user.checkUserPasswordHash(ci.getUserPasswordHash());
            }
            catch (SQLException e) {
                database.removeSession(null);
                throw e;
            }
        }
        this.checkClustering(ci, database);
        Session session = database.createSession(user);
        String[] keys = ci.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            String setting = keys[i];
            String value = ci.getProperty(setting);
            CommandInterface command = session.prepareCommand("SET " + Parser.quoteIdentifier(setting) + " " + value);
            try {
                command.executeUpdate();
                continue;
            }
            catch (SQLException e) {
                session.close();
                throw e;
            }
        }
        session.commit();
        database.getTrace("engine").info("Connected to " + name + " (build " + 12 + ")");
        return session;
    }

    private void checkClustering(ConnectionInfo ci, Database database) throws SQLException {
        String clusterSession = ci.getProperty(Set.getTypeName(13));
        if ("''".equals(clusterSession)) {
            return;
        }
        String clusterDb = database.getCluster();
        if (!"''".equals(clusterDb) && !StringUtils.equals(clusterSession, clusterDb)) {
            if (clusterDb.equals("''")) {
                throw Message.getSQLException(90093);
            }
            throw Message.getSQLException(90094, clusterDb);
        }
    }

    public void close(String name) {
        this.databases.remove(name);
    }
}

