/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.h2.engine.SessionInterface;
import org.h2.message.Message;
import org.h2.message.TraceObject;
import org.h2.value.Value;

public class JdbcBlob
extends TraceObject
implements Blob {
    private Value value;

    JdbcBlob(SessionInterface session, Value value, int id) {
        this.setTrace(session.getTrace(), 4, id);
        this.value = value;
    }

    public long length() throws SQLException {
        try {
            int len;
            long precision;
            this.infoCodeCall("length");
            if (this.value.getType() == 15 && (precision = this.value.getPrecision()) > 0L) {
                return precision;
            }
            InputStream in = this.value.getInputStream();
            long size = 0L;
            byte[] buff = new byte[16];
            while ((len = in.read(buff, 0, 16)) > 0) {
                size += (long)len;
            }
            return size;
        }
        catch (Throwable e) {
            throw Message.convert(e);
        }
    }

    public void truncate(long len) throws SQLException {
        this.infoCodeCall("truncate", len);
        throw Message.getUnsupportedException();
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        try {
            int x;
            this.infoCode("getBytes(" + pos + ", " + length + ");");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            InputStream in = this.value.getInputStream();
            in.skip(pos + 1L);
            while (length > 0 && (x = in.read()) >= 0) {
                out.write(x);
            }
            return out.toByteArray();
        }
        catch (Throwable e) {
            throw Message.convert(e);
        }
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        this.infoCode("setBytes(" + pos + ", bytes);");
        throw Message.getUnsupportedException();
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.infoCode("setBytes(" + pos + ", bytes, " + offset + ", " + len + ");");
        throw Message.getUnsupportedException();
    }

    public InputStream getBinaryStream() throws SQLException {
        this.infoCodeCall("getBinaryStream");
        return this.value.getInputStream();
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.infoCodeCall("setBinaryStream", pos);
        throw Message.getUnsupportedException();
    }

    public long position(byte[] pattern, long start) throws SQLException {
        this.infoCode("position(pattern, " + start + ");");
        throw Message.getUnsupportedException();
    }

    public long position(Blob blobPattern, long start) throws SQLException {
        this.infoCode("position(blobPattern, " + start + ");");
        throw Message.getUnsupportedException();
    }
}

